/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.yarn.appMaster.AMYarnFacadeImpl;
import org.apache.drill.yarn.appMaster.ClusterController;
import org.apache.drill.yarn.appMaster.ControllerFactory;
import org.apache.drill.yarn.appMaster.Dispatcher;
import org.apache.drill.yarn.appMaster.DispatcherAddOn;
import org.apache.drill.yarn.appMaster.DrillbitScheduler;
import org.apache.drill.yarn.appMaster.TaskSpec;
import org.apache.drill.yarn.appMaster.YarnFacadeException;
import org.apache.drill.yarn.appMaster.http.AMSecurityManagerImpl;
import org.apache.drill.yarn.core.ClusterDef;
import org.apache.drill.yarn.core.ContainerRequestSpec;
import org.apache.drill.yarn.core.DfsFacade;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.DoyConfigException;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.drill.yarn.core.LaunchSpec;
import org.apache.drill.yarn.zk.ZKClusterCoordinatorDriver;
import org.apache.drill.yarn.zk.ZKRegistry;
import org.apache.hadoop.yarn.api.records.LocalResource;

public class DrillControllerFactory
implements ControllerFactory {
    private static final Log LOG = LogFactory.getLog(DrillControllerFactory.class);
    private Config config = DrillOnYarnConfig.config();
    private String drillArchivePath;
    private String siteArchivePath;
    private boolean localized;

    @Override
    public Dispatcher build() throws ControllerFactory.ControllerFactoryException {
        Dispatcher dispatcher;
        LOG.info((Object)("Initializing AM for " + this.config.getString(DrillOnYarnConfig.APP_NAME)));
        try {
            Map<String, LocalResource> resources = this.prepareResources();
            TaskSpec taskSpec = this.buildDrillTaskSpec(resources);
            int timerPeriodMs = this.config.getInt(DrillOnYarnConfig.AM_TICK_PERIOD_MS);
            dispatcher = new Dispatcher(timerPeriodMs);
            int pollPeriodMs = this.config.getInt(DrillOnYarnConfig.AM_POLL_PERIOD_MS);
            AMYarnFacadeImpl yarn = new AMYarnFacadeImpl(pollPeriodMs);
            dispatcher.setYarn(yarn);
            dispatcher.getController().setMaxRetries(this.config.getInt(DrillOnYarnConfig.DRILLBIT_MAX_RETRIES));
            int requestTimeoutSecs = DrillOnYarnConfig.config().getInt(DrillOnYarnConfig.DRILLBIT_REQUEST_TIMEOUT_SEC);
            int maxExtraNodes = DrillOnYarnConfig.config().getInt(DrillOnYarnConfig.DRILLBIT_MAX_EXTRA_NODES);
            ClusterDef.ClusterGroup pool = ClusterDef.getCluster(this.config, 0);
            DrillbitScheduler testGroup = new DrillbitScheduler(pool.getName(), taskSpec, pool.getCount(), requestTimeoutSecs, maxExtraNodes);
            dispatcher.getController().registerScheduler(testGroup);
            pool.modifyTaskSpec(taskSpec);
            this.buildZooKeeper(this.config, dispatcher);
        }
        catch (YarnFacadeException | DoyConfigException e) {
            throw new ControllerFactory.ControllerFactoryException("Drill AM intitialization failed", e);
        }
        dispatcher.setHttpPort(this.config.getInt(DrillOnYarnConfig.HTTP_PORT));
        String trackingUrl = null;
        if (this.config.getBoolean(DrillOnYarnConfig.HTTP_ENABLED)) {
            trackingUrl = "http://<host>:<port>/redirect";
            dispatcher.setTrackingUrl(trackingUrl);
        }
        dispatcher.getController().enableFailureCheck(this.config.getBoolean(DrillOnYarnConfig.AM_ENABLE_AUTO_SHUTDOWN));
        AMSecurityManagerImpl.setup();
        return dispatcher;
    }

    private Map<String, LocalResource> prepareResources() throws YarnFacadeException {
        try {
            DfsFacade dfs = new DfsFacade(this.config);
            this.localized = dfs.isLocalized();
            if (!this.localized) {
                return null;
            }
            dfs.connect();
            HashMap<String, LocalResource> resources = new HashMap<String, LocalResource>();
            DrillOnYarnConfig drillConfig = DrillOnYarnConfig.instance();
            this.drillArchivePath = drillConfig.getDrillArchiveDfsPath();
            DfsFacade.Localizer localizer = new DfsFacade.Localizer(dfs, this.drillArchivePath);
            String key = this.config.getString(DrillOnYarnConfig.DRILL_ARCHIVE_KEY);
            localizer.defineResources(resources, key);
            LOG.info((Object)("Localizing " + this.drillArchivePath + " with key \"" + key + "\""));
            this.siteArchivePath = drillConfig.getSiteArchiveDfsPath();
            if (this.siteArchivePath != null) {
                localizer = new DfsFacade.Localizer(dfs, this.siteArchivePath);
                key = this.config.getString(DrillOnYarnConfig.SITE_ARCHIVE_KEY);
                localizer.defineResources(resources, key);
                LOG.info((Object)("Localizing " + this.siteArchivePath + " with key \"" + key + "\""));
            }
            return resources;
        }
        catch (DfsFacade.DfsFacadeException e) {
            throw new YarnFacadeException("Failed to get DFS status for Drill archive", e);
        }
    }

    private TaskSpec buildDrillTaskSpec(Map<String, LocalResource> resources) throws DoyConfigException {
        DrillOnYarnConfig doyConfig = DrillOnYarnConfig.instance();
        ContainerRequestSpec containerSpec = new ContainerRequestSpec();
        containerSpec.memoryMb = this.config.getInt(DrillOnYarnConfig.DRILLBIT_MEMORY);
        containerSpec.vCores = this.config.getInt(DrillOnYarnConfig.DRILLBIT_VCORES);
        containerSpec.disks = this.config.getDouble(DrillOnYarnConfig.DRILLBIT_DISKS);
        LaunchSpec drillbitSpec = new LaunchSpec();
        String drillHome = doyConfig.getRemoteDrillHome();
        drillbitSpec.env.put("DRILL_HOME", drillHome);
        LOG.trace((Object)("Drillbit DRILL_HOME: " + drillHome));
        this.addIfSet(drillbitSpec, DrillOnYarnConfig.DRILLBIT_HEAP, "DRILL_HEAP");
        this.addIfSet(drillbitSpec, DrillOnYarnConfig.DRILLBIT_DIRECT_MEM, "DRILL_MAX_DIRECT_MEMORY");
        this.addIfSet(drillbitSpec, DrillOnYarnConfig.DRILLBIT_CODE_CACHE, "DRILLBIT_CODE_CACHE_SIZE");
        this.addIfSet(drillbitSpec, DrillOnYarnConfig.DRILLBIT_VM_ARGS, "DRILL_JVM_OPTS");
        this.addIfSet(drillbitSpec, DrillOnYarnConfig.JAVA_LIB_PATH, "DOY_JAVA_LIB_PATH");
        if (!this.config.getBoolean(DrillOnYarnConfig.DISABLE_YARN_LOGS)) {
            drillbitSpec.env.put("DRILL_YARN_LOG_DIR", "<LOG_DIR>");
        }
        if (this.config.getBoolean(DrillOnYarnConfig.DRILLBIT_DEBUG_LAUNCH)) {
            drillbitSpec.env.put("DRILL_DEBUG", "1");
        }
        if (this.config.getBoolean(DrillOnYarnConfig.DRILLBIT_LOG_GC)) {
            drillbitSpec.env.put("ENABLE_GC_LOG", "1");
        }
        this.addIfSet(drillbitSpec, DrillOnYarnConfig.DRILLBIT_PREFIX_CLASSPATH, "DRILL_CLASSPATH_PREFIX");
        this.addIfSet(drillbitSpec, DrillOnYarnConfig.DRILLBIT_CLASSPATH, "DRILL_CLASSPATH");
        this.addIfSet(drillbitSpec, DrillOnYarnConfig.DRILLBIT_EXTN_CLASSPATH, "EXTN_CLASSPATH");
        this.addIfSet(drillbitSpec, DrillOnYarnConfig.HADOOP_CLASSPATH, "DRILL_HADOOP_CLASSPATH");
        this.addIfSet(drillbitSpec, DrillOnYarnConfig.HBASE_CLASSPATH, "DRILL_HBASE_CLASSPATH");
        drillbitSpec.command = "$DRILL_HOME/bin/yarn-drillbit.sh";
        String siteDirPath = doyConfig.getRemoteSiteDir();
        if (siteDirPath != null) {
            drillbitSpec.cmdArgs.add("--site");
            drillbitSpec.cmdArgs.add(siteDirPath);
        }
        if (resources != null) {
            drillbitSpec.resources.putAll(resources);
        }
        TaskSpec taskSpec = new TaskSpec();
        taskSpec.name = "Drillbit";
        taskSpec.containerSpec = containerSpec;
        taskSpec.launchSpec = drillbitSpec;
        taskSpec.maxRetries = this.config.getInt(DrillOnYarnConfig.DRILLBIT_MAX_RETRIES);
        return taskSpec;
    }

    public void addIfSet(LaunchSpec spec, String configParam, String envVar) {
        String value = this.config.getString(configParam);
        if (!DoYUtil.isBlank(value)) {
            spec.env.put(envVar, value);
        }
    }

    private void buildZooKeeper(Config config, Dispatcher dispatcher) {
        String zkConnect = config.getString("drill.exec.zk.connect");
        String zkRoot = config.getString("drill.exec.zk.root");
        String clusterId = config.getString("drill.exec.cluster-id");
        int failureTimeoutMs = config.getInt("drill.exec.zk.timeout");
        int retryCount = config.getInt("drill.exec.zk.retry.count");
        int retryDelayMs = config.getInt("drill.exec.zk.retry.delay");
        int userPort = config.getInt("drill.exec.rpc.user.server.port");
        int bitPort = config.getInt("drill.exec.rpc.bit.server.port");
        ZKClusterCoordinatorDriver driver = new ZKClusterCoordinatorDriver().setConnect(zkConnect, zkRoot, clusterId).setFailureTimoutMs(failureTimeoutMs).setRetryCount(retryCount).setRetryDelayMs(retryDelayMs).setPorts(userPort, bitPort, bitPort + 1);
        ZKRegistry zkRegistry = new ZKRegistry(driver);
        dispatcher.registerAddOn(new ZKRegistryAddOn(zkRegistry));
        dispatcher.getController().registerLifecycleListener(zkRegistry);
        dispatcher.setAMRegistrar(driver);
        dispatcher.getController().setProperty("zk", zkRegistry);
    }

    public static class ZKRegistryAddOn
    implements DispatcherAddOn {
        ZKRegistry zkRegistry;

        public ZKRegistryAddOn(ZKRegistry zkRegistry) {
            this.zkRegistry = zkRegistry;
        }

        @Override
        public void start(ClusterController controller) {
            this.zkRegistry.start(controller);
        }

        @Override
        public void finish(ClusterController controller) {
            this.zkRegistry.finish(controller);
        }
    }
}

