/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum.auth;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.zookeeper.Login;
import org.apache.zookeeper.SaslClientCallbackHandler;
import org.apache.zookeeper.server.quorum.QuorumAuthPacket;
import org.apache.zookeeper.server.quorum.auth.QuorumAuth;
import org.apache.zookeeper.server.quorum.auth.QuorumAuthLearner;
import org.apache.zookeeper.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslQuorumAuthLearner
implements QuorumAuthLearner {
    private static final Logger LOG = LoggerFactory.getLogger(SaslQuorumAuthLearner.class);
    private final Login learnerLogin;
    private final boolean quorumRequireSasl;
    private final String quorumServicePrincipal;
    private static Set<String> hostsFailedSaslClient = new HashSet<String>();

    public SaslQuorumAuthLearner(boolean quorumRequireSasl, String quorumServicePrincipal, String loginContext) throws SaslException {
        this.quorumRequireSasl = quorumRequireSasl;
        this.quorumServicePrincipal = quorumServicePrincipal;
        try {
            AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry(loginContext);
            if (entries == null || entries.length == 0) {
                throw new LoginException("SASL-authentication failed because the specified JAAS configuration section '" + loginContext + "' could not be found.");
            }
            this.learnerLogin = new Login(loginContext, new SaslClientCallbackHandler(null, "QuorumLearner"));
            this.learnerLogin.startThreadIfNeeded();
        }
        catch (LoginException e) {
            throw new SaslException("Failed to initialize authentication mechanism using SASL", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void authenticate(Socket sock, String hostName) throws IOException {
        if (!this.quorumRequireSasl) {
            SaslQuorumAuthLearner.LOG.info("Skipping SASL authentication as {}={}", (Object)"quorum.auth.learnerRequireSasl", (Object)this.quorumRequireSasl);
            return;
        }
        sc = null;
        principalConfig = SecurityUtils.getServerPrincipal(this.quorumServicePrincipal, hostName);
        try {
            dout = new DataOutputStream(sock.getOutputStream());
            din = new DataInputStream(sock.getInputStream());
            responseToken = new byte[]{};
            mechOpt = System.getProperty("zookeeper.authMech");
            if (mechOpt == null) {
                mechOpt = "GSSAPI";
            }
            SaslQuorumAuthLearner.LOG.debug("SaslQuorumAuthLearner: creating SASL client with mechanism " + mechOpt);
            sc = SecurityUtils.createSaslClient(this.learnerLogin.getSubject(), principalConfig, "zookeeper-quorum", "zk-quorum-sasl-md5", SaslQuorumAuthLearner.LOG, "QuorumLearner", mechOpt);
            if (sc != null) break block19;
            SaslQuorumAuthLearner.LOG.info("Connection start to {}: authenticate() failed to create a Sasl Client. Will retry soon ...", (Object)hostName);
            SaslQuorumAuthLearner.hostsFailedSaslClient.add(hostName);
            var12_9 = null;
            ** if (sc == null) goto lbl-1000
        }
        catch (Throwable var11_17) {
            var12_11 = null;
            if (sc != null) {
                try {
                    sc.dispose();
                }
                catch (SaslException e) {
                    SaslQuorumAuthLearner.LOG.error("SaslClient dispose() failed", (Throwable)e);
                }
            }
            throw var11_17;
        }
lbl-1000:
        // 1 sources

        {
            try {
                sc.dispose();
            }
            catch (SaslException e) {
                SaslQuorumAuthLearner.LOG.error("SaslClient dispose() failed", (Throwable)e);
            }
        }
lbl-1000:
        // 3 sources

        {
            block19: {
                return;
            }
            if (SaslQuorumAuthLearner.hostsFailedSaslClient.contains(hostName)) {
                SaslQuorumAuthLearner.LOG.info("Connection start to {}: authenticate() retry succeeded to create a Sasl Client.", (Object)hostName);
                SaslQuorumAuthLearner.hostsFailedSaslClient.remove(hostName);
            }
            if (sc.hasInitialResponse()) {
                responseToken = this.createSaslToken(new byte[0], sc, this.learnerLogin);
            }
            this.send(dout, responseToken);
            authPacket = this.receive(din);
            qpStatus = QuorumAuth.Status.getStatus(authPacket.getStatus());
            block11: while (!sc.isComplete()) {
                switch (2.$SwitchMap$org$apache$zookeeper$server$quorum$auth$QuorumAuth$Status[qpStatus.ordinal()]) {
                    case 1: {
                        responseToken = this.createSaslToken(authPacket.getToken(), sc, this.learnerLogin);
                        if (responseToken == null) continue block11;
                        throw new SaslException("Protocol error: attempting to send response after completion. Server addr: " + sock.getRemoteSocketAddress());
                    }
                    case 2: {
                        responseToken = this.createSaslToken(authPacket.getToken(), sc, this.learnerLogin);
                        this.send(dout, responseToken);
                        authPacket = this.receive(din);
                        qpStatus = QuorumAuth.Status.getStatus(authPacket.getStatus());
                        continue block11;
                    }
                    case 3: {
                        throw new SaslException("Authentication failed against server addr: " + sock.getRemoteSocketAddress());
                    }
                }
                SaslQuorumAuthLearner.LOG.warn("Unknown status:{}!", (Object)qpStatus);
                throw new SaslException("Authentication failed against server addr: " + sock.getRemoteSocketAddress());
            }
            this.checkAuthStatus(sock, qpStatus);
        }
        var12_10 = null;
        if (sc != null) {
            try {
                sc.dispose();
            }
            catch (SaslException e) {
                SaslQuorumAuthLearner.LOG.error("SaslClient dispose() failed", (Throwable)e);
            }
        }
    }

    private void checkAuthStatus(Socket sock, QuorumAuth.Status qpStatus) throws SaslException {
        if (qpStatus != QuorumAuth.Status.SUCCESS) {
            throw new SaslException("Authentication failed against server addr: " + sock.getRemoteSocketAddress() + ", qpStatus: " + (Object)((Object)qpStatus));
        }
        LOG.info("Successfully completed the authentication using SASL. server addr: {}, status: {}", (Object)sock.getRemoteSocketAddress(), (Object)qpStatus);
    }

    private QuorumAuthPacket receive(DataInputStream din) throws IOException {
        QuorumAuthPacket authPacket = new QuorumAuthPacket();
        BinaryInputArchive bia = BinaryInputArchive.getArchive(din);
        authPacket.deserialize(bia, "qpconnect");
        return authPacket;
    }

    private void send(DataOutputStream dout, byte[] response) throws IOException {
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(dout);
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(bufferedOutput);
        QuorumAuthPacket authPacket = QuorumAuth.createPacket(QuorumAuth.Status.IN_PROGRESS, response);
        boa.writeRecord(authPacket, "qpconnect");
        bufferedOutput.flush();
    }

    private byte[] createSaslToken(final byte[] saslToken, final SaslClient saslClient, Login login) throws SaslException {
        if (saslToken == null) {
            throw new SaslException("Error in authenticating with a Zookeeper Quorum member: the quorum member's saslToken is null.");
        }
        if (login.getSubject() != null) {
            Login login2 = login;
            synchronized (login2) {
                try {
                    byte[] retval = Subject.doAs(login.getSubject(), new PrivilegedExceptionAction<byte[]>(){

                        @Override
                        public byte[] run() throws SaslException {
                            LOG.debug("saslClient.evaluateChallenge(len=" + saslToken.length + ")");
                            return saslClient.evaluateChallenge(saslToken);
                        }
                    });
                    return retval;
                }
                catch (PrivilegedActionException e) {
                    String error = "An error: (" + e + ") occurred when evaluating Zookeeper Quorum Member's  received SASL token.";
                    String UNKNOWN_SERVER_ERROR_TEXT = "(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)";
                    if (e.toString().indexOf("(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)") > -1) {
                        error = error + " This may be caused by Java's being unable to resolve the Zookeeper Quorum Member's hostname correctly. You may want to try to adding '-Dsun.net.spi.nameservice.provider.1=dns,sun' to your server's JVMFLAGS environment.";
                    }
                    LOG.error(error);
                    throw new SaslException(error);
                }
            }
        }
        throw new SaslException("Cannot make SASL token without subject defined. For diagnosis, please look for WARNs and ERRORs in your log related to the Login class.");
    }
}

