/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.server.api.ConfigurableAuxiliaryService;

public class ConfigurableAuxServices
extends AbstractService
implements ServiceStateChangeListener {
    private static final Log LOG = LogFactory.getLog(ConfigurableAuxServices.class);
    private final Map<String, ConfigurableAuxiliaryService> serviceMap;
    private final Pattern p = Pattern.compile("^[A-Za-z_]+[A-Za-z0-9_]*$");
    private final String auxServicesPropName;

    public ConfigurableAuxServices(String name, String auxServicesPropName) {
        super(name);
        this.auxServicesPropName = auxServicesPropName;
        this.serviceMap = Collections.synchronizedMap(new HashMap());
    }

    public void serviceInit(Configuration conf) throws Exception {
        Collection auxNames = conf.getStringCollection(this.auxServicesPropName);
        for (String sName : auxNames) {
            try {
                Preconditions.checkArgument((boolean)this.validateAuxServiceName(sName), (Object)("The ServiceName: " + sName + " set in " + this.auxServicesPropName + " is invalid.The valid service name should only contain a-zA-Z0-9_ and can not start with numbers"));
                Class sClass = conf.getClass(String.format("yarn.resourcemanager.aux-services.%s.class", sName), null, ConfigurableAuxiliaryService.class);
                if (null == sClass) {
                    throw new RuntimeException("No class defined for " + sName);
                }
                ConfigurableAuxiliaryService s = (ConfigurableAuxiliaryService)((Object)ReflectionUtils.newInstance((Class)sClass, (Configuration)conf));
                this.addService(sName, s);
                s.init(conf);
            }
            catch (RuntimeException e) {
                LOG.fatal((Object)("Failed to initialize " + sName), (Throwable)e);
                throw e;
            }
        }
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        for (Map.Entry<String, ConfigurableAuxiliaryService> entry : this.serviceMap.entrySet()) {
            ConfigurableAuxiliaryService service = entry.getValue();
            service.start();
        }
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws Exception {
        try {
            Map<String, ConfigurableAuxiliaryService> map = this.serviceMap;
            synchronized (map) {
                for (Service service : this.serviceMap.values()) {
                    if (service.getServiceState() != Service.STATE.STARTED) continue;
                    service.stop();
                }
                this.serviceMap.clear();
            }
        }
        finally {
            super.serviceStop();
        }
    }

    public void stateChanged(Service service) {
        LOG.fatal((Object)("Service " + service.getName() + " changed state: " + service.getServiceState()));
        this.stop();
    }

    private final synchronized void addService(String name, ConfigurableAuxiliaryService service) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Adding auxiliary service " + service.getName() + ", \"" + name + "\""));
        }
        this.serviceMap.put(name, service);
    }

    private boolean validateAuxServiceName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        return this.p.matcher(name).matches();
    }
}

