/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Deferred;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kudu.WireProtocol;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.ConnectToMasterRequest;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.Negotiator;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.RecoverableException;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.client.RequestTracker;
import org.apache.kudu.client.RpcOutboundMessage;
import org.apache.kudu.client.RpcRemoteException;
import org.apache.kudu.client.RpcTraceFrame;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.client.Status;
import org.apache.kudu.client.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kudu.client.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.client.shaded.com.google.common.collect.Lists;
import org.apache.kudu.client.shaded.com.google.protobuf.GeneratedMessage;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.Channel;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelEvent;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelFuture;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.Channels;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ExceptionEvent;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.MessageEvent;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.apache.kudu.master.Master;
import org.apache.kudu.rpc.RpcHeader;
import org.apache.kudu.tserver.Tserver;
import org.apache.kudu.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TabletClient
extends SimpleChannelUpstreamHandler {
    public static final Logger LOG = LoggerFactory.getLogger(TabletClient.class);
    public static final byte RPC_CURRENT_VERSION = 9;
    private static final byte[] CONNECTION_HEADER = new byte[]{104, 114, 112, 99, 9, 0, 0};
    private Channel chan;
    private final ReentrantLock lock = new ReentrantLock();
    @GuardedBy(value="lock")
    ArrayList<KuduRpc<?>> pendingRpcs = Lists.newArrayList();
    @GuardedBy(value="lock")
    private int nextCallId = 0;
    @GuardedBy(value="lock")
    private State state = State.NEGOTIATING;
    @GuardedBy(value="lock")
    private HashMap<Integer, KuduRpc<?>> rpcsInflight = new HashMap();
    @GuardedBy(value="lock")
    private Negotiator.Result negotiationResult;
    private final AsyncKuduClient kuduClient;
    private final long socketReadTimeoutMs;
    private final RequestTracker requestTracker;
    private final ServerInfo serverInfo;
    private volatile boolean closedByClient;

    public TabletClient(AsyncKuduClient client, ServerInfo serverInfo) {
        this.kuduClient = client;
        this.socketReadTimeoutMs = client.getDefaultSocketReadTimeoutMs();
        this.requestTracker = client.getRequestTracker();
        this.serverInfo = serverInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> void sendRpc(KuduRpc<R> rpc) {
        Message req;
        Preconditions.checkArgument(rpc.hasDeferred());
        rpc.addTrace(new RpcTraceFrame.RpcTraceFrameBuilder(rpc.method(), RpcTraceFrame.Action.SEND_TO_SERVER).serverInfo(this.serverInfo).build());
        if (!rpc.deadlineTracker.hasDeadline()) {
            LOG.warn(this.getPeerUuidLoggingString() + " sending an rpc without a timeout " + rpc);
        }
        try {
            req = rpc.createRequestPB();
        }
        catch (Exception e) {
            LOG.error("Uncaught exception while constructing RPC request: " + rpc, (Throwable)e);
            rpc.errback(e);
            return;
        }
        this.lock.lock();
        boolean needsUnlock = true;
        try {
            if (this.state == State.DISCONNECTED) {
                this.lock.unlock();
                needsUnlock = false;
                Status statusNetworkError = Status.NetworkError(this.getPeerUuidLoggingString() + "Connection reset");
                this.failOrRetryRpc(rpc, new RecoverableException(statusNetworkError));
                return;
            }
            if (this.state == State.NEGOTIATING) {
                this.pendingRpcs.add(rpc);
                return;
            }
            assert (this.state == State.ALIVE);
            assert (this.chan != null);
            if (!rpc.getRequiredFeatures().isEmpty() && !this.negotiationResult.serverFeatures.contains(RpcHeader.RpcFeatureFlag.APPLICATION_FEATURE_FLAGS)) {
                this.lock.unlock();
                needsUnlock = false;
                Status statusNotSupported = Status.NotSupported("the server does not support theAPPLICATION_FEATURE_FLAGS RPC feature");
                rpc.errback(new NonRecoverableException(statusNotSupported));
                return;
            }
            this.sendCallToWire(rpc, req);
        }
        finally {
            if (needsUnlock) {
                this.lock.unlock();
            }
        }
    }

    @GuardedBy(value="lock")
    private <R> void sendCallToWire(KuduRpc<R> rpc, Message reqPB) {
        KuduRpc<R> oldrpc;
        assert (this.lock.isHeldByCurrentThread());
        assert (this.state == State.ALIVE);
        assert (this.chan != null);
        int callId = this.nextCallId++;
        RpcHeader.RequestHeader.Builder headerBuilder = RpcHeader.RequestHeader.newBuilder().addAllRequiredFeatureFlags(rpc.getRequiredFeatures()).setCallId(callId).setRemoteMethod(RpcHeader.RemoteMethodPB.newBuilder().setServiceName(rpc.serviceName()).setMethodName(rpc.method()));
        if (rpc.deadlineTracker.hasDeadline() || this.socketReadTimeoutMs > 0L) {
            long millisBeforeDeadline = Long.MAX_VALUE;
            if (rpc.deadlineTracker.hasDeadline()) {
                millisBeforeDeadline = rpc.deadlineTracker.getMillisBeforeDeadline();
            }
            long localRpcTimeoutMs = Long.MAX_VALUE;
            if (this.socketReadTimeoutMs > 0L) {
                localRpcTimeoutMs = this.socketReadTimeoutMs;
            }
            headerBuilder.setTimeoutMillis((int)Math.min(millisBeforeDeadline, localRpcTimeoutMs));
        }
        if (rpc.isRequestTracked()) {
            RpcHeader.RequestIdPB.Builder requestIdBuilder = RpcHeader.RequestIdPB.newBuilder();
            if (rpc.getSequenceId() == -1L) {
                rpc.setSequenceId(this.requestTracker.newSeqNo());
            }
            requestIdBuilder.setClientId(this.requestTracker.getClientId());
            requestIdBuilder.setSeqNo(rpc.getSequenceId());
            requestIdBuilder.setAttemptNo(rpc.attempt);
            requestIdBuilder.setFirstIncompleteSeqNo(this.requestTracker.firstIncomplete());
            headerBuilder.setRequestId(requestIdBuilder);
        }
        if ((oldrpc = this.rpcsInflight.put(callId, rpc)) != null) {
            String wtf = this.getPeerUuidLoggingString() + "Unexpected state: there was already an RPC in flight with" + " callId=" + callId + ": " + oldrpc + ".  This happened when sending out: " + rpc;
            LOG.error(wtf);
            Status statusIllegalState = Status.IllegalState(wtf);
            oldrpc.errback(new NonRecoverableException(statusIllegalState));
            return;
        }
        RpcOutboundMessage outbound = new RpcOutboundMessage(headerBuilder, reqPB);
        Channels.write(this.chan, outbound);
    }

    @VisibleForTesting
    ChannelFuture disconnect() {
        Preconditions.checkNotNull(this.chan);
        this.closedByClient = true;
        return Channels.disconnect(this.chan);
    }

    public Deferred<Void> shutdown() {
        ChannelFuture disconnectFuture = this.disconnect();
        final Deferred d = new Deferred();
        disconnectFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    d.callback(null);
                    return;
                }
                Throwable t = future.getCause();
                if (t instanceof Exception) {
                    d.callback((Object)t);
                } else {
                    Status statusIllegalState = Status.IllegalState("Failed to shutdown: " + TabletClient.this);
                    d.callback((Object)new NonRecoverableException(statusIllegalState, t));
                }
            }
        });
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        KuduRpc<?> rpc;
        Object m = evt.getMessage();
        if (m instanceof Negotiator.Result) {
            ArrayList<KuduRpc<?>> queuedRpcs;
            this.lock.lock();
            try {
                assert (this.chan != null);
                this.negotiationResult = (Negotiator.Result)m;
                this.state = State.ALIVE;
                queuedRpcs = this.pendingRpcs;
                this.pendingRpcs = null;
            }
            finally {
                this.lock.unlock();
            }
            this.sendQueuedRpcs(queuedRpcs);
            return;
        }
        if (!(m instanceof CallResponse)) {
            ctx.sendUpstream(evt);
            return;
        }
        CallResponse response = (CallResponse)m;
        long start = System.nanoTime();
        RpcHeader.ResponseHeader header = response.getHeader();
        if (!header.hasCallId()) {
            int size = response.getTotalResponseSize();
            String msg = this.getPeerUuidLoggingString() + "RPC response (size: " + size + ") doesn't" + " have a call ID: " + header;
            LOG.error(msg);
            Status statusIncomplete = Status.Incomplete(msg);
            throw new NonRecoverableException(statusIncomplete);
        }
        int rpcid = header.getCallId();
        this.lock.lock();
        try {
            rpc = this.rpcsInflight.remove(rpcid);
        }
        finally {
            this.lock.unlock();
        }
        if (rpc == null) {
            String msg = this.getPeerUuidLoggingString() + "Invalid rpcid: " + rpcid;
            LOG.error(msg);
            throw new NonRecoverableException(Status.IllegalState(msg));
        }
        RpcTraceFrame.RpcTraceFrameBuilder traceBuilder = new RpcTraceFrame.RpcTraceFrameBuilder(rpc.method(), RpcTraceFrame.Action.RECEIVE_FROM_SERVER).serverInfo(this.serverInfo);
        Pair<?, Object> decoded = null;
        KuduException exception = null;
        Status retryableHeaderError = Status.OK();
        if (header.hasIsError() && header.getIsError()) {
            RpcHeader.ErrorStatusPB.Builder errorBuilder = RpcHeader.ErrorStatusPB.newBuilder();
            KuduRpc.readProtobuf(response.getPBMessage(), errorBuilder);
            RpcHeader.ErrorStatusPB error = errorBuilder.build();
            if (error.getCode().equals(RpcHeader.ErrorStatusPB.RpcErrorCodePB.ERROR_SERVER_TOO_BUSY)) {
                retryableHeaderError = Status.ServiceUnavailable(error.getMessage());
            } else {
                String message = this.getPeerUuidLoggingString() + "Tablet server sent error " + error.getMessage();
                Status status = Status.RemoteError(message);
                exception = new RpcRemoteException(status, error);
                LOG.error(message);
            }
        } else {
            try {
                decoded = rpc.deserialize(response, this.serverInfo.getUuid());
            }
            catch (KuduException ex) {
                exception = ex;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.getPeerUuidLoggingString() + " received RPC response: " + "rpcId=" + rpcid + ", response size=" + response.getTotalResponseSize() + ", rpc=" + rpc);
        }
        if (!retryableHeaderError.ok()) {
            rpc.addTrace(traceBuilder.callStatus(retryableHeaderError).build());
            this.kuduClient.handleRetryableError(rpc, new RecoverableException(retryableHeaderError));
            return;
        }
        if (decoded != null) {
            GeneratedMessage error;
            if (decoded.getSecond() instanceof Tserver.TabletServerErrorPB) {
                error = (Tserver.TabletServerErrorPB)decoded.getSecond();
                exception = this.dispatchTSErrorOrReturnException(rpc, (Tserver.TabletServerErrorPB)error, traceBuilder);
                if (exception == null) {
                    return;
                }
                decoded = null;
            } else if (decoded.getSecond() instanceof Master.MasterErrorPB) {
                error = (Master.MasterErrorPB)decoded.getSecond();
                exception = this.dispatchMasterErrorOrReturnException(rpc, (Master.MasterErrorPB)error, traceBuilder);
                if (exception == null) {
                    return;
                }
                decoded = null;
            }
        }
        try {
            if (decoded != null) {
                assert (!(decoded.getFirst() instanceof Exception));
                if (this.kuduClient.isStatisticsEnabled()) {
                    rpc.updateStatistics(this.kuduClient.getStatistics(), decoded.getFirst());
                }
                rpc.addTrace(traceBuilder.callStatus(Status.OK()).build());
                rpc.callback(decoded.getFirst());
            } else {
                if (this.kuduClient.isStatisticsEnabled()) {
                    rpc.updateStatistics(this.kuduClient.getStatistics(), null);
                }
                rpc.addTrace(traceBuilder.callStatus(exception.getStatus()).build());
                rpc.errback(exception);
            }
        }
        catch (Exception e) {
            LOG.debug(this.getPeerUuidLoggingString() + "Unexpected exception while handling RPC #" + rpcid + ", rpc=" + rpc, (Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("------------------<< LEAVING  DECODE <<------------------ time elapsed: " + (System.nanoTime() - start) / 1000L + "us");
        }
    }

    private KuduException dispatchTSErrorOrReturnException(KuduRpc<?> rpc, Tserver.TabletServerErrorPB error, RpcTraceFrame.RpcTraceFrameBuilder traceBuilder) {
        WireProtocol.AppStatusPB.ErrorCode code = error.getStatus().getCode();
        Status status = Status.fromTabletServerErrorPB(error);
        if (error.getCode() == Tserver.TabletServerErrorPB.Code.TABLET_NOT_FOUND) {
            this.kuduClient.handleTabletNotFound(rpc, new RecoverableException(status), this);
        } else if (code == WireProtocol.AppStatusPB.ErrorCode.SERVICE_UNAVAILABLE) {
            this.kuduClient.handleRetryableError(rpc, new RecoverableException(status));
        } else if (code == WireProtocol.AppStatusPB.ErrorCode.ILLEGAL_STATE || code == WireProtocol.AppStatusPB.ErrorCode.ABORTED) {
            this.kuduClient.handleNotLeader(rpc, new RecoverableException(status), this);
        } else {
            return new NonRecoverableException(status);
        }
        rpc.addTrace(traceBuilder.callStatus(status).build());
        return null;
    }

    private KuduException dispatchMasterErrorOrReturnException(KuduRpc<?> rpc, Master.MasterErrorPB error, RpcTraceFrame.RpcTraceFrameBuilder traceBuilder) {
        WireProtocol.AppStatusPB.ErrorCode code = error.getStatus().getCode();
        Status status = Status.fromMasterErrorPB(error);
        if (error.getCode() == Master.MasterErrorPB.Code.NOT_THE_LEADER) {
            this.kuduClient.handleNotLeader(rpc, new RecoverableException(status), this);
        } else if (code == WireProtocol.AppStatusPB.ErrorCode.SERVICE_UNAVAILABLE) {
            if (rpc instanceof ConnectToMasterRequest) {
                return new RecoverableException(status);
            }
            this.kuduClient.handleRetryableError(rpc, new RecoverableException(status));
        } else {
            return new NonRecoverableException(status);
        }
        rpc.addTrace(traceBuilder.callStatus(status).build());
        return null;
    }

    public boolean isAlive() {
        this.lock.lock();
        try {
            boolean bl = this.state == State.ALIVE || this.state == State.NEGOTIATING;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.chan = e.getChannel();
        super.channelOpen(ctx, e);
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        assert (this.chan != null);
        Channels.write(this.chan, ChannelBuffers.wrappedBuffer(CONNECTION_HEADER));
        Negotiator negotiator = new Negotiator(this.serverInfo.getHostname(), this.kuduClient.getSecurityContext());
        ctx.getPipeline().addBefore(ctx.getName(), "negotiation", negotiator);
        negotiator.sendHello(this.chan);
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace(e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelDisconnected(ctx, e);
        this.cleanup("Connection disconnected");
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelClosed(ctx, e);
        this.cleanup("Connection closed");
    }

    private void cleanup(String errorMessage) {
        ArrayList<KuduRpc<?>> rpcsToFail = Lists.newArrayList();
        this.lock.lock();
        try {
            if (this.state == State.DISCONNECTED) {
                assert (this.pendingRpcs == null);
                return;
            }
            this.state = State.DISCONNECTED;
            if (this.pendingRpcs != null) {
                rpcsToFail.addAll(this.pendingRpcs);
            }
            this.pendingRpcs = null;
            rpcsToFail.addAll(this.rpcsInflight.values());
            this.rpcsInflight = null;
        }
        finally {
            this.lock.unlock();
        }
        Status statusNetworkError = Status.NetworkError(this.getPeerUuidLoggingString() + (errorMessage == null ? "Connection reset" : errorMessage));
        RecoverableException exception = new RecoverableException(statusNetworkError);
        this.failOrRetryRpcs(rpcsToFail, exception);
    }

    private void failOrRetryRpcs(Collection<KuduRpc<?>> rpcs, RecoverableException exception) {
        for (KuduRpc<?> rpc : rpcs) {
            this.failOrRetryRpc(rpc, exception);
        }
    }

    private void failOrRetryRpc(KuduRpc<?> rpc, RecoverableException exception) {
        rpc.addTrace(new RpcTraceFrame.RpcTraceFrameBuilder(rpc.method(), RpcTraceFrame.Action.RECEIVE_FROM_SERVER).serverInfo(this.serverInfo).callStatus(exception.getStatus()).build());
        RemoteTablet tablet = rpc.getTablet();
        if (tablet == null) {
            rpc.errback(exception);
        } else {
            this.kuduClient.handleTabletNotFound(rpc, exception, this);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        Throwable e = event.getCause();
        Channel c = event.getChannel();
        if (e instanceof RejectedExecutionException) {
            LOG.warn(this.getPeerUuidLoggingString() + "RPC rejected by the executor," + " ignore this if we're shutting down", e);
        } else if (e instanceof ReadTimeoutException) {
            LOG.debug(this.getPeerUuidLoggingString() + "Encountered a read timeout, will close the channel");
        } else if (e instanceof ClosedChannelException) {
            if (!this.closedByClient) {
                LOG.info(this.getPeerUuidLoggingString() + "Lost connection to peer");
            }
        } else {
            LOG.error(this.getPeerUuidLoggingString() + "Unexpected exception from downstream on " + c, e);
        }
        if (c.isOpen()) {
            Channels.close(c);
        } else {
            this.cleanup(e.getMessage());
        }
    }

    private void sendQueuedRpcs(List<KuduRpc<?>> rpcs) {
        assert (!this.lock.isHeldByCurrentThread());
        for (KuduRpc<?> rpc : rpcs) {
            LOG.debug(this.getPeerUuidLoggingString() + "Executing RPC queued: " + rpc);
            this.sendRpc(rpc);
        }
    }

    private String getPeerUuidLoggingString() {
        return "[Peer " + this.serverInfo.getUuid() + "] ";
    }

    ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int nInFlight;
        int npendingRpcs;
        StringBuilder buf = new StringBuilder();
        buf.append("TabletClient@").append(this.hashCode()).append("(chan=").append(this.chan).append(", uuid=").append(this.serverInfo.getUuid()).append(", #pending_rpcs=");
        this.lock.lock();
        try {
            npendingRpcs = this.pendingRpcs == null ? 0 : this.pendingRpcs.size();
            nInFlight = this.rpcsInflight == null ? 0 : this.rpcsInflight.size();
        }
        finally {
            this.lock.unlock();
        }
        buf.append(npendingRpcs);
        buf.append(", #rpcs_inflight=").append(nInFlight).append(')');
        return buf.toString();
    }

    private static enum State {
        NEGOTIATING,
        ALIVE,
        DISCONNECTED;

    }
}

