/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.vector;

import hive.org.apache.parquet.column.ColumnDescriptor;
import hive.org.apache.parquet.column.page.PageReader;
import hive.org.apache.parquet.schema.DecimalMetadata;
import hive.org.apache.parquet.schema.PrimitiveType;
import hive.org.apache.parquet.schema.Type;
import java.io.IOException;
import java.time.ZoneId;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.io.parquet.vector.BaseVectorizedColumnReader;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorizedPrimitiveColumnReader
extends BaseVectorizedColumnReader {
    public VectorizedPrimitiveColumnReader(ColumnDescriptor descriptor, PageReader pageReader, boolean skipTimestampConversion, ZoneId writerTimezone, Type type, TypeInfo hiveType) throws IOException {
        super(descriptor, pageReader, skipTimestampConversion, writerTimezone, type, hiveType);
    }

    @Override
    public void readBatch(int total, ColumnVector column, TypeInfo columnType) throws IOException {
        int rowId = 0;
        while (total > 0) {
            int leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            if (leftInPage == 0) {
                this.readPage();
                leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            }
            int num = Math.min(total, leftInPage);
            if (this.isCurrentPageDictionaryEncoded) {
                LongColumnVector dictionaryIds = new LongColumnVector();
                this.readDictionaryIDs(num, dictionaryIds, rowId);
                this.decodeDictionaryIds(rowId, num, column, columnType, dictionaryIds);
            } else {
                this.readBatchHelper(num, column, columnType, rowId);
            }
            rowId += num;
            total -= num;
        }
    }

    private void readBatchHelper(int num, ColumnVector column, TypeInfo columnType, int rowId) throws IOException {
        PrimitiveTypeInfo primitiveColumnType = (PrimitiveTypeInfo)columnType;
        switch (primitiveColumnType.getPrimitiveCategory()) {
            case INT: 
            case BYTE: 
            case SHORT: {
                this.readIntegers(num, (LongColumnVector)column, rowId);
                break;
            }
            case DATE: 
            case INTERVAL_YEAR_MONTH: 
            case LONG: {
                this.readLongs(num, (LongColumnVector)column, rowId);
                break;
            }
            case BOOLEAN: {
                this.readBooleans(num, (LongColumnVector)column, rowId);
                break;
            }
            case DOUBLE: {
                this.readDoubles(num, (DoubleColumnVector)column, rowId);
                break;
            }
            case BINARY: {
                this.readBinaries(num, (BytesColumnVector)column, rowId);
                break;
            }
            case STRING: {
                this.readString(num, (BytesColumnVector)column, rowId);
                break;
            }
            case VARCHAR: {
                this.readVarchar(num, (BytesColumnVector)column, rowId);
                break;
            }
            case CHAR: {
                this.readChar(num, (BytesColumnVector)column, rowId);
                break;
            }
            case FLOAT: {
                this.readFloats(num, (DoubleColumnVector)column, rowId);
                break;
            }
            case DECIMAL: {
                this.readDecimal(num, (DecimalColumnVector)column, rowId);
                break;
            }
            case TIMESTAMP: {
                this.readTimestamp(num, (TimestampColumnVector)column, rowId);
                break;
            }
            default: {
                throw new IOException("Unsupported type: " + this.type);
            }
        }
    }

    private static void setNullValue(ColumnVector c, int rowId) {
        c.isNull[rowId] = true;
        c.isRepeating = false;
        c.noNulls = false;
    }

    private void readDictionaryIDs(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readValueDictionaryId();
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
            } else {
                VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
            }
            ++rowId;
        }
    }

    private void readIntegers(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readInteger();
                if (this.dataColumn.isValid(c.vector[rowId])) {
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    c.vector[rowId] = 0L;
                    VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
            }
            ++rowId;
        }
    }

    private void readDoubles(int total, DoubleColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readDouble();
                if (this.dataColumn.isValid(c.vector[rowId])) {
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    c.vector[rowId] = 0.0;
                    VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
            }
            ++rowId;
        }
    }

    private void readBooleans(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readBoolean() ? 1L : 0L;
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
            } else {
                VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
            }
            ++rowId;
        }
    }

    private void readLongs(int total, LongColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readLong();
                if (this.dataColumn.isValid(c.vector[rowId])) {
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    c.vector[rowId] = 0L;
                    VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
            }
            ++rowId;
        }
    }

    private void readFloats(int total, DoubleColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.vector[rowId] = this.dataColumn.readFloat();
                if (this.dataColumn.isValid(c.vector[rowId])) {
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    c.vector[rowId] = 0.0;
                    VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
            }
            ++rowId;
        }
    }

    private void readDecimal(int total, DecimalColumnVector c, int rowId) throws IOException {
        DecimalMetadata decimalMetadata = this.type.asPrimitiveType().getDecimalMetadata();
        this.fillDecimalPrecisionScale(decimalMetadata, c);
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                if (decimalMetadata != null) {
                    c.vector[rowId].set(this.dataColumn.readDecimal(), c.scale);
                    c.isNull[rowId] = false;
                    c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                } else {
                    long value = this.dataColumn.readLong();
                    if (this.dataColumn.isValid(value)) {
                        c.vector[rowId].setFromLong(value);
                        c.isNull[rowId] = false;
                        c.isRepeating = c.isRepeating && c.vector[0] == c.vector[rowId];
                    } else {
                        VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
                    }
                }
            } else {
                VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
            }
            ++rowId;
        }
    }

    private void readString(int total, BytesColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.setVal(rowId, this.dataColumn.readString());
                c.isNull[rowId] = false;
                c.isRepeating = false;
            } else {
                VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
            }
            ++rowId;
        }
    }

    private void readChar(int total, BytesColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.setVal(rowId, this.dataColumn.readChar());
                c.isNull[rowId] = false;
                c.isRepeating = false;
            } else {
                VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
            }
            ++rowId;
        }
    }

    private void readVarchar(int total, BytesColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.setVal(rowId, this.dataColumn.readVarchar());
                c.isNull[rowId] = false;
                c.isRepeating = false;
            } else {
                VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
            }
            ++rowId;
        }
    }

    private void readBinaries(int total, BytesColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                c.setVal(rowId, this.dataColumn.readBytes());
                c.isNull[rowId] = false;
                c.isRepeating = false;
            } else {
                VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
            }
            ++rowId;
        }
    }

    private void readTimestamp(int total, TimestampColumnVector c, int rowId) throws IOException {
        for (int left = total; left > 0; --left) {
            this.readRepetitionAndDefinitionLevels();
            if (this.definitionLevel >= this.maxDefLevel) {
                switch (this.descriptor.getType()) {
                    case INT96: {
                        c.set(rowId, this.dataColumn.readTimestamp().toSqlTimestamp());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported parquet logical type: " + this.type.getOriginalType() + " for timestamp");
                    }
                }
                c.isNull[rowId] = false;
                c.isRepeating = c.isRepeating && c.time[0] == c.time[rowId] && c.nanos[0] == c.nanos[rowId];
            } else {
                VectorizedPrimitiveColumnReader.setNullValue(c, rowId);
            }
            ++rowId;
        }
    }

    private void decodeDictionaryIds(int rowId, int num, ColumnVector column, TypeInfo columnType, LongColumnVector dictionaryIds) {
        System.arraycopy(dictionaryIds.isNull, rowId, column.isNull, rowId, num);
        if (column.noNulls) {
            column.noNulls = dictionaryIds.noNulls;
        }
        column.isRepeating = column.isRepeating && dictionaryIds.isRepeating;
        PrimitiveTypeInfo primitiveColumnType = (PrimitiveTypeInfo)columnType;
        switch (primitiveColumnType.getPrimitiveCategory()) {
            case INT: 
            case BYTE: 
            case SHORT: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((LongColumnVector)column).vector[i] = this.dictionary.readInteger((int)dictionaryIds.vector[i]);
                    if (this.dictionary.isValid(((LongColumnVector)column).vector[i])) continue;
                    VectorizedPrimitiveColumnReader.setNullValue(column, i);
                    ((LongColumnVector)column).vector[i] = 0L;
                }
                break;
            }
            case DATE: 
            case INTERVAL_YEAR_MONTH: 
            case LONG: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((LongColumnVector)column).vector[i] = this.dictionary.readLong((int)dictionaryIds.vector[i]);
                }
                break;
            }
            case BOOLEAN: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((LongColumnVector)column).vector[i] = this.dictionary.readBoolean((int)dictionaryIds.vector[i]) ? 1L : 0L;
                }
                break;
            }
            case DOUBLE: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((DoubleColumnVector)column).vector[i] = this.dictionary.readDouble((int)dictionaryIds.vector[i]);
                }
                break;
            }
            case BINARY: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((BytesColumnVector)column).setVal(i, this.dictionary.readBytes((int)dictionaryIds.vector[i]));
                }
                break;
            }
            case STRING: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((BytesColumnVector)column).setVal(i, this.dictionary.readString((int)dictionaryIds.vector[i]));
                }
                break;
            }
            case VARCHAR: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((BytesColumnVector)column).setVal(i, this.dictionary.readVarchar((int)dictionaryIds.vector[i]));
                }
                break;
            }
            case CHAR: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((BytesColumnVector)column).setVal(i, this.dictionary.readChar((int)dictionaryIds.vector[i]));
                }
                break;
            }
            case FLOAT: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((DoubleColumnVector)column).vector[i] = this.dictionary.readFloat((int)dictionaryIds.vector[i]);
                }
                break;
            }
            case DECIMAL: {
                DecimalMetadata decimalMetadata = this.type.asPrimitiveType().getDecimalMetadata();
                DecimalColumnVector decimalColumnVector = (DecimalColumnVector)column;
                this.fillDecimalPrecisionScale(decimalMetadata, decimalColumnVector);
                if (decimalMetadata != null) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        decimalColumnVector.vector[i].set(this.dictionary.readDecimal((int)dictionaryIds.vector[i]), decimalColumnVector.scale);
                    }
                } else {
                    for (int i = rowId; i < rowId + num; ++i) {
                        long value = this.dictionary.readLong((int)dictionaryIds.vector[i]);
                        if (this.dictionary.isValid(value)) {
                            decimalColumnVector.vector[i].setFromLong(this.dictionary.readLong((int)dictionaryIds.vector[i]));
                            continue;
                        }
                        VectorizedPrimitiveColumnReader.setNullValue(column, i);
                    }
                }
                break;
            }
            case TIMESTAMP: {
                for (int i = rowId; i < rowId + num; ++i) {
                    ((TimestampColumnVector)column).set(i, this.dictionary.readTimestamp((int)dictionaryIds.vector[i]).toSqlTimestamp());
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + this.type);
            }
        }
    }

    private void fillDecimalPrecisionScale(DecimalMetadata decimalMetadata, DecimalColumnVector decimalColumnVector) {
        if (decimalMetadata != null) {
            decimalColumnVector.precision = (short)this.type.asPrimitiveType().getDecimalMetadata().getPrecision();
            decimalColumnVector.scale = (short)this.type.asPrimitiveType().getDecimalMetadata().getScale();
        } else if (this.type.asPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
            decimalColumnVector.precision = (short)10;
            decimalColumnVector.scale = 0;
        } else if (this.type.asPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64) {
            decimalColumnVector.precision = (short)19;
            decimalColumnVector.scale = 0;
        } else {
            throw new UnsupportedOperationException("The underlying Parquet type cannot be converted to Hive Decimal type: " + this.type);
        }
    }
}

