/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.cache;

import hive.com.google.common.annotations.VisibleForTesting;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.cache.ByteArrayWrapper;
import org.apache.hadoop.hive.metastore.cache.CacheUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.util.IncrementalObjectSizeEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedCache {
    private static ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
    private boolean isCatalogCachePrewarmed = false;
    private Map<String, Catalog> catalogCache = new TreeMap<String, Catalog>();
    private HashSet<String> catalogsDeletedDuringPrewarm = new HashSet();
    private AtomicBoolean isCatalogCacheDirty = new AtomicBoolean(false);
    private Map<String, Database> databaseCache = new TreeMap<String, Database>();
    private boolean isDatabaseCachePrewarmed = false;
    private HashSet<String> databasesDeletedDuringPrewarm = new HashSet();
    private AtomicBoolean isDatabaseCacheDirty = new AtomicBoolean(false);
    private Map<String, TableWrapper> tableCache = new TreeMap<String, TableWrapper>();
    private boolean isTableCachePrewarmed = false;
    private HashSet<String> tablesDeletedDuringPrewarm = new HashSet();
    private AtomicBoolean isTableCacheDirty = new AtomicBoolean(false);
    private Map<ByteArrayWrapper, StorageDescriptorWrapper> sdCache = new HashMap<ByteArrayWrapper, StorageDescriptorWrapper>();
    private static MessageDigest md;
    private static final Logger LOG;
    private AtomicLong cacheUpdateCount = new AtomicLong(0L);
    private static long maxCacheSizeInBytes;
    private static long currentCacheSizeInBytes;
    private static HashMap<Class<?>, IncrementalObjectSizeEstimator.ObjectEstimator> sizeEstimators;

    public void initialize(long maxSharedCacheSizeInBytes) {
        maxCacheSizeInBytes = maxSharedCacheSizeInBytes;
        if (maxCacheSizeInBytes > 0L && sizeEstimators == null) {
            sizeEstimators = IncrementalObjectSizeEstimator.createEstimators(SharedCache.class);
        }
    }

    private static IncrementalObjectSizeEstimator.ObjectEstimator getMemorySizeEstimator(Class<?> clazz) {
        IncrementalObjectSizeEstimator.ObjectEstimator estimator = sizeEstimators.get(clazz);
        if (estimator == null) {
            IncrementalObjectSizeEstimator.createEstimators(clazz, sizeEstimators);
            estimator = sizeEstimators.get(clazz);
        }
        return estimator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateCatalogsInCache(Collection<Catalog> catalogs) {
        for (Catalog cat : catalogs) {
            Catalog catCopy = cat.deepCopy();
            catCopy.setName(catCopy.getName().toLowerCase());
            try {
                cacheLock.writeLock().lock();
                if (this.catalogsDeletedDuringPrewarm.contains(catCopy.getName())) continue;
                this.catalogCache.putIfAbsent(catCopy.getName(), catCopy);
                this.catalogsDeletedDuringPrewarm.clear();
                this.isCatalogCachePrewarmed = true;
            }
            finally {
                cacheLock.writeLock().unlock();
            }
        }
    }

    public Catalog getCatalogFromCache(String name) {
        Catalog cat = null;
        try {
            cacheLock.readLock().lock();
            if (this.catalogCache.get(name) != null) {
                cat = this.catalogCache.get(name).deepCopy();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return cat;
    }

    public void addCatalogToCache(Catalog cat) {
        try {
            cacheLock.writeLock().lock();
            Catalog catCopy = cat.deepCopy();
            catCopy.setName(catCopy.getName().toLowerCase());
            this.catalogCache.put(cat.getName(), catCopy);
            this.isCatalogCacheDirty.set(true);
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    public void alterCatalogInCache(String catName, Catalog newCat) {
        try {
            cacheLock.writeLock().lock();
            this.removeCatalogFromCache(catName);
            this.addCatalogToCache(newCat.deepCopy());
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    public void removeCatalogFromCache(String name) {
        name = StringUtils.normalizeIdentifier(name);
        try {
            cacheLock.writeLock().lock();
            if (!this.isCatalogCachePrewarmed) {
                this.catalogsDeletedDuringPrewarm.add(name);
            }
            if (this.catalogCache.remove(name) != null) {
                this.isCatalogCacheDirty.set(true);
            }
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    public List<String> listCachedCatalogs() {
        try {
            cacheLock.readLock().lock();
            ArrayList<String> arrayList = new ArrayList<String>(this.catalogCache.keySet());
            return arrayList;
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    public boolean isCatalogCachePrewarmed() {
        return this.isCatalogCachePrewarmed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getDatabaseFromCache(String catName, String name) {
        Database db = null;
        try {
            cacheLock.readLock().lock();
            String key = CacheUtils.buildDbKey(catName, name);
            if (this.databaseCache.get(key) != null) {
                db = this.databaseCache.get(key).deepCopy();
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateDatabasesInCache(List<Database> databases) {
        for (Database db : databases) {
            Database dbCopy = db.deepCopy();
            dbCopy.setName(dbCopy.getName().toLowerCase());
            try {
                cacheLock.writeLock().lock();
                String key = CacheUtils.buildDbKey(dbCopy.getCatalogName().toLowerCase(), dbCopy.getName().toLowerCase());
                if (this.databasesDeletedDuringPrewarm.contains(key)) continue;
                this.databaseCache.putIfAbsent(key, dbCopy);
                this.databasesDeletedDuringPrewarm.clear();
                this.isDatabaseCachePrewarmed = true;
            }
            finally {
                cacheLock.writeLock().unlock();
            }
        }
    }

    public boolean isDatabaseCachePrewarmed() {
        return this.isDatabaseCachePrewarmed;
    }

    public void addDatabaseToCache(Database db) {
        try {
            cacheLock.writeLock().lock();
            Database dbCopy = db.deepCopy();
            dbCopy.setName(dbCopy.getName().toLowerCase());
            dbCopy.setCatalogName(dbCopy.getCatalogName().toLowerCase());
            this.databaseCache.put(CacheUtils.buildDbKey(dbCopy.getCatalogName(), dbCopy.getName()), dbCopy);
            this.isDatabaseCacheDirty.set(true);
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatabaseFromCache(String catName, String dbName) {
        try {
            cacheLock.writeLock().lock();
            String key = CacheUtils.buildDbKey(catName, dbName);
            if (!this.isDatabaseCachePrewarmed) {
                this.databasesDeletedDuringPrewarm.add(key);
            }
            if (this.databaseCache.remove(key) != null) {
                this.isDatabaseCacheDirty.set(true);
            }
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listCachedDatabases(String catName) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            cacheLock.readLock().lock();
            for (String pair : this.databaseCache.keySet()) {
                String[] n = CacheUtils.splitDbName(pair);
                if (!catName.equals(n[0])) continue;
                results.add(n[1]);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listCachedDatabases(String catName, String pattern) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            cacheLock.readLock().lock();
            for (String pair : this.databaseCache.keySet()) {
                String[] n = CacheUtils.splitDbName(pair);
                if (!catName.equals(n[0])) continue;
                n[1] = StringUtils.normalizeIdentifier(n[1]);
                if (!CacheUtils.matches(n[1], pattern)) continue;
                results.add(n[1]);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterDatabaseInCache(String catName, String dbName, Database newDb) {
        try {
            cacheLock.writeLock().lock();
            this.removeDatabaseFromCache(catName, dbName);
            this.addDatabaseToCache(newDb.deepCopy());
            this.isDatabaseCacheDirty.set(true);
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDatabasesInCache(List<Database> databases) {
        try {
            cacheLock.writeLock().lock();
            if (this.isDatabaseCacheDirty.compareAndSet(true, false)) {
                LOG.debug("Skipping database cache update; the database list we have is dirty.");
                return;
            }
            this.databaseCache.clear();
            for (Database db : databases) {
                this.addDatabaseToCache(db);
            }
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    public int getCachedDatabaseCount() {
        try {
            cacheLock.readLock().lock();
            int n = this.databaseCache.size();
            return n;
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateTableInCache(Table table, ColumnStatistics tableColStats, List<Partition> partitions, List<ColumnStatistics> partitionColStats, AggrStats aggrStatsAllPartitions, AggrStats aggrStatsAllButDefaultPartition) {
        String tableName;
        String dbName;
        String catName = StringUtils.normalizeIdentifier(table.getCatName());
        if (this.tablesDeletedDuringPrewarm.contains(CacheUtils.buildTableKey(catName, dbName = StringUtils.normalizeIdentifier(table.getDbName()), tableName = StringUtils.normalizeIdentifier(table.getTableName())))) {
            return false;
        }
        TableWrapper tblWrapper = this.createTableWrapper(catName, dbName, tableName, table);
        if (maxCacheSizeInBytes > 0L) {
            IncrementalObjectSizeEstimator.ObjectEstimator tblWrapperSizeEstimator = SharedCache.getMemorySizeEstimator(TableWrapper.class);
            long estimatedMemUsage = tblWrapperSizeEstimator.estimate(tblWrapper, sizeEstimators);
            LOG.debug("Memory needed to cache Database: {}'s Table: {}, is {} bytes", new Object[]{dbName, tableName, estimatedMemUsage});
            if (SharedCache.isCacheMemoryFull(estimatedMemUsage)) {
                LOG.debug("Cannot cache Database: {}'s Table: {}. Memory needed is {} bytes, whereas the memory we have remaining is: {} bytes.", new Object[]{dbName, tableName, estimatedMemUsage, 0.8 * (double)maxCacheSizeInBytes - (double)currentCacheSizeInBytes});
                return false;
            }
            LOG.debug("Current cache size: {} bytes", (Object)(currentCacheSizeInBytes += estimatedMemUsage));
        }
        if (!table.isSetPartitionKeys() && tableColStats != null) {
            if (!tblWrapper.updateTableColStats(tableColStats.getStatsObj())) {
                return false;
            }
        } else {
            if (partitions != null && !tblWrapper.cachePartitions(partitions, this)) {
                return false;
            }
            if (partitionColStats != null) {
                for (ColumnStatistics cs : partitionColStats) {
                    try {
                        List<ColumnStatisticsObj> colStats;
                        AbstractList<String> partVal = Warehouse.makeValsFromName(cs.getStatsDesc().getPartName(), null);
                        if (tblWrapper.updatePartitionColStats(partVal, colStats = cs.getStatsObj())) continue;
                        return false;
                    }
                    catch (MetaException e) {
                        LOG.debug("Unable to cache partition column stats for table: " + tableName, (Throwable)e);
                    }
                }
            }
            tblWrapper.cacheAggrPartitionColStats(aggrStatsAllPartitions, aggrStatsAllButDefaultPartition);
        }
        try {
            cacheLock.writeLock().lock();
            this.tableCache.putIfAbsent(CacheUtils.buildTableKey(catName, dbName, tableName), tblWrapper);
            boolean bl = true;
            return bl;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    private static boolean isCacheMemoryFull(long estimatedMemUsage) {
        return 0.8 * (double)maxCacheSizeInBytes < (double)(currentCacheSizeInBytes + estimatedMemUsage);
    }

    public void completeTableCachePrewarm() {
        try {
            cacheLock.writeLock().lock();
            this.tablesDeletedDuringPrewarm.clear();
            this.isTableCachePrewarmed = true;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTableFromCache(String catName, String dbName, String tableName) {
        Table t = null;
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tableName));
            if (tblWrapper != null) {
                t = CacheUtils.assemble(tblWrapper, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableWrapper addTableToCache(String catName, String dbName, String tblName, Table tbl) {
        try {
            cacheLock.writeLock().lock();
            TableWrapper wrapper = this.createTableWrapper(catName, dbName, tblName, tbl);
            this.tableCache.put(CacheUtils.buildTableKey(catName, dbName, tblName), wrapper);
            this.isTableCacheDirty.set(true);
            TableWrapper tableWrapper = wrapper;
            return tableWrapper;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    private TableWrapper createTableWrapper(String catName, String dbName, String tblName, Table tbl) {
        TableWrapper wrapper;
        Table tblCopy = tbl.deepCopy();
        tblCopy.setCatName(StringUtils.normalizeIdentifier(catName));
        tblCopy.setDbName(StringUtils.normalizeIdentifier(dbName));
        tblCopy.setTableName(StringUtils.normalizeIdentifier(tblName));
        if (tblCopy.getPartitionKeys() != null) {
            for (FieldSchema fs : tblCopy.getPartitionKeys()) {
                fs.setName(StringUtils.normalizeIdentifier(fs.getName()));
            }
        }
        if (tbl.getSd() != null) {
            byte[] sdHash = MetaStoreUtils.hashStorageDescriptor(tbl.getSd(), md);
            StorageDescriptor sd = tbl.getSd();
            this.increSd(sd, sdHash);
            tblCopy.setSd(null);
            wrapper = new TableWrapper(tblCopy, sdHash, sd.getLocation(), sd.getParameters());
        } else {
            wrapper = new TableWrapper(tblCopy, null, null, null);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableFromCache(String catName, String dbName, String tblName) {
        try {
            TableWrapper tblWrapper;
            byte[] sdHash;
            cacheLock.writeLock().lock();
            if (!this.isTableCachePrewarmed) {
                this.tablesDeletedDuringPrewarm.add(CacheUtils.buildTableKey(catName, dbName, tblName));
            }
            if ((sdHash = (tblWrapper = this.tableCache.remove(CacheUtils.buildTableKey(catName, dbName, tblName))).getSdHash()) != null) {
                this.decrSd(sdHash);
            }
            this.isTableCacheDirty.set(true);
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTableInCache(String catName, String dbName, String tblName, Table newTable) {
        try {
            cacheLock.writeLock().lock();
            TableWrapper tblWrapper = this.tableCache.remove(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.updateTableObj(newTable, this);
                String newDbName = StringUtils.normalizeIdentifier(newTable.getDbName());
                String newTblName = StringUtils.normalizeIdentifier(newTable.getTableName());
                this.tableCache.put(CacheUtils.buildTableKey(catName, newDbName, newTblName), tblWrapper);
                this.isTableCacheDirty.set(true);
            }
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Table> listCachedTables(String catName, String dbName) {
        ArrayList<Table> tables = new ArrayList<Table>();
        try {
            cacheLock.readLock().lock();
            for (TableWrapper wrapper : this.tableCache.values()) {
                if (!wrapper.sameDatabase(catName, dbName)) continue;
                tables.add(CacheUtils.assemble(wrapper, this));
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listCachedTableNames(String catName, String dbName) {
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            cacheLock.readLock().lock();
            for (TableWrapper wrapper : this.tableCache.values()) {
                if (!wrapper.sameDatabase(catName, dbName)) continue;
                tableNames.add(StringUtils.normalizeIdentifier(wrapper.getTable().getTableName()));
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listCachedTableNames(String catName, String dbName, String pattern, short maxTables) {
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            cacheLock.readLock().lock();
            int count = 0;
            for (TableWrapper wrapper : this.tableCache.values()) {
                if (!wrapper.sameDatabase(catName, dbName) || !CacheUtils.matches(wrapper.getTable().getTableName(), pattern) || maxTables != -1 && count >= maxTables) continue;
                tableNames.add(StringUtils.normalizeIdentifier(wrapper.getTable().getTableName()));
                ++count;
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listCachedTableNames(String catName, String dbName, String pattern, TableType tableType) {
        ArrayList<String> tableNames = new ArrayList<String>();
        try {
            cacheLock.readLock().lock();
            for (TableWrapper wrapper : this.tableCache.values()) {
                if (!wrapper.sameDatabase(catName, dbName) || !CacheUtils.matches(wrapper.getTable().getTableName(), pattern) || !wrapper.getTable().getTableType().equals(tableType.toString())) continue;
                tableNames.add(StringUtils.normalizeIdentifier(wrapper.getTable().getTableName()));
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTablesInCache(String catName, String dbName, List<Table> tables) {
        try {
            cacheLock.writeLock().lock();
            if (this.isTableCacheDirty.compareAndSet(true, false)) {
                LOG.debug("Skipping table cache update; the table list we have is dirty.");
                return;
            }
            HashMap<String, TableWrapper> newTableCache = new HashMap<String, TableWrapper>();
            for (Table tbl : tables) {
                String tblName = StringUtils.normalizeIdentifier(tbl.getTableName());
                TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
                if (tblWrapper != null) {
                    tblWrapper.updateTableObj(tbl, this);
                } else {
                    tblWrapper = this.createTableWrapper(catName, dbName, tblName, tbl);
                }
                newTableCache.put(CacheUtils.buildTableKey(catName, dbName, tblName), tblWrapper);
            }
            this.tableCache.clear();
            this.tableCache = newTableCache;
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColumnStatisticsObj> getTableColStatsFromCache(String catName, String dbName, String tblName, List<String> colNames) {
        ArrayList<ColumnStatisticsObj> colStatObjs = new ArrayList();
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                colStatObjs = tblWrapper.getCachedTableColStats(colNames);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return colStatObjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableColStatsFromCache(String catName, String dbName, String tblName, String colName) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.removeTableColStats(colName);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTableColStatsInCache(String catName, String dbName, String tableName, List<ColumnStatisticsObj> colStatsForTable) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tableName));
            if (tblWrapper != null) {
                tblWrapper.updateTableColStats(colStatsForTable);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTableColStatsInCache(String catName, String dbName, String tableName, List<ColumnStatisticsObj> colStatsForTable) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tableName));
            if (tblWrapper != null) {
                tblWrapper.refreshTableColStats(colStatsForTable);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    public int getCachedTableCount() {
        try {
            cacheLock.readLock().lock();
            int n = this.tableCache.size();
            return n;
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableMeta> getTableMeta(String catName, String dbNames, String tableNames, List<String> tableTypes) {
        ArrayList<TableMeta> tableMetas = new ArrayList<TableMeta>();
        try {
            cacheLock.readLock().lock();
            for (String dbName : this.listCachedDatabases(catName)) {
                if (!CacheUtils.matches(dbName, dbNames)) continue;
                for (Table table : this.listCachedTables(catName, dbName)) {
                    if (!CacheUtils.matches(table.getTableName(), tableNames) || tableTypes != null && !tableTypes.contains(table.getTableType())) continue;
                    TableMeta metaData = new TableMeta(dbName, table.getTableName(), table.getTableType());
                    metaData.setCatName(catName);
                    metaData.setComments(table.getParameters().get("comment"));
                    tableMetas.add(metaData);
                }
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return tableMetas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartitionToCache(String catName, String dbName, String tblName, Partition part) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.cachePartition(part, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartitionsToCache(String catName, String dbName, String tblName, List<Partition> parts) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.cachePartitions(parts, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Partition getPartitionFromCache(String catName, String dbName, String tblName, List<String> partVals) {
        Partition part = null;
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                part = tblWrapper.getPartition(partVals, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existPartitionFromCache(String catName, String dbName, String tblName, List<String> partVals) {
        boolean existsPart = false;
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                existsPart = tblWrapper.containsPartition(partVals);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return existsPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Partition removePartitionFromCache(String catName, String dbName, String tblName, List<String> partVals) {
        Partition part = null;
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                part = tblWrapper.removePartition(partVals, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartitionsFromCache(String catName, String dbName, String tblName, List<List<String>> partVals) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.removePartitions(partVals, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Partition> listCachedPartitions(String catName, String dbName, String tblName, int max) {
        ArrayList<Partition> parts = new ArrayList();
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                parts = tblWrapper.listPartitions(max, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterPartitionInCache(String catName, String dbName, String tblName, List<String> partVals, Partition newPart) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.alterPartition(partVals, newPart, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterPartitionsInCache(String catName, String dbName, String tblName, List<List<String>> partValsList, List<Partition> newParts) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.alterPartitions(partValsList, newParts, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPartitionsInCache(String catName, String dbName, String tblName, List<Partition> partitions) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.refreshPartitions(partitions, this);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartitionColStatsFromCache(String catName, String dbName, String tblName, List<String> partVals, String colName) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.removePartitionColStats(partVals, colName);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePartitionColStatsInCache(String catName, String dbName, String tableName, List<String> partVals, List<ColumnStatisticsObj> colStatsObjs) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tableName));
            if (tblWrapper != null) {
                tblWrapper.updatePartitionColStats(partVals, colStatsObjs);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnStatisticsObj getPartitionColStatsFromCache(String catName, String dbName, String tblName, List<String> partVal, String colName) {
        ColumnStatisticsObj colStatObj = null;
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                colStatObj = tblWrapper.getPartitionColStats(partVal, colName);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return colStatObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPartitionColStatsInCache(String catName, String dbName, String tblName, List<ColumnStatistics> partitionColStats) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.refreshPartitionColStats(partitionColStats);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColumnStatisticsObj> getAggrStatsFromCache(String catName, String dbName, String tblName, List<String> colNames, StatsType statsType) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                List<ColumnStatisticsObj> list = tblWrapper.getAggrPartitionColStats(colNames, statsType);
                return list;
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAggregateStatsToCache(String catName, String dbName, String tblName, AggrStats aggrStatsAllPartitions, AggrStats aggrStatsAllButDefaultPartition) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.cacheAggrPartitionColStats(aggrStatsAllPartitions, aggrStatsAllButDefaultPartition);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAggregateStatsInCache(String catName, String dbName, String tblName, AggrStats aggrStatsAllPartitions, AggrStats aggrStatsAllButDefaultPartition) {
        try {
            cacheLock.readLock().lock();
            TableWrapper tblWrapper = this.tableCache.get(CacheUtils.buildTableKey(catName, dbName, tblName));
            if (tblWrapper != null) {
                tblWrapper.refreshAggrPartitionColStats(aggrStatsAllPartitions, aggrStatsAllButDefaultPartition);
            }
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    public synchronized void increSd(StorageDescriptor sd, byte[] sdHash) {
        ByteArrayWrapper byteArray = new ByteArrayWrapper(sdHash);
        if (this.sdCache.containsKey(byteArray)) {
            ++this.sdCache.get((Object)byteArray).refCount;
        } else {
            StorageDescriptor sdToCache = sd.deepCopy();
            sdToCache.setLocation(null);
            sdToCache.setParameters(null);
            this.sdCache.put(byteArray, new StorageDescriptorWrapper(sdToCache, 1));
        }
    }

    public synchronized void decrSd(byte[] sdHash) {
        ByteArrayWrapper byteArray = new ByteArrayWrapper(sdHash);
        StorageDescriptorWrapper sdWrapper = this.sdCache.get(byteArray);
        --sdWrapper.refCount;
        if (sdWrapper.getRefCount() == 0) {
            this.sdCache.remove(byteArray);
        }
    }

    public synchronized StorageDescriptor getSdFromCache(byte[] sdHash) {
        StorageDescriptorWrapper sdWrapper = this.sdCache.get(new ByteArrayWrapper(sdHash));
        return sdWrapper.getSd();
    }

    @VisibleForTesting
    Map<String, Database> getDatabaseCache() {
        return this.databaseCache;
    }

    @VisibleForTesting
    Map<String, TableWrapper> getTableCache() {
        return this.tableCache;
    }

    @VisibleForTesting
    Map<ByteArrayWrapper, StorageDescriptorWrapper> getSdCache() {
        return this.sdCache;
    }

    void resetCatalogCache() {
        this.isCatalogCachePrewarmed = false;
        this.catalogCache.clear();
        this.catalogsDeletedDuringPrewarm.clear();
        this.isCatalogCacheDirty.set(false);
    }

    public long getUpdateCount() {
        return this.cacheUpdateCount.get();
    }

    public void incrementUpdateCount() {
        this.cacheUpdateCount.incrementAndGet();
    }

    static {
        LOG = LoggerFactory.getLogger((String)SharedCache.class.getName());
        maxCacheSizeInBytes = -1L;
        currentCacheSizeInBytes = 0L;
        sizeEstimators = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("should not happen", e);
        }
    }

    static class StorageDescriptorWrapper {
        StorageDescriptor sd;
        int refCount = 0;

        StorageDescriptorWrapper(StorageDescriptor sd, int refCount) {
            this.sd = sd;
            this.refCount = refCount;
        }

        public StorageDescriptor getSd() {
            return this.sd;
        }

        public int getRefCount() {
            return this.refCount;
        }
    }

    static class PartitionWrapper {
        Partition p;
        String location;
        Map<String, String> parameters;
        byte[] sdHash;

        PartitionWrapper(Partition p, byte[] sdHash, String location, Map<String, String> parameters) {
            this.p = p;
            this.sdHash = sdHash;
            this.location = location;
            this.parameters = parameters;
        }

        public Partition getPartition() {
            return this.p;
        }

        public byte[] getSdHash() {
            return this.sdHash;
        }

        public String getLocation() {
            return this.location;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }

    static class TableWrapper {
        Table t;
        String location;
        Map<String, String> parameters;
        byte[] sdHash;
        ReentrantReadWriteLock tableLock = new ReentrantReadWriteLock(true);
        private Map<String, ColumnStatisticsObj> tableColStatsCache = new ConcurrentHashMap<String, ColumnStatisticsObj>();
        private AtomicBoolean isTableColStatsCacheDirty = new AtomicBoolean(false);
        private Map<String, PartitionWrapper> partitionCache = new ConcurrentHashMap<String, PartitionWrapper>();
        private AtomicBoolean isPartitionCacheDirty = new AtomicBoolean(false);
        private Map<String, ColumnStatisticsObj> partitionColStatsCache = new ConcurrentHashMap<String, ColumnStatisticsObj>();
        private AtomicBoolean isPartitionColStatsCacheDirty = new AtomicBoolean(false);
        private Map<String, List<ColumnStatisticsObj>> aggrColStatsCache = new ConcurrentHashMap<String, List<ColumnStatisticsObj>>();
        private AtomicBoolean isAggrPartitionColStatsCacheDirty = new AtomicBoolean(false);

        TableWrapper(Table t, byte[] sdHash, String location, Map<String, String> parameters) {
            this.t = t;
            this.sdHash = sdHash;
            this.location = location;
            this.parameters = parameters;
        }

        public Table getTable() {
            return this.t;
        }

        public void setTable(Table t) {
            this.t = t;
        }

        public byte[] getSdHash() {
            return this.sdHash;
        }

        public void setSdHash(byte[] sdHash) {
            this.sdHash = sdHash;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public void setParameters(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        boolean sameDatabase(String catName, String dbName) {
            return catName.equals(this.t.getCatName()) && dbName.equals(this.t.getDbName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cachePartition(Partition part, SharedCache sharedCache) {
            try {
                this.tableLock.writeLock().lock();
                PartitionWrapper wrapper = this.makePartitionWrapper(part, sharedCache);
                this.partitionCache.put(CacheUtils.buildPartitionCacheKey(part.getValues()), wrapper);
                this.isPartitionCacheDirty.set(true);
                if (!this.aggrColStatsCache.isEmpty()) {
                    this.aggrColStatsCache.clear();
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cachePartitions(List<Partition> parts, SharedCache sharedCache) {
            try {
                this.tableLock.writeLock().lock();
                for (Partition part : parts) {
                    PartitionWrapper ptnWrapper = this.makePartitionWrapper(part, sharedCache);
                    if (maxCacheSizeInBytes > 0L) {
                        IncrementalObjectSizeEstimator.ObjectEstimator ptnWrapperSizeEstimator = SharedCache.getMemorySizeEstimator(PartitionWrapper.class);
                        long estimatedMemUsage = ptnWrapperSizeEstimator.estimate(ptnWrapper, sizeEstimators);
                        LOG.trace("Memory needed to cache Partition: {} is {} bytes", (Object)part, (Object)estimatedMemUsage);
                        if (SharedCache.isCacheMemoryFull(estimatedMemUsage)) {
                            LOG.debug("Cannot cache Partition: {}. Memory needed is {} bytes, whereas the memory remaining is: {} bytes.", new Object[]{part, estimatedMemUsage, 0.8 * (double)maxCacheSizeInBytes - (double)currentCacheSizeInBytes});
                            boolean bl = false;
                            return bl;
                        }
                        LOG.trace("Current cache size: {} bytes", (Object)(currentCacheSizeInBytes += estimatedMemUsage));
                    }
                    this.partitionCache.put(CacheUtils.buildPartitionCacheKey(part.getValues()), ptnWrapper);
                    this.isPartitionCacheDirty.set(true);
                }
                if (!this.aggrColStatsCache.isEmpty()) {
                    this.aggrColStatsCache.clear();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Partition getPartition(List<String> partVals, SharedCache sharedCache) {
            Partition part = null;
            try {
                this.tableLock.readLock().lock();
                PartitionWrapper wrapper = this.partitionCache.get(CacheUtils.buildPartitionCacheKey(partVals));
                if (wrapper == null) {
                    Partition partition = null;
                    return partition;
                }
                part = CacheUtils.assemble(wrapper, sharedCache);
            }
            finally {
                this.tableLock.readLock().unlock();
            }
            return part;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Partition> listPartitions(int max, SharedCache sharedCache) {
            ArrayList<Partition> parts = new ArrayList<Partition>();
            int count = 0;
            try {
                this.tableLock.readLock().lock();
                for (PartitionWrapper wrapper : this.partitionCache.values()) {
                    if (max != -1 && count >= max) continue;
                    parts.add(CacheUtils.assemble(wrapper, sharedCache));
                    ++count;
                }
            }
            finally {
                this.tableLock.readLock().unlock();
            }
            return parts;
        }

        public boolean containsPartition(List<String> partVals) {
            boolean containsPart = false;
            try {
                this.tableLock.readLock().lock();
                containsPart = this.partitionCache.containsKey(CacheUtils.buildPartitionCacheKey(partVals));
            }
            finally {
                this.tableLock.readLock().unlock();
            }
            return containsPart;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Partition removePartition(List<String> partVal, SharedCache sharedCache) {
            Partition part = null;
            try {
                this.tableLock.writeLock().lock();
                PartitionWrapper wrapper = this.partitionCache.remove(CacheUtils.buildPartitionCacheKey(partVal));
                this.isPartitionCacheDirty.set(true);
                if (wrapper.getSdHash() != null) {
                    sharedCache.decrSd(wrapper.getSdHash());
                }
                part = CacheUtils.assemble(wrapper, sharedCache);
                String partialKey = CacheUtils.buildPartitionCacheKey(partVal);
                Iterator<Map.Entry<String, ColumnStatisticsObj>> iterator = this.partitionColStatsCache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ColumnStatisticsObj> entry = iterator.next();
                    String key = entry.getKey();
                    if (!key.toLowerCase().startsWith(partialKey.toLowerCase())) continue;
                    iterator.remove();
                }
                if (!this.aggrColStatsCache.isEmpty()) {
                    this.aggrColStatsCache.clear();
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
            return part;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePartitions(List<List<String>> partVals, SharedCache sharedCache) {
            try {
                this.tableLock.writeLock().lock();
                for (List<String> partVal : partVals) {
                    this.removePartition(partVal, sharedCache);
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alterPartition(List<String> partVals, Partition newPart, SharedCache sharedCache) {
            try {
                this.tableLock.writeLock().lock();
                this.removePartition(partVals, sharedCache);
                this.cachePartition(newPart, sharedCache);
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alterPartitions(List<List<String>> partValsList, List<Partition> newParts, SharedCache sharedCache) {
            try {
                this.tableLock.writeLock().lock();
                for (int i = 0; i < partValsList.size(); ++i) {
                    List<String> partVals = partValsList.get(i);
                    Partition newPart = newParts.get(i);
                    this.alterPartition(partVals, newPart, sharedCache);
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshPartitions(List<Partition> partitions, SharedCache sharedCache) {
            HashMap<String, PartitionWrapper> newPartitionCache = new HashMap<String, PartitionWrapper>();
            try {
                this.tableLock.writeLock().lock();
                for (Partition part : partitions) {
                    if (this.isPartitionCacheDirty.compareAndSet(true, false)) {
                        LOG.debug("Skipping partition cache update for table: " + this.getTable().getTableName() + "; the partition list we have is dirty.");
                        return;
                    }
                    String key = CacheUtils.buildPartitionCacheKey(part.getValues());
                    PartitionWrapper wrapper = this.partitionCache.get(key);
                    if (wrapper != null && wrapper.getSdHash() != null) {
                        sharedCache.decrSd(wrapper.getSdHash());
                    }
                    wrapper = this.makePartitionWrapper(part, sharedCache);
                    newPartitionCache.put(key, wrapper);
                }
                this.partitionCache = newPartitionCache;
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateTableColStats(List<ColumnStatisticsObj> colStatsForTable) {
            try {
                this.tableLock.writeLock().lock();
                for (ColumnStatisticsObj colStatObj : colStatsForTable) {
                    String key = colStatObj.getColName();
                    ColumnStatisticsObj oldStatsObj = this.tableColStatsCache.get(key);
                    if (oldStatsObj != null) {
                        StatObjectConverter.setFieldsIntoOldStats(oldStatsObj, colStatObj);
                        continue;
                    }
                    if (maxCacheSizeInBytes > 0L) {
                        IncrementalObjectSizeEstimator.ObjectEstimator tblColStatsSizeEstimator = SharedCache.getMemorySizeEstimator(ColumnStatisticsObj.class);
                        long estimatedMemUsage = tblColStatsSizeEstimator.estimate(colStatObj, sizeEstimators);
                        LOG.trace("Memory needed to cache Table Column Statistics Object: {} is {} bytes", (Object)colStatObj, (Object)estimatedMemUsage);
                        if (SharedCache.isCacheMemoryFull(estimatedMemUsage)) {
                            LOG.debug("Cannot cache Table Column Statistics Object: {}. Memory needed is {} bytes, whereas the memory remaining is: {} bytes.", new Object[]{colStatObj, estimatedMemUsage, 0.8 * (double)maxCacheSizeInBytes - (double)currentCacheSizeInBytes});
                            boolean bl = false;
                            return bl;
                        }
                        LOG.trace("Current cache size: {} bytes", (Object)(currentCacheSizeInBytes += estimatedMemUsage));
                    }
                    this.tableColStatsCache.put(key, colStatObj.deepCopy());
                }
                this.isTableColStatsCacheDirty.set(true);
                boolean bl = true;
                return bl;
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshTableColStats(List<ColumnStatisticsObj> colStatsForTable) {
            HashMap<String, ColumnStatisticsObj> newTableColStatsCache = new HashMap<String, ColumnStatisticsObj>();
            try {
                this.tableLock.writeLock().lock();
                for (ColumnStatisticsObj colStatObj : colStatsForTable) {
                    if (this.isTableColStatsCacheDirty.compareAndSet(true, false)) {
                        LOG.debug("Skipping table col stats cache update for table: " + this.getTable().getTableName() + "; the table col stats list we have is dirty.");
                        return;
                    }
                    String key = colStatObj.getColName();
                    newTableColStatsCache.put(key, colStatObj.deepCopy());
                }
                this.tableColStatsCache = newTableColStatsCache;
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ColumnStatisticsObj> getCachedTableColStats(List<String> colNames) {
            ArrayList<ColumnStatisticsObj> colStatObjs = new ArrayList<ColumnStatisticsObj>();
            try {
                this.tableLock.readLock().lock();
                for (String colName : colNames) {
                    ColumnStatisticsObj colStatObj = this.tableColStatsCache.get(colName);
                    if (colStatObj == null) continue;
                    colStatObjs.add(colStatObj);
                }
            }
            finally {
                this.tableLock.readLock().unlock();
            }
            return colStatObjs;
        }

        public void removeTableColStats(String colName) {
            try {
                this.tableLock.writeLock().lock();
                this.tableColStatsCache.remove(colName);
                this.isTableColStatsCacheDirty.set(true);
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ColumnStatisticsObj getPartitionColStats(List<String> partVal, String colName) {
            try {
                this.tableLock.readLock().lock();
                ColumnStatisticsObj columnStatisticsObj = this.partitionColStatsCache.get(CacheUtils.buildPartitonColStatsCacheKey(partVal, colName));
                return columnStatisticsObj;
            }
            finally {
                this.tableLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updatePartitionColStats(List<String> partVal, List<ColumnStatisticsObj> colStatsObjs) {
            try {
                this.tableLock.writeLock().lock();
                for (ColumnStatisticsObj colStatObj : colStatsObjs) {
                    String key = CacheUtils.buildPartitonColStatsCacheKey(partVal, colStatObj.getColName());
                    ColumnStatisticsObj oldStatsObj = this.partitionColStatsCache.get(key);
                    if (oldStatsObj != null) {
                        StatObjectConverter.setFieldsIntoOldStats(oldStatsObj, colStatObj);
                        continue;
                    }
                    if (maxCacheSizeInBytes > 0L) {
                        IncrementalObjectSizeEstimator.ObjectEstimator ptnColStatsSizeEstimator = SharedCache.getMemorySizeEstimator(ColumnStatisticsObj.class);
                        long estimatedMemUsage = ptnColStatsSizeEstimator.estimate(colStatObj, sizeEstimators);
                        LOG.trace("Memory needed to cache Partition Column Statistics Object: {} is {} bytes", (Object)colStatObj, (Object)estimatedMemUsage);
                        if (SharedCache.isCacheMemoryFull(estimatedMemUsage)) {
                            LOG.debug("Cannot cache Partition Column Statistics Object: {}. Memory needed is {} bytes, whereas the memory remaining is: {} bytes.", new Object[]{colStatObj, estimatedMemUsage, 0.8 * (double)maxCacheSizeInBytes - (double)currentCacheSizeInBytes});
                            boolean bl = false;
                            return bl;
                        }
                        LOG.trace("Current cache size: {} bytes", (Object)(currentCacheSizeInBytes += estimatedMemUsage));
                    }
                    this.partitionColStatsCache.put(key, colStatObj.deepCopy());
                }
                this.isPartitionColStatsCacheDirty.set(true);
                if (!this.aggrColStatsCache.isEmpty()) {
                    this.aggrColStatsCache.clear();
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
            return true;
        }

        public void removePartitionColStats(List<String> partVals, String colName) {
            try {
                this.tableLock.writeLock().lock();
                this.partitionColStatsCache.remove(CacheUtils.buildPartitonColStatsCacheKey(partVals, colName));
                this.isPartitionColStatsCacheDirty.set(true);
                if (!this.aggrColStatsCache.isEmpty()) {
                    this.aggrColStatsCache.clear();
                }
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void refreshPartitionColStats(List<ColumnStatistics> partitionColStats) {
            HashMap<String, ColumnStatisticsObj> newPartitionColStatsCache = new HashMap<String, ColumnStatisticsObj>();
            try {
                this.tableLock.writeLock().lock();
                String tableName = StringUtils.normalizeIdentifier(this.getTable().getTableName());
                Iterator<ColumnStatistics> iterator = partitionColStats.iterator();
                block6: while (true) {
                    ColumnStatistics cs;
                    if (iterator.hasNext()) {
                        cs = iterator.next();
                        if (this.isPartitionColStatsCacheDirty.compareAndSet(true, false)) {
                            LOG.debug("Skipping partition column stats cache update for table: " + this.getTable().getTableName() + "; the partition column stats list we have is dirty");
                            this.tableLock.writeLock().unlock();
                            return;
                        }
                    } else {
                        this.partitionColStatsCache = newPartitionColStatsCache;
                        this.tableLock.writeLock().unlock();
                        return;
                    }
                    AbstractList<String> partVal = Warehouse.makeValsFromName(cs.getStatsDesc().getPartName(), null);
                    List<ColumnStatisticsObj> colStatsObjs = cs.getStatsObj();
                    Iterator<ColumnStatisticsObj> iterator2 = colStatsObjs.iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block6;
                        ColumnStatisticsObj colStatObj = iterator2.next();
                        if (this.isPartitionColStatsCacheDirty.compareAndSet(true, false)) {
                            LOG.debug("Skipping partition column stats cache update for table: " + this.getTable().getTableName() + "; the partition column list we have is dirty");
                            this.tableLock.writeLock().unlock();
                            return;
                        }
                        String key = CacheUtils.buildPartitonColStatsCacheKey(partVal, colStatObj.getColName());
                        newPartitionColStatsCache.put(key, colStatObj.deepCopy());
                        continue;
                        break;
                    }
                    catch (MetaException e) {
                        LOG.debug("Unable to cache partition column stats for table: " + tableName, (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                this.tableLock.writeLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ColumnStatisticsObj> getAggrPartitionColStats(List<String> colNames, StatsType statsType) {
            ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>();
            try {
                this.tableLock.readLock().lock();
                for (String colName : colNames) {
                    List<ColumnStatisticsObj> colStatList = this.aggrColStatsCache.get(colName);
                    if (colStatList == null) {
                        List<ColumnStatisticsObj> list = null;
                        return list;
                    }
                    ColumnStatisticsObj colStatObj = colStatList.get(statsType.getPosition());
                    if (colStatObj == null) {
                        List<ColumnStatisticsObj> list = null;
                        return list;
                    }
                    colStats.add(colStatObj);
                }
            }
            finally {
                this.tableLock.readLock().unlock();
            }
            return colStats;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cacheAggrPartitionColStats(AggrStats aggrStatsAllPartitions, AggrStats aggrStatsAllButDefaultPartition) {
            try {
                List<Object> aggrStats;
                this.tableLock.writeLock().lock();
                if (aggrStatsAllPartitions != null) {
                    for (ColumnStatisticsObj statObj : aggrStatsAllPartitions.getColStats()) {
                        if (statObj == null) continue;
                        aggrStats = new ArrayList<ColumnStatisticsObj>();
                        aggrStats.add(StatsType.ALL.ordinal(), statObj.deepCopy());
                        this.aggrColStatsCache.put(statObj.getColName(), aggrStats);
                    }
                }
                if (aggrStatsAllButDefaultPartition != null) {
                    for (ColumnStatisticsObj statObj : aggrStatsAllButDefaultPartition.getColStats()) {
                        if (statObj == null) continue;
                        aggrStats = this.aggrColStatsCache.get(statObj.getColName());
                        if (aggrStats == null) {
                            aggrStats = new ArrayList();
                        }
                        aggrStats.add(StatsType.ALLBUTDEFAULT.ordinal(), statObj.deepCopy());
                    }
                }
                this.isAggrPartitionColStatsCacheDirty.set(true);
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshAggrPartitionColStats(AggrStats aggrStatsAllPartitions, AggrStats aggrStatsAllButDefaultPartition) {
            HashMap<String, List<ColumnStatisticsObj>> newAggrColStatsCache = new HashMap<String, List<ColumnStatisticsObj>>();
            try {
                List<ColumnStatisticsObj> aggrStats;
                this.tableLock.writeLock().lock();
                if (aggrStatsAllPartitions != null) {
                    for (ColumnStatisticsObj statObj : aggrStatsAllPartitions.getColStats()) {
                        if (this.isAggrPartitionColStatsCacheDirty.compareAndSet(true, false)) {
                            LOG.debug("Skipping aggregate stats cache update for table: " + this.getTable().getTableName() + "; the aggregate stats list we have is dirty");
                            return;
                        }
                        if (statObj == null) continue;
                        aggrStats = new ArrayList<ColumnStatisticsObj>();
                        aggrStats.add(StatsType.ALL.ordinal(), statObj.deepCopy());
                        newAggrColStatsCache.put(statObj.getColName(), aggrStats);
                    }
                }
                if (aggrStatsAllButDefaultPartition != null) {
                    for (ColumnStatisticsObj statObj : aggrStatsAllButDefaultPartition.getColStats()) {
                        if (this.isAggrPartitionColStatsCacheDirty.compareAndSet(true, false)) {
                            LOG.debug("Skipping aggregate stats cache update for table: " + this.getTable().getTableName() + "; the aggregate stats list we have is dirty");
                            return;
                        }
                        if (statObj == null) continue;
                        aggrStats = (List)newAggrColStatsCache.get(statObj.getColName());
                        if (aggrStats == null) {
                            aggrStats = new ArrayList();
                        }
                        aggrStats.add(StatsType.ALLBUTDEFAULT.ordinal(), statObj.deepCopy());
                    }
                }
                this.aggrColStatsCache = newAggrColStatsCache;
            }
            finally {
                this.tableLock.writeLock().unlock();
            }
        }

        private void updateTableObj(Table newTable, SharedCache sharedCache) {
            Table tblCopy;
            byte[] sdHash = this.getSdHash();
            if (sdHash != null) {
                sharedCache.decrSd(sdHash);
            }
            if ((tblCopy = newTable.deepCopy()).getPartitionKeys() != null) {
                for (FieldSchema fs : tblCopy.getPartitionKeys()) {
                    fs.setName(StringUtils.normalizeIdentifier(fs.getName()));
                }
            }
            this.setTable(tblCopy);
            if (tblCopy.getSd() != null) {
                sdHash = MetaStoreUtils.hashStorageDescriptor(tblCopy.getSd(), md);
                StorageDescriptor sd = tblCopy.getSd();
                sharedCache.increSd(sd, sdHash);
                tblCopy.setSd(null);
                this.setSdHash(sdHash);
                this.setLocation(sd.getLocation());
                this.setParameters(sd.getParameters());
            } else {
                this.setSdHash(null);
                this.setLocation(null);
                this.setParameters(null);
            }
        }

        private PartitionWrapper makePartitionWrapper(Partition part, SharedCache sharedCache) {
            PartitionWrapper wrapper;
            Partition partCopy = part.deepCopy();
            if (part.getSd() != null) {
                byte[] sdHash = MetaStoreUtils.hashStorageDescriptor(part.getSd(), md);
                StorageDescriptor sd = part.getSd();
                sharedCache.increSd(sd, sdHash);
                partCopy.setSd(null);
                wrapper = new PartitionWrapper(partCopy, sdHash, sd.getLocation(), sd.getParameters());
            } else {
                wrapper = new PartitionWrapper(partCopy, null, null, null);
            }
            return wrapper;
        }
    }

    static enum StatsType {
        ALL(0),
        ALLBUTDEFAULT(1);

        private final int position;

        private StatsType(int position) {
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

