/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.auth;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthUtils.class);
    private static HiveConf hiveConf = null;
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public static <T extends TTransport> T configureThriftMaxMessageSize(T transport, int maxMessageSize) {
        if (maxMessageSize > 0) {
            if (transport.getConfiguration() == null) {
                LOG.warn("TTransport {} is returning a null Configuration, Thrift max message size is not getting configured", (Object)transport.getClass().getName());
                return transport;
            }
            transport.getConfiguration().setMaxMessageSize(maxMessageSize);
        }
        return transport;
    }

    public static TTransport getSocketTransport(String host, int port, int loginTimeout) throws TTransportException {
        return HiveAuthUtils.getSocketTransport(host, port, loginTimeout, -1);
    }

    public static TTransport getSocketTransport(String host, int port, int loginTimeout, int maxMessageSize) throws TTransportException {
        TSocket tSocket = new TSocket(host, port, loginTimeout);
        return HiveAuthUtils.configureThriftMaxMessageSize(tSocket, maxMessageSize);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout, String trustStorePath, String trustStorePassWord, String sslProtocolVersion) throws TTransportException {
        return HiveAuthUtils.getSSLSocket(host, port, loginTimeout, trustStorePath, trustStorePassWord, sslProtocolVersion, -1);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout, String trustStorePath, String trustStorePassWord, String sslProtocolVersion, int maxMessageSize) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters(sslProtocolVersion, null);
        String trustManagerType = TrustManagerFactory.getDefaultAlgorithm();
        String trustStoreType = KeyStore.getDefaultType();
        params.setTrustStore(trustStorePath, trustStorePassWord, trustManagerType, trustStoreType);
        params.requireClientAuth(true);
        TSocket tSSLSocket = TSSLTransportFactory.getClientSocket(host, port, loginTimeout, params);
        return HiveAuthUtils.getSSLSocketWithHttps(tSSLSocket, maxMessageSize);
    }

    private static TSocket getSSLSocketWithHttps(TSocket tSSLSocket, int maxMessageSize) throws TTransportException {
        SSLSocket sslSocket = (SSLSocket)tSSLSocket.getSocket();
        SSLParameters sslParams = sslSocket.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm("HTTPS");
        sslSocket.setSSLParameters(sslParams);
        TSocket tSocket = new TSocket(sslSocket);
        return HiveAuthUtils.configureThriftMaxMessageSize(tSocket, maxMessageSize);
    }

    public static TServerSocket getServerSocket(String hiveHost, int portNum, int socketTimeout) throws TTransportException {
        InetSocketAddress serverAddress = hiveHost == null || hiveHost.isEmpty() ? new InetSocketAddress(portNum) : new InetSocketAddress(hiveHost, portNum);
        return new TServerSocket(serverAddress, socketTimeout);
    }

    public static TServerSocket getServerSSLSocket(String hiveHost, int portNum, String keyStorePath, String keyStorePassWord, List<String> sslVersionBlacklist, String sslProtocolVersion, int socketTimeout) throws TTransportException, UnknownHostException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters(sslProtocolVersion, null);
        String keyManagerType = TrustManagerFactory.getDefaultAlgorithm();
        String keyStoreType = KeyStore.getDefaultType();
        params.setKeyStore(keyStorePath, keyStorePassWord, keyManagerType, keyStoreType);
        InetSocketAddress serverAddress = hiveHost == null || hiveHost.isEmpty() ? new InetSocketAddress(portNum) : new InetSocketAddress(hiveHost, portNum);
        TServerSocket thriftServerSocket = TSSLTransportFactory.getServerSocket(portNum, socketTimeout, serverAddress.getAddress(), params);
        if (thriftServerSocket.getServerSocket() instanceof SSLServerSocket) {
            ArrayList<String> sslVersionBlacklistLocal = new ArrayList<String>();
            for (String sslVersion : sslVersionBlacklist) {
                sslVersionBlacklistLocal.add(sslVersion.trim().toLowerCase());
            }
            SSLServerSocket sslServerSocket = (SSLServerSocket)thriftServerSocket.getServerSocket();
            ArrayList<String> enabledProtocols = new ArrayList<String>();
            for (String protocol : sslServerSocket.getEnabledProtocols()) {
                if (sslVersionBlacklistLocal.contains(protocol.toLowerCase())) {
                    LOG.debug("Disabling SSL Protocol: " + protocol);
                    continue;
                }
                enabledProtocols.add(protocol);
            }
            sslServerSocket.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
            LOG.info("SSL Server Socket Enabled Protocols: " + Arrays.toString(sslServerSocket.getEnabledProtocols()));
        }
        return thriftServerSocket;
    }

    public static TTransport getTrustAllSSLSocket(String host, int port, int loginTimeout) throws TTransportException {
        SSLSocket socket;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }
        }};
        try {
            SSLContext sslContext = HiveAuthUtils.isFips() ? SSLContext.getInstance(HiveAuthUtils.getSslProtocolVersion(), (Provider)new BouncyCastleJsseProvider()) : SSLContext.getInstance(HiveAuthUtils.getSslProtocolVersion());
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory factory = sslContext.getSocketFactory();
            socket = (SSLSocket)factory.createSocket(host, port);
            socket.setSoTimeout(loginTimeout);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new TTransportException("Couldn't create Trust All SSL socket", (Throwable)e);
        }
        return new TSocket(socket);
    }

    public static Configuration buildConfigurationFromDefaultFiles() {
        Configuration conf = new Configuration();
        URL hiveSiteURL = HiveConf.findConfigFile(classLoader, "hive-site.xml", true);
        URL hivemetastoreSiteUrl = HiveConf.findConfigFile(classLoader, "hivemetastore-site.xml", false);
        URL hiveServer2SiteUrl = HiveConf.findConfigFile(classLoader, "hiveserver2-site.xml", false);
        if (hiveSiteURL != null) {
            conf.addResource(hiveSiteURL, false);
        }
        if (hivemetastoreSiteUrl != null && HiveConf.isLoadMetastoreConfig()) {
            conf.addResource(hivemetastoreSiteUrl, false);
        }
        if (hiveServer2SiteUrl != null && HiveConf.isLoadHiveServer2Config()) {
            conf.addResource(hiveServer2SiteUrl, false);
        }
        HiveConf.applySystemProperties(conf);
        return conf;
    }

    public static String getSslProtocolVersion() {
        return HiveAuthUtils.buildConfigurationFromDefaultFiles().get(HiveConf.ConfVars.HIVE_SSL_PROTOCOL_VERSION.varname, HiveConf.ConfVars.HIVE_SSL_PROTOCOL_VERSION.defaultStrVal);
    }

    public static boolean isFips() {
        Provider[] providers;
        for (Provider provider : providers = Security.getProviders()) {
            if (!provider.getName().toLowerCase().contains("fips")) continue;
            return true;
        }
        return false;
    }

    static {
        if (classLoader == null) {
            classLoader = HiveAuthUtils.class.getClassLoader();
        }
    }
}

