/*
 * Decompiled with CFR 0.152.
 */
package hive.shaded.parquet.net.openhft.hashing;

import hive.shaded.parquet.net.openhft.hashing.Access;
import hive.shaded.parquet.net.openhft.hashing.Primitives;
import java.nio.ByteOrder;

public abstract class CharSequenceAccess
extends Access<CharSequence> {
    static CharSequenceAccess charSequenceAccess(ByteOrder order) {
        return order == ByteOrder.LITTLE_ENDIAN ? LittleEndianCharSequenceAccess.INSTANCE : BigEndianCharSequenceAccess.INSTANCE;
    }

    static CharSequenceAccess nativeCharSequenceAccess() {
        return CharSequenceAccess.charSequenceAccess(ByteOrder.nativeOrder());
    }

    private static int ix(long offset) {
        return (int)(offset >> 1);
    }

    protected static long getLong(CharSequence input, long offset, int char0Off, int char1Off, int char2Off, int char3Off, int char4Off, int delta) {
        int base = CharSequenceAccess.ix(offset);
        if (0 == ((int)offset & 1)) {
            long char0 = input.charAt(base + char0Off);
            long char1 = input.charAt(base + char1Off);
            long char2 = input.charAt(base + char2Off);
            long char3 = input.charAt(base + char3Off);
            return char0 | char1 << 16 | char2 << 32 | char3 << 48;
        }
        long char0 = input.charAt(base + char0Off + delta) >>> 8;
        long char1 = input.charAt(base + char1Off + delta);
        long char2 = input.charAt(base + char2Off + delta);
        long char3 = input.charAt(base + char3Off + delta);
        long char4 = input.charAt(base + char4Off);
        return char0 | char1 << 8 | char2 << 24 | char3 << 40 | char4 << 56;
    }

    protected static long getUnsignedInt(CharSequence input, long offset, int char0Off, int char1Off, int char2Off, int delta) {
        int base = CharSequenceAccess.ix(offset);
        if (0 == ((int)offset & 1)) {
            long char0 = input.charAt(base + char0Off);
            long char1 = input.charAt(base + char1Off);
            return char0 | char1 << 16;
        }
        long char0 = input.charAt(base + char0Off + delta) >>> 8;
        long char1 = input.charAt(base + char1Off + delta);
        long char2 = Primitives.unsignedByte(input.charAt(base + char2Off));
        return char0 | char1 << 8 | char2 << 24;
    }

    protected static char getUnsignedShort(CharSequence input, long offset, int char1Off, int delta) {
        if (0 == ((int)offset & 1)) {
            return input.charAt(CharSequenceAccess.ix(offset));
        }
        int base = CharSequenceAccess.ix(offset);
        int char0 = input.charAt(base + delta) >>> 8;
        char char1 = input.charAt(base + char1Off);
        return (char)(char0 | char1 << 8);
    }

    protected static int getUnsignedByte(CharSequence input, long offset, int shift) {
        return Primitives.unsignedByte(input.charAt(CharSequenceAccess.ix(offset)) >> shift);
    }

    private CharSequenceAccess() {
    }

    @Override
    public int getInt(CharSequence input, long offset) {
        return (int)this.getUnsignedInt(input, offset);
    }

    @Override
    public int getShort(CharSequence input, long offset) {
        return (short)this.getUnsignedShort(input, offset);
    }

    @Override
    public int getByte(CharSequence input, long offset) {
        return (byte)this.getUnsignedByte(input, offset);
    }

    private static class BigEndianCharSequenceAccess
    extends CharSequenceAccess {
        private static final CharSequenceAccess INSTANCE = new BigEndianCharSequenceAccess();
        private static final Access<CharSequence> INSTANCE_REVERSE = Access.newDefaultReverseAccess(INSTANCE);

        private BigEndianCharSequenceAccess() {
        }

        @Override
        public long getLong(CharSequence input, long offset) {
            return BigEndianCharSequenceAccess.getLong(input, offset, 3, 2, 1, 0, 0, 1);
        }

        @Override
        public long getUnsignedInt(CharSequence input, long offset) {
            return BigEndianCharSequenceAccess.getUnsignedInt(input, offset, 1, 0, 0, 1);
        }

        @Override
        public int getUnsignedShort(CharSequence input, long offset) {
            return BigEndianCharSequenceAccess.getUnsignedShort(input, offset, 0, 1);
        }

        @Override
        public int getUnsignedByte(CharSequence input, long offset) {
            return BigEndianCharSequenceAccess.getUnsignedByte(input, offset, ((int)offset & 1 ^ 1) << 3);
        }

        @Override
        public ByteOrder byteOrder(CharSequence input) {
            return ByteOrder.BIG_ENDIAN;
        }

        @Override
        protected Access<CharSequence> reverseAccess() {
            return INSTANCE_REVERSE;
        }
    }

    private static class LittleEndianCharSequenceAccess
    extends CharSequenceAccess {
        private static final CharSequenceAccess INSTANCE = new LittleEndianCharSequenceAccess();
        private static final Access<CharSequence> INSTANCE_REVERSE = Access.newDefaultReverseAccess(INSTANCE);

        private LittleEndianCharSequenceAccess() {
        }

        @Override
        public long getLong(CharSequence input, long offset) {
            return LittleEndianCharSequenceAccess.getLong(input, offset, 0, 1, 2, 3, 4, 0);
        }

        @Override
        public long getUnsignedInt(CharSequence input, long offset) {
            return LittleEndianCharSequenceAccess.getUnsignedInt(input, offset, 0, 1, 2, 0);
        }

        @Override
        public int getUnsignedShort(CharSequence input, long offset) {
            return LittleEndianCharSequenceAccess.getUnsignedShort(input, offset, 1, 0);
        }

        @Override
        public int getUnsignedByte(CharSequence input, long offset) {
            return LittleEndianCharSequenceAccess.getUnsignedByte(input, offset, ((int)offset & 1) << 3);
        }

        @Override
        public ByteOrder byteOrder(CharSequence input) {
            return ByteOrder.LITTLE_ENDIAN;
        }

        @Override
        protected Access<CharSequence> reverseAccess() {
            return INSTANCE_REVERSE;
        }
    }
}

