/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop.metadata;

import hive.org.apache.parquet.hadoop.metadata.FileMetaData;
import hive.org.apache.parquet.hadoop.metadata.KeyValueMetadataMergeStrategy;
import hive.org.apache.parquet.hadoop.metadata.StrictKeyValueMetadataMergeStrategy;
import hive.org.apache.parquet.schema.MessageType;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GlobalMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MessageType schema;
    private final Map<String, Set<String>> keyValueMetaData;
    private final Set<String> createdBy;

    public GlobalMetaData(MessageType schema, Map<String, Set<String>> keyValueMetaData, Set<String> createdBy) {
        this.schema = Objects.requireNonNull(schema, "schema cannot be null");
        this.keyValueMetaData = Collections.unmodifiableMap(Objects.requireNonNull(keyValueMetaData, "keyValueMetaData cannot be null"));
        this.createdBy = createdBy;
    }

    public MessageType getSchema() {
        return this.schema;
    }

    public String toString() {
        return "GlobalMetaData{schema: " + this.schema + ", metadata: " + this.keyValueMetaData + "}";
    }

    public Map<String, Set<String>> getKeyValueMetaData() {
        return this.keyValueMetaData;
    }

    public Set<String> getCreatedBy() {
        return this.createdBy;
    }

    public FileMetaData merge() {
        return this.merge(new StrictKeyValueMetadataMergeStrategy());
    }

    public FileMetaData merge(KeyValueMetadataMergeStrategy keyValueMetadataMergeStrategy) {
        String createdByString = this.createdBy.size() == 1 ? this.createdBy.iterator().next() : this.createdBy.toString();
        Map<String, String> mergedKeyValues = keyValueMetadataMergeStrategy.merge(this.keyValueMetaData);
        return new FileMetaData(this.schema, mergedKeyValues, createdByString);
    }
}

