/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop;

import hive.org.apache.parquet.column.ColumnWriteStore;
import hive.org.apache.parquet.column.ParquetProperties;
import hive.org.apache.parquet.column.values.bloomfilter.BloomFilterWriteStore;
import hive.org.apache.parquet.compression.CompressionCodecFactory;
import hive.org.apache.parquet.crypto.InternalFileEncryptor;
import hive.org.apache.parquet.hadoop.ColumnChunkPageWriteStore;
import hive.org.apache.parquet.hadoop.ParquetFileWriter;
import hive.org.apache.parquet.hadoop.api.WriteSupport;
import hive.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import hive.org.apache.parquet.io.ColumnIOFactory;
import hive.org.apache.parquet.io.MessageColumnIO;
import hive.org.apache.parquet.io.api.RecordConsumer;
import hive.org.apache.parquet.schema.MessageType;
import hive.org.apache.parquet.util.AutoCloseables;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalParquetRecordWriter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(InternalParquetRecordWriter.class);
    private final ParquetFileWriter parquetFileWriter;
    private final WriteSupport<T> writeSupport;
    private final MessageType schema;
    private final Map<String, String> extraMetaData;
    private final long rowGroupSize;
    private long rowGroupSizeThreshold;
    private long nextRowGroupSize;
    private final CompressionCodecFactory.BytesInputCompressor compressor;
    private final boolean validating;
    private final ParquetProperties props;
    private boolean closed;
    private long recordCount = 0L;
    private long recordCountForNextMemCheck;
    private long lastRowGroupEndPos = 0L;
    private ColumnWriteStore columnStore;
    private ColumnChunkPageWriteStore pageStore;
    private BloomFilterWriteStore bloomFilterWriteStore;
    private RecordConsumer recordConsumer;
    private InternalFileEncryptor fileEncryptor;
    private int rowGroupOrdinal;
    private boolean aborted;

    public InternalParquetRecordWriter(ParquetFileWriter parquetFileWriter, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, long rowGroupSize, CompressionCodecFactory.BytesInputCompressor compressor, boolean validating, ParquetProperties props) {
        this.parquetFileWriter = parquetFileWriter;
        this.writeSupport = Objects.requireNonNull(writeSupport, "writeSupport cannot be null");
        this.schema = schema;
        this.extraMetaData = extraMetaData;
        this.rowGroupSize = rowGroupSize;
        this.nextRowGroupSize = this.rowGroupSizeThreshold = rowGroupSize;
        this.compressor = compressor;
        this.validating = validating;
        this.props = props;
        this.fileEncryptor = parquetFileWriter.getEncryptor();
        this.rowGroupOrdinal = 0;
        this.initStore();
        this.recordCountForNextMemCheck = props.getMinRowCountForPageSizeCheck();
    }

    public ParquetMetadata getFooter() {
        return this.parquetFileWriter.getFooter();
    }

    private void initStore() {
        ColumnChunkPageWriteStore columnChunkPageWriteStore;
        this.pageStore = columnChunkPageWriteStore = new ColumnChunkPageWriteStore(this.compressor, this.schema, this.props.getAllocator(), this.props.getColumnIndexTruncateLength(), this.props.getPageWriteChecksumEnabled(), this.fileEncryptor, this.rowGroupOrdinal);
        this.bloomFilterWriteStore = columnChunkPageWriteStore;
        this.columnStore = this.props.newColumnWriteStore(this.schema, this.pageStore, this.bloomFilterWriteStore);
        MessageColumnIO columnIO = new ColumnIOFactory(this.validating).getColumnIO(this.schema);
        this.recordConsumer = columnIO.getRecordWriter(this.columnStore);
        this.writeSupport.prepareForWrite(this.recordConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, InterruptedException {
        if (!this.closed) {
            block5: {
                try {
                    if (!this.aborted) break block5;
                }
                catch (Throwable throwable) {
                    AutoCloseables.uncheckedClose(this.columnStore, this.pageStore, this.bloomFilterWriteStore, this.parquetFileWriter);
                    this.closed = true;
                    throw throwable;
                }
                AutoCloseables.uncheckedClose(this.columnStore, this.pageStore, this.bloomFilterWriteStore, this.parquetFileWriter);
                this.closed = true;
                return;
            }
            this.flushRowGroupToStore();
            WriteSupport.FinalizedWriteContext finalWriteContext = this.writeSupport.finalizeWrite();
            HashMap<String, String> finalMetadata = new HashMap<String, String>(this.extraMetaData);
            String modelName = this.writeSupport.getName();
            if (modelName != null) {
                finalMetadata.put("writer.model.name", modelName);
            }
            finalMetadata.putAll(finalWriteContext.getExtraMetaData());
            this.parquetFileWriter.end(finalMetadata);
            AutoCloseables.uncheckedClose(this.columnStore, this.pageStore, this.bloomFilterWriteStore, this.parquetFileWriter);
            this.closed = true;
        }
    }

    public void write(T value) throws IOException, InterruptedException {
        try {
            this.writeSupport.write(value);
            ++this.recordCount;
            this.checkBlockSizeReached();
        }
        catch (Throwable t) {
            this.aborted = true;
            throw t;
        }
    }

    public long getDataSize() {
        return this.lastRowGroupEndPos + this.columnStore.getBufferedSize();
    }

    private void checkBlockSizeReached() throws IOException {
        if (this.recordCount >= this.recordCountForNextMemCheck) {
            long recordSize;
            long memSize = this.columnStore.getBufferedSize();
            if (memSize > this.nextRowGroupSize - 2L * (recordSize = memSize / this.recordCount)) {
                LOG.debug("mem size {} > {}: flushing {} records to disk.", new Object[]{memSize, this.nextRowGroupSize, this.recordCount});
                this.flushRowGroupToStore();
                this.initStore();
                this.recordCountForNextMemCheck = Math.min(Math.max((long)this.props.getMinRowCountForPageSizeCheck(), this.recordCount / 2L), (long)this.props.getMaxRowCountForPageSizeCheck());
                this.lastRowGroupEndPos = this.parquetFileWriter.getPos();
            } else {
                this.recordCountForNextMemCheck = Math.min(Math.max((long)this.props.getMinRowCountForPageSizeCheck(), (this.recordCount + (long)((float)this.nextRowGroupSize / (float)recordSize)) / 2L), this.recordCount + (long)this.props.getMaxRowCountForPageSizeCheck());
                LOG.debug("Checked mem at {} will check again at: {}", (Object)this.recordCount, (Object)this.recordCountForNextMemCheck);
            }
        }
    }

    private void flushRowGroupToStore() throws IOException {
        try {
            this.recordConsumer.flush();
            LOG.debug("Flushing mem columnStore to file. allocated memory: {}", (Object)this.columnStore.getAllocatedSize());
            if (this.columnStore.getAllocatedSize() > 3L * this.rowGroupSizeThreshold) {
                LOG.warn("Too much memory used: {}", (Object)this.columnStore.memUsageString());
            }
            if (this.recordCount > 0L) {
                ++this.rowGroupOrdinal;
                this.parquetFileWriter.startBlock(this.recordCount);
                this.columnStore.flush();
                this.pageStore.flushToFileWriter(this.parquetFileWriter);
                this.recordCount = 0L;
                this.parquetFileWriter.endBlock();
                this.nextRowGroupSize = Math.min(this.parquetFileWriter.getNextRowGroupSize(), this.rowGroupSizeThreshold);
            }
        }
        catch (Throwable throwable) {
            AutoCloseables.uncheckedClose(this.columnStore, this.pageStore, this.bloomFilterWriteStore);
            this.columnStore = null;
            this.pageStore = null;
            this.bloomFilterWriteStore = null;
            throw throwable;
        }
        AutoCloseables.uncheckedClose(this.columnStore, this.pageStore, this.bloomFilterWriteStore);
        this.columnStore = null;
        this.pageStore = null;
        this.bloomFilterWriteStore = null;
    }

    long getRowGroupSizeThreshold() {
        return this.rowGroupSizeThreshold;
    }

    void setRowGroupSizeThreshold(long rowGroupSizeThreshold) {
        this.rowGroupSizeThreshold = rowGroupSizeThreshold;
    }

    MessageType getSchema() {
        return this.schema;
    }
}

