/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdCompressCtx;
import com.github.luben.zstd.ZstdDecompressCtx;
import hive.org.apache.parquet.ParquetRuntimeException;
import hive.org.apache.parquet.Preconditions;
import hive.org.apache.parquet.bytes.ByteBufferAllocator;
import hive.org.apache.parquet.bytes.ByteBufferReleaser;
import hive.org.apache.parquet.bytes.BytesInput;
import hive.org.apache.parquet.bytes.ReusingByteBufferAllocator;
import hive.org.apache.parquet.hadoop.CodecFactory;
import hive.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import hive.org.apache.parquet.util.AutoCloseables;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

class DirectCodecFactory
extends CodecFactory
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DirectCodecFactory.class);
    private final ByteBufferAllocator allocator;
    private static final Class<?> DIRECT_DECOMPRESSION_CODEC_CLASS;
    private static final Method DECOMPRESS_METHOD;
    private static final Method CREATE_DIRECT_DECOMPRESSOR_METHOD;

    DirectCodecFactory(Configuration config, ByteBufferAllocator allocator, int pageSize) {
        super(config, pageSize);
        this.allocator = Objects.requireNonNull(allocator, "allocator cannot be null");
        Preconditions.checkState(allocator.isDirect(), "A %s requires a direct buffer allocator be provided.", (Object)this.getClass().getSimpleName());
    }

    @Override
    protected CodecFactory.BytesCompressor createCompressor(CompressionCodecName codecName) {
        switch (codecName) {
            case SNAPPY: {
                return new SnappyCompressor();
            }
            case ZSTD: {
                return new ZstdCompressor();
            }
        }
        return super.createCompressor(codecName);
    }

    @Override
    protected CodecFactory.BytesDecompressor createDecompressor(CompressionCodecName codecName) {
        switch (codecName) {
            case SNAPPY: {
                return new SnappyDecompressor();
            }
            case ZSTD: {
                return new ZstdDecompressor();
            }
        }
        CompressionCodec codec = this.getCodec(codecName);
        if (codec == null) {
            return NO_OP_DECOMPRESSOR;
        }
        DirectCodecPool.CodecPool pool = DirectCodecPool.INSTANCE.codec(codec);
        if (pool.supportsDirectDecompression()) {
            return new FullDirectDecompressor(pool.borrowDirectDecompressor());
        }
        return new IndirectDecompressor(pool.borrowDecompressor());
    }

    @Override
    public void close() {
        this.release();
    }

    static {
        Class<?> tempClass = null;
        Method tempCreateMethod = null;
        Method tempDecompressMethod = null;
        try {
            tempClass = Class.forName("org.apache.hadoop.io.compress.DirectDecompressionCodec");
            tempCreateMethod = tempClass.getMethod("createDirectDecompressor", new Class[0]);
            Class<?> tempClass2 = Class.forName("org.apache.hadoop.io.compress.DirectDecompressor");
            tempDecompressMethod = tempClass2.getMethod("decompress", ByteBuffer.class, ByteBuffer.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        DIRECT_DECOMPRESSION_CODEC_CLASS = tempClass;
        CREATE_DIRECT_DECOMPRESSOR_METHOD = tempCreateMethod;
        DECOMPRESS_METHOD = tempDecompressMethod;
    }

    static class DirectCodecPool {
        public static final DirectCodecPool INSTANCE = new DirectCodecPool();
        private final Map<CompressionCodec, CodecPool> codecs = Collections.synchronizedMap(new HashMap());
        private final Map<Class<?>, GenericObjectPool> directDePools = Collections.synchronizedMap(new HashMap());
        private final Map<Class<?>, GenericObjectPool> dePools = Collections.synchronizedMap(new HashMap());
        private final Map<Class<?>, GenericObjectPool> cPools = Collections.synchronizedMap(new HashMap());

        private DirectCodecPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CodecPool codec(CompressionCodec codec) {
            CodecPool pools = this.codecs.get(codec);
            if (pools == null) {
                DirectCodecPool directCodecPool = this;
                synchronized (directCodecPool) {
                    pools = this.codecs.get(codec);
                    if (pools == null) {
                        pools = new CodecPool(codec);
                        this.codecs.put(codec, pools);
                    }
                }
            }
            return pools;
        }

        private void returnToPool(Object obj, Map<Class<?>, GenericObjectPool> pools) {
            try {
                GenericObjectPool pool = pools.get(obj.getClass());
                if (pool == null) {
                    throw new IllegalStateException("Received unexpected compressor or decompressor, cannot be returned to any available pool: " + obj.getClass().getSimpleName());
                }
                pool.returnObject(obj);
            }
            catch (Exception e) {
                throw new ParquetCompressionCodecException(e);
            }
        }

        public <T> T borrow(GenericObjectPool pool) {
            try {
                return (T)pool.borrowObject();
            }
            catch (Exception e) {
                throw new ParquetCompressionCodecException(e);
            }
        }

        public void returnCompressor(Compressor compressor) {
            this.returnToPool(compressor, this.cPools);
        }

        public void returnDecompressor(Decompressor decompressor) {
            this.returnToPool(decompressor, this.dePools);
        }

        public void returnDirectDecompressor(Object decompressor) {
            this.returnToPool(decompressor, this.directDePools);
        }

        public static class ParquetCompressionCodecException
        extends ParquetRuntimeException {
            public ParquetCompressionCodecException() {
            }

            public ParquetCompressionCodecException(String message, Throwable cause) {
                super(message, cause);
            }

            public ParquetCompressionCodecException(String message) {
                super(message);
            }

            public ParquetCompressionCodecException(Throwable cause) {
                super(cause);
            }
        }

        public class CodecPool {
            private final GenericObjectPool compressorPool;
            private final GenericObjectPool decompressorPool;
            private final GenericObjectPool directDecompressorPool;
            private final boolean supportDirectDecompressor;
            private static final String BYTE_BUF_IMPL_NOT_FOUND_MSG = "Unable to find ByteBuffer based %s for codec %s, will use a byte array based implementation instead.";

            private CodecPool(final CompressionCodec codec) {
                try {
                    boolean supportDirectDecompressor = DIRECT_DECOMPRESSION_CODEC_CLASS != null && DIRECT_DECOMPRESSION_CODEC_CLASS.isAssignableFrom(codec.getClass());
                    this.compressorPool = new GenericObjectPool((PoolableObjectFactory)new BasePoolableObjectFactory(){

                        public Object makeObject() throws Exception {
                            return codec.createCompressor();
                        }
                    }, Integer.MAX_VALUE);
                    Object com = this.compressorPool.borrowObject();
                    if (com != null) {
                        DirectCodecPool.this.cPools.put(com.getClass(), this.compressorPool);
                        this.compressorPool.returnObject(com);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format(BYTE_BUF_IMPL_NOT_FOUND_MSG, "compressor", codec.getClass().getName()));
                    }
                    this.decompressorPool = new GenericObjectPool((PoolableObjectFactory)new BasePoolableObjectFactory(){

                        public Object makeObject() throws Exception {
                            return codec.createDecompressor();
                        }
                    }, Integer.MAX_VALUE);
                    Object decom = this.decompressorPool.borrowObject();
                    if (decom != null) {
                        DirectCodecPool.this.dePools.put(decom.getClass(), this.decompressorPool);
                        this.decompressorPool.returnObject(decom);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format(BYTE_BUF_IMPL_NOT_FOUND_MSG, "decompressor", codec.getClass().getName()));
                    }
                    if (supportDirectDecompressor) {
                        this.directDecompressorPool = new GenericObjectPool((PoolableObjectFactory)new BasePoolableObjectFactory(){

                            public Object makeObject() throws Exception {
                                return CREATE_DIRECT_DECOMPRESSOR_METHOD.invoke((Object)codec, new Object[0]);
                            }
                        }, Integer.MAX_VALUE);
                        Object ddecom = this.directDecompressorPool.borrowObject();
                        if (ddecom != null) {
                            DirectCodecPool.this.directDePools.put(ddecom.getClass(), this.directDecompressorPool);
                            this.directDecompressorPool.returnObject(ddecom);
                        } else {
                            supportDirectDecompressor = false;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(String.format(BYTE_BUF_IMPL_NOT_FOUND_MSG, "compressor", codec.getClass().getName()));
                            }
                        }
                    } else {
                        this.directDecompressorPool = null;
                    }
                    this.supportDirectDecompressor = supportDirectDecompressor;
                }
                catch (Exception e) {
                    throw new ParquetCompressionCodecException("Error creating compression codec pool.", e);
                }
            }

            public Object borrowDirectDecompressor() {
                Preconditions.checkArgument(this.supportDirectDecompressor, "Tried to get a direct Decompressor from a non-direct codec.");
                try {
                    return this.directDecompressorPool.borrowObject();
                }
                catch (Exception e) {
                    throw new ParquetCompressionCodecException(e);
                }
            }

            public boolean supportsDirectDecompression() {
                return this.supportDirectDecompressor;
            }

            public Decompressor borrowDecompressor() {
                return (Decompressor)DirectCodecPool.this.borrow(this.decompressorPool);
            }

            public Compressor borrowCompressor() {
                return (Compressor)DirectCodecPool.this.borrow(this.compressorPool);
            }
        }
    }

    @Deprecated
    public static class NoopCompressor
    extends CodecFactory.BytesCompressor {
        @Override
        public BytesInput compress(BytesInput bytes) throws IOException {
            return CodecFactory.NO_OP_COMPRESSOR.compress(bytes);
        }

        @Override
        public CompressionCodecName getCodecName() {
            return CodecFactory.NO_OP_COMPRESSOR.getCodecName();
        }

        @Override
        public void release() {
            CodecFactory.NO_OP_COMPRESSOR.release();
        }
    }

    private class ZstdCompressor
    extends BaseCompressor {
        private final ZstdCompressCtx context;

        ZstdCompressor() {
            this.context = new ZstdCompressCtx();
            this.context.setLevel(DirectCodecFactory.this.conf.getInt("parquet.compression.codec.zstd.level", 3));
            this.context.setWorkers(DirectCodecFactory.this.conf.getInt("parquet.compression.codec.zstd.workers", 0));
        }

        @Override
        public CompressionCodecName getCodecName() {
            return CompressionCodecName.ZSTD;
        }

        @Override
        int maxCompressedSize(int size) {
            return Math.toIntExact(Zstd.compressBound((long)size));
        }

        @Override
        int compress(ByteBuffer input, ByteBuffer output) {
            return this.context.compress(output, input);
        }

        @Override
        void closeCompressor() {
            this.context.close();
        }
    }

    private class ZstdDecompressor
    extends BaseDecompressor {
        private final ZstdDecompressCtx context;

        ZstdDecompressor() {
            this.context = new ZstdDecompressCtx();
        }

        @Override
        int decompress(ByteBuffer input, ByteBuffer output) {
            return this.context.decompress(output, input);
        }

        @Override
        void closeDecompressor() {
            this.context.close();
        }
    }

    public class SnappyCompressor
    extends BaseCompressor {
        @Override
        int compress(ByteBuffer input, ByteBuffer output) throws IOException {
            return Snappy.compress((ByteBuffer)input, (ByteBuffer)output);
        }

        @Override
        int maxCompressedSize(int size) {
            return Snappy.maxCompressedLength((int)size);
        }

        @Override
        public CompressionCodecName getCodecName() {
            return CompressionCodecName.SNAPPY;
        }

        @Override
        void closeCompressor() {
        }
    }

    public class SnappyDecompressor
    extends BaseDecompressor {
        @Override
        int decompress(ByteBuffer input, ByteBuffer output) throws IOException {
            return Snappy.uncompress((ByteBuffer)input, (ByteBuffer)output);
        }

        @Override
        void closeDecompressor() {
        }
    }

    @Deprecated
    public class NoopDecompressor
    extends CodecFactory.BytesDecompressor {
        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int decompressedSize) throws IOException {
            CodecFactory.NO_OP_DECOMPRESSOR.decompress(input, compressedSize, output, decompressedSize);
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int decompressedSize) throws IOException {
            return CodecFactory.NO_OP_DECOMPRESSOR.decompress(bytes, decompressedSize);
        }

        @Override
        public void release() {
            CodecFactory.NO_OP_DECOMPRESSOR.release();
        }
    }

    public class FullDirectDecompressor
    extends BaseDecompressor {
        private final Object decompressor;

        public FullDirectDecompressor(CompressionCodecName codecName) {
            this(DirectCodecPool.INSTANCE.codec(Objects.requireNonNull(this$0.getCodec(codecName))).borrowDirectDecompressor());
        }

        private FullDirectDecompressor(Object decompressor) {
            this.decompressor = decompressor;
        }

        @Override
        public BytesInput decompress(BytesInput compressedBytes, int decompressedSize) throws IOException {
            if (this.decompressor instanceof Decompressor) {
                ((Decompressor)this.decompressor).reset();
            }
            return super.decompress(compressedBytes, decompressedSize);
        }

        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int decompressedSize) throws IOException {
            if (this.decompressor instanceof Decompressor) {
                ((Decompressor)this.decompressor).reset();
            }
            super.decompress(input, compressedSize, output, decompressedSize);
        }

        @Override
        int decompress(ByteBuffer input, ByteBuffer output) {
            int startPos = output.position();
            try {
                DECOMPRESS_METHOD.invoke(this.decompressor, input, output);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new DirectCodecPool.ParquetCompressionCodecException(e);
            }
            int size = output.position() - startPos;
            return size == 0 ? output.limit() : size;
        }

        @Override
        void closeDecompressor() {
            DirectCodecPool.INSTANCE.returnDirectDecompressor(this.decompressor);
        }
    }

    private abstract class BaseCompressor
    extends CodecFactory.BytesCompressor {
        private final ReusingByteBufferAllocator inputAllocator;
        private final ReusingByteBufferAllocator outputAllocator;

        BaseCompressor() {
            this.inputAllocator = ReusingByteBufferAllocator.strict(DirectCodecFactory.this.allocator);
            this.outputAllocator = ReusingByteBufferAllocator.unsafe(DirectCodecFactory.this.allocator);
        }

        @Override
        public BytesInput compress(BytesInput bytes) throws IOException {
            try (ByteBufferReleaser releaser = this.inputAllocator.getReleaser();){
                ByteBuffer input = bytes.toByteBuffer(releaser);
                ByteBuffer output = this.outputAllocator.allocate(this.maxCompressedSize(Math.toIntExact(bytes.size())));
                int size = this.compress(input.slice(), output.slice());
                output.limit(size);
                BytesInput bytesInput = BytesInput.from(output);
                return bytesInput;
            }
        }

        abstract int maxCompressedSize(int var1);

        abstract int compress(ByteBuffer var1, ByteBuffer var2) throws IOException;

        @Override
        public void release() {
            AutoCloseables.uncheckedClose(this.outputAllocator, this.inputAllocator, this::closeCompressor);
        }

        abstract void closeCompressor();
    }

    private abstract class BaseDecompressor
    extends CodecFactory.BytesDecompressor {
        private final ReusingByteBufferAllocator inputAllocator;
        private final ReusingByteBufferAllocator outputAllocator;

        BaseDecompressor() {
            this.inputAllocator = ReusingByteBufferAllocator.strict(DirectCodecFactory.this.allocator);
            this.outputAllocator = ReusingByteBufferAllocator.unsafe(DirectCodecFactory.this.allocator);
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int decompressedSize) throws IOException {
            try (ByteBufferReleaser releaser = this.inputAllocator.getReleaser();){
                ByteBuffer input = bytes.toByteBuffer(releaser);
                ByteBuffer output = this.outputAllocator.allocate(decompressedSize);
                int size = this.decompress(input.slice(), output.slice());
                if (size != decompressedSize) {
                    throw new DirectCodecPool.ParquetCompressionCodecException("Unexpected decompressed size: " + size + " != " + decompressedSize);
                }
                output.limit(size);
                BytesInput bytesInput = BytesInput.from(output);
                return bytesInput;
            }
        }

        abstract int decompress(ByteBuffer var1, ByteBuffer var2) throws IOException;

        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int decompressedSize) throws IOException {
            int origInputLimit = input.limit();
            input.limit(input.position() + compressedSize);
            int origOutputLimit = output.limit();
            output.limit(output.position() + decompressedSize);
            int size = this.decompress(input.slice(), output.slice());
            if (size != decompressedSize) {
                throw new DirectCodecPool.ParquetCompressionCodecException("Unexpected decompressed size: " + size + " != " + decompressedSize);
            }
            input.position(input.limit());
            input.limit(origInputLimit);
            output.position(output.limit());
            output.limit(origOutputLimit);
        }

        @Override
        public void release() {
            AutoCloseables.uncheckedClose(this.outputAllocator, this.inputAllocator, this::closeDecompressor);
        }

        abstract void closeDecompressor();
    }

    public class IndirectDecompressor
    extends CodecFactory.BytesDecompressor {
        private final Decompressor decompressor;

        public IndirectDecompressor(CompressionCodec codec) {
            this(DirectCodecPool.INSTANCE.codec(codec).borrowDecompressor());
        }

        private IndirectDecompressor(Decompressor decompressor) {
            this.decompressor = decompressor;
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int decompressedSize) throws IOException {
            this.decompressor.reset();
            byte[] inputBytes = bytes.toByteArray();
            this.decompressor.setInput(inputBytes, 0, inputBytes.length);
            byte[] output = new byte[decompressedSize];
            this.decompressor.decompress(output, 0, decompressedSize);
            return BytesInput.from(output);
        }

        @Override
        public void decompress(ByteBuffer input, int compressedSize, ByteBuffer output, int decompressedSize) throws IOException {
            this.decompressor.reset();
            byte[] inputBytes = new byte[compressedSize];
            input.get(inputBytes);
            this.decompressor.setInput(inputBytes, 0, inputBytes.length);
            byte[] outputBytes = new byte[decompressedSize];
            this.decompressor.decompress(outputBytes, 0, decompressedSize);
            output.put(outputBytes);
        }

        @Override
        public void release() {
            DirectCodecPool.INSTANCE.returnDecompressor(this.decompressor);
        }
    }
}

