/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.com.google.common.collect.ArrayListMultimap;
import hive.com.google.common.collect.HashMultimap;
import hive.com.google.common.collect.ListMultimap;
import hive.com.google.common.collect.SetMultimap;
import hive.com.google.common.collect.Sets;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.RelNode;

public class HiveRulesRegistry {
    private SetMultimap<RelOptRule, RelNode> registryVisited = HashMultimap.create();
    private ListMultimap<RelNode, Set<String>> registryPushedPredicates = ArrayListMultimap.create();

    public void registerVisited(RelOptRule rule, RelNode operator) {
        this.registryVisited.put(rule, operator);
    }

    public Set<RelNode> getVisited(RelOptRule rule) {
        return this.registryVisited.get((Object)rule);
    }

    public Set<String> getPushedPredicates(RelNode operator, int pos) {
        if (!this.registryPushedPredicates.containsKey(operator)) {
            for (int i = 0; i < operator.getInputs().size(); ++i) {
                this.registryPushedPredicates.get((Object)operator).add(Sets.newHashSet());
            }
        }
        return (Set)this.registryPushedPredicates.get((Object)operator).get(pos);
    }

    public void copyPushedPredicates(RelNode operator, RelNode otherOperator) {
        if (this.registryPushedPredicates.containsKey(operator)) {
            for (Set s : this.registryPushedPredicates.get((Object)operator)) {
                this.registryPushedPredicates.put(otherOperator, Sets.newHashSet(s));
            }
        }
    }
}

