/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;

public final class HiveMultiJoin
extends AbstractRelNode {
    private final List<RelNode> inputs;
    private final RexNode condition;
    private final RelDataType rowType;
    private final ImmutableList<Pair<Integer, Integer>> joinInputs;
    private final ImmutableList<JoinRelType> joinTypes;
    private final ImmutableList<RexNode> filters;
    private final boolean outerJoin;
    private final HiveCalciteUtil.JoinPredicateInfo joinPredInfo;

    public HiveMultiJoin(RelOptCluster cluster, List<RelNode> inputs, RexNode condition, RelDataType rowType, List<Pair<Integer, Integer>> joinInputs, List<JoinRelType> joinTypes, List<RexNode> filters, HiveCalciteUtil.JoinPredicateInfo joinPredicateInfo) {
        super(cluster, TraitsUtil.getDefaultTraitSet(cluster));
        this.inputs = inputs;
        this.condition = condition;
        this.rowType = rowType;
        assert (joinInputs.size() == joinTypes.size());
        this.joinInputs = ImmutableList.copyOf(joinInputs);
        this.joinTypes = ImmutableList.copyOf(joinTypes);
        this.filters = ImmutableList.copyOf(filters);
        this.outerJoin = this.containsOuter();
        if (joinPredicateInfo == null) {
            try {
                this.joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(this);
            }
            catch (CalciteSemanticException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.joinPredInfo = joinPredicateInfo;
        }
    }

    public HiveMultiJoin(RelOptCluster cluster, List<RelNode> inputs, RexNode condition, RelDataType rowType, List<Pair<Integer, Integer>> joinInputs, List<JoinRelType> joinTypes, List<RexNode> filters) {
        this(cluster, Lists.newArrayList(inputs), condition, rowType, joinInputs, joinTypes, filters, null);
    }

    public void replaceInput(int ordinalInParent, RelNode p) {
        this.inputs.set(ordinalInParent, p);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.containsIfApplicable((RelTrait)HiveRelNode.CONVENTION));
        return new HiveMultiJoin(this.getCluster(), inputs, this.condition, this.rowType, this.joinInputs, this.joinTypes, this.filters);
    }

    public RelWriter explainTerms(RelWriter pw) {
        ArrayList<String> joinsString = new ArrayList<String>();
        for (int i = 0; i < this.joinInputs.size(); ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append(((Pair)this.joinInputs.get((int)i)).left).append(" - ").append(((Pair)this.joinInputs.get((int)i)).right).append(" : ").append(((JoinRelType)this.joinTypes.get(i)).name());
            joinsString.add(sb.toString());
        }
        super.explainTerms(pw);
        for (Ord ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        return pw.item("condition", (Object)this.condition).item("joinsDescription", joinsString);
    }

    public RelDataType deriveRowType() {
        return this.rowType;
    }

    public List<RelNode> getInputs() {
        return this.inputs;
    }

    public List<RexNode> getChildExps() {
        return ImmutableList.of(this.condition);
    }

    public RelNode accept(RexShuttle shuttle) {
        RexNode joinFilter = shuttle.apply(this.condition);
        if (joinFilter == this.condition) {
            return this;
        }
        return new HiveMultiJoin(this.getCluster(), this.inputs, joinFilter, this.rowType, this.joinInputs, this.joinTypes, this.filters);
    }

    public RexNode getCondition() {
        return this.condition;
    }

    public boolean isOuterJoin() {
        return this.outerJoin;
    }

    public List<Pair<Integer, Integer>> getJoinInputs() {
        return this.joinInputs;
    }

    public List<JoinRelType> getJoinTypes() {
        return this.joinTypes;
    }

    public List<RexNode> getJoinFilters() {
        return this.filters;
    }

    public HiveCalciteUtil.JoinPredicateInfo getJoinPredicateInfo() {
        return this.joinPredInfo;
    }

    private boolean containsOuter() {
        for (JoinRelType joinType : this.joinTypes) {
            if (joinType == JoinRelType.INNER) continue;
            return true;
        }
        return false;
    }
}

