/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.facebook.fb303.FacebookBase;
import com.facebook.fb303.fb_status;
import hive.com.google.common.annotations.VisibleForTesting;
import hive.com.google.common.base.Preconditions;
import hive.com.google.common.base.Splitter;
import hive.com.google.common.collect.ImmutableCollection;
import hive.com.google.common.collect.ImmutableListMultimap;
import hive.com.google.common.collect.Lists;
import hive.com.google.common.collect.Multimaps;
import hive.com.google.common.primitives.Ints;
import hive.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.jdo.JDOException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.metastore.AcidEventListener;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.FileMetadataManager;
import org.apache.hadoop.hive.metastore.HMSMetricsListener;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreEndFunctionContext;
import org.apache.hadoop.hive.metastore.MetaStoreEndFunctionListener;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.MetaStoreInit;
import org.apache.hadoop.hive.metastore.MetaStoreInitContext;
import org.apache.hadoop.hive.metastore.MetaStoreInitListener;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.MetastoreStatusServlet;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.PartFilterExprUtil;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.RawStoreProxy;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.RetryingHMSHandler;
import org.apache.hadoop.hive.metastore.SessionPropertiesListener;
import org.apache.hadoop.hive.metastore.StorageSchemaReader;
import org.apache.hadoop.hive.metastore.TServerSocketKeepAlive;
import org.apache.hadoop.hive.metastore.TSetIpAddressProcessor;
import org.apache.hadoop.hive.metastore.TUGIBasedProcessor;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.ThreadPool;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.TransactionalValidationListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddCheckConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddDefaultConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AddForeignKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddNotNullConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.AddPartitionsResult;
import org.apache.hadoop.hive.metastore.api.AddPrimaryKeyRequest;
import org.apache.hadoop.hive.metastore.api.AddUniqueConstraintRequest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.AlterCatalogRequest;
import org.apache.hadoop.hive.metastore.api.AlterISchemaRequest;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.CacheFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.ClearFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.ClearFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.ClientCapabilities;
import org.apache.hadoop.hive.metastore.api.ClientCapability;
import org.apache.hadoop.hive.metastore.api.CmRecycleRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleResponse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CreateCatalogRequest;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.DropCatalogRequest;
import org.apache.hadoop.hive.metastore.api.DropConstraintRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsExpr;
import org.apache.hadoop.hive.metastore.api.DropPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.DropPartitionsResult;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsResp;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsRqst;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventRequestData;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.ForeignKeysResponse;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetCatalogRequest;
import org.apache.hadoop.hive.metastore.api.GetCatalogResponse;
import org.apache.hadoop.hive.metastore.api.GetCatalogsResponse;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataByExprResult;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.GetFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.GetRuntimeStatsRequest;
import org.apache.hadoop.hive.metastore.api.GetSerdeRequest;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetTableResult;
import org.apache.hadoop.hive.metastore.api.GetTablesRequest;
import org.apache.hadoop.hive.metastore.api.GetTablesResult;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokePrivilegeResponse;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleRequest;
import org.apache.hadoop.hive.metastore.api.GrantRevokeRoleResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.ISchemaName;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MapSchemaVersionToSerdeRequest;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpecWithSharedSD;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PartitionWithoutSD;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprResult;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsResult;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.PutFileMetadataRequest;
import org.apache.hadoop.hive.metastore.api.PutFileMetadataResult;
import org.apache.hadoop.hive.metastore.api.ReplTblWriteIdStateRequest;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionDescriptor;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.SetSchemaVersionStateRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TableStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableStatsResult;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterPoolRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterPoolResponse;
import org.apache.hadoop.hive.metastore.api.WMAlterResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMAlterTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMAlterTriggerResponse;
import org.apache.hadoop.hive.metastore.api.WMCreateOrDropTriggerToPoolMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateOrDropTriggerToPoolMappingResponse;
import org.apache.hadoop.hive.metastore.api.WMCreateOrUpdateMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateOrUpdateMappingResponse;
import org.apache.hadoop.hive.metastore.api.WMCreatePoolRequest;
import org.apache.hadoop.hive.metastore.api.WMCreatePoolResponse;
import org.apache.hadoop.hive.metastore.api.WMCreateResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMCreateTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMCreateTriggerResponse;
import org.apache.hadoop.hive.metastore.api.WMDropMappingRequest;
import org.apache.hadoop.hive.metastore.api.WMDropMappingResponse;
import org.apache.hadoop.hive.metastore.api.WMDropPoolRequest;
import org.apache.hadoop.hive.metastore.api.WMDropPoolResponse;
import org.apache.hadoop.hive.metastore.api.WMDropResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMDropResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMDropTriggerRequest;
import org.apache.hadoop.hive.metastore.api.WMDropTriggerResponse;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMGetActiveResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetActiveResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMGetAllResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetAllResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMGetResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMGetTriggersForResourePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMGetTriggersForResourePlanResponse;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanRequest;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AbortTxnEvent;
import org.apache.hadoop.hive.metastore.events.AddForeignKeyEvent;
import org.apache.hadoop.hive.metastore.events.AddNotNullConstraintEvent;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AddPrimaryKeyEvent;
import org.apache.hadoop.hive.metastore.events.AddSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.AddUniqueConstraintEvent;
import org.apache.hadoop.hive.metastore.events.AllocWriteIdEvent;
import org.apache.hadoop.hive.metastore.events.AlterCatalogEvent;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterISchemaEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CommitTxnEvent;
import org.apache.hadoop.hive.metastore.events.ConfigChangeEvent;
import org.apache.hadoop.hive.metastore.events.CreateCatalogEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateFunctionEvent;
import org.apache.hadoop.hive.metastore.events.CreateISchemaEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropCatalogEvent;
import org.apache.hadoop.hive.metastore.events.DropConstraintEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropFunctionEvent;
import org.apache.hadoop.hive.metastore.events.DropISchemaEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.InsertEvent;
import org.apache.hadoop.hive.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.events.OpenTxnEvent;
import org.apache.hadoop.hive.metastore.events.PreAddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAddSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterCatalogEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterISchemaEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreAuthorizationCallEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateCatalogEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateFunctionEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateISchemaEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreDropCatalogEvent;
import org.apache.hadoop.hive.metastore.events.PreDropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreDropFunctionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropISchemaEvent;
import org.apache.hadoop.hive.metastore.events.PreDropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.events.PreLoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.events.PreReadCatalogEvent;
import org.apache.hadoop.hive.metastore.events.PreReadDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreReadISchemaEvent;
import org.apache.hadoop.hive.metastore.events.PreReadTableEvent;
import org.apache.hadoop.hive.metastore.events.PreReadhSchemaVersionEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.metrics.JvmPauseMonitor;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.metrics.PerfLogger;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.security.MetastoreDelegationTokenManager;
import org.apache.hadoop.hive.metastore.security.TUGIContainingTransport;
import org.apache.hadoop.hive.metastore.tools.MetastoreSchemaTool;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.CommonCliOptions;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.FilterUtils;
import org.apache.hadoop.hive.metastore.utils.HdfsUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.LogUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.MetastoreVersionInfo;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hive.com.codahale.metrics.Counter;
import org.apache.hive.com.codahale.metrics.Timer;
import org.apache.hive.http.SimpleHttpStatusServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStore
extends ThriftHiveMetastore {
    public static final Logger LOG = LoggerFactory.getLogger(HiveMetaStore.class);
    public static final String PARTITION_NUMBER_EXCEED_LIMIT_MSG = "Number of partitions scanned (=%d) on table '%s' exceeds limit (=%d). This is controlled on the metastore server by %s.";
    private static boolean isMetaStoreRemote = false;
    @VisibleForTesting
    static boolean TEST_TIMEOUT_ENABLED = false;
    @VisibleForTesting
    static long TEST_TIMEOUT_VALUE = -1L;
    private static SimpleHttpStatusServer statusServer;
    private static ShutdownHookManager shutdownHookMgr;
    public static final String ADMIN = "admin";
    public static final String PUBLIC = "public";
    public static final char MM_WRITE_OPEN = 'o';
    public static final char MM_WRITE_COMMITTED = 'c';
    public static final char MM_WRITE_ABORTED = 'a';
    private static HadoopThriftAuthBridge.Server saslServer;
    private static MetastoreDelegationTokenManager delegationTokenManager;
    private static boolean useSasl;
    static final String NO_FILTER_STRING = "";
    static final int UNLIMITED_MAX_PARTITIONS = -1;
    private static AtomicInteger openConnections;
    private static int nextThreadId;

    public static boolean isRenameAllowed(Database srcDB, Database destDB) {
        return srcDB.getName().equalsIgnoreCase(destDB.getName()) || !ReplChangeManager.isSourceOfReplication(srcDB) && !ReplChangeManager.isSourceOfReplication(destDB);
    }

    private static IHMSHandler newRetryingHMSHandler(IHMSHandler baseHandler, Configuration conf) throws MetaException {
        return HiveMetaStore.newRetryingHMSHandler(baseHandler, conf, false);
    }

    private static IHMSHandler newRetryingHMSHandler(IHMSHandler baseHandler, Configuration conf, boolean local) throws MetaException {
        return RetryingHMSHandler.getProxy(conf, baseHandler, local);
    }

    static ThriftHiveMetastore.Iface newRetryingHMSHandler(String name, Configuration conf, boolean local) throws MetaException {
        HMSHandler baseHandler = new HMSHandler(name, conf, false);
        return RetryingHMSHandler.getProxy(conf, baseHandler, local);
    }

    public static void cancelDelegationToken(String tokenStrForm) throws IOException {
        delegationTokenManager.cancelDelegationToken(tokenStrForm);
    }

    public static String getDelegationToken(String owner, String renewer, String remoteAddr) throws IOException, InterruptedException {
        return delegationTokenManager.getDelegationToken(owner, renewer, remoteAddr);
    }

    public static boolean isMetaStoreRemote() {
        return isMetaStoreRemote;
    }

    public static long renewDelegationToken(String tokenStrForm) throws IOException {
        return delegationTokenManager.renewDelegationToken(tokenStrForm);
    }

    public static void main(String[] args) throws Throwable {
        Configuration conf = MetastoreConf.newMetastoreConf();
        shutdownHookMgr = ShutdownHookManager.get();
        HiveMetastoreCli cli = new HiveMetastoreCli(conf);
        cli.parse(args);
        boolean isCliVerbose = cli.isVerbose();
        Properties hiveconf = cli.addHiveconfToSystemProperties();
        try {
            if (System.getProperty("log4j.configurationFile") == null) {
                LogUtils.initHiveLog4j(conf);
            } else {
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.reconfigure();
            }
        }
        catch (LogUtils.LogInitializationException e) {
            HMSHandler.LOG.warn(e.getMessage());
        }
        HiveMetaStore.startupShutdownMessage(HiveMetaStore.class, args, LOG);
        try {
            String msg = "Starting hive metastore on port " + cli.port;
            HMSHandler.LOG.info(msg);
            if (cli.isVerbose()) {
                System.err.println(msg);
            }
            for (Map.Entry<Object, Object> item : hiveconf.entrySet()) {
                conf.set((String)item.getKey(), (String)item.getValue());
            }
            shutdownHookMgr.addShutdownHook(() -> {
                String shutdownMsg = "Shutting down hive metastore.";
                HMSHandler.LOG.info(shutdownMsg);
                if (isCliVerbose) {
                    System.err.println(shutdownMsg);
                }
                if (MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.METRICS_ENABLED)) {
                    try {
                        Metrics.shutdown();
                    }
                    catch (Exception e) {
                        LOG.error("error in Metrics deinit: " + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
                    }
                }
                ThreadPool.shutdown();
            }, 10);
            if (MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.METRICS_ENABLED)) {
                try {
                    Metrics.initialize(conf);
                }
                catch (Exception e) {
                    LOG.error("error in Metrics init: " + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
                }
            }
            ReentrantLock startLock = new ReentrantLock();
            Condition startCondition = startLock.newCondition();
            AtomicBoolean startedServing = new AtomicBoolean();
            HiveMetaStore.startMetaStoreThreads(conf, startLock, startCondition, startedServing);
            HiveMetaStore.startMetaStore(cli.getPort(), HadoopThriftAuthBridge.getBridge(), conf, startLock, startCondition, startedServing);
        }
        catch (Throwable t) {
            HMSHandler.LOG.error("Metastore Thrift Server threw an exception...", t);
            throw t;
        }
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge) throws Throwable {
        HiveMetaStore.startMetaStore(port, bridge, MetastoreConf.newMetastoreConf(), null, null, null);
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge, Configuration conf) throws Throwable {
        HiveMetaStore.startMetaStore(port, bridge, conf, null, null, null);
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge, Configuration conf, Lock startLock, Condition startCondition, AtomicBoolean startedServing) throws Throwable {
        try {
            TServerSocket serverSocket;
            TProcessor processor;
            TTransportFactory transFactory;
            TProtocolFactory inputProtoFactory;
            TProtocolFactory protocolFactory;
            isMetaStoreRemote = true;
            long maxMessageSize = MetastoreConf.getLongVar(conf, MetastoreConf.ConfVars.SERVER_MAX_MESSAGE_SIZE);
            int minWorkerThreads = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.SERVER_MIN_THREADS);
            int maxWorkerThreads = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.SERVER_MAX_THREADS);
            int socketTimeout = Ints.saturatedCast(MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.TCP_SOCKET_BLOCKING_TIMEOUT, TimeUnit.MILLISECONDS));
            boolean tcpKeepAlive = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.TCP_KEEP_ALIVE);
            boolean useFramedTransport = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.USE_THRIFT_FRAMED_TRANSPORT);
            boolean useCompactProtocol = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.USE_THRIFT_COMPACT_PROTOCOL);
            boolean useSSL = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.USE_SSL);
            useSasl = MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.USE_THRIFT_SASL);
            if (useSasl) {
                String kerberosName = SecurityUtil.getServerPrincipal((String)MetastoreConf.getVar(conf, MetastoreConf.ConfVars.KERBEROS_PRINCIPAL), (String)"0.0.0.0");
                String keyTabFile = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.KERBEROS_KEYTAB_FILE);
                UserGroupInformation.loginUserFromKeytab((String)kerberosName, (String)keyTabFile);
            }
            if (useCompactProtocol) {
                protocolFactory = new TCompactProtocol.Factory();
                inputProtoFactory = new TCompactProtocol.Factory(maxMessageSize, maxMessageSize);
            } else {
                protocolFactory = new TBinaryProtocol.Factory();
                inputProtoFactory = new TBinaryProtocol.Factory(true, true, maxMessageSize, maxMessageSize);
            }
            HMSHandler baseHandler = new HMSHandler("new db based metaserver", conf, false);
            IHMSHandler handler = HiveMetaStore.newRetryingHMSHandler(baseHandler, conf);
            if (useSasl) {
                if (useFramedTransport) {
                    throw new HiveMetaException("Framed transport is not supported with SASL enabled.");
                }
                saslServer = bridge.createServer(MetastoreConf.getVar(conf, MetastoreConf.ConfVars.KERBEROS_KEYTAB_FILE), MetastoreConf.getVar(conf, MetastoreConf.ConfVars.KERBEROS_PRINCIPAL), MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CLIENT_KERBEROS_PRINCIPAL));
                delegationTokenManager = new MetastoreDelegationTokenManager();
                delegationTokenManager.startDelegationTokenSecretManager(conf, baseHandler, HadoopThriftAuthBridge.Server.ServerMode.METASTORE);
                saslServer.setSecretManager(delegationTokenManager.getSecretManager());
                transFactory = saslServer.createTransportFactory(MetaStoreUtils.getMetaStoreSaslProperties(conf, useSSL));
                processor = saslServer.wrapProcessor(new ThriftHiveMetastore.Processor<IHMSHandler>(handler));
                LOG.info("Starting DB backed MetaStore Server in Secure Mode");
            } else if (MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.EXECUTE_SET_UGI)) {
                transFactory = useFramedTransport ? new ChainedTTransportFactory(new TFramedTransport.Factory(), new TUGIContainingTransport.Factory()) : new TUGIContainingTransport.Factory();
                processor = new TUGIBasedProcessor<IHMSHandler>(handler);
                LOG.info("Starting DB backed MetaStore Server with SetUGI enabled");
            } else {
                transFactory = useFramedTransport ? new TFramedTransport.Factory() : new TTransportFactory();
                processor = new TSetIpAddressProcessor<IHMSHandler>(handler);
                LOG.info("Starting DB backed MetaStore Server");
            }
            if (!useSSL) {
                serverSocket = SecurityUtils.getServerSocket(null, port, socketTimeout);
            } else {
                String keyStorePath = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.SSL_KEYSTORE_PATH).trim();
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(MetastoreConf.ConfVars.SSL_KEYSTORE_PATH.toString() + " Not configured for SSL connection");
                }
                String keyStorePassword = MetastoreConf.getPassword(conf, MetastoreConf.ConfVars.SSL_KEYSTORE_PASSWORD);
                ArrayList<String> sslVersionBlacklist = new ArrayList<String>();
                for (String sslVersion : MetastoreConf.getVar(conf, MetastoreConf.ConfVars.SSL_PROTOCOL_BLACKLIST).split(",")) {
                    sslVersionBlacklist.add(sslVersion);
                }
                String sslProtocolVersion = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.SSL_PROTOCOL_VERSION);
                serverSocket = SecurityUtils.getServerSSLSocket(null, port, keyStorePath, keyStorePassword, sslVersionBlacklist, sslProtocolVersion, socketTimeout);
            }
            if (tcpKeepAlive) {
                serverSocket = new TServerSocketKeepAlive(serverSocket);
            }
            openConnections = Metrics.getOrCreateGauge("open_connections");
            TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args(serverSocket).processor(processor)).transportFactory(transFactory)).protocolFactory(protocolFactory)).inputProtocolFactory(inputProtoFactory)).minWorkerThreads(minWorkerThreads).maxWorkerThreads(maxWorkerThreads);
            TThreadPoolServer tServer = new TThreadPoolServer(args);
            TServerEventHandler tServerEventHandler = new TServerEventHandler(){

                @Override
                public void preServe() {
                }

                @Override
                public ServerContext createContext(TProtocol tProtocol, TProtocol tProtocol1) {
                    openConnections.incrementAndGet();
                    return null;
                }

                @Override
                public void deleteContext(ServerContext serverContext, TProtocol tProtocol, TProtocol tProtocol1) {
                    openConnections.decrementAndGet();
                    HiveMetaStore.cleanupRawStore();
                }

                @Override
                public void processContext(ServerContext serverContext, TTransport tTransport, TTransport tTransport1) {
                }
            };
            tServer.setServerEventHandler(tServerEventHandler);
            HMSHandler.LOG.info("Started the new metaserver on port [" + port + "]...");
            HMSHandler.LOG.info("Options.minWorkerThreads = " + minWorkerThreads);
            HMSHandler.LOG.info("Options.maxWorkerThreads = " + maxWorkerThreads);
            HMSHandler.LOG.info("TCP keepalive = " + tcpKeepAlive);
            HMSHandler.LOG.info("Enable SSL = " + useSSL);
            if (statusServer != null && !statusServer.isRunning()) {
                try {
                    statusServer.start();
                    HMSHandler.LOG.info("Metastore status server has started on port " + statusServer.getPort());
                }
                catch (Exception e) {
                    HMSHandler.LOG.error("Error starting Metastore status server: ", (Throwable)e);
                    throw new MetaException(e.getMessage());
                }
            }
            if (startLock != null) {
                HiveMetaStore.signalOtherThreadsToStart(tServer, startLock, startCondition, startedServing);
            }
            ((TServer)tServer).serve();
        }
        catch (Throwable x) {
            x.printStackTrace();
            HMSHandler.LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)x));
            throw x;
        }
    }

    private static void cleanupRawStore() {
        try {
            RawStore rs = HMSHandler.getRawStore();
            if (rs != null) {
                HMSHandler.logInfo("Cleaning up thread local RawStore...");
                rs.shutdown();
                if (statusServer != null) {
                    statusServer.stop();
                }
            }
        }
        catch (Exception e) {
            HMSHandler.logInfo(e.getMessage());
        }
        finally {
            HMSHandler handler = HMSHandler.threadLocalHMSHandler.get();
            if (handler != null) {
                handler.notifyMetaListenersOnShutDown();
            }
            HMSHandler.threadLocalHMSHandler.remove();
            HMSHandler.threadLocalConf.remove();
            HMSHandler.threadLocalModifiedConfig.remove();
            HMSHandler.removeRawStore();
            HMSHandler.logInfo("Done cleaning up thread local RawStore");
        }
    }

    private static void signalOtherThreadsToStart(final TServer server, final Lock startLock, final Condition startCondition, final AtomicBoolean startedServing) {
        Thread t = new Thread(){

            @Override
            public void run() {
                do {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Signalling thread was interrupted: " + e.getMessage());
                    }
                } while (!server.isServing());
                startLock.lock();
                try {
                    startedServing.set(true);
                    startCondition.signalAll();
                }
                finally {
                    startLock.unlock();
                }
            }
        };
        t.start();
    }

    private static void startMetaStoreThreads(final Configuration conf, final Lock startLock, final Condition startCondition, final AtomicBoolean startedServing) {
        Thread t = new Thread(){

            @Override
            public void run() {
                startLock.lock();
                try {
                    JvmPauseMonitor pauseMonitor = new JvmPauseMonitor(conf);
                    pauseMonitor.start();
                }
                catch (Throwable t) {
                    LOG.warn("Could not initiate the JvmPauseMonitor thread. GCs and Pauses may not be warned upon.", t);
                }
                try {
                    while (!startedServing.get()) {
                        startCondition.await();
                    }
                    HiveMetaStore.startCompactorInitiator(conf);
                    HiveMetaStore.startCompactorWorkers(conf);
                    HiveMetaStore.startCompactorCleaner(conf);
                    HiveMetaStore.startRemoteOnlyTasks(conf);
                    HiveMetaStore.startStatsUpdater(conf);
                }
                catch (Throwable e) {
                    LOG.error("Failure when starting the compactor, compactions may not happen, " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                finally {
                    startLock.unlock();
                }
                ReplChangeManager.scheduleCMClearer(conf);
            }
        };
        t.setDaemon(true);
        t.setName("Metastore threads starter thread");
        t.start();
    }

    protected static void startStatsUpdater(Configuration conf) throws Exception {
        MetastoreConf.StatsUpdateMode mode = MetastoreConf.StatsUpdateMode.valueOf(MetastoreConf.getVar(conf, MetastoreConf.ConfVars.STATS_AUTO_UPDATE).toUpperCase());
        if (mode == MetastoreConf.StatsUpdateMode.NONE) {
            return;
        }
        MetaStoreThread t = HiveMetaStore.instantiateThread("org.apache.hadoop.hive.ql.stats.StatsUpdaterThread");
        HiveMetaStore.initializeAndStartThread(t, conf);
    }

    private static void startCompactorInitiator(Configuration conf) throws Exception {
        if (MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON)) {
            MetaStoreThread initiator = HiveMetaStore.instantiateThread("org.apache.hadoop.hive.ql.txn.compactor.Initiator");
            HiveMetaStore.initializeAndStartThread(initiator, conf);
        }
    }

    private static void startCompactorWorkers(Configuration conf) throws Exception {
        int numWorkers = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS);
        for (int i = 0; i < numWorkers; ++i) {
            MetaStoreThread worker = HiveMetaStore.instantiateThread("org.apache.hadoop.hive.ql.txn.compactor.Worker");
            HiveMetaStore.initializeAndStartThread(worker, conf);
        }
    }

    private static void startCompactorCleaner(Configuration conf) throws Exception {
        if (MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON)) {
            MetaStoreThread cleaner = HiveMetaStore.instantiateThread("org.apache.hadoop.hive.ql.txn.compactor.Cleaner");
            HiveMetaStore.initializeAndStartThread(cleaner, conf);
        }
    }

    private static MetaStoreThread instantiateThread(String classname) throws Exception {
        Class<?> c = Class.forName(classname);
        Object o = c.newInstance();
        if (MetaStoreThread.class.isAssignableFrom(o.getClass())) {
            return (MetaStoreThread)o;
        }
        String s = classname + " is not an instance of MetaStoreThread.";
        LOG.error(s);
        throw new IOException(s);
    }

    private static void initializeAndStartThread(MetaStoreThread thread, Configuration conf) throws MetaException {
        LOG.info("Starting metastore thread of type " + thread.getClass().getName());
        thread.setConf(conf);
        thread.setThreadId(nextThreadId++);
        thread.init(new AtomicBoolean(), new AtomicBoolean());
        thread.start();
    }

    private static void startRemoteOnlyTasks(Configuration conf) throws Exception {
        if (!MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON)) {
            return;
        }
        ThreadPool.initialize(conf);
        Collection<String> taskNames = MetastoreConf.getStringCollection(conf, MetastoreConf.ConfVars.TASK_THREADS_REMOTE_ONLY);
        for (String taskName : taskNames) {
            MetastoreTaskThread task = JavaUtils.newInstance(JavaUtils.getClass(taskName, MetastoreTaskThread.class));
            task.setConf(conf);
            long freq = task.runFrequency(TimeUnit.MILLISECONDS);
            ThreadPool.getPool().scheduleAtFixedRate(task, freq, freq, TimeUnit.MILLISECONDS);
        }
    }

    private static void startupShutdownMessage(Class<?> clazz, String[] args, Logger LOG) {
        String hostname = HiveMetaStore.getHostname();
        String classname = clazz.getSimpleName();
        LOG.info(HiveMetaStore.toStartupShutdownString("STARTUP_MSG: ", new String[]{"Starting " + classname, "  host = " + hostname, "  args = " + Arrays.asList(args), "  version = " + MetastoreVersionInfo.getVersion(), "  classpath = " + System.getProperty("java.class.path"), "  build = " + MetastoreVersionInfo.getUrl() + " -r " + MetastoreVersionInfo.getRevision() + "; compiled by '" + MetastoreVersionInfo.getUser() + "' on " + MetastoreVersionInfo.getDate()}));
        shutdownHookMgr.addShutdownHook(() -> LOG.info(HiveMetaStore.toStartupShutdownString("SHUTDOWN_MSG: ", new String[]{"Shutting down " + classname + " at " + hostname})), 0);
    }

    private static String toStartupShutdownString(String prefix, String[] msg) {
        StringBuilder b = new StringBuilder(prefix);
        b.append("\n/************************************************************");
        for (String s : msg) {
            b.append("\n").append(prefix).append(s);
        }
        b.append("\n************************************************************/");
        return b.toString();
    }

    private static String getHostname() {
        try {
            return NO_FILTER_STRING + InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            return NO_FILTER_STRING + uhe;
        }
    }

    static {
        nextThreadId = 1000000;
    }

    public static class HiveMetastoreCli
    extends CommonCliOptions {
        private int port;

        HiveMetastoreCli(Configuration configuration) {
            super("hivemetastore", true);
            this.port = MetastoreConf.getIntVar(configuration, MetastoreConf.ConfVars.SERVER_PORT);
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"port");
            OptionBuilder.withDescription((String)("Hive Metastore port number, default:" + this.port));
            this.OPTIONS.addOption(OptionBuilder.create((char)'p'));
        }

        @Override
        public void parse(String[] args) {
            super.parse(args);
            args = this.commandLine.getArgs();
            if (args.length > 0) {
                System.err.println("This usage has been deprecated, consider using the new command line syntax (run with -h to see usage information)");
                this.port = new Integer(args[0]);
            }
            if (this.commandLine.hasOption('p')) {
                this.port = Integer.parseInt(this.commandLine.getOptionValue('p'));
            } else {
                String metastorePort = System.getenv("METASTORE_PORT");
                if (metastorePort != null) {
                    this.port = Integer.parseInt(metastorePort);
                }
            }
        }

        public int getPort() {
            return this.port;
        }
    }

    public static class HMSHandler
    extends FacebookBase
    implements IHMSHandler {
        public static final Logger LOG = LOG;
        private final Configuration conf;
        private static final AtomicBoolean alwaysThreadsInitialized = new AtomicBoolean(false);
        private static String currentUrl;
        private FileMetadataManager fileMetadataManager;
        private PartitionExpressionProxy expressionProxy;
        private StorageSchemaReader storageSchemaReader;
        static AtomicInteger databaseCount;
        static AtomicInteger tableCount;
        static AtomicInteger partCount;
        private Warehouse wh;
        private static final ThreadLocal<RawStore> threadLocalMS;
        private static final ThreadLocal<TxnStore> threadLocalTxn;
        private static final ThreadLocal<Map<String, Timer.Context>> timerContexts;
        private static final ThreadLocal<Configuration> threadLocalConf;
        private static final ThreadLocal<HMSHandler> threadLocalHMSHandler;
        private static final ThreadLocal<Map<String, String>> threadLocalModifiedConfig;
        private static ExecutorService threadPool;
        static final Logger auditLog;
        private static int nextSerialNum;
        private static ThreadLocal<Integer> threadLocalId;
        private static ThreadLocal<String> threadLocalIpAddress;
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private AlterHandler alterHandler;
        private List<MetaStorePreEventListener> preListeners;
        private List<MetaStoreEventListener> listeners;
        private List<TransactionalMetaStoreEventListener> transactionalListeners;
        private List<MetaStoreEndFunctionListener> endFunctionListeners;
        private List<MetaStoreInitListener> initListeners;
        private MetaStoreFilterHook filterHook;
        private boolean isServerFilterEnabled = false;
        private Pattern partitionValidationPattern;
        private final boolean isInTest;
        private static final Map<Long, ByteBuffer> EMPTY_MAP_FM1;
        private static final Map<Long, MetadataPpdResult> EMPTY_MAP_FM2;

        public static RawStore getRawStore() {
            return threadLocalMS.get();
        }

        static void removeRawStore() {
            threadLocalMS.remove();
        }

        private static void logAuditEvent(String cmd) {
            UserGroupInformation ugi;
            if (cmd == null) {
                return;
            }
            try {
                ugi = SecurityUtils.getUGI();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            String address = HMSHandler.getIPAddress();
            if (address == null) {
                address = "unknown-ip-addr";
            }
            auditLog.info("ugi={}\tip={}\tcmd={}\t", new Object[]{ugi.getUserName(), address, cmd});
        }

        public static String getIPAddress() {
            if (useSasl) {
                if (saslServer != null && saslServer.getRemoteAddress() != null) {
                    return saslServer.getRemoteAddress().getHostAddress();
                }
            } else {
                return HMSHandler.getThreadLocalIpAddress();
            }
            return null;
        }

        private void notifyMetaListeners(String key, String oldValue, String newValue) throws MetaException {
            for (MetaStoreEventListener listener : this.listeners) {
                listener.onConfigChange(new ConfigChangeEvent(this, key, oldValue, newValue));
            }
            if (this.transactionalListeners.size() > 0) {
                ConfigChangeEvent cce = new ConfigChangeEvent(this, key, oldValue, newValue);
                for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                    metaStoreEventListener.onConfigChange(cce);
                }
            }
        }

        private void notifyMetaListenersOnShutDown() {
            Map<String, String> modifiedConf = threadLocalModifiedConfig.get();
            if (modifiedConf == null) {
                return;
            }
            try {
                Configuration conf = threadLocalConf.get();
                if (conf == null) {
                    throw new MetaException("Unexpected: modifiedConf is non-null but conf is null");
                }
                for (Map.Entry<String, String> entry : modifiedConf.entrySet()) {
                    String key = entry.getKey();
                    String currVal = entry.getValue();
                    String oldVal = conf.get(key);
                    if (Objects.equals(oldVal, currVal)) continue;
                    this.notifyMetaListeners(key, oldVal, currVal);
                }
                HMSHandler.logInfo("Meta listeners shutdown notification completed.");
            }
            catch (MetaException e) {
                LOG.error("Failed to notify meta listeners on shutdown: ", (Throwable)e);
            }
        }

        static void setThreadLocalIpAddress(String ipAddress) {
            threadLocalIpAddress.set(ipAddress);
        }

        static String getThreadLocalIpAddress() {
            return threadLocalIpAddress.get();
        }

        @VisibleForTesting
        PartitionExpressionProxy getExpressionProxy() {
            return this.expressionProxy;
        }

        @Deprecated
        public static Integer get() {
            return threadLocalId.get();
        }

        @Override
        public int getThreadId() {
            return threadLocalId.get();
        }

        public HMSHandler(String name) throws MetaException {
            this(name, MetastoreConf.newMetastoreConf(), true);
        }

        public HMSHandler(String name, Configuration conf) throws MetaException {
            this(name, conf, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public HMSHandler(String name, Configuration conf, boolean init) throws MetaException {
            super(name);
            if (this.classLoader == null) {
                this.classLoader = Configuration.class.getClassLoader();
            }
            this.conf = conf;
            this.isInTest = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEST);
            if (threadPool == null) {
                Class<HMSHandler> clazz = HMSHandler.class;
                // MONITORENTER : org.apache.hadoop.hive.metastore.HiveMetaStore$HMSHandler.class
                int numThreads = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.FS_HANDLER_THREADS_COUNT);
                threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HMSHandler #%d").build());
                // MONITOREXIT : clazz
            }
            if (!init) return;
            this.init();
        }

        @Deprecated
        public Configuration getHiveConf() {
            return this.conf;
        }

        @Override
        public List<TransactionalMetaStoreEventListener> getTransactionalListeners() {
            return this.transactionalListeners;
        }

        @Override
        public List<MetaStoreEventListener> getListeners() {
            return this.listeners;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init() throws MetaException {
            this.initListeners = MetaStoreUtils.getMetaStoreListeners(MetaStoreInitListener.class, this.conf, MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.INIT_HOOKS));
            for (MetaStoreInitListener metaStoreInitListener : this.initListeners) {
                MetaStoreInitContext context = new MetaStoreInitContext();
                metaStoreInitListener.onInit(context);
            }
            String alterHandlerName = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.ALTER_HANDLER);
            this.alterHandler = (AlterHandler)ReflectionUtils.newInstance(JavaUtils.getClass(alterHandlerName, AlterHandler.class), (Configuration)this.conf);
            this.wh = new Warehouse(this.conf);
            Class<HMSHandler> clazz = HMSHandler.class;
            synchronized (HMSHandler.class) {
                if (currentUrl == null || !currentUrl.equals(MetaStoreInit.getConnectionURL(this.conf))) {
                    this.createDefaultDB();
                    this.createDefaultRoles();
                    this.addAdminUsers();
                    currentUrl = MetaStoreInit.getConnectionURL(this.conf);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                if (MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.METRICS_ENABLED)) {
                    LOG.info("Begin calculating metadata count metrics.");
                    Metrics.initialize(this.conf);
                    databaseCount = Metrics.getOrCreateGauge("total_count_dbs");
                    tableCount = Metrics.getOrCreateGauge("total_count_tables");
                    partCount = Metrics.getOrCreateGauge("total_count_partitions");
                    this.updateMetrics();
                }
                this.preListeners = MetaStoreUtils.getMetaStoreListeners(MetaStorePreEventListener.class, this.conf, MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.PRE_EVENT_LISTENERS));
                this.preListeners.add(0, new TransactionalValidationListener(this.conf));
                this.listeners = MetaStoreUtils.getMetaStoreListeners(MetaStoreEventListener.class, this.conf, MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.EVENT_LISTENERS));
                this.listeners.add(new SessionPropertiesListener(this.conf));
                this.listeners.add(new AcidEventListener(this.conf));
                this.transactionalListeners = MetaStoreUtils.getMetaStoreListeners(TransactionalMetaStoreEventListener.class, this.conf, MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.TRANSACTIONAL_EVENT_LISTENERS));
                if (Metrics.getRegistry() != null) {
                    this.listeners.add(new HMSMetricsListener(this.conf));
                }
                this.endFunctionListeners = MetaStoreUtils.getMetaStoreListeners(MetaStoreEndFunctionListener.class, this.conf, MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.END_FUNCTION_LISTENERS));
                String string = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN);
                this.partitionValidationPattern = string != null && !string.isEmpty() ? Pattern.compile(string) : null;
                if (alwaysThreadsInitialized.compareAndSet(false, true)) {
                    ThreadPool.initialize(this.conf);
                    Collection<String> taskNames = MetastoreConf.getStringCollection(this.conf, MetastoreConf.ConfVars.TASK_THREADS_ALWAYS);
                    for (String taskName : taskNames) {
                        MetastoreTaskThread task = JavaUtils.newInstance(JavaUtils.getClass(taskName, MetastoreTaskThread.class));
                        task.setConf(this.conf);
                        long freq = task.runFrequency(TimeUnit.MILLISECONDS);
                        if (freq <= 0L) continue;
                        ThreadPool.getPool().scheduleAtFixedRate(task, freq, freq, TimeUnit.MILLISECONDS);
                    }
                }
                this.expressionProxy = PartFilterExprUtil.createExpressionProxy(this.conf);
                this.fileMetadataManager = new FileMetadataManager(this.getMS(), this.conf);
                this.isServerFilterEnabled = this.getIfServerFilterenabled();
                MetaStoreFilterHook metaStoreFilterHook = this.filterHook = this.isServerFilterEnabled ? this.loadFilterHooks() : null;
                if (statusServer == null) {
                    SimpleHttpStatusServer.Builder builder = new SimpleHttpStatusServer.Builder("metastore-status");
                    int hmsServerPort = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.HIVE_METASTORE_STATUS_PORT);
                    String hmsStatusServerHost = "0.0.0.0";
                    int hmsMaxThreads = 50;
                    builder.setPort(hmsServerPort);
                    builder.setHost(hmsStatusServerHost);
                    builder.setMaxThreads(hmsMaxThreads);
                    builder.setConf(this.conf);
                    try {
                        statusServer = builder.build();
                        statusServer.addServlet("service_status", "/status", MetastoreStatusServlet.class);
                    }
                    catch (IOException e) {
                        LOG.warn("Error creating Metastore status server: ", (Throwable)e);
                    }
                }
                return;
            }
        }

        private boolean getIfServerFilterenabled() throws MetaException {
            boolean isEnabled = MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.METASTORE_SERVER_FILTER_ENABLED);
            if (!isEnabled) {
                LOG.info("HMS server filtering is disabled by configuration");
                return false;
            }
            String filterHookClassName = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.FILTER_HOOK);
            if (hive.org.apache.commons.lang.StringUtils.isBlank(filterHookClassName)) {
                throw new MetaException("HMS server filtering is enabled but no filter hook is configured");
            }
            if (filterHookClassName.trim().equalsIgnoreCase(DefaultMetaStoreFilterHookImpl.class.getName())) {
                throw new MetaException("HMS server filtering is enabled but the filter hook is DefaultMetaStoreFilterHookImpl, which does no filtering");
            }
            LOG.info("HMS server filtering is enabled. The filter class is " + filterHookClassName);
            return true;
        }

        private MetaStoreFilterHook loadFilterHooks() throws IllegalStateException {
            String errorMsg = "Unable to load filter hook at HMS server. ";
            String filterHookClassName = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.FILTER_HOOK);
            Preconditions.checkState(!hive.org.apache.commons.lang.StringUtils.isBlank(filterHookClassName));
            try {
                return (MetaStoreFilterHook)Class.forName(filterHookClassName.trim(), true, JavaUtils.getClassLoader()).getConstructor(Configuration.class).newInstance(this.conf);
            }
            catch (Exception e) {
                LOG.error(errorMsg, (Throwable)e);
                throw new IllegalStateException(errorMsg + e.getMessage(), e);
            }
        }

        private void authorizeTableForPartitionMetadata(String catName, String dbName, String tblName) throws NoSuchObjectException, MetaException {
            FilterUtils.checkDbAndTableFilters(this.isServerFilterEnabled, this.filterHook, catName, dbName, tblName);
        }

        private static String addPrefix(String s) {
            return threadLocalId.get() + ": " + s;
        }

        private static void setHMSHandler(HMSHandler handler) {
            if (threadLocalHMSHandler.get() == null) {
                threadLocalHMSHandler.set(handler);
            }
        }

        public void setConf(Configuration conf) {
            threadLocalConf.set(conf);
            RawStore ms = threadLocalMS.get();
            if (ms != null) {
                ms.setConf(conf);
            }
        }

        public Configuration getConf() {
            Configuration conf = threadLocalConf.get();
            if (conf == null) {
                conf = new Configuration(this.conf);
                threadLocalConf.set(conf);
            }
            return conf;
        }

        private Map<String, String> getModifiedConf() {
            Map<String, String> modifiedConf = threadLocalModifiedConfig.get();
            if (modifiedConf == null) {
                modifiedConf = new HashMap<String, String>();
                threadLocalModifiedConfig.set(modifiedConf);
            }
            return modifiedConf;
        }

        @Override
        public Warehouse getWh() {
            return this.wh;
        }

        @Override
        public void setMetaConf(String key, String value) throws MetaException {
            MetastoreConf.ConfVars confVar = MetastoreConf.getMetaConf(key);
            if (confVar == null) {
                throw new MetaException("Invalid configuration key " + key);
            }
            try {
                confVar.validate(value);
            }
            catch (IllegalArgumentException e) {
                throw new MetaException("Invalid configuration value " + value + " for key " + key + " by " + e.getMessage());
            }
            Configuration configuration = this.getConf();
            String oldValue = MetastoreConf.get(configuration, key);
            Map<String, String> modifiedConf = this.getModifiedConf();
            if (!modifiedConf.containsKey(key)) {
                modifiedConf.put(key, oldValue);
            }
            HMSHandler.setHMSHandler(this);
            configuration.set(key, value);
            this.notifyMetaListeners(key, oldValue, value);
        }

        @Override
        public String getMetaConf(String key) throws MetaException {
            MetastoreConf.ConfVars confVar = MetastoreConf.getMetaConf(key);
            if (confVar == null) {
                throw new MetaException("Invalid configuration key " + key);
            }
            return this.getConf().get(key, confVar.getDefaultVal().toString());
        }

        @Override
        public RawStore getMS() throws MetaException {
            Configuration conf = this.getConf();
            return HMSHandler.getMSForConf(conf);
        }

        public static RawStore getMSForConf(Configuration conf) throws MetaException {
            RawStore ms = threadLocalMS.get();
            if (ms == null) {
                ms = HMSHandler.newRawStoreForConf(conf);
                ms.verifySchema();
                threadLocalMS.set(ms);
                ms = threadLocalMS.get();
            }
            return ms;
        }

        @Override
        public TxnStore getTxnHandler() {
            TxnStore txn = threadLocalTxn.get();
            if (txn == null) {
                txn = TxnUtils.getTxnStore(this.conf);
                threadLocalTxn.set(txn);
            }
            return txn;
        }

        static RawStore newRawStoreForConf(Configuration conf) throws MetaException {
            Configuration newConf = new Configuration(conf);
            String rawStoreClassName = MetastoreConf.getVar(newConf, MetastoreConf.ConfVars.RAW_STORE_IMPL);
            LOG.info(HMSHandler.addPrefix("Opening raw store with implementation class:" + rawStoreClassName));
            return RawStoreProxy.getProxy(newConf, conf, rawStoreClassName, threadLocalId.get());
        }

        @VisibleForTesting
        public static void createDefaultCatalog(RawStore ms, Warehouse wh) throws MetaException, InvalidOperationException {
            try {
                Catalog defaultCat = ms.getCatalog("hive");
                if (defaultCat != null && defaultCat.getLocationUri().equals("TBD")) {
                    LOG.info("Setting location of default catalog, as it hasn't been done after upgrade");
                    defaultCat.setLocationUri(wh.getWhRoot().toString());
                    ms.alterCatalog(defaultCat.getName(), defaultCat);
                }
            }
            catch (NoSuchObjectException e) {
                Catalog cat = new Catalog("hive", wh.getWhRoot().toString());
                cat.setDescription("Default catalog, for Hive");
                ms.createCatalog(cat);
            }
        }

        private void createDefaultDB_core(RawStore ms) throws MetaException, InvalidObjectException {
            try {
                ms.getDatabase("hive", "default");
            }
            catch (NoSuchObjectException e) {
                Database db = new Database("default", "Default Hive database", this.wh.getDefaultDatabasePath("default").toString(), null);
                db.setOwnerName(HiveMetaStore.PUBLIC);
                db.setOwnerType(PrincipalType.ROLE);
                db.setCatalogName("hive");
                ms.createDatabase(db);
            }
        }

        private void createDefaultDB() throws MetaException {
            try {
                RawStore ms = this.getMS();
                HMSHandler.createDefaultCatalog(ms, this.wh);
                this.createDefaultDB_core(ms);
            }
            catch (JDOException e) {
                LOG.warn("Retrying creating default database after error: " + e.getMessage(), (Throwable)e);
                try {
                    this.createDefaultDB_core(this.getMS());
                }
                catch (InvalidObjectException e1) {
                    throw new MetaException(e1.getMessage());
                }
            }
            catch (InvalidObjectException | InvalidOperationException e) {
                throw new MetaException(e.getMessage());
            }
        }

        private void createDefaultRoles() throws MetaException {
            try {
                this.createDefaultRoles_core();
            }
            catch (JDOException e) {
                LOG.warn("Retrying creating default roles after error: " + e.getMessage(), (Throwable)e);
                this.createDefaultRoles_core();
            }
        }

        private void createDefaultRoles_core() throws MetaException {
            RawStore ms = this.getMS();
            try {
                ms.addRole(HiveMetaStore.ADMIN, HiveMetaStore.ADMIN);
            }
            catch (InvalidObjectException e) {
                LOG.debug("admin role already exists", (Throwable)e);
            }
            catch (NoSuchObjectException e) {
                LOG.warn("Unexpected exception while adding admin roles", (Throwable)e);
            }
            LOG.info("Added admin role in metastore");
            try {
                ms.addRole(HiveMetaStore.PUBLIC, HiveMetaStore.PUBLIC);
            }
            catch (InvalidObjectException e) {
                LOG.debug("public role already exists", (Throwable)e);
            }
            catch (NoSuchObjectException e) {
                LOG.warn("Unexpected exception while adding public roles", (Throwable)e);
            }
            LOG.info("Added public role in metastore");
            PrivilegeBag privs = new PrivilegeBag();
            privs.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.GLOBAL, null, null, null, null), HiveMetaStore.ADMIN, PrincipalType.ROLE, new PrivilegeGrantInfo("All", 0, HiveMetaStore.ADMIN, PrincipalType.ROLE, true), "SQL"));
            try {
                ms.grantPrivileges(privs);
            }
            catch (InvalidObjectException e) {
                LOG.debug("Failed while granting global privs to admin", (Throwable)e);
            }
            catch (NoSuchObjectException e) {
                LOG.warn("Failed while granting global privs to admin", (Throwable)e);
            }
        }

        private void addAdminUsers() throws MetaException {
            try {
                this.addAdminUsers_core();
            }
            catch (JDOException e) {
                LOG.warn("Retrying adding admin users after error: " + e.getMessage(), (Throwable)e);
                this.addAdminUsers_core();
            }
        }

        private void addAdminUsers_core() throws MetaException {
            Role adminRole;
            String userStr = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.USERS_IN_ADMIN_ROLE, HiveMetaStore.NO_FILTER_STRING).trim();
            if (userStr.isEmpty()) {
                LOG.info("No user is added in admin role, since config is empty");
                return;
            }
            Iterator<String> users = Splitter.on(",").trimResults().omitEmptyStrings().split(userStr).iterator();
            if (!users.hasNext()) {
                LOG.info("No user is added in admin role, since config value " + userStr + " is in incorrect format. We accept comma separated list of users.");
                return;
            }
            RawStore ms = this.getMS();
            try {
                adminRole = ms.getRole(HiveMetaStore.ADMIN);
            }
            catch (NoSuchObjectException e) {
                LOG.error("Failed to retrieve just added admin role", (Throwable)e);
                return;
            }
            while (users.hasNext()) {
                String userName = users.next();
                try {
                    ms.grantRole(adminRole, userName, PrincipalType.USER, HiveMetaStore.ADMIN, PrincipalType.ROLE, true);
                    LOG.info("Added " + userName + " to admin role");
                }
                catch (NoSuchObjectException e) {
                    LOG.error("Failed to add " + userName + " in admin role", (Throwable)e);
                }
                catch (InvalidObjectException e) {
                    LOG.debug(userName + " already in admin role", (Throwable)e);
                }
            }
        }

        private static void logInfo(String m) {
            LOG.info(threadLocalId.get().toString() + ": " + m);
            HMSHandler.logAuditEvent(m);
        }

        private String startFunction(String function, String extraLogInfo) {
            Counter counter;
            this.incrementCounter(function);
            HMSHandler.logInfo((String)(HMSHandler.getThreadLocalIpAddress() == null ? HiveMetaStore.NO_FILTER_STRING : "source:" + HMSHandler.getThreadLocalIpAddress() + " ") + function + extraLogInfo);
            Timer timer = Metrics.getOrCreateTimer("api_" + function);
            if (timer != null) {
                timerContexts.get().put(function, timer.time());
            }
            if ((counter = Metrics.getOrCreateCounter("active_calls_" + function)) != null) {
                counter.inc();
            }
            return function;
        }

        private String startFunction(String function) {
            return this.startFunction(function, HiveMetaStore.NO_FILTER_STRING);
        }

        private void startTableFunction(String function, String catName, String db, String tbl) {
            this.startFunction(function, " : tbl=" + Warehouse.getCatalogQualifiedTableName(catName, db, tbl));
        }

        private void startMultiTableFunction(String function, String db, List<String> tbls) {
            String tableNames = hive.org.apache.commons.lang.StringUtils.join(tbls, ",");
            this.startFunction(function, " : db=" + db + " tbls=" + tableNames);
        }

        private void startPartitionFunction(String function, String cat, String db, String tbl, List<String> partVals) {
            this.startFunction(function, " : tbl=" + Warehouse.getCatalogQualifiedTableName(cat, db, tbl) + "[" + hive.org.apache.commons.lang.StringUtils.join(partVals, ",") + "]");
        }

        private void startPartitionFunction(String function, String catName, String db, String tbl, Map<String, String> partName) {
            this.startFunction(function, " : tbl=" + Warehouse.getCatalogQualifiedTableName(catName, db, tbl) + "partition=" + partName);
        }

        private void endFunction(String function, boolean successful, Exception e) {
            this.endFunction(function, successful, e, null);
        }

        private void endFunction(String function, boolean successful, Exception e, String inputTableName) {
            this.endFunction(function, new MetaStoreEndFunctionContext(successful, e, inputTableName));
        }

        private void endFunction(String function, MetaStoreEndFunctionContext context) {
            Counter counter;
            Timer.Context timerContext = timerContexts.get().remove(function);
            if (timerContext != null) {
                timerContext.close();
            }
            if ((counter = Metrics.getOrCreateCounter("active_calls_" + function)) != null) {
                counter.dec();
            }
            for (MetaStoreEndFunctionListener listener : this.endFunctionListeners) {
                listener.onEndFunction(function, context);
            }
        }

        public fb_status getStatus() {
            return fb_status.ALIVE;
        }

        public void shutdown() {
            HiveMetaStore.cleanupRawStore();
            PerfLogger.getPerfLogger(false).cleanupPerfLogMetrics();
        }

        public AbstractMap<String, Long> getCounters() {
            AbstractMap counters = super.getCounters();
            if (this.endFunctionListeners != null) {
                for (MetaStoreEndFunctionListener listener : this.endFunctionListeners) {
                    listener.exportCounters(counters);
                }
            }
            return counters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void create_catalog(CreateCatalogRequest rqst) throws AlreadyExistsException, InvalidObjectException, MetaException {
            Catalog catalog = rqst.getCatalog();
            this.startFunction("create_catalog", ": " + catalog.toString());
            boolean success = false;
            TException ex = null;
            try {
                try {
                    this.getMS().getCatalog(catalog.getName());
                    throw new AlreadyExistsException("Catalog " + catalog.getName() + " already exists");
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    if (!MetaStoreUtils.validateName(catalog.getName(), null)) {
                        throw new InvalidObjectException(catalog.getName() + " is not a valid catalog name");
                    }
                    if (catalog.getLocationUri() == null) {
                        throw new InvalidObjectException("You must specify a path for the catalog");
                    }
                    RawStore ms = this.getMS();
                    Path catPath = new Path(catalog.getLocationUri());
                    boolean madeDir = false;
                    Map<String, String> transactionalListenersResponses = Collections.emptyMap();
                    try {
                        this.firePreEvent(new PreCreateCatalogEvent(this, catalog));
                        if (!this.wh.isDir(catPath)) {
                            if (!this.wh.mkdirs(catPath)) {
                                throw new MetaException("Unable to create catalog path " + catPath + ", failed to create catalog " + catalog.getName());
                            }
                            madeDir = true;
                        }
                        ms.openTransaction();
                        ms.createCatalog(catalog);
                        Database db = new Database("default", "Default database for catalog " + catalog.getName(), catalog.getLocationUri(), Collections.emptyMap());
                        db.setCatalogName(catalog.getName());
                        this.create_database_core(ms, db);
                        if (!this.transactionalListeners.isEmpty()) {
                            transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.CREATE_CATALOG, new CreateCatalogEvent(true, this, catalog));
                        }
                        success = ms.commitTransaction();
                    }
                    finally {
                        if (!success) {
                            ms.rollbackTransaction();
                            if (madeDir) {
                                this.wh.deleteDir(catPath, true, false, false);
                            }
                        }
                        if (!this.listeners.isEmpty()) {
                            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_CATALOG, new CreateCatalogEvent(success, this, catalog), null, transactionalListenersResponses, ms);
                        }
                    }
                    success = true;
                    this.endFunction("create_catalog", success, ex);
                }
            }
            catch (AlreadyExistsException | InvalidObjectException | MetaException e) {
                try {
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("create_catalog", success, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public void alter_catalog(AlterCatalogRequest rqst) throws TException {
            this.startFunction("alter_catalog " + rqst.getName());
            boolean success = false;
            TException ex = null;
            RawStore ms = this.getMS();
            Map<String, String> transactionalListenersResponses = Collections.emptyMap();
            GetCatalogResponse oldCat = null;
            try {
                oldCat = this.get_catalog(new GetCatalogRequest(rqst.getName()));
                assert (oldCat != null && oldCat.getCatalog() != null);
                this.firePreEvent(new PreAlterCatalogEvent(oldCat.getCatalog(), rqst.getNewCat(), this));
                ms.openTransaction();
                ms.alterCatalog(rqst.getName(), rqst.getNewCat());
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_CATALOG, new AlterCatalogEvent(oldCat.getCatalog(), rqst.getNewCat(), true, this));
                }
                success = ms.commitTransaction();
            }
            catch (MetaException | NoSuchObjectException e) {
                ex = e;
                throw e;
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                if (null != oldCat && !this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_CATALOG, new AlterCatalogEvent(oldCat.getCatalog(), rqst.getNewCat(), success, this), null, transactionalListenersResponses, ms);
                }
                this.endFunction("alter_catalog", success, ex);
            }
        }

        @Override
        public GetCatalogResponse get_catalog(GetCatalogRequest rqst) throws NoSuchObjectException, TException {
            String catName = rqst.getName();
            this.startFunction("get_catalog", ": " + catName);
            Catalog cat = null;
            TException ex = null;
            try {
                cat = this.getMS().getCatalog(catName);
                this.firePreEvent(new PreReadCatalogEvent(this, cat));
                GetCatalogResponse getCatalogResponse = new GetCatalogResponse(cat);
                this.endFunction("get_catalog", cat != null, ex);
                return getCatalogResponse;
            }
            catch (MetaException | NoSuchObjectException e) {
                try {
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_catalog", cat != null, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public GetCatalogsResponse get_catalogs() throws MetaException {
            this.startFunction("get_catalogs");
            List<String> ret = null;
            MetaException ex = null;
            try {
                ret = this.getMS().getCatalogs();
                this.endFunction("get_catalog", ret != null, ex);
            }
            catch (MetaException e) {
                try {
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_catalog", ret != null, ex);
                    throw throwable;
                }
            }
            return new GetCatalogsResponse(ret == null ? Collections.emptyList() : ret);
        }

        @Override
        public void drop_catalog(DropCatalogRequest rqst) throws NoSuchObjectException, InvalidOperationException, MetaException {
            String catName = rqst.getName();
            this.startFunction("drop_catalog", ": " + catName);
            if ("hive".equalsIgnoreCase(catName)) {
                this.endFunction("drop_catalog", false, null);
                throw new MetaException("Can not drop hive catalog");
            }
            boolean success = false;
            Exception ex = null;
            try {
                this.dropCatalogCore(catName);
                success = true;
            }
            catch (InvalidOperationException | MetaException | NoSuchObjectException e) {
                ex = e;
                throw e;
            }
            catch (Exception e) {
                ex = e;
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("drop_catalog", success, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dropCatalogCore(String catName) throws MetaException, NoSuchObjectException, InvalidOperationException {
            boolean success = false;
            Catalog cat = null;
            Map<String, String> transactionalListenerResponses = Collections.emptyMap();
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                cat = ms.getCatalog(catName);
                this.firePreEvent(new PreDropCatalogEvent(this, cat));
                List<String> allDbs = this.get_databases(MetaStoreUtils.prependNotNullCatToDbName(catName, null));
                if (allDbs != null && !allDbs.isEmpty()) {
                    if (allDbs.size() == 1 && allDbs.get(0).equals("default")) {
                        try {
                            this.drop_database_core(ms, catName, "default", true, false);
                        }
                        catch (InvalidOperationException e) {
                            throw new InvalidOperationException("There are still objects in the default database for catalog " + catName);
                        }
                        catch (IOException | InvalidInputException | InvalidObjectException e) {
                            MetaException me = new MetaException("Error attempt to drop default database for catalog " + catName);
                            me.initCause(e);
                            throw me;
                        }
                    } else {
                        throw new InvalidOperationException("There are non-default databases in the catalog " + catName + " so it cannot be dropped.");
                    }
                }
                ms.dropCatalog(catName);
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_CATALOG, new DropCatalogEvent(true, this, cat));
                }
                success = ms.commitTransaction();
            }
            finally {
                if (success) {
                    this.wh.deleteDir(this.wh.getDnsPath(new Path(cat.getLocationUri())), false, false, false);
                } else {
                    ms.rollbackTransaction();
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_CATALOG, new DropCatalogEvent(success, this, cat), null, transactionalListenerResponses, ms);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_database_core(RawStore ms, Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
            if (!MetaStoreUtils.validateName(db.getName(), null)) {
                throw new InvalidObjectException(db.getName() + " is not a valid database name");
            }
            Catalog cat = null;
            try {
                cat = this.getMS().getCatalog(db.getCatalogName());
            }
            catch (NoSuchObjectException e) {
                LOG.error("No such catalog " + db.getCatalogName());
                throw new InvalidObjectException("No such catalog " + db.getCatalogName());
            }
            Path dbPath = this.wh.determineDatabasePath(cat, db);
            String dbLocationUri = this.wh.getDnsPath(dbPath).toString();
            Configuration conf = this.getConf();
            if (!MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.METASTORE_ALLOW_NEW_DB_IN_EXISTING_DIRECTORY) && FileUtils.exists(dbPath, conf)) {
                throw new InvalidObjectException("Failed to create database. Database directory already exists: " + dbLocationUri);
            }
            db.setLocationUri(dbLocationUri);
            boolean success = false;
            boolean madeDir = false;
            Map<String, String> transactionalListenersResponses = Collections.emptyMap();
            try {
                this.firePreEvent(new PreCreateDatabaseEvent(db, (IHMSHandler)this));
                if (!this.wh.isDir(dbPath)) {
                    LOG.debug("Creating database path " + dbPath);
                    if (!this.wh.mkdirs(dbPath)) {
                        throw new MetaException("Unable to create database path " + dbPath + ", failed to create database " + db.getName());
                    }
                    madeDir = true;
                }
                ms.openTransaction();
                ms.createDatabase(db);
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.CREATE_DATABASE, new CreateDatabaseEvent(db, true, this));
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                    if (madeDir) {
                        this.wh.deleteDir(dbPath, true, db);
                    }
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_DATABASE, new CreateDatabaseEvent(db, success, this), null, transactionalListenersResponses, ms);
                }
            }
        }

        @Override
        public void create_database(Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
            this.startFunction("create_database", ": " + db.toString());
            boolean success = false;
            Exception ex = null;
            if (!db.isSetCatalogName()) {
                db.setCatalogName(MetaStoreUtils.getDefaultCatalog(this.conf));
            }
            try {
                try {
                    if (null != this.get_database_core(db.getCatalogName(), db.getName())) {
                        throw new AlreadyExistsException("Database " + db.getName() + " already exists");
                    }
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    // empty catch block
                }
                if (TEST_TIMEOUT_ENABLED) {
                    try {
                        Thread.sleep(TEST_TIMEOUT_VALUE);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Deadline.checkTimeout();
                }
                this.create_database_core(this.getMS(), db);
                success = true;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof InvalidObjectException) {
                    throw (InvalidObjectException)e;
                }
                if (e instanceof AlreadyExistsException) {
                    throw (AlreadyExistsException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("create_database", success, ex);
            }
        }

        @Override
        public Database get_database(String name) throws NoSuchObjectException, MetaException {
            this.startFunction("get_database", ": " + name);
            Database db = null;
            TException ex = null;
            try {
                String[] parsedDbName = MetaStoreUtils.parseDbName(name, this.conf);
                db = this.get_database_core(parsedDbName[0], parsedDbName[1]);
                this.firePreEvent(new PreReadDatabaseEvent(db, (IHMSHandler)this));
                this.endFunction("get_database", db != null, ex);
            }
            catch (MetaException | NoSuchObjectException e) {
                try {
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_database", db != null, ex);
                    throw throwable;
                }
            }
            return db;
        }

        @Override
        public Database get_database_core(String catName, String name) throws NoSuchObjectException, MetaException {
            Database db = null;
            if (name == null) {
                throw new MetaException("Database name cannot be null.");
            }
            try {
                db = this.getMS().getDatabase(catName, name);
            }
            catch (MetaException | NoSuchObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return db;
        }

        @Override
        public void alter_database(String dbName, Database newDB) throws TException {
            this.startFunction("alter_database " + dbName);
            boolean success = false;
            TException ex = null;
            RawStore ms = this.getMS();
            Database oldDB = null;
            Map<String, String> transactionalListenersResponses = Collections.emptyMap();
            if (newDB.getLocationUri() != null) {
                newDB.setLocationUri(this.wh.getDnsPath(new Path(newDB.getLocationUri())).toString());
            }
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            try {
                oldDB = this.get_database_core(parsedDbName[0], parsedDbName[1]);
                if (oldDB == null) {
                    throw new MetaException("Could not alter database \"" + parsedDbName[1] + "\". Could not retrieve old definition.");
                }
                this.firePreEvent(new PreAlterDatabaseEvent(oldDB, newDB, this));
                ms.openTransaction();
                ms.alterDatabase(parsedDbName[0], parsedDbName[1], newDB);
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_DATABASE, new AlterDatabaseEvent(oldDB, newDB, true, this));
                }
                success = ms.commitTransaction();
            }
            catch (MetaException | NoSuchObjectException e) {
                ex = e;
                throw e;
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                if (null != oldDB && !this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_DATABASE, new AlterDatabaseEvent(oldDB, newDB, success, this), null, transactionalListenersResponses, ms);
                }
                this.endFunction("alter_database", success, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_database_core(RawStore ms, String catName, String name, boolean deleteData, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, IOException, InvalidObjectException, InvalidInputException {
            boolean success = false;
            Database db = null;
            ArrayList<Path> tablePaths = new ArrayList<Path>();
            List<Path> partitionPaths = new ArrayList<Path>();
            Map<String, String> transactionalListenerResponses = Collections.emptyMap();
            if (name == null) {
                throw new MetaException("Database name cannot be null.");
            }
            try {
                Path path;
                ms.openTransaction();
                db = ms.getDatabase(catName, name);
                if (!this.isInTest && ReplChangeManager.isSourceOfReplication(db)) {
                    throw new InvalidOperationException("can not drop a database which is a source of replication");
                }
                this.firePreEvent(new PreDropDatabaseEvent(db, (IHMSHandler)this));
                String catPrependedName = MetaStoreUtils.prependCatalogToDbName(catName, name, this.conf);
                HashSet<String> uniqueTableNames = new HashSet<String>(this.get_all_tables(catPrependedName));
                List<String> allFunctions = this.get_functions(catPrependedName, "*");
                if (!cascade) {
                    if (!uniqueTableNames.isEmpty()) {
                        throw new InvalidOperationException("Database " + db.getName() + " is not empty. One or more tables exist.");
                    }
                    if (!allFunctions.isEmpty()) {
                        throw new InvalidOperationException("Database " + db.getName() + " is not empty. One or more functions exist.");
                    }
                }
                if (!this.wh.isWritable(path = new Path(db.getLocationUri()).getParent())) {
                    throw new MetaException("Database not dropped since " + path + " is not writable by " + SecurityUtils.getUser());
                }
                Path databasePath = this.wh.getDnsPath(this.wh.getDatabasePath(db));
                for (String funcName : allFunctions) {
                    this.drop_function(catPrependedName, funcName);
                }
                int tableBatchSize = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
                List<String> materializedViewNames = this.get_tables_by_type(name, ".*", TableType.MATERIALIZED_VIEW.toString());
                int startIndex = 0;
                while (startIndex < materializedViewNames.size()) {
                    List<Table> materializedViews;
                    int endIndex = Math.min(startIndex + tableBatchSize, materializedViewNames.size());
                    try {
                        materializedViews = ms.getTableObjectsByName(catName, name, materializedViewNames.subList(startIndex, endIndex));
                    }
                    catch (UnknownDBException e) {
                        throw new MetaException(e.getMessage());
                    }
                    if (materializedViews != null && !materializedViews.isEmpty()) {
                        for (Table materializedView : materializedViews) {
                            if (materializedView.getSd().getLocation() != null) {
                                Path materializedViewPath = this.wh.getDnsPath(new Path(materializedView.getSd().getLocation()));
                                if (!this.wh.isWritable(materializedViewPath.getParent())) {
                                    throw new MetaException("Database metadata not deleted since table: " + materializedView.getTableName() + " has a parent location " + materializedViewPath.getParent() + " which is not writable by " + SecurityUtils.getUser());
                                }
                                if (!this.isSubdirectory(databasePath, materializedViewPath)) {
                                    tablePaths.add(materializedViewPath);
                                }
                            }
                            this.drop_table(name, materializedView.getTableName(), false);
                            uniqueTableNames.remove(materializedView.getTableName());
                        }
                    }
                    startIndex = endIndex;
                }
                ArrayList<String> allTables = new ArrayList<String>(uniqueTableNames);
                startIndex = 0;
                while (startIndex < allTables.size()) {
                    List<Table> tables;
                    int endIndex = Math.min(startIndex + tableBatchSize, allTables.size());
                    try {
                        tables = ms.getTableObjectsByName(catName, name, allTables.subList(startIndex, endIndex));
                    }
                    catch (UnknownDBException e) {
                        throw new MetaException(e.getMessage());
                    }
                    if (tables == null || tables.isEmpty()) continue;
                    for (Table table : tables) {
                        Path tablePath = null;
                        if (table.getSd().getLocation() != null && !this.isExternal(table)) {
                            tablePath = this.wh.getDnsPath(new Path(table.getSd().getLocation()));
                            if (!this.wh.isWritable(tablePath.getParent())) {
                                throw new MetaException("Database metadata not deleted since table: " + table.getTableName() + " has a parent location " + tablePath.getParent() + " which is not writable by " + SecurityUtils.getUser());
                            }
                            if (!this.isSubdirectory(databasePath, tablePath)) {
                                tablePaths.add(tablePath);
                            }
                        }
                        partitionPaths = this.dropPartitionsAndGetLocations(ms, catName, name, table.getTableName(), tablePath, table.getPartitionKeys(), deleteData && !this.isExternal(table));
                        this.drop_table(MetaStoreUtils.prependCatalogToDbName(table.getCatName(), table.getDbName(), this.conf), table.getTableName(), false);
                    }
                    startIndex = endIndex;
                }
                if (ms.dropDatabase(catName, name)) {
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_DATABASE, new DropDatabaseEvent(db, true, this));
                    }
                    success = ms.commitTransaction();
                }
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                } else if (deleteData) {
                    this.deletePartitionData(partitionPaths, false, db);
                    for (Path tablePath : tablePaths) {
                        this.deleteTableData(tablePath, false, db);
                    }
                    try {
                        this.wh.deleteDir(new Path(db.getLocationUri()), true, db);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to delete database directory: " + db.getLocationUri() + " " + e.getMessage());
                    }
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_DATABASE, new DropDatabaseEvent(db, success, this), null, transactionalListenerResponses, ms);
                }
            }
        }

        private boolean isSubdirectory(Path parent, Path other) {
            return other.toString().startsWith((String)(parent.toString().endsWith("/") ? parent.toString() : parent.toString() + "/"));
        }

        @Override
        public void drop_database(String dbName, boolean deleteData, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException {
            this.startFunction("drop_database", ": " + dbName);
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            if ("hive".equalsIgnoreCase(parsedDbName[0]) && "default".equalsIgnoreCase(parsedDbName[1])) {
                this.endFunction("drop_database", false, null);
                throw new MetaException("Can not drop default database in catalog hive");
            }
            boolean success = false;
            Exception ex = null;
            try {
                this.drop_database_core(this.getMS(), parsedDbName[0], parsedDbName[1], deleteData, cascade);
                success = true;
            }
            catch (InvalidOperationException | MetaException | NoSuchObjectException e) {
                ex = e;
                throw e;
            }
            catch (Exception e) {
                ex = e;
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("drop_database", success, ex);
            }
        }

        @Override
        public List<String> get_databases(String pattern) throws MetaException {
            this.startFunction("get_databases", ": " + pattern);
            String[] parsedDbNamed = MetaStoreUtils.parseDbName(pattern, this.conf);
            List<String> ret = null;
            Exception ex = null;
            try {
                if (parsedDbNamed[1] == null) {
                    ret = this.getMS().getAllDatabases(parsedDbNamed[0]);
                    ret = FilterUtils.filterDbNamesIfEnabled(this.isServerFilterEnabled, this.filterHook, ret);
                } else {
                    ret = this.getMS().getDatabases(parsedDbNamed[0], parsedDbNamed[1]);
                    ret = FilterUtils.filterDbNamesIfEnabled(this.isServerFilterEnabled, this.filterHook, ret);
                }
                this.endFunction("get_databases", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_databases", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> get_all_databases() throws MetaException {
            return this.get_databases(MetaStoreUtils.prependCatalogToDbName(null, null, this.conf));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_type_core(RawStore ms, Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            if (!MetaStoreUtils.validateName(type.getName(), null)) {
                throw new InvalidObjectException("Invalid type name");
            }
            boolean success = false;
            try {
                ms.openTransaction();
                if (this.is_type_exists(ms, type.getName())) {
                    throw new AlreadyExistsException("Type " + type.getName() + " already exists");
                }
                ms.createType(type);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean create_type(Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.startFunction("create_type", ": " + type.toString());
            boolean success = false;
            Exception ex = null;
            try {
                this.create_type_core(this.getMS(), type);
                success = true;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof InvalidObjectException) {
                    throw (InvalidObjectException)e;
                }
                if (e instanceof AlreadyExistsException) {
                    throw (AlreadyExistsException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("create_type", success, ex);
            }
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Type get_type(String name) throws MetaException, NoSuchObjectException {
            this.startFunction("get_type", ": " + name);
            Type ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getType(name);
                if (null == ret) {
                    throw new NoSuchObjectException("Type \"" + name + "\" not found.");
                }
                this.endFunction("get_type", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.throwMetaException(e);
                    this.endFunction("get_type", ret != null, ex);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_type", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        private boolean is_type_exists(RawStore ms, String typeName) throws MetaException {
            return ms.getType(typeName) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop_type(String name) throws MetaException, NoSuchObjectException {
            this.startFunction("drop_type", ": " + name);
            boolean success = false;
            Exception ex = null;
            try {
                success = this.getMS().dropType(name);
            }
            catch (Exception e) {
                ex = e;
                this.throwMetaException(e);
            }
            finally {
                this.endFunction("drop_type", success, ex);
            }
            return success;
        }

        @Override
        public Map<String, Type> get_type_all(String name) throws MetaException {
            this.startFunction("get_type_all", ": " + name);
            this.endFunction("get_type_all", false, null);
            throw new MetaException("Not yet implemented");
        }

        private void create_table_core(RawStore ms, Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, MetaException, InvalidObjectException, NoSuchObjectException {
            this.create_table_core(ms, tbl, envContext, null, null, null, null, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_table_core(RawStore ms, Table tbl, EnvironmentContext envContext, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws AlreadyExistsException, MetaException, InvalidObjectException, NoSuchObjectException {
            boolean success;
            Map<String, String> transactionalListenerResponses;
            block67: {
                if (!MetaStoreUtils.validateName(tbl.getTableName(), this.conf)) {
                    throw new InvalidObjectException(tbl.getTableName() + " is not a valid object name");
                }
                String validate = MetaStoreUtils.validateTblColumns(tbl.getSd().getCols());
                if (validate != null) {
                    throw new InvalidObjectException("Invalid column " + validate);
                }
                if (tbl.getPartitionKeys() != null && (validate = MetaStoreUtils.validateTblColumns(tbl.getPartitionKeys())) != null) {
                    throw new InvalidObjectException("Invalid partition column " + validate);
                }
                SkewedInfo skew = tbl.getSd().getSkewedInfo();
                if (skew != null) {
                    validate = MetaStoreUtils.validateSkewedColNames(skew.getSkewedColNames());
                    if (validate != null) {
                        throw new InvalidObjectException("Invalid skew column " + validate);
                    }
                    validate = MetaStoreUtils.validateSkewedColNamesSubsetCol(skew.getSkewedColNames(), tbl.getSd().getCols());
                    if (validate != null) {
                        throw new InvalidObjectException("Invalid skew column " + validate);
                    }
                }
                transactionalListenerResponses = Collections.emptyMap();
                Path tblPath = null;
                success = false;
                boolean madeDir = false;
                Database db = null;
                try {
                    if (!tbl.isSetCatName()) {
                        tbl.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
                    }
                    this.firePreEvent(new PreCreateTableEvent(tbl, (IHMSHandler)this));
                    ms.openTransaction();
                    db = ms.getDatabase(tbl.getCatName(), tbl.getDbName());
                    if (this.is_table_exists(ms, tbl.getCatName(), tbl.getDbName(), tbl.getTableName())) {
                        throw new AlreadyExistsException("Table " + Warehouse.getCatalogQualifiedTableName(tbl) + " already exists");
                    }
                    if (!TableType.VIRTUAL_VIEW.toString().equals(tbl.getTableType())) {
                        if (tbl.getSd().getLocation() == null || tbl.getSd().getLocation().isEmpty()) {
                            tblPath = this.wh.getDefaultTablePath(db, tbl);
                        } else {
                            if (!this.isExternal(tbl) && !MetaStoreUtils.isNonNativeTable(tbl)) {
                                LOG.warn("Location: " + tbl.getSd().getLocation() + " specified for non-external table:" + tbl.getTableName());
                            }
                            tblPath = this.wh.getDnsPath(new Path(tbl.getSd().getLocation()));
                        }
                        tbl.getSd().setLocation(tblPath.toString());
                    }
                    if (tblPath != null && !this.wh.isDir(tblPath)) {
                        if (!this.wh.mkdirs(tblPath)) {
                            throw new MetaException(tblPath + " is not a directory or unable to create one");
                        }
                        madeDir = true;
                    }
                    if (MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.STATS_AUTO_GATHER) && !MetaStoreUtils.isView(tbl)) {
                        MetaStoreUtils.updateTableStatsSlow(db, tbl, this.wh, madeDir, false, envContext);
                    }
                    long time = System.currentTimeMillis() / 1000L;
                    tbl.setCreateTime((int)time);
                    if (tbl.getParameters() == null || tbl.getParameters().get("transient_lastDdlTime") == null) {
                        tbl.putToParameters("transient_lastDdlTime", Long.toString(time));
                    }
                    if (primaryKeys == null && foreignKeys == null && uniqueConstraints == null && notNullConstraints == null && defaultConstraints == null && checkConstraints == null) {
                        ms.createTable(tbl);
                    } else {
                        int i;
                        if (primaryKeys != null && !primaryKeys.isEmpty() && !primaryKeys.get(0).isSetCatName()) {
                            for (SQLPrimaryKey pkcol : primaryKeys) {
                                pkcol.setCatName(tbl.getCatName());
                            }
                        }
                        if (foreignKeys != null && !foreignKeys.isEmpty() && !foreignKeys.get(0).isSetCatName()) {
                            for (SQLForeignKey fkcol : foreignKeys) {
                                fkcol.setCatName(tbl.getCatName());
                            }
                        }
                        if (uniqueConstraints != null && !uniqueConstraints.isEmpty() && !uniqueConstraints.get(0).isSetCatName()) {
                            for (SQLUniqueConstraint uccol : uniqueConstraints) {
                                uccol.setCatName(tbl.getCatName());
                            }
                        }
                        if (notNullConstraints != null && !notNullConstraints.isEmpty() && !notNullConstraints.get(0).isSetCatName()) {
                            for (SQLNotNullConstraint nncol : notNullConstraints) {
                                nncol.setCatName(tbl.getCatName());
                            }
                        }
                        if (defaultConstraints != null && !defaultConstraints.isEmpty() && !defaultConstraints.get(0).isSetCatName()) {
                            for (SQLDefaultConstraint dccol : defaultConstraints) {
                                dccol.setCatName(tbl.getCatName());
                            }
                        }
                        if (checkConstraints != null && !checkConstraints.isEmpty() && !checkConstraints.get(0).isSetCatName()) {
                            for (SQLCheckConstraint cccol : checkConstraints) {
                                cccol.setCatName(tbl.getCatName());
                            }
                        }
                        List<String> constraintNames = ms.createTableWithConstraints(tbl, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
                        int primaryKeySize = 0;
                        if (primaryKeys != null) {
                            primaryKeySize = primaryKeys.size();
                            for (int i2 = 0; i2 < primaryKeys.size(); ++i2) {
                                if (primaryKeys.get(i2).getPk_name() == null) {
                                    primaryKeys.get(i2).setPk_name(constraintNames.get(i2));
                                }
                                if (primaryKeys.get(i2).isSetCatName()) continue;
                                primaryKeys.get(i2).setCatName(tbl.getCatName());
                            }
                        }
                        int foreignKeySize = 0;
                        if (foreignKeys != null) {
                            foreignKeySize = foreignKeys.size();
                            for (int i3 = 0; i3 < foreignKeySize; ++i3) {
                                if (foreignKeys.get(i3).getFk_name() == null) {
                                    foreignKeys.get(i3).setFk_name(constraintNames.get(primaryKeySize + i3));
                                }
                                if (foreignKeys.get(i3).isSetCatName()) continue;
                                foreignKeys.get(i3).setCatName(tbl.getCatName());
                            }
                        }
                        int uniqueConstraintSize = 0;
                        if (uniqueConstraints != null) {
                            uniqueConstraintSize = uniqueConstraints.size();
                            for (int i4 = 0; i4 < uniqueConstraintSize; ++i4) {
                                if (uniqueConstraints.get(i4).getUk_name() == null) {
                                    uniqueConstraints.get(i4).setUk_name(constraintNames.get(primaryKeySize + foreignKeySize + i4));
                                }
                                if (uniqueConstraints.get(i4).isSetCatName()) continue;
                                uniqueConstraints.get(i4).setCatName(tbl.getCatName());
                            }
                        }
                        int notNullConstraintSize = 0;
                        if (notNullConstraints != null) {
                            for (int i5 = 0; i5 < notNullConstraints.size(); ++i5) {
                                if (notNullConstraints.get(i5).getNn_name() == null) {
                                    notNullConstraints.get(i5).setNn_name(constraintNames.get(primaryKeySize + foreignKeySize + uniqueConstraintSize + i5));
                                }
                                if (notNullConstraints.get(i5).isSetCatName()) continue;
                                notNullConstraints.get(i5).setCatName(tbl.getCatName());
                            }
                        }
                        int defaultConstraintSize = 0;
                        if (defaultConstraints != null) {
                            for (i = 0; i < defaultConstraints.size(); ++i) {
                                if (defaultConstraints.get(i).getDc_name() == null) {
                                    defaultConstraints.get(i).setDc_name(constraintNames.get(primaryKeySize + foreignKeySize + uniqueConstraintSize + notNullConstraintSize + i));
                                }
                                if (defaultConstraints.get(i).isSetCatName()) continue;
                                defaultConstraints.get(i).setCatName(tbl.getCatName());
                            }
                        }
                        if (checkConstraints != null) {
                            for (i = 0; i < checkConstraints.size(); ++i) {
                                if (checkConstraints.get(i).getDc_name() == null) {
                                    checkConstraints.get(i).setDc_name(constraintNames.get(primaryKeySize + foreignKeySize + uniqueConstraintSize + defaultConstraintSize + notNullConstraintSize + i));
                                }
                                if (checkConstraints.get(i).isSetCatName()) continue;
                                checkConstraints.get(i).setCatName(tbl.getCatName());
                            }
                        }
                    }
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.CREATE_TABLE, new CreateTableEvent(tbl, true, this), envContext);
                        if (primaryKeys != null && !primaryKeys.isEmpty()) {
                            MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_PRIMARYKEY, new AddPrimaryKeyEvent(primaryKeys, true, this), envContext);
                        }
                        if (foreignKeys != null && !foreignKeys.isEmpty()) {
                            MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_FOREIGNKEY, new AddForeignKeyEvent(foreignKeys, true, this), envContext);
                        }
                        if (uniqueConstraints != null && !uniqueConstraints.isEmpty()) {
                            MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_UNIQUECONSTRAINT, new AddUniqueConstraintEvent(uniqueConstraints, true, this), envContext);
                        }
                        if (notNullConstraints != null && !notNullConstraints.isEmpty()) {
                            MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_NOTNULLCONSTRAINT, new AddNotNullConstraintEvent(notNullConstraints, true, this), envContext);
                        }
                    }
                    if (success = ms.commitTransaction()) break block67;
                    ms.rollbackTransaction();
                    if (!madeDir) break block67;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                        if (madeDir) {
                            this.wh.deleteDir(tblPath, true, db);
                        }
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_TABLE, new CreateTableEvent(tbl, success, this), envContext, transactionalListenerResponses, ms);
                        if (primaryKeys != null && !primaryKeys.isEmpty()) {
                            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PRIMARYKEY, new AddPrimaryKeyEvent(primaryKeys, success, this), envContext);
                        }
                        if (foreignKeys != null && !foreignKeys.isEmpty()) {
                            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_FOREIGNKEY, new AddForeignKeyEvent(foreignKeys, success, this), envContext);
                        }
                        if (uniqueConstraints != null && !uniqueConstraints.isEmpty()) {
                            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_UNIQUECONSTRAINT, new AddUniqueConstraintEvent(uniqueConstraints, success, this), envContext);
                        }
                        if (notNullConstraints != null && !notNullConstraints.isEmpty()) {
                            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_NOTNULLCONSTRAINT, new AddNotNullConstraintEvent(notNullConstraints, success, this), envContext);
                        }
                    }
                    throw throwable;
                }
                this.wh.deleteDir(tblPath, true, db);
            }
            if (!this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_TABLE, new CreateTableEvent(tbl, success, this), envContext, transactionalListenerResponses, ms);
                if (primaryKeys != null && !primaryKeys.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PRIMARYKEY, new AddPrimaryKeyEvent(primaryKeys, success, this), envContext);
                }
                if (foreignKeys != null && !foreignKeys.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_FOREIGNKEY, new AddForeignKeyEvent(foreignKeys, success, this), envContext);
                }
                if (uniqueConstraints != null && !uniqueConstraints.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_UNIQUECONSTRAINT, new AddUniqueConstraintEvent(uniqueConstraints, success, this), envContext);
                }
                if (notNullConstraints != null && !notNullConstraints.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_NOTNULLCONSTRAINT, new AddNotNullConstraintEvent(notNullConstraints, success, this), envContext);
                }
            }
        }

        @Override
        public void create_table(Table tbl) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.create_table_with_environment_context(tbl, null);
        }

        @Override
        public void create_table_with_environment_context(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.startFunction("create_table", ": " + tbl.toString());
            boolean success = false;
            Exception ex = null;
            try {
                this.create_table_core(this.getMS(), tbl, envContext);
                success = true;
            }
            catch (NoSuchObjectException e) {
                LOG.warn("create_table_with_environment_context got ", (Throwable)e);
                ex = e;
                throw new InvalidObjectException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof InvalidObjectException) {
                    throw (InvalidObjectException)e;
                }
                if (e instanceof AlreadyExistsException) {
                    throw (AlreadyExistsException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("create_table", success, ex, tbl.getTableName());
            }
        }

        @Override
        public void create_table_with_constraints(Table tbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.startFunction("create_table", ": " + tbl.toString());
            boolean success = false;
            Exception ex = null;
            try {
                this.create_table_core(this.getMS(), tbl, null, primaryKeys, foreignKeys, uniqueConstraints, notNullConstraints, defaultConstraints, checkConstraints);
                success = true;
            }
            catch (NoSuchObjectException e) {
                ex = e;
                throw new InvalidObjectException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof InvalidObjectException) {
                    throw (InvalidObjectException)e;
                }
                if (e instanceof AlreadyExistsException) {
                    throw (AlreadyExistsException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("create_table", success, ex, tbl.getTableName());
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void drop_constraint(DropConstraintRequest req) throws MetaException, InvalidObjectException {
            Exception ex;
            boolean success;
            String constraintName;
            block12: {
                Object dropConstraintEvent;
                String catName = req.isSetCatName() ? req.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
                String dbName = req.getDbname();
                String tableName = req.getTablename();
                constraintName = req.getConstraintname();
                this.startFunction("drop_constraint", ": " + constraintName);
                success = false;
                ex = null;
                RawStore ms = this.getMS();
                try {
                    ms.openTransaction();
                    ms.dropConstraint(catName, dbName, tableName, constraintName);
                    if (this.transactionalListeners.size() > 0) {
                        dropConstraintEvent = new DropConstraintEvent(catName, dbName, tableName, constraintName, true, this);
                        for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                            metaStoreEventListener.onDropConstraint((DropConstraintEvent)dropConstraintEvent);
                        }
                    }
                    if (!(success = ms.commitTransaction())) {
                        ms.rollbackTransaction();
                        break block12;
                    }
                    dropConstraintEvent = this.listeners.iterator();
                }
                catch (NoSuchObjectException e) {
                    try {
                        ex = e;
                        throw new InvalidObjectException(e.getMessage());
                        catch (Exception e2) {
                            ex = e2;
                            if (!(e2 instanceof MetaException)) throw HMSHandler.newMetaException(e2);
                            throw (MetaException)e2;
                        }
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            ms.rollbackTransaction();
                        } else {
                            for (MetaStoreEventListener listener : this.listeners) {
                                DropConstraintEvent dropConstraintEvent2 = new DropConstraintEvent(catName, dbName, tableName, constraintName, true, this);
                                listener.onDropConstraint(dropConstraintEvent2);
                            }
                        }
                        this.endFunction("drop_constraint", success, ex, constraintName);
                        throw throwable;
                    }
                }
                while (dropConstraintEvent.hasNext()) {
                    MetaStoreEventListener listener = (MetaStoreEventListener)dropConstraintEvent.next();
                    DropConstraintEvent dropConstraintEvent3 = new DropConstraintEvent(catName, dbName, tableName, constraintName, true, this);
                    listener.onDropConstraint(dropConstraintEvent3);
                }
            }
            this.endFunction("drop_constraint", success, ex, constraintName);
        }

        @Override
        public void add_primary_key(AddPrimaryKeyRequest req) throws MetaException, InvalidObjectException {
            Exception ex;
            boolean success;
            String constraintName;
            block17: {
                List<SQLPrimaryKey> primaryKeyCols = req.getPrimaryKeyCols();
                constraintName = primaryKeyCols != null && primaryKeyCols.size() > 0 ? primaryKeyCols.get(0).getPk_name() : "null";
                this.startFunction("add_primary_key", ": " + constraintName);
                success = false;
                ex = null;
                if (!primaryKeyCols.isEmpty() && !primaryKeyCols.get(0).isSetCatName()) {
                    String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
                    primaryKeyCols.forEach(pk -> pk.setCatName(defaultCat));
                }
                RawStore ms = this.getMS();
                try {
                    ms.openTransaction();
                    List<String> constraintNames = ms.addPrimaryKeys(primaryKeyCols);
                    if (primaryKeyCols != null) {
                        for (int i = 0; i < primaryKeyCols.size(); ++i) {
                            if (primaryKeyCols.get(i).getPk_name() != null) continue;
                            primaryKeyCols.get(i).setPk_name(constraintNames.get(i));
                        }
                    }
                    if (this.transactionalListeners.size() > 0 && primaryKeyCols != null && primaryKeyCols.size() > 0) {
                        AddPrimaryKeyEvent addPrimaryKeyEvent = new AddPrimaryKeyEvent(primaryKeyCols, true, this);
                        for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                            metaStoreEventListener.onAddPrimaryKey(addPrimaryKeyEvent);
                        }
                    }
                    if (!(success = ms.commitTransaction())) {
                        ms.rollbackTransaction();
                        break block17;
                    }
                    if (primaryKeyCols == null || primaryKeyCols.size() <= 0) break block17;
                }
                catch (Exception e) {
                    try {
                        ex = e;
                        if (e instanceof MetaException) {
                            throw (MetaException)e;
                        }
                        if (e instanceof InvalidObjectException) {
                            throw (InvalidObjectException)e;
                        }
                        throw HMSHandler.newMetaException(e);
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            ms.rollbackTransaction();
                        } else if (primaryKeyCols != null && primaryKeyCols.size() > 0) {
                            for (MetaStoreEventListener listener : this.listeners) {
                                AddPrimaryKeyEvent addPrimaryKeyEvent = new AddPrimaryKeyEvent(primaryKeyCols, true, this);
                                listener.onAddPrimaryKey(addPrimaryKeyEvent);
                            }
                        }
                        this.endFunction("add_primary_key", success, ex, constraintName);
                        throw throwable;
                    }
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    AddPrimaryKeyEvent addPrimaryKeyEvent = new AddPrimaryKeyEvent(primaryKeyCols, true, this);
                    listener.onAddPrimaryKey(addPrimaryKeyEvent);
                }
            }
            this.endFunction("add_primary_key", success, ex, constraintName);
        }

        @Override
        public void add_foreign_key(AddForeignKeyRequest req) throws MetaException, InvalidObjectException {
            Exception ex;
            boolean success;
            String constraintName;
            block17: {
                List<SQLForeignKey> foreignKeyCols = req.getForeignKeyCols();
                constraintName = foreignKeyCols != null && foreignKeyCols.size() > 0 ? foreignKeyCols.get(0).getFk_name() : "null";
                this.startFunction("add_foreign_key", ": " + constraintName);
                success = false;
                ex = null;
                if (!foreignKeyCols.isEmpty() && !foreignKeyCols.get(0).isSetCatName()) {
                    String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
                    foreignKeyCols.forEach(pk -> pk.setCatName(defaultCat));
                }
                RawStore ms = this.getMS();
                try {
                    ms.openTransaction();
                    List<String> constraintNames = ms.addForeignKeys(foreignKeyCols);
                    if (foreignKeyCols != null) {
                        for (int i = 0; i < foreignKeyCols.size(); ++i) {
                            if (foreignKeyCols.get(i).getFk_name() != null) continue;
                            foreignKeyCols.get(i).setFk_name(constraintNames.get(i));
                        }
                    }
                    if (this.transactionalListeners.size() > 0 && foreignKeyCols != null && foreignKeyCols.size() > 0) {
                        AddForeignKeyEvent addForeignKeyEvent = new AddForeignKeyEvent(foreignKeyCols, true, this);
                        for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                            metaStoreEventListener.onAddForeignKey(addForeignKeyEvent);
                        }
                    }
                    if (!(success = ms.commitTransaction())) {
                        ms.rollbackTransaction();
                        break block17;
                    }
                    if (foreignKeyCols == null || foreignKeyCols.size() <= 0) break block17;
                }
                catch (Exception e) {
                    try {
                        ex = e;
                        if (e instanceof MetaException) {
                            throw (MetaException)e;
                        }
                        if (e instanceof InvalidObjectException) {
                            throw (InvalidObjectException)e;
                        }
                        throw HMSHandler.newMetaException(e);
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            ms.rollbackTransaction();
                        } else if (foreignKeyCols != null && foreignKeyCols.size() > 0) {
                            for (MetaStoreEventListener listener : this.listeners) {
                                AddForeignKeyEvent addForeignKeyEvent = new AddForeignKeyEvent(foreignKeyCols, true, this);
                                listener.onAddForeignKey(addForeignKeyEvent);
                            }
                        }
                        this.endFunction("add_foreign_key", success, ex, constraintName);
                        throw throwable;
                    }
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    AddForeignKeyEvent addForeignKeyEvent = new AddForeignKeyEvent(foreignKeyCols, true, this);
                    listener.onAddForeignKey(addForeignKeyEvent);
                }
            }
            this.endFunction("add_foreign_key", success, ex, constraintName);
        }

        @Override
        public void add_unique_constraint(AddUniqueConstraintRequest req) throws MetaException, InvalidObjectException {
            Exception ex;
            boolean success;
            String constraintName;
            block17: {
                List<SQLUniqueConstraint> uniqueConstraintCols = req.getUniqueConstraintCols();
                constraintName = uniqueConstraintCols != null && uniqueConstraintCols.size() > 0 ? uniqueConstraintCols.get(0).getUk_name() : "null";
                this.startFunction("add_unique_constraint", ": " + constraintName);
                success = false;
                ex = null;
                if (!uniqueConstraintCols.isEmpty() && !uniqueConstraintCols.get(0).isSetCatName()) {
                    String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
                    uniqueConstraintCols.forEach(pk -> pk.setCatName(defaultCat));
                }
                RawStore ms = this.getMS();
                try {
                    ms.openTransaction();
                    List<String> constraintNames = ms.addUniqueConstraints(uniqueConstraintCols);
                    if (uniqueConstraintCols != null) {
                        for (int i = 0; i < uniqueConstraintCols.size(); ++i) {
                            if (uniqueConstraintCols.get(i).getUk_name() != null) continue;
                            uniqueConstraintCols.get(i).setUk_name(constraintNames.get(i));
                        }
                    }
                    if (this.transactionalListeners.size() > 0 && uniqueConstraintCols != null && uniqueConstraintCols.size() > 0) {
                        AddUniqueConstraintEvent addUniqueConstraintEvent = new AddUniqueConstraintEvent(uniqueConstraintCols, true, this);
                        for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                            metaStoreEventListener.onAddUniqueConstraint(addUniqueConstraintEvent);
                        }
                    }
                    if (!(success = ms.commitTransaction())) {
                        ms.rollbackTransaction();
                        break block17;
                    }
                    if (uniqueConstraintCols == null || uniqueConstraintCols.size() <= 0) break block17;
                }
                catch (Exception e) {
                    try {
                        ex = e;
                        if (e instanceof MetaException) {
                            throw (MetaException)e;
                        }
                        if (e instanceof InvalidObjectException) {
                            throw (InvalidObjectException)e;
                        }
                        throw HMSHandler.newMetaException(e);
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            ms.rollbackTransaction();
                        } else if (uniqueConstraintCols != null && uniqueConstraintCols.size() > 0) {
                            for (MetaStoreEventListener listener : this.listeners) {
                                AddUniqueConstraintEvent addUniqueConstraintEvent = new AddUniqueConstraintEvent(uniqueConstraintCols, true, this);
                                listener.onAddUniqueConstraint(addUniqueConstraintEvent);
                            }
                        }
                        this.endFunction("add_unique_constraint", success, ex, constraintName);
                        throw throwable;
                    }
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    AddUniqueConstraintEvent addUniqueConstraintEvent = new AddUniqueConstraintEvent(uniqueConstraintCols, true, this);
                    listener.onAddUniqueConstraint(addUniqueConstraintEvent);
                }
            }
            this.endFunction("add_unique_constraint", success, ex, constraintName);
        }

        @Override
        public void add_not_null_constraint(AddNotNullConstraintRequest req) throws MetaException, InvalidObjectException {
            Exception ex;
            boolean success;
            String constraintName;
            block17: {
                List<SQLNotNullConstraint> notNullConstraintCols = req.getNotNullConstraintCols();
                constraintName = notNullConstraintCols != null && notNullConstraintCols.size() > 0 ? notNullConstraintCols.get(0).getNn_name() : "null";
                this.startFunction("add_not_null_constraint", ": " + constraintName);
                success = false;
                ex = null;
                if (!notNullConstraintCols.isEmpty() && !notNullConstraintCols.get(0).isSetCatName()) {
                    String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
                    notNullConstraintCols.forEach(pk -> pk.setCatName(defaultCat));
                }
                RawStore ms = this.getMS();
                try {
                    ms.openTransaction();
                    List<String> constraintNames = ms.addNotNullConstraints(notNullConstraintCols);
                    if (notNullConstraintCols != null) {
                        for (int i = 0; i < notNullConstraintCols.size(); ++i) {
                            if (notNullConstraintCols.get(i).getNn_name() != null) continue;
                            notNullConstraintCols.get(i).setNn_name(constraintNames.get(i));
                        }
                    }
                    if (this.transactionalListeners.size() > 0 && notNullConstraintCols != null && notNullConstraintCols.size() > 0) {
                        AddNotNullConstraintEvent addNotNullConstraintEvent = new AddNotNullConstraintEvent(notNullConstraintCols, true, this);
                        for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                            metaStoreEventListener.onAddNotNullConstraint(addNotNullConstraintEvent);
                        }
                    }
                    if (!(success = ms.commitTransaction())) {
                        ms.rollbackTransaction();
                        break block17;
                    }
                    if (notNullConstraintCols == null || notNullConstraintCols.size() <= 0) break block17;
                }
                catch (Exception e) {
                    try {
                        ex = e;
                        if (e instanceof MetaException) {
                            throw (MetaException)e;
                        }
                        if (e instanceof InvalidObjectException) {
                            throw (InvalidObjectException)e;
                        }
                        throw HMSHandler.newMetaException(e);
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            ms.rollbackTransaction();
                        } else if (notNullConstraintCols != null && notNullConstraintCols.size() > 0) {
                            for (MetaStoreEventListener listener : this.listeners) {
                                AddNotNullConstraintEvent addNotNullConstraintEvent = new AddNotNullConstraintEvent(notNullConstraintCols, true, this);
                                listener.onAddNotNullConstraint(addNotNullConstraintEvent);
                            }
                        }
                        this.endFunction("add_not_null_constraint", success, ex, constraintName);
                        throw throwable;
                    }
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    AddNotNullConstraintEvent addNotNullConstraintEvent = new AddNotNullConstraintEvent(notNullConstraintCols, true, this);
                    listener.onAddNotNullConstraint(addNotNullConstraintEvent);
                }
            }
            this.endFunction("add_not_null_constraint", success, ex, constraintName);
        }

        @Override
        public void add_default_constraint(AddDefaultConstraintRequest req) throws MetaException, InvalidObjectException {
            Exception ex;
            boolean success;
            String constraintName;
            block16: {
                List<SQLDefaultConstraint> defaultConstraintCols = req.getDefaultConstraintCols();
                constraintName = defaultConstraintCols != null && defaultConstraintCols.size() > 0 ? defaultConstraintCols.get(0).getDc_name() : "null";
                this.startFunction("add_default_constraint", ": " + constraintName);
                success = false;
                ex = null;
                if (!defaultConstraintCols.isEmpty() && !defaultConstraintCols.get(0).isSetCatName()) {
                    String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
                    defaultConstraintCols.forEach(pk -> pk.setCatName(defaultCat));
                }
                RawStore ms = this.getMS();
                try {
                    ms.openTransaction();
                    List<String> constraintNames = ms.addDefaultConstraints(defaultConstraintCols);
                    if (defaultConstraintCols != null) {
                        for (int i = 0; i < defaultConstraintCols.size(); ++i) {
                            if (defaultConstraintCols.get(i).getDc_name() != null) continue;
                            defaultConstraintCols.get(i).setDc_name(constraintNames.get(i));
                        }
                    }
                    if (this.transactionalListeners.size() <= 0 || defaultConstraintCols == null || defaultConstraintCols.size() > 0) {
                        // empty if block
                    }
                    if (!(success = ms.commitTransaction())) {
                        ms.rollbackTransaction();
                        break block16;
                    }
                    if (defaultConstraintCols == null || defaultConstraintCols.size() <= 0) break block16;
                }
                catch (Exception e) {
                    try {
                        ex = e;
                        if (e instanceof MetaException) {
                            throw (MetaException)e;
                        }
                        if (e instanceof InvalidObjectException) {
                            throw (InvalidObjectException)e;
                        }
                        throw HMSHandler.newMetaException(e);
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            ms.rollbackTransaction();
                        } else if (defaultConstraintCols != null && defaultConstraintCols.size() > 0) {
                            for (MetaStoreEventListener metaStoreEventListener : this.listeners) {
                            }
                        }
                        this.endFunction("add_default_constraint", success, ex, constraintName);
                        throw throwable;
                    }
                }
                for (MetaStoreEventListener metaStoreEventListener : this.listeners) {
                }
            }
            this.endFunction("add_default_constraint", success, ex, constraintName);
        }

        @Override
        public void add_check_constraint(AddCheckConstraintRequest req) throws MetaException, InvalidObjectException {
            Exception ex;
            boolean success;
            String constraintName;
            block16: {
                List<SQLCheckConstraint> checkConstraintCols = req.getCheckConstraintCols();
                constraintName = checkConstraintCols != null && checkConstraintCols.size() > 0 ? checkConstraintCols.get(0).getDc_name() : "null";
                this.startFunction("add_check_constraint", ": " + constraintName);
                success = false;
                ex = null;
                if (!checkConstraintCols.isEmpty() && !checkConstraintCols.get(0).isSetCatName()) {
                    String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
                    checkConstraintCols.forEach(pk -> pk.setCatName(defaultCat));
                }
                RawStore ms = this.getMS();
                try {
                    ms.openTransaction();
                    List<String> constraintNames = ms.addCheckConstraints(checkConstraintCols);
                    if (checkConstraintCols != null) {
                        for (int i = 0; i < checkConstraintCols.size(); ++i) {
                            if (checkConstraintCols.get(i).getDc_name() != null) continue;
                            checkConstraintCols.get(i).setDc_name(constraintNames.get(i));
                        }
                    }
                    if (this.transactionalListeners.size() <= 0 || checkConstraintCols == null || checkConstraintCols.size() > 0) {
                        // empty if block
                    }
                    if (!(success = ms.commitTransaction())) {
                        ms.rollbackTransaction();
                        break block16;
                    }
                    if (checkConstraintCols == null || checkConstraintCols.size() <= 0) break block16;
                }
                catch (Exception e) {
                    try {
                        ex = e;
                        if (e instanceof MetaException) {
                            throw (MetaException)e;
                        }
                        if (e instanceof InvalidObjectException) {
                            throw (InvalidObjectException)e;
                        }
                        throw HMSHandler.newMetaException(e);
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            ms.rollbackTransaction();
                        } else if (checkConstraintCols != null && checkConstraintCols.size() > 0) {
                            for (MetaStoreEventListener metaStoreEventListener : this.listeners) {
                            }
                        }
                        this.endFunction("add_check_constraint", success, ex, constraintName);
                        throw throwable;
                    }
                }
                for (MetaStoreEventListener metaStoreEventListener : this.listeners) {
                }
            }
            this.endFunction("add_check_constraint", success, ex, constraintName);
        }

        private boolean is_table_exists(RawStore ms, String catName, String dbname, String name) throws MetaException {
            return ms.getTable(catName, dbname, name) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean drop_table_core(RawStore ms, String catName, String dbname, String name, boolean deleteData, EnvironmentContext envContext, String indexName) throws NoSuchObjectException, MetaException, IOException, InvalidObjectException, InvalidInputException {
            boolean success = false;
            boolean isExternal = false;
            Path tblPath = null;
            List<Path> partPaths = null;
            Table tbl = null;
            boolean ifPurge = false;
            Map<String, String> transactionalListenerResponses = Collections.emptyMap();
            Database db = null;
            try {
                ms.openTransaction();
                db = ms.getDatabase(catName, dbname);
                tbl = this.get_table_core(catName, dbname, name);
                if (tbl == null) {
                    throw new NoSuchObjectException(name + " doesn't exist");
                }
                if (tbl.getSd() == null) {
                    throw new MetaException("Table metadata is corrupted");
                }
                ifPurge = HMSHandler.isMustPurge(envContext, tbl);
                this.firePreEvent(new PreDropTableEvent(tbl, deleteData, this));
                isExternal = this.isExternal(tbl);
                if (tbl.getSd().getLocation() != null && !this.wh.isWritable((tblPath = new Path(tbl.getSd().getLocation())).getParent())) {
                    String target = indexName == null ? "Table" : "Index table";
                    throw new MetaException(target + " metadata not deleted since " + tblPath.getParent() + " is not writable by " + SecurityUtils.getUser());
                }
                partPaths = this.dropPartitionsAndGetLocations(ms, catName, dbname, name, tblPath, tbl.getPartitionKeys(), deleteData && !isExternal);
                ms.dropConstraint(catName, dbname, name, null, true);
                if (!ms.dropTable(catName, dbname, name)) {
                    String tableName = Warehouse.getCatalogQualifiedTableName(catName, dbname, name);
                    throw new MetaException(indexName == null ? "Unable to drop table " + tableName : "Unable to drop index table " + tableName + " for index " + indexName);
                }
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_TABLE, new DropTableEvent(tbl, true, deleteData, this), envContext);
                }
                if (!(success = ms.commitTransaction())) {
                    ms.rollbackTransaction();
                } else if (deleteData && !isExternal) {
                    this.deletePartitionData(partPaths, ifPurge, db);
                    this.deleteTableData(tblPath, ifPurge, db);
                }
                if (this.listeners.isEmpty()) return success;
            }
            catch (Throwable throwable) {
                if (!success) {
                    ms.rollbackTransaction();
                } else if (deleteData && !isExternal) {
                    this.deletePartitionData(partPaths, ifPurge, db);
                    this.deleteTableData(tblPath, ifPurge, db);
                }
                if (this.listeners.isEmpty()) throw throwable;
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_TABLE, new DropTableEvent(tbl, success, deleteData, this), envContext, transactionalListenerResponses, ms);
                throw throwable;
            }
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_TABLE, new DropTableEvent(tbl, success, deleteData, this), envContext, transactionalListenerResponses, ms);
            return success;
        }

        private void deleteTableData(Path tablePath, boolean ifPurge, Database db) {
            if (tablePath != null) {
                try {
                    this.wh.deleteDir(tablePath, true, ifPurge, db);
                }
                catch (Exception e) {
                    LOG.error("Failed to delete table directory: " + tablePath + " " + e.getMessage());
                }
            }
        }

        private void deletePartitionData(List<Path> partPaths, boolean ifPurge, Database db) {
            if (partPaths != null && !partPaths.isEmpty()) {
                for (Path partPath : partPaths) {
                    try {
                        this.wh.deleteDir(partPath, true, ifPurge, db);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to delete partition directory: " + partPath + " " + e.getMessage());
                    }
                }
            }
        }

        private List<Path> dropPartitionsAndGetLocations(RawStore ms, String catName, String dbName, String tableName, Path tablePath, List<FieldSchema> partitionKeys, boolean checkLocation) throws MetaException, IOException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
            List<Partition> partsToDelete;
            int partitionBatchSize = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
            Path tableDnsPath = null;
            if (tablePath != null) {
                tableDnsPath = this.wh.getDnsPath(tablePath);
            }
            ArrayList<Path> partPaths = new ArrayList<Path>();
            Table tbl = ms.getTable(catName, dbName, tableName);
            while ((partsToDelete = ms.getPartitions(catName, dbName, tableName, partitionBatchSize)) != null && !partsToDelete.isEmpty()) {
                ArrayList<String> partNames = new ArrayList<String>();
                for (Partition part : partsToDelete) {
                    if (checkLocation && part.getSd() != null && part.getSd().getLocation() != null) {
                        Path partPath = this.wh.getDnsPath(new Path(part.getSd().getLocation()));
                        if (tableDnsPath == null || partPath != null && !this.isSubdirectory(tableDnsPath, partPath)) {
                            if (!this.wh.isWritable(partPath.getParent())) {
                                throw new MetaException("Table metadata not deleted since the partition " + Warehouse.makePartName(partitionKeys, part.getValues()) + " has parent location " + partPath.getParent() + " which is not writable by " + SecurityUtils.getUser());
                            }
                            partPaths.add(partPath);
                        }
                    }
                    partNames.add(Warehouse.makePartName(tbl.getPartitionKeys(), part.getValues()));
                }
                for (MetaStoreEventListener listener : this.listeners) {
                    if (!(listener instanceof HMSMetricsListener)) continue;
                    for (Partition part : partsToDelete) {
                        listener.onDropPartition(null);
                    }
                }
                ms.dropPartitions(catName, dbName, tableName, partNames);
            }
            return partPaths;
        }

        @Override
        public void drop_table(String dbname, String name, boolean deleteData) throws NoSuchObjectException, MetaException {
            this.drop_table_with_environment_context(dbname, name, deleteData, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop_table_with_environment_context(String dbname, String name, boolean deleteData, EnvironmentContext envContext) throws NoSuchObjectException, MetaException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbname, this.conf);
            this.startTableFunction("drop_table", parsedDbName[0], parsedDbName[1], name);
            boolean success = false;
            Exception ex = null;
            try {
                success = this.drop_table_core(this.getMS(), parsedDbName[0], parsedDbName[1], name, deleteData, envContext, null);
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                this.throwMetaException(e);
            }
            finally {
                this.endFunction("drop_table", success, ex, name);
            }
        }

        private void updateStatsForTruncate(Map<String, String> props, EnvironmentContext environmentContext) {
            if (null == props) {
                return;
            }
            for (String stat : StatsSetupConst.supportedStats) {
                String statVal = props.get(stat);
                if (statVal == null) continue;
                props.put(stat, "0");
            }
            StatsSetupConst.setBasicStatsState(props, "true");
            environmentContext.putToProperties("STATS_GENERATED", "TASK");
            StatsSetupConst.clearColumnStatsState(props);
        }

        private void alterPartitionForTruncate(RawStore ms, String catName, String dbName, String tableName, Table table, Partition partition) throws Exception {
            EnvironmentContext environmentContext = new EnvironmentContext();
            this.updateStatsForTruncate(partition.getParameters(), environmentContext);
            if (!this.transactionalListeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(partition, partition, table, true, true, this));
            }
            if (!this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(partition, partition, table, true, true, this));
            }
            this.alterHandler.alterPartition(ms, this.wh, catName, dbName, tableName, null, partition, environmentContext, this);
        }

        private void alterTableStatsForTruncate(RawStore ms, String catName, String dbName, String tableName, Table table, List<String> partNames) throws Exception {
            if (partNames == null) {
                if (0 != table.getPartitionKeysSize()) {
                    for (Partition partition : ms.getPartitions(catName, dbName, tableName, Integer.MAX_VALUE)) {
                        this.alterPartitionForTruncate(ms, catName, dbName, tableName, table, partition);
                    }
                } else {
                    EnvironmentContext environmentContext = new EnvironmentContext();
                    this.updateStatsForTruncate(table.getParameters(), environmentContext);
                    if (!this.transactionalListeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_TABLE, new AlterTableEvent(table, table, true, true, this));
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_TABLE, new AlterTableEvent(table, table, true, true, this));
                    }
                    this.alterHandler.alterTable(ms, this.wh, catName, dbName, tableName, table, environmentContext, this);
                }
            } else {
                for (Partition partition : ms.getPartitionsByNames(catName, dbName, tableName, partNames)) {
                    this.alterPartitionForTruncate(ms, catName, dbName, tableName, table, partition);
                }
            }
        }

        private List<Path> getLocationsForTruncate(RawStore ms, String catName, String dbName, String tableName, Table table, List<String> partNames) throws Exception {
            ArrayList<Path> locations = new ArrayList<Path>();
            if (partNames == null) {
                if (0 != table.getPartitionKeysSize()) {
                    for (Partition partition : ms.getPartitions(catName, dbName, tableName, Integer.MAX_VALUE)) {
                        locations.add(new Path(partition.getSd().getLocation()));
                    }
                } else {
                    locations.add(new Path(table.getSd().getLocation()));
                }
            } else {
                for (Partition partition : ms.getPartitionsByNames(catName, dbName, tableName, partNames)) {
                    locations.add(new Path(partition.getSd().getLocation()));
                }
            }
            return locations;
        }

        @Override
        public CmRecycleResponse cm_recycle(CmRecycleRequest request) throws MetaException {
            this.wh.recycleDirToCmPath(new Path(request.getDataPath()), request.isPurge());
            return new CmRecycleResponse();
        }

        @Override
        public void truncate_table(String dbName, String tableName, List<String> partNames) throws NoSuchObjectException, MetaException {
            try {
                String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
                Table tbl = this.get_table_core(parsedDbName[0], parsedDbName[1], tableName);
                boolean isAutopurge = tbl.isSetParameters() && "true".equalsIgnoreCase(tbl.getParameters().get("auto.purge"));
                Database db = this.get_database_core(parsedDbName[0], parsedDbName[1]);
                for (Path location : this.getLocationsForTruncate(this.getMS(), parsedDbName[0], parsedDbName[1], tableName, tbl, partNames)) {
                    FileSystem fs = location.getFileSystem(this.getConf());
                    if (!HdfsUtils.isPathEncrypted(this.getConf(), fs.getUri(), location) && !FileUtils.pathHasSnapshotSubDir(location, fs)) {
                        HdfsUtils.HadoopFileStatus status = new HdfsUtils.HadoopFileStatus(this.getConf(), fs, location);
                        FileStatus targetStatus = fs.getFileStatus(location);
                        String targetGroup = targetStatus == null ? null : targetStatus.getGroup();
                        this.wh.deleteDir(location, true, isAutopurge, db);
                        fs.mkdirs(location);
                        HdfsUtils.setFullFileStatus(this.getConf(), status, targetGroup, fs, location, false);
                        continue;
                    }
                    FileStatus[] statuses = fs.listStatus(location, FileUtils.HIDDEN_FILES_PATH_FILTER);
                    if (statuses == null || statuses.length == 0) continue;
                    for (FileStatus status : statuses) {
                        this.wh.deleteDir(status.getPath(), true, isAutopurge, db);
                    }
                }
                this.alterTableStatsForTruncate(this.getMS(), parsedDbName[0], parsedDbName[1], tableName, tbl, partNames);
            }
            catch (IOException e) {
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof NoSuchObjectException) {
                    throw (NoSuchObjectException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
        }

        private boolean isExternal(Table table) {
            return MetaStoreUtils.isExternalTable(table);
        }

        @Override
        @Deprecated
        public Table get_table(String dbname, String name) throws MetaException, NoSuchObjectException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbname, this.conf);
            return this.getTableInternal(parsedDbName[0], parsedDbName[1], name, null);
        }

        @Override
        public GetTableResult get_table_req(GetTableRequest req) throws MetaException, NoSuchObjectException {
            String catName = req.isSetCatName() ? req.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            return new GetTableResult(this.getTableInternal(catName, req.getDbName(), req.getTblName(), req.getCapabilities()));
        }

        private Table getTableInternal(String catName, String dbname, String name, ClientCapabilities capabilities) throws MetaException, NoSuchObjectException {
            if (this.isInTest) {
                this.assertClientHasCapability(capabilities, ClientCapability.TEST_CAPABILITY, "Hive tests", "get_table_req");
            }
            Table t = null;
            this.startTableFunction("get_table", catName, dbname, name);
            TException ex = null;
            try {
                t = this.get_table_core(catName, dbname, name);
                if (MetaStoreUtils.isInsertOnlyTableParam(t.getParameters())) {
                    this.assertClientHasCapability(capabilities, ClientCapability.INSERT_ONLY_TABLES, "insert-only tables", "get_table_req");
                }
                this.firePreEvent(new PreReadTableEvent(t, (IHMSHandler)this));
                this.endFunction("get_table", t != null, ex, name);
            }
            catch (MetaException | NoSuchObjectException e) {
                try {
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_table", t != null, ex, name);
                    throw throwable;
                }
            }
            return t;
        }

        @Override
        public List<TableMeta> get_table_meta(String dbnames, String tblNames, List<String> tblTypes) throws MetaException, NoSuchObjectException {
            List<TableMeta> t = null;
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbnames, this.conf);
            this.startTableFunction("get_table_metas", parsedDbName[0], parsedDbName[1], tblNames);
            Exception ex = null;
            try {
                t = this.getMS().getTableMeta(parsedDbName[0], parsedDbName[1], tblNames, tblTypes);
                t = FilterUtils.filterTableMetasIfEnabled(this.isServerFilterEnabled, this.filterHook, parsedDbName[0], parsedDbName[1], t);
                this.endFunction("get_table_metas", t != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_table_metas", t != null, ex);
                    throw throwable;
                }
            }
            return t;
        }

        @Override
        public Table get_table_core(String catName, String dbname, String name) throws MetaException, NoSuchObjectException {
            Table t = null;
            try {
                t = this.getMS().getTable(catName, dbname, name);
                if (t == null) {
                    throw new NoSuchObjectException(Warehouse.getCatalogQualifiedTableName(catName, dbname, name) + " table not found");
                }
            }
            catch (Exception e) {
                this.throwMetaException(e);
            }
            return t;
        }

        @Override
        @Deprecated
        public List<Table> get_table_objects_by_name(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            return this.getTableObjectsInternal(parsedDbName[0], parsedDbName[1], tableNames, null);
        }

        @Override
        public GetTablesResult get_table_objects_by_name_req(GetTablesRequest req) throws TException {
            String catName = req.isSetCatName() ? req.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            return new GetTablesResult(this.getTableObjectsInternal(catName, req.getDbName(), req.getTblNames(), req.getCapabilities()));
        }

        private List<Table> getTableObjectsInternal(String catName, String dbName, List<String> tableNames, ClientCapabilities capabilities) throws MetaException, InvalidOperationException, UnknownDBException {
            if (this.isInTest) {
                this.assertClientHasCapability(capabilities, ClientCapability.TEST_CAPABILITY, "Hive tests", "get_table_objects_by_name_req");
            }
            ArrayList<Table> tables = new ArrayList<Table>();
            this.startMultiTableFunction("get_multi_table", dbName, tableNames);
            Exception ex = null;
            int tableBatchSize = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
            try {
                if (dbName == null || dbName.isEmpty()) {
                    throw new UnknownDBException("DB name is null or empty");
                }
                if (tableNames == null) {
                    throw new InvalidOperationException(dbName + " cannot find null tables");
                }
                List<String> distinctTableNames = tableNames;
                if (distinctTableNames.size() > tableBatchSize) {
                    ArrayList<String> lowercaseTableNames = new ArrayList<String>();
                    for (String tableName : tableNames) {
                        lowercaseTableNames.add(StringUtils.normalizeIdentifier(tableName));
                    }
                    distinctTableNames = new ArrayList<String>(new HashSet(lowercaseTableNames));
                }
                RawStore ms = this.getMS();
                int startIndex = 0;
                while (startIndex < distinctTableNames.size()) {
                    int endIndex = Math.min(startIndex + tableBatchSize, distinctTableNames.size());
                    tables.addAll(ms.getTableObjectsByName(catName, dbName, distinctTableNames.subList(startIndex, endIndex)));
                    startIndex = endIndex;
                }
                for (Table t : tables) {
                    if (!MetaStoreUtils.isInsertOnlyTableParam(t.getParameters())) continue;
                    this.assertClientHasCapability(capabilities, ClientCapability.INSERT_ONLY_TABLES, "insert-only tables", "get_table_req");
                }
                FilterUtils.filterTablesIfEnabled(this.isServerFilterEnabled, this.filterHook, tables);
                this.endFunction("get_multi_table", tables != null, ex, hive.org.apache.commons.lang.StringUtils.join(tableNames, ","));
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof InvalidOperationException) {
                        throw (InvalidOperationException)e;
                    }
                    if (e instanceof UnknownDBException) {
                        throw (UnknownDBException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_multi_table", tables != null, ex, hive.org.apache.commons.lang.StringUtils.join(tableNames, ","));
                    throw throwable;
                }
            }
            return tables;
        }

        @Override
        public Materialization get_materialization_invalidation_info(CreationMetadata cm, String validTxnList) throws MetaException {
            return this.getTxnHandler().getMaterializationInvalidationInfo(cm, validTxnList);
        }

        @Override
        public void update_creation_metadata(String catName, String dbName, String tableName, CreationMetadata cm) throws MetaException {
            this.getMS().updateCreationMetadata(catName, dbName, tableName, cm);
        }

        private void assertClientHasCapability(ClientCapabilities client, ClientCapability value, String what, String call) throws MetaException {
            if (!this.doesClientHaveCapability(client, value)) {
                throw new MetaException("Your client does not appear to support " + what + ". To skip capability checks, please set " + MetastoreConf.ConfVars.CAPABILITY_CHECK.toString() + " to false. This setting can be set globally, or on the client for the current metastore session. Note that this may lead to incorrect results, data loss, undefined behavior, etc. if your client is actually incompatible. You can also specify custom client capabilities via " + call + " API.");
            }
        }

        private boolean doesClientHaveCapability(ClientCapabilities client, ClientCapability value) {
            if (!MetastoreConf.getBoolVar(this.getConf(), MetastoreConf.ConfVars.CAPABILITY_CHECK)) {
                return true;
            }
            return client != null && client.isSetValues() && client.getValues().contains(value);
        }

        @Override
        public List<String> get_table_names_by_filter(String dbName, String filter, short maxTables) throws MetaException, InvalidOperationException, UnknownDBException {
            List<String> tables = null;
            this.startFunction("get_table_names_by_filter", ": db = " + dbName + ", filter = " + filter);
            Exception ex = null;
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            try {
                if (parsedDbName[0] == null || parsedDbName[0].isEmpty() || parsedDbName[1] == null || parsedDbName[1].isEmpty()) {
                    throw new UnknownDBException("DB name is null or empty");
                }
                if (filter == null) {
                    throw new InvalidOperationException(filter + " cannot apply null filter");
                }
                tables = this.getMS().listTableNamesByFilter(parsedDbName[0], parsedDbName[1], filter, maxTables);
                this.endFunction("get_table_names_by_filter", (tables = FilterUtils.filterTableNamesIfEnabled(this.isServerFilterEnabled, this.filterHook, parsedDbName[0], parsedDbName[1], tables)) != null, ex, hive.org.apache.commons.lang.StringUtils.join(tables, ","));
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof InvalidOperationException) {
                        throw (InvalidOperationException)e;
                    }
                    if (e instanceof UnknownDBException) {
                        throw (UnknownDBException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_table_names_by_filter", tables != null, ex, hive.org.apache.commons.lang.StringUtils.join(tables, ","));
                    throw throwable;
                }
            }
            return tables;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Partition append_partition_common(RawStore ms, String catName, String dbName, String tableName, List<String> part_vals, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException, NoSuchObjectException {
            Map<String, String> transactionalListenerResponses;
            Table tbl;
            boolean success;
            Partition part;
            block16: {
                part = new Partition();
                success = false;
                boolean madeDir = false;
                Path partLocation = null;
                tbl = null;
                transactionalListenerResponses = Collections.emptyMap();
                Database db = null;
                try {
                    Partition old_part;
                    ms.openTransaction();
                    part.setCatName(catName);
                    part.setDbName(dbName);
                    part.setTableName(tableName);
                    part.setValues(part_vals);
                    MetaStoreUtils.validatePartitionNameCharacters(part_vals, this.partitionValidationPattern);
                    tbl = ms.getTable(part.getCatName(), part.getDbName(), part.getTableName());
                    if (tbl == null) {
                        throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                    }
                    if (tbl.getSd().getLocation() == null) {
                        throw new MetaException("Cannot append a partition to a view");
                    }
                    db = this.get_database_core(catName, dbName);
                    this.firePreEvent(new PreAddPartitionEvent(tbl, part, (IHMSHandler)this));
                    part.setSd(tbl.getSd().deepCopy());
                    partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part_vals));
                    part.getSd().setLocation(partLocation.toString());
                    try {
                        old_part = ms.getPartition(part.getCatName(), part.getDbName(), part.getTableName(), part.getValues());
                    }
                    catch (NoSuchObjectException e) {
                        old_part = null;
                    }
                    if (old_part != null) {
                        throw new AlreadyExistsException("Partition already exists:" + part);
                    }
                    if (!this.wh.isDir(partLocation)) {
                        if (!this.wh.mkdirs(partLocation)) {
                            throw new MetaException(partLocation + " is not a directory or unable to create one");
                        }
                        madeDir = true;
                    }
                    long time = System.currentTimeMillis() / 1000L;
                    part.setCreateTime((int)time);
                    part.putToParameters("transient_lastDdlTime", Long.toString(time));
                    if (MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.STATS_AUTO_GATHER) && !MetaStoreUtils.isView(tbl)) {
                        MetaStoreUtils.updatePartitionStatsFast(part, tbl, this.wh, madeDir, false, envContext, true);
                    }
                    if (ms.addPartition(part)) {
                        if (!this.transactionalListeners.isEmpty()) {
                            transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, part, true, (IHMSHandler)this), envContext);
                        }
                        success = ms.commitTransaction();
                    }
                    if (success) break block16;
                    ms.rollbackTransaction();
                    if (!madeDir) break block16;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                        if (madeDir) {
                            this.wh.deleteDir(partLocation, true, db);
                        }
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, part, success, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
                    }
                    throw throwable;
                }
                this.wh.deleteDir(partLocation, true, db);
            }
            if (!this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, part, success, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
            }
            return part;
        }

        private void firePreEvent(PreEventContext event) throws MetaException {
            for (MetaStorePreEventListener listener : this.preListeners) {
                try {
                    listener.onEvent(event);
                }
                catch (NoSuchObjectException e) {
                    throw new MetaException(e.getMessage());
                }
                catch (InvalidOperationException e) {
                    throw new MetaException(e.getMessage());
                }
            }
        }

        @Override
        public Partition append_partition(String dbName, String tableName, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException {
            return this.append_partition_with_environment_context(dbName, tableName, part_vals, null);
        }

        @Override
        public Partition append_partition_with_environment_context(String dbName, String tableName, List<String> part_vals, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException {
            if (part_vals == null || part_vals.isEmpty()) {
                throw new MetaException("The partition values must not be null or empty.");
            }
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            this.startPartitionFunction("append_partition", parsedDbName[0], parsedDbName[1], tableName, part_vals);
            if (LOG.isDebugEnabled()) {
                for (String part : part_vals) {
                    LOG.debug(part);
                }
            }
            Partition ret = null;
            Exception ex = null;
            try {
                ret = this.append_partition_common(this.getMS(), parsedDbName[0], parsedDbName[1], tableName, part_vals, envContext);
                this.endFunction("append_partition", ret != null, ex, tableName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)e;
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("append_partition", ret != null, ex, tableName);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Partition> add_partitions_core(RawStore ms, String catName, String dbName, String tblName, List<Partition> parts, boolean ifNotExists) throws TException {
            ArrayList<Partition> newParts;
            block25: {
                Map<String, String> transactionalListenerResponses;
                Table tbl;
                ArrayList<Partition> existingParts;
                block24: {
                    HMSHandler.logInfo("add_partitions");
                    boolean success = false;
                    final ConcurrentHashMap addedPartitions = new ConcurrentHashMap();
                    newParts = new ArrayList<Partition>();
                    existingParts = new ArrayList<Partition>();
                    tbl = null;
                    transactionalListenerResponses = Collections.emptyMap();
                    Database db = null;
                    try {
                        ms.openTransaction();
                        tbl = ms.getTable(catName, dbName, tblName);
                        if (tbl == null) {
                            throw new InvalidObjectException("Unable to add partitions because " + Warehouse.getCatalogQualifiedTableName(catName, dbName, tblName) + " does not exist");
                        }
                        db = ms.getDatabase(catName, dbName);
                        if (!parts.isEmpty()) {
                            this.firePreEvent(new PreAddPartitionEvent(tbl, parts, (IHMSHandler)this));
                        }
                        ArrayList<Future<Partition>> partFutures = Lists.newArrayList();
                        final Table table = tbl;
                        for (final Partition partition : parts) {
                            UserGroupInformation ugi;
                            if (!partition.getTableName().equals(tblName) || !partition.getDbName().equals(dbName)) {
                                throw new MetaException("Partition does not belong to target table " + Warehouse.getCatalogQualifiedTableName(catName, dbName, tblName) + ": " + partition);
                            }
                            boolean bl = this.startAddPartition(ms, partition, ifNotExists);
                            if (!bl) {
                                existingParts.add(partition);
                                LOG.info("Not adding partition " + partition + " as it already exists");
                                continue;
                            }
                            try {
                                ugi = UserGroupInformation.getCurrentUser();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            partFutures.add(threadPool.submit(new Callable<Partition>(){

                                @Override
                                public Partition call() throws Exception {
                                    ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                        @Override
                                        public Object run() throws Exception {
                                            try {
                                                boolean madeDir = this.createLocationForAddedPartition(table, partition);
                                                if (addedPartitions.put(new PartValEqWrapper(partition), madeDir) != null) {
                                                    throw new MetaException("Duplicate partitions in the list: " + partition);
                                                }
                                                this.initializeAddedPartition(table, partition, madeDir);
                                            }
                                            catch (MetaException e) {
                                                throw new IOException(e.getMessage(), e);
                                            }
                                            return null;
                                        }
                                    });
                                    return partition;
                                }
                            }));
                        }
                        try {
                            for (Future future : partFutures) {
                                Partition partition = (Partition)future.get();
                                if (partition == null) continue;
                                newParts.add(partition);
                            }
                        }
                        catch (InterruptedException | ExecutionException e) {
                            for (Future future : partFutures) {
                                future.cancel(true);
                            }
                            throw new MetaException(e.getMessage());
                        }
                        success = !newParts.isEmpty() ? ms.addPartitions(catName, dbName, tblName, newParts) : true;
                        success = false;
                        if (!this.transactionalListeners.isEmpty()) {
                            transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, newParts, true, (IHMSHandler)this));
                        }
                        if (success = ms.commitTransaction()) break block24;
                        ms.rollbackTransaction();
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            ms.rollbackTransaction();
                            for (Map.Entry e : addedPartitions.entrySet()) {
                                if (!((Boolean)e.getValue()).booleanValue()) continue;
                                this.wh.deleteDir(new Path(((PartValEqWrapper)e.getKey()).partition.getSd().getLocation()), true, db);
                            }
                            if (!this.listeners.isEmpty()) {
                                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, parts, false, (IHMSHandler)this), null, null, ms);
                            }
                        } else if (!this.listeners.isEmpty()) {
                            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, newParts, true, (IHMSHandler)this), null, transactionalListenerResponses, ms);
                            if (!existingParts.isEmpty()) {
                                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, existingParts, false, (IHMSHandler)this), null, null, ms);
                            }
                        }
                        throw throwable;
                    }
                    for (Map.Entry e : addedPartitions.entrySet()) {
                        if (!((Boolean)e.getValue()).booleanValue()) continue;
                        this.wh.deleteDir(new Path(((PartValEqWrapper)e.getKey()).partition.getSd().getLocation()), true, db);
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, parts, false, (IHMSHandler)this), null, null, ms);
                    }
                    break block25;
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, newParts, true, (IHMSHandler)this), null, transactionalListenerResponses, ms);
                    if (!existingParts.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, existingParts, false, (IHMSHandler)this), null, null, ms);
                    }
                }
            }
            return newParts;
        }

        @Override
        public AddPartitionsResult add_partitions_req(AddPartitionsRequest request) throws TException {
            AddPartitionsResult result = new AddPartitionsResult();
            if (request.getParts().isEmpty()) {
                return result;
            }
            try {
                if (!request.isSetCatName()) {
                    request.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
                }
                request.getParts().forEach(p -> {
                    if (!p.isSetCatName()) {
                        p.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
                    }
                });
                List<Partition> parts = this.add_partitions_core(this.getMS(), request.getCatName(), request.getDbName(), request.getTblName(), request.getParts(), request.isIfNotExists());
                if (request.isNeedResult()) {
                    result.setPartitions(parts);
                }
            }
            catch (TException te) {
                throw te;
            }
            catch (Exception e) {
                throw HMSHandler.newMetaException(e);
            }
            return result;
        }

        @Override
        public int add_partitions(List<Partition> parts) throws MetaException, InvalidObjectException, AlreadyExistsException {
            this.startFunction("add_partition");
            if (parts.size() == 0) {
                return 0;
            }
            Integer ret = null;
            Exception ex = null;
            try {
                if (!parts.get(0).isSetCatName()) {
                    String defaultCat = MetaStoreUtils.getDefaultCatalog(this.conf);
                    for (Partition p : parts) {
                        p.setCatName(defaultCat);
                    }
                }
                ret = this.add_partitions_core(this.getMS(), parts.get(0).getCatName(), parts.get(0).getDbName(), parts.get(0).getTableName(), parts, false).size();
                assert (ret.intValue() == parts.size());
                String tableName = parts.get(0).getTableName();
                this.endFunction("add_partition", ret != null, ex, tableName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)e;
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    String tableName = parts.get(0).getTableName();
                    this.endFunction("add_partition", ret != null, ex, tableName);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public int add_partitions_pspec(List<PartitionSpec> partSpecs) throws TException {
            String catName;
            HMSHandler.logInfo("add_partitions_pspec");
            if (partSpecs.isEmpty()) {
                return 0;
            }
            String dbName = partSpecs.get(0).getDbName();
            String tableName = partSpecs.get(0).getTableName();
            if (!partSpecs.get(0).isSetCatName()) {
                catName = MetaStoreUtils.getDefaultCatalog(this.conf);
                partSpecs.forEach(ps -> ps.setCatName(catName));
            } else {
                catName = partSpecs.get(0).getCatName();
            }
            return this.add_partitions_pspec_core(this.getMS(), catName, dbName, tableName, partSpecs, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int add_partitions_pspec_core(RawStore ms, String catName, String dbName, String tblName, List<PartitionSpec> partSpecs, boolean ifNotExists) throws TException {
            int n;
            Map<String, String> transactionalListenerResponses;
            Table tbl;
            PartitionSpecProxy partitionSpecProxy;
            block18: {
                boolean success = false;
                final ConcurrentHashMap addedPartitions = new ConcurrentHashMap();
                partitionSpecProxy = PartitionSpecProxy.Factory.get(partSpecs);
                PartitionSpecProxy.PartitionIterator partitionIterator = partitionSpecProxy.getPartitionIterator();
                tbl = null;
                transactionalListenerResponses = Collections.emptyMap();
                Database db = null;
                try {
                    ms.openTransaction();
                    tbl = ms.getTable(catName, dbName, tblName);
                    if (tbl == null) {
                        throw new InvalidObjectException("Unable to add partitions because database or table " + dbName + "." + tblName + " does not exist");
                    }
                    db = ms.getDatabase(catName, dbName);
                    this.firePreEvent(new PreAddPartitionEvent(tbl, partitionSpecProxy, (IHMSHandler)this));
                    ArrayList<Future<Partition>> partFutures = Lists.newArrayList();
                    final Table table = tbl;
                    while (partitionIterator.hasNext()) {
                        UserGroupInformation userGroupInformation;
                        final Partition part = partitionIterator.getCurrent();
                        if (!part.getTableName().equalsIgnoreCase(tblName) || !part.getDbName().equalsIgnoreCase(dbName)) {
                            throw new MetaException("Partition does not belong to target table " + dbName + "." + tblName + ": " + (Partition)part);
                        }
                        boolean bl = this.startAddPartition(ms, part, ifNotExists);
                        if (!bl) {
                            LOG.info("Not adding partition " + (Partition)part + " as it already exists");
                            continue;
                        }
                        try {
                            userGroupInformation = UserGroupInformation.getCurrentUser();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        partFutures.add(threadPool.submit(new Callable<Partition>(){

                            @Override
                            public Partition call() throws Exception {
                                userGroupInformation.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Partition>(){

                                    @Override
                                    public Partition run() throws Exception {
                                        try {
                                            boolean madeDir = this.createLocationForAddedPartition(table, part);
                                            if (addedPartitions.put(new PartValEqWrapperLite(part), madeDir) != null) {
                                                throw new MetaException("Duplicate partitions in the list: " + part);
                                            }
                                            this.initializeAddedPartition(table, part, madeDir);
                                        }
                                        catch (MetaException e) {
                                            throw new IOException(e.getMessage(), e);
                                        }
                                        return null;
                                    }
                                });
                                return part;
                            }
                        }));
                        partitionIterator.next();
                    }
                    try {
                        for (Future future : partFutures) {
                            future.get();
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        for (Future future : partFutures) {
                            future.cancel(true);
                        }
                        throw new MetaException(e.getMessage());
                    }
                    success = ms.addPartitions(catName, dbName, tblName, partitionSpecProxy, ifNotExists);
                    success = false;
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, partitionSpecProxy, true, (IHMSHandler)this));
                    }
                    success = ms.commitTransaction();
                    n = addedPartitions.size();
                    if (success) break block18;
                    ms.rollbackTransaction();
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                        for (Map.Entry e : addedPartitions.entrySet()) {
                            if (!((Boolean)e.getValue()).booleanValue()) continue;
                            this.wh.deleteDir(new Path(((PartValEqWrapperLite)e.getKey()).location), true, db);
                        }
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, partitionSpecProxy, true, (IHMSHandler)this), null, transactionalListenerResponses, ms);
                    }
                    throw throwable;
                }
                for (Map.Entry entry : addedPartitions.entrySet()) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    this.wh.deleteDir(new Path(((PartValEqWrapperLite)entry.getKey()).location), true, db);
                }
            }
            if (!this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, partitionSpecProxy, true, (IHMSHandler)this), null, transactionalListenerResponses, ms);
            }
            return n;
        }

        private boolean startAddPartition(RawStore ms, Partition part, boolean ifNotExists) throws TException {
            MetaStoreUtils.validatePartitionNameCharacters(part.getValues(), this.partitionValidationPattern);
            boolean doesExist = ms.doesPartitionExist(part.getCatName(), part.getDbName(), part.getTableName(), part.getValues());
            if (doesExist && !ifNotExists) {
                throw new AlreadyExistsException("Partition already exists: " + part);
            }
            return !doesExist;
        }

        private boolean createLocationForAddedPartition(Table tbl, Partition part) throws MetaException {
            Path partLocation = null;
            String partLocationStr = null;
            if (part.getSd() != null) {
                partLocationStr = part.getSd().getLocation();
            }
            if (partLocationStr == null || partLocationStr.isEmpty()) {
                if (tbl.getSd().getLocation() != null) {
                    partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part.getValues()));
                }
            } else {
                if (tbl.getSd().getLocation() == null) {
                    throw new MetaException("Cannot specify location for a view partition");
                }
                partLocation = this.wh.getDnsPath(new Path(partLocationStr));
            }
            boolean result = false;
            if (partLocation != null) {
                part.getSd().setLocation(partLocation.toString());
                if (!this.wh.isDir(partLocation)) {
                    if (!this.wh.mkdirs(partLocation)) {
                        throw new MetaException(partLocation + " is not a directory or unable to create one");
                    }
                    result = true;
                }
            }
            return result;
        }

        private void initializeAddedPartition(Table tbl, Partition part, boolean madeDir) throws MetaException {
            this.initializeAddedPartition(tbl, new PartitionSpecProxy.SimplePartitionWrapperIterator(part), madeDir);
        }

        private void initializeAddedPartition(Table tbl, PartitionSpecProxy.PartitionIterator part, boolean madeDir) throws MetaException {
            if (MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.STATS_AUTO_GATHER) && !MetaStoreUtils.isView(tbl)) {
                MetaStoreUtils.updatePartitionStatsFast(part, tbl, this.wh, madeDir, false, null, true);
            }
            long time = System.currentTimeMillis() / 1000L;
            part.setCreateTime((int)time);
            if (part.getParameters() == null || part.getParameters().get("transient_lastDdlTime") == null) {
                part.putToParameters("transient_lastDdlTime", Long.toString(time));
            }
            Map<String, String> tblParams = tbl.getParameters();
            String inheritProps = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.PART_INHERIT_TBL_PROPS).trim();
            Set<String> inheritKeys = new HashSet<String>(Arrays.asList(inheritProps.split(",")));
            if (inheritKeys.contains("*")) {
                inheritKeys = tblParams.keySet();
            }
            for (String key : inheritKeys) {
                String paramVal = tblParams.get(key);
                if (null == paramVal) continue;
                part.putToParameters(key, paramVal);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Partition add_partition_core(RawStore ms, Partition part, EnvironmentContext envContext) throws TException {
            boolean success = false;
            Table tbl = null;
            Map<String, String> transactionalListenerResponses = Collections.emptyMap();
            if (!part.isSetCatName()) {
                part.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
            }
            try {
                ms.openTransaction();
                tbl = ms.getTable(part.getCatName(), part.getDbName(), part.getTableName());
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                }
                this.firePreEvent(new PreAddPartitionEvent(tbl, part, (IHMSHandler)this));
                boolean shouldAdd = this.startAddPartition(ms, part, false);
                assert (shouldAdd);
                boolean madeDir = this.createLocationForAddedPartition(tbl, part);
                try {
                    this.initializeAddedPartition(tbl, part, madeDir);
                    success = ms.addPartition(part);
                }
                finally {
                    if (!success && madeDir) {
                        this.wh.deleteDir(new Path(part.getSd().getLocation()), true, ms.getDatabase(tbl.getCatName(), tbl.getDbName()));
                    }
                }
                success = false;
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, Arrays.asList(part), true, (IHMSHandler)this), envContext);
                }
                if (!(success = ms.commitTransaction())) {
                    ms.rollbackTransaction();
                }
                if (this.listeners.isEmpty()) return part;
            }
            catch (Throwable throwable) {
                if (!success) {
                    ms.rollbackTransaction();
                }
                if (this.listeners.isEmpty()) throw throwable;
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, Arrays.asList(part), success, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
                throw throwable;
            }
            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(tbl, Arrays.asList(part), success, (IHMSHandler)this), envContext, transactionalListenerResponses, ms);
            return part;
        }

        @Override
        public Partition add_partition(Partition part) throws InvalidObjectException, AlreadyExistsException, MetaException {
            return this.add_partition_with_environment_context(part, null);
        }

        @Override
        public Partition add_partition_with_environment_context(Partition part, EnvironmentContext envContext) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.startTableFunction("add_partition", part.getCatName(), part.getDbName(), part.getTableName());
            Partition ret = null;
            Exception ex = null;
            try {
                ret = this.add_partition_core(this.getMS(), part, envContext);
                this.endFunction("add_partition", ret != null, ex, part != null ? part.getTableName() : null);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)e;
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("add_partition", ret != null, ex, part != null ? part.getTableName() : null);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceDbName, String sourceTableName, String destDbName, String destTableName) throws TException {
            this.exchange_partitions(partitionSpecs, sourceDbName, sourceTableName, destDbName, destTableName);
            return new Partition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDbName, String sourceTableName, String destDbName, String destTableName) throws TException {
            ArrayList<Partition> arrayList;
            ArrayList<Map<String, String>> transactionalListenerResponsesForDropPartition;
            Map<String, String> transactionalListenerResponsesForAddPartition;
            ArrayList<Partition> destPartitions;
            List<Partition> partitionsToExchange;
            int i;
            Table sourceTable;
            Table destinationTable;
            RawStore ms;
            boolean success;
            block23: {
                Database destDb;
                Database srcDb;
                String[] parsedDestDbName = MetaStoreUtils.parseDbName(destDbName, this.conf);
                String[] parsedSourceDbName = MetaStoreUtils.parseDbName(sourceDbName, this.conf);
                if (partitionSpecs == null || parsedSourceDbName[1] == null || sourceTableName == null || parsedDestDbName[1] == null || destTableName == null) {
                    throw new MetaException("The DB and table name for the source and destination tables, and the partition specs must not be null.");
                }
                if (!parsedDestDbName[0].equals(parsedSourceDbName[0])) {
                    throw new MetaException("You cannot move a partition across catalogs");
                }
                success = false;
                boolean pathCreated = false;
                ms = this.getMS();
                ms.openTransaction();
                destinationTable = ms.getTable(parsedDestDbName[0], parsedDestDbName[1], destTableName);
                if (destinationTable == null) {
                    throw new MetaException("The destination table " + Warehouse.getCatalogQualifiedTableName(parsedDestDbName[0], parsedDestDbName[1], destTableName) + " not found");
                }
                sourceTable = ms.getTable(parsedSourceDbName[0], parsedSourceDbName[1], sourceTableName);
                if (sourceTable == null) {
                    throw new MetaException("The source table " + Warehouse.getCatalogQualifiedTableName(parsedSourceDbName[0], parsedSourceDbName[1], sourceTableName) + " not found");
                }
                List<String> partVals = MetaStoreUtils.getPvals(sourceTable.getPartitionKeys(), partitionSpecs);
                ArrayList<String> partValsPresent = new ArrayList<String>();
                ArrayList<FieldSchema> partitionKeysPresent = new ArrayList<FieldSchema>();
                i = 0;
                for (FieldSchema fs : sourceTable.getPartitionKeys()) {
                    String partVal = partVals.get(i);
                    if (partVal != null && !partVal.equals(HiveMetaStore.NO_FILTER_STRING)) {
                        partValsPresent.add(partVal);
                        partitionKeysPresent.add(fs);
                    }
                    ++i;
                }
                partitionsToExchange = this.get_partitions_ps(sourceDbName, sourceTableName, partVals, (short)-1);
                if (partitionsToExchange == null || partitionsToExchange.isEmpty()) {
                    throw new MetaException("No partition is found with the values " + partitionSpecs + " for the table " + sourceTableName);
                }
                boolean sameColumns = MetaStoreUtils.compareFieldColumns(sourceTable.getSd().getCols(), destinationTable.getSd().getCols());
                boolean samePartitions = MetaStoreUtils.compareFieldColumns(sourceTable.getPartitionKeys(), destinationTable.getPartitionKeys());
                if (!sameColumns || !samePartitions) {
                    throw new MetaException("The tables have different schemas. Their partitions cannot be exchanged.");
                }
                Path sourcePath = new Path(sourceTable.getSd().getLocation(), Warehouse.makePartName(partitionKeysPresent, partValsPresent));
                Path destPath = new Path(destinationTable.getSd().getLocation(), Warehouse.makePartName(partitionKeysPresent, partValsPresent));
                destPartitions = new ArrayList<Partition>();
                transactionalListenerResponsesForAddPartition = Collections.emptyMap();
                transactionalListenerResponsesForDropPartition = Lists.newArrayListWithCapacity(partitionsToExchange.size());
                List<String> destPartitionNames = ms.listPartitionNames(parsedDestDbName[0], parsedDestDbName[1], destTableName, (short)-1);
                if (destPartitionNames != null && !destPartitionNames.isEmpty()) {
                    for (Partition partition : partitionsToExchange) {
                        String partToExchangeName = Warehouse.makePartName(destinationTable.getPartitionKeys(), partition.getValues());
                        if (!destPartitionNames.contains(partToExchangeName)) continue;
                        throw new MetaException("The partition " + (String)partToExchangeName + " already exists in the table " + destTableName);
                    }
                }
                if (!HiveMetaStore.isRenameAllowed(srcDb = ms.getDatabase(parsedSourceDbName[0], parsedSourceDbName[1]), destDb = ms.getDatabase(parsedDestDbName[0], parsedDestDbName[1]))) {
                    throw new MetaException("Exchange partition not allowed for " + Warehouse.getCatalogQualifiedTableName(parsedSourceDbName[0], parsedSourceDbName[1], sourceTableName) + " Dest db : " + destDbName);
                }
                try {
                    for (Partition partition : partitionsToExchange) {
                        Partition destPartition = new Partition(partition);
                        destPartition.setDbName(parsedDestDbName[1]);
                        destPartition.setTableName(destinationTable.getTableName());
                        Path destPartitionPath = new Path(destinationTable.getSd().getLocation(), Warehouse.makePartName(destinationTable.getPartitionKeys(), partition.getValues()));
                        destPartition.getSd().setLocation(destPartitionPath.toString());
                        ms.addPartition(destPartition);
                        destPartitions.add(destPartition);
                        ms.dropPartition(parsedSourceDbName[0], partition.getDbName(), sourceTable.getTableName(), partition.getValues());
                    }
                    Path destParentPath = destPath.getParent();
                    if (!this.wh.isDir(destParentPath) && !this.wh.mkdirs(destParentPath)) {
                        throw new MetaException("Unable to create path " + destParentPath);
                    }
                    pathCreated = this.wh.renameDir(sourcePath, destPath, false);
                    success = false;
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenerResponsesForAddPartition = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_PARTITION, new AddPartitionEvent(destinationTable, destPartitions, true, (IHMSHandler)this));
                        for (Partition partition : partitionsToExchange) {
                            DropPartitionEvent dropPartitionEvent = new DropPartitionEvent(sourceTable, partition, true, true, this);
                            transactionalListenerResponsesForDropPartition.add(MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_PARTITION, dropPartitionEvent));
                        }
                    }
                    success = ms.commitTransaction();
                    arrayList = destPartitions;
                    if (success && pathCreated) break block23;
                    ms.rollbackTransaction();
                    if (!pathCreated) break block23;
                }
                catch (Throwable throwable) {
                    if (!success || !pathCreated) {
                        ms.rollbackTransaction();
                        if (pathCreated) {
                            this.wh.renameDir(destPath, sourcePath, false);
                        }
                    }
                    if (!this.listeners.isEmpty()) {
                        AddPartitionEvent addPartitionEvent = new AddPartitionEvent(destinationTable, destPartitions, success, (IHMSHandler)this);
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, addPartitionEvent, null, transactionalListenerResponsesForAddPartition, ms);
                        i = 0;
                        for (Partition partition : partitionsToExchange) {
                            DropPartitionEvent dropPartitionEvent = new DropPartitionEvent(sourceTable, partition, success, true, this);
                            Map parameters = transactionalListenerResponsesForDropPartition.size() > i ? (Map)transactionalListenerResponsesForDropPartition.get(i) : null;
                            MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_PARTITION, dropPartitionEvent, null, parameters, ms);
                            ++i;
                        }
                    }
                    throw throwable;
                }
                this.wh.renameDir(destPath, sourcePath, false);
            }
            if (!this.listeners.isEmpty()) {
                AddPartitionEvent addPartitionEvent = new AddPartitionEvent(destinationTable, destPartitions, success, (IHMSHandler)this);
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_PARTITION, addPartitionEvent, null, transactionalListenerResponsesForAddPartition, ms);
                i = 0;
                for (Partition partition : partitionsToExchange) {
                    DropPartitionEvent dropPartitionEvent = new DropPartitionEvent(sourceTable, partition, success, true, this);
                    Map parameters = transactionalListenerResponsesForDropPartition.size() > i ? (Map)transactionalListenerResponsesForDropPartition.get(i) : null;
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_PARTITION, dropPartitionEvent, null, parameters, ms);
                    ++i;
                }
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drop_partition_common(RawStore ms, String catName, String db_name, String tbl_name, List<String> part_vals, boolean deleteData, EnvironmentContext envContext) throws MetaException, NoSuchObjectException, IOException, InvalidObjectException, InvalidInputException {
            Map<String, String> transactionalListenerResponses;
            Partition part;
            Table tbl;
            boolean success;
            block26: {
                boolean isSourceOfReplication;
                boolean mustPurge;
                Path archiveParentDir;
                boolean isArchived;
                Path partPath;
                block28: {
                    block27: {
                        success = false;
                        partPath = null;
                        tbl = null;
                        part = null;
                        isArchived = false;
                        archiveParentDir = null;
                        mustPurge = false;
                        boolean isExternalTbl = false;
                        isSourceOfReplication = false;
                        transactionalListenerResponses = Collections.emptyMap();
                        if (db_name == null) {
                            throw new MetaException("The DB name cannot be null.");
                        }
                        if (tbl_name == null) {
                            throw new MetaException("The table name cannot be null.");
                        }
                        if (part_vals == null) {
                            throw new MetaException("The partition values cannot be null.");
                        }
                        try {
                            ms.openTransaction();
                            part = ms.getPartition(catName, db_name, tbl_name, part_vals);
                            tbl = this.get_table_core(catName, db_name, tbl_name);
                            isExternalTbl = this.isExternal(tbl);
                            this.firePreEvent(new PreDropPartitionEvent(tbl, part, deleteData, this));
                            mustPurge = HMSHandler.isMustPurge(envContext, tbl);
                            if (part == null) {
                                throw new NoSuchObjectException("Partition doesn't exist. " + part_vals);
                            }
                            isArchived = MetaStoreUtils.isArchived(part);
                            if (isArchived) {
                                archiveParentDir = MetaStoreUtils.getOriginalLocation(part);
                                this.verifyIsWritablePath(archiveParentDir);
                            }
                            if (part.getSd() != null && part.getSd().getLocation() != null) {
                                partPath = new Path(part.getSd().getLocation());
                                this.verifyIsWritablePath(partPath);
                            }
                            if (!ms.dropPartition(catName, db_name, tbl_name, part_vals)) {
                                throw new MetaException("Unable to drop partition");
                            }
                            if (!this.transactionalListeners.isEmpty()) {
                                transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_PARTITION, new DropPartitionEvent(tbl, part, true, deleteData, this), envContext);
                            }
                            isSourceOfReplication = ReplChangeManager.isSourceOfReplication(ms.getDatabase(catName, db_name));
                            success = ms.commitTransaction();
                            if (!success) {
                                ms.rollbackTransaction();
                                break block26;
                            }
                            if (!deleteData || partPath == null && archiveParentDir == null || isExternalTbl) break block26;
                            if (!mustPurge) break block27;
                        }
                        catch (Throwable throwable) {
                            if (!success) {
                                ms.rollbackTransaction();
                            } else if (deleteData && (partPath != null || archiveParentDir != null) && !isExternalTbl) {
                                if (mustPurge) {
                                    LOG.info("dropPartition() will purge " + partPath + " directly, skipping trash.");
                                } else {
                                    LOG.info("dropPartition() will move " + partPath + " to trash-directory.");
                                }
                                if (isArchived) {
                                    assert (archiveParentDir != null);
                                    this.wh.deleteDir(archiveParentDir, true, mustPurge, isSourceOfReplication);
                                } else {
                                    assert (partPath != null);
                                    this.wh.deleteDir(partPath, true, mustPurge, isSourceOfReplication);
                                    this.deleteParentRecursive(partPath.getParent(), part_vals.size() - 1, mustPurge, isSourceOfReplication);
                                }
                            }
                            if (!this.listeners.isEmpty()) {
                                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_PARTITION, new DropPartitionEvent(tbl, part, success, deleteData, this), envContext, transactionalListenerResponses, ms);
                            }
                            throw throwable;
                        }
                        LOG.info("dropPartition() will purge " + partPath + " directly, skipping trash.");
                        break block28;
                    }
                    LOG.info("dropPartition() will move " + partPath + " to trash-directory.");
                }
                if (isArchived) {
                    assert (archiveParentDir != null);
                    this.wh.deleteDir(archiveParentDir, true, mustPurge, isSourceOfReplication);
                } else {
                    assert (partPath != null);
                    this.wh.deleteDir(partPath, true, mustPurge, isSourceOfReplication);
                    this.deleteParentRecursive(partPath.getParent(), part_vals.size() - 1, mustPurge, isSourceOfReplication);
                }
            }
            if (!this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_PARTITION, new DropPartitionEvent(tbl, part, success, deleteData, this), envContext, transactionalListenerResponses, ms);
            }
            return true;
        }

        private static boolean isMustPurge(EnvironmentContext envContext, Table tbl) {
            return envContext != null && Boolean.parseBoolean(envContext.getProperties().get("ifPurge")) || tbl.isSetParameters() && "true".equalsIgnoreCase(tbl.getParameters().get("auto.purge"));
        }

        private void deleteParentRecursive(Path parent, int depth, boolean mustPurge, boolean needRecycle) throws IOException, MetaException {
            if (depth > 0 && parent != null && this.wh.isWritable(parent)) {
                if (this.wh.isDir(parent) && this.wh.isEmpty(parent)) {
                    this.wh.deleteDir(parent, true, mustPurge, needRecycle);
                }
                this.deleteParentRecursive(parent.getParent(), depth - 1, mustPurge, needRecycle);
            }
        }

        @Override
        public boolean drop_partition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws TException {
            return this.drop_partition_with_environment_context(db_name, tbl_name, part_vals, deleteData, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DropPartitionsResult drop_partitions_req(DropPartitionsRequest request) throws TException {
            DropPartitionsResult dropPartitionsResult;
            ArrayList<Map<String, String>> transactionalListenerResponses;
            List<Object> parts;
            Table tbl;
            boolean success;
            EnvironmentContext envContext;
            boolean deleteData;
            RawStore ms;
            block37: {
                ms = this.getMS();
                String dbName = request.getDbName();
                String tblName = request.getTblName();
                String catName = request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
                boolean ifExists = request.isSetIfExists() && request.isIfExists();
                deleteData = request.isSetDeleteData() && request.isDeleteData();
                boolean ignoreProtection = request.isSetIgnoreProtection() && request.isIgnoreProtection();
                boolean needResult = !request.isSetNeedResult() || request.isNeedResult();
                ArrayList<PathAndPartValSize> dirsToDelete = new ArrayList<PathAndPartValSize>();
                ArrayList<Path> archToDelete = new ArrayList<Path>();
                envContext = request.isSetEnvironmentContext() ? request.getEnvironmentContext() : null;
                success = false;
                ms.openTransaction();
                tbl = null;
                parts = null;
                boolean mustPurge = false;
                transactionalListenerResponses = Lists.newArrayList();
                boolean isSourceOfReplication = ReplChangeManager.isSourceOfReplication(ms.getDatabase(catName, dbName));
                try {
                    tbl = this.get_table_core(catName, dbName, tblName);
                    this.isExternal(tbl);
                    mustPurge = HMSHandler.isMustPurge(envContext, tbl);
                    int minCount = 0;
                    RequestPartsSpec spec = request.getParts();
                    List<String> partNames = null;
                    if (spec.isSetExprs()) {
                        parts = new ArrayList(spec.getExprs().size());
                        for (DropPartitionsExpr dropPartitionsExpr : spec.getExprs()) {
                            ++minCount;
                            ArrayList<Partition> arrayList = new ArrayList<Partition>();
                            boolean hasUnknown = ms.getPartitionsByExpr(catName, dbName, tblName, dropPartitionsExpr.getExpr(), null, (short)-1, arrayList);
                            if (hasUnknown) {
                                throw new MetaException("Unexpected unknown partitions to drop");
                            }
                            if (!ignoreProtection && dropPartitionsExpr.isSetPartArchiveLevel()) {
                                for (Partition partition : parts) {
                                    if (!MetaStoreUtils.isArchived(partition) || MetaStoreUtils.getArchivingLevel(partition) >= dropPartitionsExpr.getPartArchiveLevel()) continue;
                                    throw new MetaException("Cannot drop a subset of partitions  in an archive, partition " + partition);
                                }
                            }
                            parts.addAll(arrayList);
                        }
                    } else if (spec.isSetNames()) {
                        partNames = spec.getNames();
                        minCount = partNames.size();
                        parts = ms.getPartitionsByNames(catName, dbName, tblName, partNames);
                    } else {
                        throw new MetaException("Partition spec is not set");
                    }
                    if (parts.size() < minCount && !ifExists) {
                        throw new NoSuchObjectException("Some partitions to drop are missing");
                    }
                    ArrayList<String> colNames = null;
                    if (partNames == null) {
                        partNames = new ArrayList<String>(parts.size());
                        colNames = new ArrayList<String>(tbl.getPartitionKeys().size());
                        for (FieldSchema fieldSchema : tbl.getPartitionKeys()) {
                            colNames.add(fieldSchema.getName());
                        }
                    }
                    for (Partition partition : parts) {
                        this.firePreEvent(new PreDropPartitionEvent(tbl, partition, deleteData, this));
                        if (colNames != null) {
                            partNames.add(FileUtils.makePartName(colNames, partition.getValues()));
                        }
                        if (MetaStoreUtils.isArchived(partition)) {
                            Path archiveParentDir = MetaStoreUtils.getOriginalLocation(partition);
                            this.verifyIsWritablePath(archiveParentDir);
                            archToDelete.add(archiveParentDir);
                        }
                        if (partition.getSd() == null || partition.getSd().getLocation() == null) continue;
                        Path partPath = new Path(partition.getSd().getLocation());
                        this.verifyIsWritablePath(partPath);
                        dirsToDelete.add(new PathAndPartValSize(partPath, partition.getValues().size()));
                    }
                    ms.dropPartitions(catName, dbName, tblName, partNames);
                    if (parts != null && !this.transactionalListeners.isEmpty()) {
                        for (Partition partition : parts) {
                            transactionalListenerResponses.add(MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_PARTITION, new DropPartitionEvent(tbl, partition, true, deleteData, this), envContext));
                        }
                    }
                    success = ms.commitTransaction();
                    DropPartitionsResult dropPartitionsResult2 = new DropPartitionsResult();
                    if (needResult) {
                        dropPartitionsResult2.setPartitions(parts);
                    }
                    dropPartitionsResult = dropPartitionsResult2;
                    if (!success) {
                        ms.rollbackTransaction();
                        break block37;
                    }
                    if (!deleteData || this.isExternal(tbl)) break block37;
                    LOG.info(mustPurge ? "dropPartition() will purge partition-directories directly, skipping trash." : "dropPartition() will move partition-directories to trash-directory.");
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    } else if (deleteData && !this.isExternal(tbl)) {
                        LOG.info(mustPurge ? "dropPartition() will purge partition-directories directly, skipping trash." : "dropPartition() will move partition-directories to trash-directory.");
                        for (Path path : archToDelete) {
                            this.wh.deleteDir(path, true, mustPurge, isSourceOfReplication);
                        }
                        for (PathAndPartValSize p : dirsToDelete) {
                            this.wh.deleteDir(p.path, true, mustPurge, isSourceOfReplication);
                            try {
                                this.deleteParentRecursive(p.path.getParent(), p.partValSize - 1, mustPurge, isSourceOfReplication);
                            }
                            catch (IOException iOException) {
                                LOG.warn("Error from deleteParentRecursive", (Throwable)iOException);
                                throw new MetaException("Failed to delete parent: " + iOException.getMessage());
                            }
                        }
                    }
                    if (parts != null) {
                        int i = 0;
                        if (parts != null && !this.listeners.isEmpty()) {
                            for (Partition partition : parts) {
                                Map parameters = !transactionalListenerResponses.isEmpty() ? (Map)transactionalListenerResponses.get(i) : null;
                                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_PARTITION, new DropPartitionEvent(tbl, partition, success, deleteData, this), envContext, parameters, ms);
                                ++i;
                            }
                        }
                    }
                    throw throwable;
                }
                for (Path path : archToDelete) {
                    this.wh.deleteDir(path, true, mustPurge, isSourceOfReplication);
                }
                for (PathAndPartValSize p : dirsToDelete) {
                    this.wh.deleteDir(p.path, true, mustPurge, isSourceOfReplication);
                    try {
                        this.deleteParentRecursive(p.path.getParent(), p.partValSize - 1, mustPurge, isSourceOfReplication);
                    }
                    catch (IOException iOException) {
                        LOG.warn("Error from deleteParentRecursive", (Throwable)iOException);
                        throw new MetaException("Failed to delete parent: " + iOException.getMessage());
                    }
                }
            }
            if (parts != null) {
                int i = 0;
                if (parts != null && !this.listeners.isEmpty()) {
                    for (Partition partition : parts) {
                        Map parameters = !transactionalListenerResponses.isEmpty() ? (Map)transactionalListenerResponses.get(i) : null;
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_PARTITION, new DropPartitionEvent(tbl, partition, success, deleteData, this), envContext, parameters, ms);
                        ++i;
                    }
                }
            }
            return dropPartitionsResult;
        }

        private void verifyIsWritablePath(Path dir) throws MetaException {
            try {
                if (!this.wh.isWritable(dir.getParent())) {
                    throw new MetaException("Table partition not deleted since " + dir.getParent() + " is not writable by " + SecurityUtils.getUser());
                }
            }
            catch (IOException ex) {
                LOG.warn("Error from isWritable", (Throwable)ex);
                throw new MetaException("Table partition not deleted since " + dir.getParent() + " access cannot be checked: " + ex.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop_partition_with_environment_context(String db_name, String tbl_name, List<String> part_vals, boolean deleteData, EnvironmentContext envContext) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startPartitionFunction("drop_partition", parsedDbName[0], parsedDbName[1], tbl_name, part_vals);
            LOG.info("Partition values:" + part_vals);
            boolean ret = false;
            Exception ex = null;
            try {
                ret = this.drop_partition_common(this.getMS(), parsedDbName[0], parsedDbName[1], tbl_name, part_vals, deleteData, envContext);
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                this.rethrowException(e);
            }
            finally {
                this.endFunction("drop_partition", ret, ex, tbl_name);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Partition get_partition(String db_name, String tbl_name, List<String> part_vals) throws MetaException, NoSuchObjectException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startPartitionFunction("get_partition", parsedDbName[0], parsedDbName[1], tbl_name, part_vals);
            Partition ret = null;
            Exception ex = null;
            try {
                this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
                this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tbl_name);
                ret = this.getMS().getPartition(parsedDbName[0], parsedDbName[1], tbl_name, part_vals);
                ret = FilterUtils.filterPartitionIfEnabled(this.isServerFilterEnabled, this.filterHook, ret);
                this.endFunction("get_partition", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.throwMetaException(e);
                    this.endFunction("get_partition", ret != null, ex, tbl_name);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        private void fireReadTablePreEvent(String catName, String dbName, String tblName) throws MetaException, NoSuchObjectException {
            if (this.preListeners.size() > 0) {
                Table t = this.getMS().getTable(catName, dbName, tblName);
                if (t == null) {
                    throw new NoSuchObjectException(Warehouse.getCatalogQualifiedTableName(catName, dbName, tblName) + " table not found");
                }
                this.firePreEvent(new PreReadTableEvent(t, (IHMSHandler)this));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Partition get_partition_with_auth(String db_name, String tbl_name, List<String> part_vals, String user_name, List<String> group_names) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startPartitionFunction("get_partition_with_auth", parsedDbName[0], parsedDbName[1], tbl_name, part_vals);
            this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tbl_name);
            Partition ret = null;
            Exception ex = null;
            try {
                this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
                ret = this.getMS().getPartitionWithAuth(parsedDbName[0], parsedDbName[1], tbl_name, part_vals, user_name, group_names);
                ret = FilterUtils.filterPartitionIfEnabled(this.isServerFilterEnabled, this.filterHook, ret);
                this.endFunction("get_partition_with_auth", ret != null, ex, tbl_name);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new NoSuchObjectException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        this.rethrowException(e2);
                        this.endFunction("get_partition_with_auth", ret != null, ex, tbl_name);
                        return ret;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition_with_auth", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Partition> get_partitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startTableFunction("get_partitions", parsedDbName[0], parsedDbName[1], tbl_name);
            this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tbl_name);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                this.checkLimitNumberOfPartitionsByFilter(parsedDbName[0], parsedDbName[1], tbl_name, HiveMetaStore.NO_FILTER_STRING, max_parts);
                this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
                ret = this.getMS().getPartitions(parsedDbName[0], parsedDbName[1], tbl_name, max_parts);
                ret = FilterUtils.filterPartitionsIfEnabled(this.isServerFilterEnabled, this.filterHook, ret);
                this.endFunction("get_partitions", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.throwMetaException(e);
                    this.endFunction("get_partitions", ret != null, ex, tbl_name);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Partition> get_partitions_with_auth(String dbName, String tblName, short maxParts, String userName, List<String> groupNames) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            this.startTableFunction("get_partitions_with_auth", parsedDbName[0], parsedDbName[1], tblName);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                this.checkLimitNumberOfPartitionsByFilter(parsedDbName[0], parsedDbName[1], tblName, HiveMetaStore.NO_FILTER_STRING, maxParts);
                this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tblName);
                ret = this.getMS().getPartitionsWithAuth(parsedDbName[0], parsedDbName[1], tblName, maxParts, userName, groupNames);
                ret = FilterUtils.filterPartitionsIfEnabled(this.isServerFilterEnabled, this.filterHook, ret);
                this.endFunction("get_partitions_with_auth", ret != null, ex, tblName);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new NoSuchObjectException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        this.rethrowException(e2);
                        this.endFunction("get_partitions_with_auth", ret != null, ex, tblName);
                        return ret;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_with_auth", ret != null, ex, tblName);
                    throw throwable;
                }
            }
        }

        private void checkLimitNumberOfPartitionsByFilter(String catName, String dbName, String tblName, String filterString, int maxParts) throws TException {
            if (this.isPartitionLimitEnabled()) {
                this.checkLimitNumberOfPartitions(tblName, this.get_num_partitions_by_filter(MetaStoreUtils.prependCatalogToDbName(catName, dbName, this.conf), tblName, filterString), maxParts);
            }
        }

        private void checkLimitNumberOfPartitionsByExpr(String catName, String dbName, String tblName, byte[] filterExpr, int maxParts) throws TException {
            if (this.isPartitionLimitEnabled()) {
                this.checkLimitNumberOfPartitions(tblName, this.get_num_partitions_by_expr(catName, dbName, tblName, filterExpr), maxParts);
            }
        }

        private boolean isPartitionLimitEnabled() {
            int partitionLimit = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST);
            return partitionLimit > -1;
        }

        private void checkLimitNumberOfPartitions(String tblName, int numPartitions, int maxToFetch) throws MetaException {
            if (this.isPartitionLimitEnabled()) {
                int partitionRequest;
                int partitionLimit = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST);
                int n = partitionRequest = maxToFetch < 0 ? numPartitions : maxToFetch;
                if (partitionRequest > partitionLimit) {
                    String configName = MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST.toString();
                    throw new MetaException(String.format(HiveMetaStore.PARTITION_NUMBER_EXCEED_LIMIT_MSG, partitionRequest, tblName, partitionLimit, configName));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PartitionSpec> get_partitions_pspec(String db_name, String tbl_name, int max_parts) throws NoSuchObjectException, MetaException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            String tableName = tbl_name.toLowerCase();
            this.startTableFunction("get_partitions_pspec", parsedDbName[0], parsedDbName[1], tableName);
            List<PartitionSpec> partitionSpecs = null;
            try {
                Table table = this.get_table_core(parsedDbName[0], parsedDbName[1], tableName);
                List<Partition> partitions = this.get_partitions(db_name, tableName, (short)max_parts);
                if (HMSHandler.is_partition_spec_grouping_enabled(table)) {
                    partitionSpecs = this.get_partitionspecs_grouped_by_storage_descriptor(table, partitions);
                } else {
                    PartitionSpec pSpec = new PartitionSpec();
                    pSpec.setPartitionList(new PartitionListComposingSpec(partitions));
                    pSpec.setCatName(parsedDbName[0]);
                    pSpec.setDbName(parsedDbName[1]);
                    pSpec.setTableName(tableName);
                    pSpec.setRootPath(table.getSd().getLocation());
                    partitionSpecs = Arrays.asList(pSpec);
                }
                List<PartitionSpec> list = partitionSpecs;
                this.endFunction("get_partitions_pspec", partitionSpecs != null && !partitionSpecs.isEmpty(), null, tbl_name);
                return list;
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_pspec", partitionSpecs != null && !partitionSpecs.isEmpty(), null, tbl_name);
                throw throwable;
            }
        }

        private List<PartitionSpec> get_partitionspecs_grouped_by_storage_descriptor(Table table, List<Partition> partitions) throws NoSuchObjectException, MetaException {
            ImmutableCollection partitionsOutsideTableDir;
            assert (HMSHandler.is_partition_spec_grouping_enabled(table));
            final String tablePath = table.getSd().getLocation();
            ImmutableListMultimap<Boolean, Partition> partitionsWithinTableDirectory = Multimaps.index(partitions, new hive.com.google.common.base.Function<Partition, Boolean>(){

                @Override
                public Boolean apply(Partition input) {
                    return input.getSd().getLocation().startsWith(tablePath);
                }
            });
            ArrayList<PartitionSpec> partSpecs = new ArrayList<PartitionSpec>();
            HashMap sdToPartList = new HashMap();
            if (partitionsWithinTableDirectory.containsKey(true)) {
                ImmutableCollection partsWithinTableDir = partitionsWithinTableDirectory.get((Object)true);
                for (Partition partition : partsWithinTableDir) {
                    PartitionWithoutSD partitionWithoutSD = new PartitionWithoutSD(partition.getValues(), partition.getCreateTime(), partition.getLastAccessTime(), partition.getSd().getLocation().substring(tablePath.length()), partition.getParameters());
                    StorageDescriptorKey sdKey = new StorageDescriptorKey(partition.getSd());
                    if (!sdToPartList.containsKey(sdKey)) {
                        sdToPartList.put(sdKey, new ArrayList());
                    }
                    ((List)sdToPartList.get(sdKey)).add(partitionWithoutSD);
                }
                for (Map.Entry entry : sdToPartList.entrySet()) {
                    partSpecs.add(this.getSharedSDPartSpec(table, (StorageDescriptorKey)entry.getKey(), (List)entry.getValue()));
                }
            }
            if (partitionsWithinTableDirectory.containsKey(false) && !(partitionsOutsideTableDir = partitionsWithinTableDirectory.get((Object)false)).isEmpty()) {
                PartitionSpec partListSpec = new PartitionSpec();
                partListSpec.setDbName(table.getDbName());
                partListSpec.setTableName(table.getTableName());
                partListSpec.setPartitionList(new PartitionListComposingSpec((List<Partition>)((Object)partitionsOutsideTableDir)));
                partSpecs.add(partListSpec);
            }
            return partSpecs;
        }

        private PartitionSpec getSharedSDPartSpec(Table table, StorageDescriptorKey sdKey, List<PartitionWithoutSD> partitions) {
            StorageDescriptor sd = new StorageDescriptor(sdKey.getSd());
            sd.setLocation(table.getSd().getLocation());
            PartitionSpecWithSharedSD sharedSDPartSpec = new PartitionSpecWithSharedSD(partitions, sd);
            PartitionSpec ret = new PartitionSpec();
            ret.setRootPath(sd.getLocation());
            ret.setSharedSDPartitionSpec(sharedSDPartSpec);
            ret.setDbName(table.getDbName());
            ret.setTableName(table.getTableName());
            return ret;
        }

        private static boolean is_partition_spec_grouping_enabled(Table table) {
            Map<String, String> parameters = table.getParameters();
            return parameters.containsKey("hive.hcatalog.partition.spec.grouping.enabled") && parameters.get("hive.hcatalog.partition.spec.grouping.enabled").equalsIgnoreCase("true");
        }

        @Override
        public List<String> get_partition_names(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startTableFunction("get_partition_names", parsedDbName[0], parsedDbName[1], tbl_name);
            this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tbl_name);
            List<String> ret = null;
            Exception ex = null;
            try {
                this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
                ret = this.getMS().listPartitionNames(parsedDbName[0], parsedDbName[1], tbl_name, max_parts);
                ret = FilterUtils.filterPartitionNamesIfEnabled(this.isServerFilterEnabled, this.filterHook, parsedDbName[0], parsedDbName[1], tbl_name, ret);
                this.endFunction("get_partition_names", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition_names", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public PartitionValuesResponse get_partition_values(PartitionValuesRequest request) throws MetaException {
            String catName = request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String dbName = request.getDbName();
            String tblName = request.getTblName();
            try {
                this.authorizeTableForPartitionMetadata(catName, dbName, tblName);
                ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
                partCols.add(request.getPartitionKeys().get(0));
                return this.getMS().listPartitionValues(catName, dbName, tblName, request.getPartitionKeys(), request.isApplyDistinct(), request.getFilter(), request.isAscending(), request.getPartitionOrder(), request.getMaxParts());
            }
            catch (NoSuchObjectException e) {
                LOG.error(String.format("Unable to get partition for %s.%s.%s", catName, dbName, tblName), (Throwable)e);
                throw new MetaException(e.getMessage());
            }
        }

        @Override
        public void alter_partition(String db_name, String tbl_name, Partition new_part) throws TException {
            this.rename_partition(db_name, tbl_name, null, new_part);
        }

        @Override
        public void alter_partition_with_environment_context(String dbName, String tableName, Partition newPartition, EnvironmentContext envContext) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            this.rename_partition(parsedDbName[0], parsedDbName[1], tableName, null, newPartition, envContext);
        }

        @Override
        public void rename_partition(String db_name, String tbl_name, List<String> part_vals, Partition new_part) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.rename_partition(parsedDbName[0], parsedDbName[1], tbl_name, part_vals, new_part, null);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void rename_partition(String catName, String db_name, String tbl_name, List<String> part_vals, Partition new_part, EnvironmentContext envContext) throws TException {
            String newLocation;
            this.startTableFunction("alter_partition", catName, db_name, tbl_name);
            if (LOG.isInfoEnabled()) {
                LOG.info("New partition values:" + new_part.getValues());
                if (part_vals != null && part_vals.size() > 0) {
                    LOG.info("Old Partition values:" + part_vals);
                }
            }
            if (new_part.getSd() != null && hive.org.apache.commons.lang.StringUtils.isNotEmpty(newLocation = new_part.getSd().getLocation())) {
                Path tblPath = this.wh.getDnsPath(new Path(newLocation));
                new_part.getSd().setLocation(tblPath.toString());
            }
            if (!new_part.isSetCatName()) {
                new_part.setCatName(catName);
            }
            Partition oldPart = null;
            Exception ex = null;
            try {
                this.firePreEvent(new PreAlterPartitionEvent(db_name, tbl_name, part_vals, new_part, this));
                if (part_vals != null && !part_vals.isEmpty()) {
                    MetaStoreUtils.validatePartitionNameCharacters(new_part.getValues(), this.partitionValidationPattern);
                }
                oldPart = this.alterHandler.alterPartition(this.getMS(), this.wh, catName, db_name, tbl_name, part_vals, new_part, envContext, this);
                Table table = null;
                if (!this.listeners.isEmpty()) {
                    if (table == null) {
                        table = this.getMS().getTable(catName, db_name, tbl_name);
                    }
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldPart, new_part, table, false, true, this), envContext);
                }
                this.endFunction("alter_partition", oldPart != null, ex, tbl_name);
                return;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new InvalidOperationException(e.getMessage());
                    catch (AlreadyExistsException e2) {
                        ex = e2;
                        throw new InvalidOperationException(e2.getMessage());
                    }
                    catch (Exception e3) {
                        ex = e3;
                        if (e3 instanceof MetaException) {
                            throw (MetaException)e3;
                        }
                        if (!(e3 instanceof InvalidOperationException)) throw HMSHandler.newMetaException(e3);
                        throw (InvalidOperationException)e3;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("alter_partition", oldPart != null, ex, tbl_name);
                    throw throwable;
                }
            }
        }

        @Override
        public void alter_partitions(String db_name, String tbl_name, List<Partition> new_parts) throws TException {
            this.alter_partitions_with_environment_context(db_name, tbl_name, new_parts, null);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void alter_partitions_with_environment_context(String db_name, String tbl_name, List<Partition> new_parts, EnvironmentContext environmentContext) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startTableFunction("alter_partitions", parsedDbName[0], parsedDbName[1], tbl_name);
            if (LOG.isInfoEnabled()) {
                for (Partition tmpPart : new_parts) {
                    LOG.info("New partition values:" + tmpPart.getValues());
                }
            }
            List<Partition> oldParts = null;
            Exception ex = null;
            try {
                for (Partition tmpPart : new_parts) {
                    if (!tmpPart.isSetCatName()) {
                        tmpPart.setCatName(MetaStoreUtils.getDefaultCatalog(this.conf));
                    }
                    this.firePreEvent(new PreAlterPartitionEvent(parsedDbName[1], tbl_name, null, tmpPart, this));
                }
                oldParts = this.alterHandler.alterPartitions(this.getMS(), this.wh, parsedDbName[0], parsedDbName[1], tbl_name, new_parts, environmentContext, this);
                Iterator<Partition> olditr = oldParts.iterator();
                Table table = null;
                for (Partition tmpPart : new_parts) {
                    if (!olditr.hasNext()) throw new InvalidOperationException("failed to alterpartitions");
                    Partition oldTmpPart = olditr.next();
                    if (table == null) {
                        table = this.getMS().getTable(parsedDbName[0], parsedDbName[1], tbl_name);
                    }
                    if (this.listeners.isEmpty()) continue;
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_PARTITION, new AlterPartitionEvent(oldTmpPart, tmpPart, table, false, true, this));
                }
                this.endFunction("alter_partition", oldParts != null, ex, tbl_name);
                return;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new InvalidOperationException(e.getMessage());
                    catch (AlreadyExistsException e2) {
                        ex = e2;
                        throw new InvalidOperationException(e2.getMessage());
                    }
                    catch (Exception e3) {
                        ex = e3;
                        if (e3 instanceof MetaException) {
                            throw (MetaException)e3;
                        }
                        if (!(e3 instanceof InvalidOperationException)) throw HMSHandler.newMetaException(e3);
                        throw (InvalidOperationException)e3;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("alter_partition", oldParts != null, ex, tbl_name);
                    throw throwable;
                }
            }
        }

        public String getVersion() throws TException {
            this.endFunction(this.startFunction("getVersion"), true, null);
            return "3.0";
        }

        @Override
        public void alter_table(String dbname, String name, Table newTable) throws InvalidOperationException, MetaException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbname, this.conf);
            this.alter_table_core(parsedDbName[0], parsedDbName[1], name, newTable, null);
        }

        @Override
        public void alter_table_with_cascade(String dbname, String name, Table newTable, boolean cascade) throws InvalidOperationException, MetaException {
            EnvironmentContext envContext = null;
            if (cascade) {
                envContext = new EnvironmentContext();
                envContext.putToProperties("CASCADE", "true");
            }
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbname, this.conf);
            this.alter_table_core(parsedDbName[0], parsedDbName[1], name, newTable, envContext);
        }

        @Override
        public void alter_table_with_environment_context(String dbname, String name, Table newTable, EnvironmentContext envContext) throws InvalidOperationException, MetaException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbname, this.conf);
            this.alter_table_core(parsedDbName[0], parsedDbName[1], name, newTable, envContext);
        }

        private void alter_table_core(String catName, String dbname, String name, Table newTable, EnvironmentContext envContext) throws InvalidOperationException, MetaException {
            String newLocation;
            this.startFunction("alter_table", ": " + Warehouse.getCatalogQualifiedTableName(catName, dbname, name) + " newtbl=" + newTable.getTableName());
            if (newTable.getParameters() == null || newTable.getParameters().get("transient_lastDdlTime") == null) {
                newTable.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            }
            if (newTable.getSd() != null && hive.org.apache.commons.lang.StringUtils.isNotEmpty(newLocation = newTable.getSd().getLocation())) {
                Path tblPath = this.wh.getDnsPath(new Path(newLocation));
                newTable.getSd().setLocation(tblPath.toString());
            }
            if (!newTable.isSetCatName()) {
                newTable.setCatName(catName);
            }
            boolean success = false;
            Exception ex = null;
            try {
                Table oldt = this.get_table_core(catName, dbname, name);
                this.firePreEvent(new PreAlterTableEvent(oldt, newTable, this));
                this.alterHandler.alterTable(this.getMS(), this.wh, catName, dbname, name, newTable, envContext, this);
                success = true;
            }
            catch (NoSuchObjectException e) {
                ex = e;
                throw new InvalidOperationException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                if (e instanceof InvalidOperationException) {
                    throw (InvalidOperationException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("alter_table", success, ex, name);
            }
        }

        @Override
        public List<String> get_tables(String dbname, String pattern) throws MetaException {
            this.startFunction("get_tables", ": db=" + dbname + " pat=" + pattern);
            List<String> ret = null;
            Exception ex = null;
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbname, this.conf);
            try {
                ret = this.getMS().getTables(parsedDbName[0], parsedDbName[1], pattern);
                ret = FilterUtils.filterTableNamesIfEnabled(this.isServerFilterEnabled, this.filterHook, parsedDbName[0], dbname, ret);
                this.endFunction("get_tables", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_tables", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> get_tables_by_type(String dbname, String pattern, String tableType) throws MetaException {
            this.startFunction("get_tables_by_type", ": db=" + dbname + " pat=" + pattern + ",type=" + tableType);
            List<String> ret = null;
            Exception ex = null;
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbname, this.conf);
            try {
                ret = this.getMS().getTables(parsedDbName[0], parsedDbName[1], pattern, TableType.valueOf(tableType));
                this.endFunction("get_tables_by_type", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_tables_by_type", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> get_materialized_views_for_rewriting(String dbname) throws MetaException {
            this.startFunction("get_materialized_views_for_rewriting", ": db=" + dbname);
            List<String> ret = null;
            Exception ex = null;
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbname, this.conf);
            try {
                ret = this.getMS().getMaterializedViewsForRewriting(parsedDbName[0], parsedDbName[1]);
                this.endFunction("get_materialized_views_for_rewriting", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_materialized_views_for_rewriting", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> get_all_tables(String dbname) throws MetaException {
            this.startFunction("get_all_tables", ": db=" + dbname);
            List<String> ret = null;
            Exception ex = null;
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbname, this.conf);
            try {
                ret = this.getMS().getAllTables(parsedDbName[0], parsedDbName[1]);
                ret = FilterUtils.filterTableNamesIfEnabled(this.isServerFilterEnabled, this.filterHook, parsedDbName[0], parsedDbName[1], ret);
                this.endFunction("get_all_tables", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_all_tables", ret != null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<FieldSchema> get_fields(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            return this.get_fields_with_environment_context(db, tableName, null);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<FieldSchema> get_fields_with_environment_context(String db, String tableName, EnvironmentContext envContext) throws MetaException, UnknownTableException, UnknownDBException {
            Exception ex;
            List<FieldSchema> ret;
            block10: {
                this.startFunction("get_fields_with_environment_context", ": db=" + db + "tbl=" + tableName);
                String[] names = tableName.split("\\.");
                String base_table_name = names[0];
                String[] parsedDbName = MetaStoreUtils.parseDbName(db, this.conf);
                ret = null;
                ex = null;
                ClassLoader orgHiveLoader = null;
                try {
                    Table tbl;
                    try {
                        tbl = this.get_table_core(parsedDbName[0], parsedDbName[1], base_table_name);
                    }
                    catch (NoSuchObjectException e) {
                        throw new UnknownTableException(e.getMessage());
                    }
                    if (null == tbl.getSd().getSerdeInfo().getSerializationLib() || MetastoreConf.getStringCollection(this.conf, MetastoreConf.ConfVars.SERDES_USING_METASTORE_FOR_SCHEMA).contains(tbl.getSd().getSerdeInfo().getSerializationLib())) {
                        ret = tbl.getSd().getCols();
                    } else {
                        StorageSchemaReader schemaReader = this.getStorageSchemaReader();
                        ret = schemaReader.readSchema(tbl, envContext, this.getConf());
                    }
                    if (orgHiveLoader == null) break block10;
                }
                catch (Exception e) {
                    try {
                        ex = e;
                        if (e instanceof UnknownTableException) {
                            throw (UnknownTableException)e;
                        }
                        if (!(e instanceof MetaException)) throw HMSHandler.newMetaException(e);
                        throw (MetaException)e;
                    }
                    catch (Throwable throwable) {
                        if (orgHiveLoader != null) {
                            this.conf.setClassLoader(orgHiveLoader);
                        }
                        this.endFunction("get_fields_with_environment_context", ret != null, ex, tableName);
                        throw throwable;
                    }
                }
                this.conf.setClassLoader(orgHiveLoader);
            }
            this.endFunction("get_fields_with_environment_context", ret != null, ex, tableName);
            return ret;
        }

        private StorageSchemaReader getStorageSchemaReader() throws MetaException {
            if (this.storageSchemaReader == null) {
                String className = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.STORAGE_SCHEMA_READER_IMPL);
                Class<StorageSchemaReader> readerClass = JavaUtils.getClass(className, StorageSchemaReader.class);
                try {
                    this.storageSchemaReader = readerClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOG.error("Unable to instantiate class " + className, (Throwable)e);
                    throw new MetaException(e.getMessage());
                }
            }
            return this.storageSchemaReader;
        }

        @Override
        public List<FieldSchema> get_schema(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            return this.get_schema_with_environment_context(db, tableName, null);
        }

        @Override
        public List<FieldSchema> get_schema_with_environment_context(String db, String tableName, EnvironmentContext envContext) throws MetaException, UnknownTableException, UnknownDBException {
            this.startFunction("get_schema_with_environment_context", ": db=" + db + "tbl=" + tableName);
            boolean success = false;
            Exception ex = null;
            try {
                Table tbl;
                String[] names = tableName.split("\\.");
                String base_table_name = names[0];
                String[] parsedDbName = MetaStoreUtils.parseDbName(db, this.conf);
                try {
                    tbl = this.get_table_core(parsedDbName[0], parsedDbName[1], base_table_name);
                }
                catch (NoSuchObjectException e) {
                    throw new UnknownTableException(e.getMessage());
                }
                List<FieldSchema> fieldSchemas = this.get_fields_with_environment_context(db, base_table_name, envContext);
                if (tbl == null || fieldSchemas == null) {
                    throw new UnknownTableException(tableName + " doesn't exist");
                }
                if (tbl.getPartitionKeys() != null) {
                    fieldSchemas.addAll(tbl.getPartitionKeys());
                }
                success = true;
                List<FieldSchema> list = fieldSchemas;
                return list;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof UnknownDBException) {
                    throw (UnknownDBException)e;
                }
                if (e instanceof UnknownTableException) {
                    throw (UnknownTableException)e;
                }
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                MetaException me = new MetaException(e.toString());
                me.initCause(e);
                throw me;
            }
            finally {
                this.endFunction("get_schema_with_environment_context", success, ex, tableName);
            }
        }

        public String getCpuProfile(int profileDurationInSec) throws TException {
            return HiveMetaStore.NO_FILTER_STRING;
        }

        @Override
        public String get_config_value(String name, String defaultValue) throws TException {
            this.startFunction("get_config_value", ": name=" + name + " defaultValue=" + defaultValue);
            boolean success = false;
            Exception ex = null;
            try {
                if (name == null) {
                    success = true;
                    String string = defaultValue;
                    return string;
                }
                if (!Pattern.matches("(hive|hdfs|mapred|metastore).*", name)) {
                    throw new ConfigValSecurityException("For security reasons, the config key " + name + " cannot be accessed");
                }
                String toReturn = defaultValue;
                try {
                    toReturn = MetastoreConf.get(this.conf, name);
                    if (toReturn == null) {
                        toReturn = defaultValue;
                    }
                }
                catch (RuntimeException e) {
                    LOG.error(threadLocalId.get().toString() + ": RuntimeException thrown in get_config_value - msg: " + e.getMessage() + " cause: " + e.getCause());
                }
                success = true;
                String string = toReturn;
                return string;
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof ConfigValSecurityException) {
                    throw (ConfigValSecurityException)e;
                }
                throw new TException(e);
            }
            finally {
                this.endFunction("get_config_value", success, ex);
            }
        }

        private List<String> getPartValsFromName(Table t, String partName) throws MetaException, InvalidObjectException {
            Preconditions.checkArgument(t != null, "Table can not be null");
            LinkedHashMap<String, String> hm = Warehouse.makeSpecFromName(partName);
            ArrayList<String> partVals = new ArrayList<String>();
            for (FieldSchema field : t.getPartitionKeys()) {
                String key = field.getName();
                String val = hm.get(key);
                if (val == null) {
                    throw new InvalidObjectException("incomplete partition name - missing " + key);
                }
                partVals.add(val);
            }
            return partVals;
        }

        private List<String> getPartValsFromName(RawStore ms, String catName, String dbName, String tblName, String partName) throws MetaException, InvalidObjectException {
            Table t = ms.getTable(catName, dbName, tblName);
            if (t == null) {
                throw new InvalidObjectException(dbName + "." + tblName + " table not found");
            }
            return this.getPartValsFromName(t, partName);
        }

        private Partition get_partition_by_name_core(RawStore ms, String catName, String db_name, String tbl_name, String part_name) throws TException {
            List<String> partVals;
            this.fireReadTablePreEvent(catName, db_name, tbl_name);
            try {
                partVals = this.getPartValsFromName(ms, catName, db_name, tbl_name, part_name);
            }
            catch (InvalidObjectException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            Partition p = ms.getPartition(catName, db_name, tbl_name, partVals);
            p = FilterUtils.filterPartitionIfEnabled(this.isServerFilterEnabled, this.filterHook, p);
            if (p == null) {
                throw new NoSuchObjectException(Warehouse.getCatalogQualifiedTableName(catName, db_name, tbl_name) + " partition (" + part_name + ") not found");
            }
            return p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Partition get_partition_by_name(String db_name, String tbl_name, String part_name) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startFunction("get_partition_by_name", ": tbl=" + Warehouse.getCatalogQualifiedTableName(parsedDbName[0], parsedDbName[1], tbl_name) + " part=" + part_name);
            Partition ret = null;
            Exception ex = null;
            try {
                ret = this.get_partition_by_name_core(this.getMS(), parsedDbName[0], parsedDbName[1], tbl_name, part_name);
                ret = FilterUtils.filterPartitionIfEnabled(this.isServerFilterEnabled, this.filterHook, ret);
                this.endFunction("get_partition_by_name", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_partition_by_name", ret != null, ex, tbl_name);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partition_by_name", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public Partition append_partition_by_name(String db_name, String tbl_name, String part_name) throws TException {
            return this.append_partition_by_name_with_environment_context(db_name, tbl_name, part_name, null);
        }

        @Override
        public Partition append_partition_by_name_with_environment_context(String db_name, String tbl_name, String part_name, EnvironmentContext env_context) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startFunction("append_partition_by_name", ": tbl=" + Warehouse.getCatalogQualifiedTableName(parsedDbName[0], parsedDbName[1], tbl_name) + " part=" + part_name);
            Partition ret = null;
            Exception ex = null;
            try {
                RawStore ms = this.getMS();
                List<String> partVals = this.getPartValsFromName(ms, parsedDbName[0], parsedDbName[1], tbl_name, part_name);
                ret = this.append_partition_common(ms, parsedDbName[0], parsedDbName[1], tbl_name, partVals, env_context);
                this.endFunction("append_partition_by_name", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof InvalidObjectException) {
                        throw (InvalidObjectException)e;
                    }
                    if (e instanceof AlreadyExistsException) {
                        throw (AlreadyExistsException)e;
                    }
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("append_partition_by_name", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        private boolean drop_partition_by_name_core(RawStore ms, String catName, String db_name, String tbl_name, String part_name, boolean deleteData, EnvironmentContext envContext) throws TException, IOException {
            List<String> partVals;
            try {
                partVals = this.getPartValsFromName(ms, catName, db_name, tbl_name, part_name);
            }
            catch (InvalidObjectException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            return this.drop_partition_common(ms, catName, db_name, tbl_name, partVals, deleteData, envContext);
        }

        @Override
        public boolean drop_partition_by_name(String db_name, String tbl_name, String part_name, boolean deleteData) throws TException {
            return this.drop_partition_by_name_with_environment_context(db_name, tbl_name, part_name, deleteData, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean drop_partition_by_name_with_environment_context(String db_name, String tbl_name, String part_name, boolean deleteData, EnvironmentContext envContext) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startFunction("drop_partition_by_name", ": tbl=" + Warehouse.getCatalogQualifiedTableName(parsedDbName[0], parsedDbName[1], tbl_name) + " part=" + part_name);
            boolean ret = false;
            Exception ex = null;
            try {
                ret = this.drop_partition_by_name_core(this.getMS(), parsedDbName[0], parsedDbName[1], tbl_name, part_name, deleteData, envContext);
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                this.rethrowException(e);
            }
            finally {
                this.endFunction("drop_partition_by_name", ret, ex, tbl_name);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Partition> get_partitions_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startPartitionFunction("get_partitions_ps", parsedDbName[0], parsedDbName[1], tbl_name, part_vals);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
                ret = this.get_partitions_ps_with_auth(db_name, tbl_name, part_vals, max_parts, null, null);
                ret = FilterUtils.filterPartitionsIfEnabled(this.isServerFilterEnabled, this.filterHook, ret);
                this.endFunction("get_partitions_ps", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_partitions_ps", ret != null, ex, tbl_name);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_ps", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<Partition> get_partitions_ps_with_auth(String db_name, String tbl_name, List<String> part_vals, short max_parts, String userName, List<String> groupNames) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startPartitionFunction("get_partitions_ps_with_auth", parsedDbName[0], parsedDbName[1], tbl_name, part_vals);
            this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tbl_name);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
                ret = this.getMS().listPartitionsPsWithAuth(parsedDbName[0], parsedDbName[1], tbl_name, part_vals, max_parts, userName, groupNames);
                ret = FilterUtils.filterPartitionsIfEnabled(this.isServerFilterEnabled, this.filterHook, ret);
                this.endFunction("get_partitions_ps_with_auth", ret != null, ex, tbl_name);
                return ret;
            }
            catch (InvalidObjectException e) {
                try {
                    ex = e;
                    throw new MetaException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        this.rethrowException(e2);
                        this.endFunction("get_partitions_ps_with_auth", ret != null, ex, tbl_name);
                        return ret;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_ps_with_auth", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> get_partition_names_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startPartitionFunction("get_partitions_names_ps", parsedDbName[0], parsedDbName[1], tbl_name, part_vals);
            this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tbl_name);
            List<String> ret = null;
            Exception ex = null;
            try {
                this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tbl_name);
                ret = this.getMS().listPartitionNamesPs(parsedDbName[0], parsedDbName[1], tbl_name, part_vals, max_parts);
                ret = FilterUtils.filterPartitionNamesIfEnabled(this.isServerFilterEnabled, this.filterHook, parsedDbName[0], parsedDbName[1], tbl_name, ret);
                this.endFunction("get_partitions_names_ps", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_partitions_names_ps", ret != null, ex, tbl_name);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_names_ps", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> partition_name_to_vals(String part_name) throws TException {
            if (part_name.length() == 0) {
                return new ArrayList<String>();
            }
            LinkedHashMap<String, String> map = Warehouse.makeSpecFromName(part_name);
            ArrayList<String> part_vals = new ArrayList<String>();
            part_vals.addAll(map.values());
            return part_vals;
        }

        @Override
        public Map<String, String> partition_name_to_spec(String part_name) throws TException {
            if (part_name.length() == 0) {
                return new HashMap<String, String>();
            }
            return Warehouse.makeSpecFromName(part_name);
        }

        private String lowerCaseConvertPartName(String partName) throws MetaException {
            boolean isFirst = true;
            Map<String, String> partSpec = Warehouse.makeEscSpecFromName(partName);
            Object convertedPartName = new String();
            for (Map.Entry<String, String> entry : partSpec.entrySet()) {
                String partColName = entry.getKey();
                String partColVal = entry.getValue();
                if (!isFirst) {
                    convertedPartName = (String)convertedPartName + "/";
                } else {
                    isFirst = false;
                }
                convertedPartName = (String)convertedPartName + partColName.toLowerCase() + "=" + partColVal;
            }
            return convertedPartName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ColumnStatistics get_table_column_statistics(String dbName, String tableName, String colName) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            parsedDbName[0] = parsedDbName[0].toLowerCase();
            parsedDbName[1] = parsedDbName[1].toLowerCase();
            tableName = tableName.toLowerCase();
            colName = colName.toLowerCase();
            this.startFunction("get_column_statistics_by_table", ": table=" + Warehouse.getCatalogQualifiedTableName(parsedDbName[0], parsedDbName[1], tableName) + " column=" + colName);
            ColumnStatistics statsObj = null;
            try {
                statsObj = this.getMS().getTableColumnStatistics(parsedDbName[0], parsedDbName[1], tableName, Lists.newArrayList(colName));
                if (statsObj != null) assert (statsObj.getStatsObjSize() <= 1);
                ColumnStatistics columnStatistics = statsObj;
                this.endFunction("get_column_statistics_by_table", statsObj != null, null, tableName);
                return columnStatistics;
            }
            catch (Throwable throwable) {
                this.endFunction("get_column_statistics_by_table", statsObj != null, null, tableName);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TableStatsResult get_table_statistics_req(TableStatsRequest request) throws TException {
            String catName = request.isSetCatName() ? request.getCatName().toLowerCase() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String dbName = request.getDbName().toLowerCase();
            String tblName = request.getTblName().toLowerCase();
            this.startFunction("get_table_statistics_req", ": table=" + Warehouse.getCatalogQualifiedTableName(catName, dbName, tblName));
            TableStatsResult result = null;
            ArrayList<String> lowerCaseColNames = new ArrayList<String>(request.getColNames().size());
            for (String colName : request.getColNames()) {
                lowerCaseColNames.add(colName.toLowerCase());
            }
            try {
                ColumnStatistics cs = this.getMS().getTableColumnStatistics(catName, dbName, tblName, lowerCaseColNames);
                result = new TableStatsResult(cs == null || cs.getStatsObj() == null ? Lists.newArrayList() : cs.getStatsObj());
                this.endFunction("get_table_statistics_req", result == null, null, tblName);
            }
            catch (Throwable throwable) {
                this.endFunction("get_table_statistics_req", result == null, null, tblName);
                throw throwable;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ColumnStatistics get_partition_column_statistics(String dbName, String tableName, String partName, String colName) throws TException {
            List<ColumnStatistics> list;
            ColumnStatistics statsObj;
            block4: {
                dbName = dbName.toLowerCase();
                String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
                tableName = tableName.toLowerCase();
                colName = colName.toLowerCase();
                String convertedPartName = this.lowerCaseConvertPartName(partName);
                this.startFunction("get_column_statistics_by_partition", ": table=" + Warehouse.getCatalogQualifiedTableName(parsedDbName[0], parsedDbName[1], tableName) + " partition=" + convertedPartName + " column=" + colName);
                statsObj = null;
                try {
                    list = this.getMS().getPartitionColumnStatistics(parsedDbName[0], parsedDbName[1], tableName, Lists.newArrayList(convertedPartName), Lists.newArrayList(colName));
                    if (!list.isEmpty()) break block4;
                    ColumnStatistics columnStatistics = null;
                    this.endFunction("get_column_statistics_by_partition", statsObj != null, null, tableName);
                    return columnStatistics;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_column_statistics_by_partition", statsObj != null, null, tableName);
                    throw throwable;
                }
            }
            if (list.size() != 1) {
                throw new MetaException(list.size() + " statistics for single column and partition");
            }
            statsObj = list.get(0);
            this.endFunction("get_column_statistics_by_partition", statsObj != null, null, tableName);
            return statsObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartitionsStatsResult get_partitions_statistics_req(PartitionsStatsRequest request) throws TException {
            String catName = request.isSetCatName() ? request.getCatName().toLowerCase() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String dbName = request.getDbName().toLowerCase();
            String tblName = request.getTblName().toLowerCase();
            this.startFunction("get_partitions_statistics_req", ": table=" + Warehouse.getCatalogQualifiedTableName(catName, dbName, tblName));
            PartitionsStatsResult result = null;
            ArrayList<String> lowerCaseColNames = new ArrayList<String>(request.getColNames().size());
            for (String string : request.getColNames()) {
                lowerCaseColNames.add(string.toLowerCase());
            }
            ArrayList<String> lowerCasePartNames = new ArrayList<String>(request.getPartNames().size());
            for (String partName : request.getPartNames()) {
                lowerCasePartNames.add(this.lowerCaseConvertPartName(partName));
            }
            try {
                List<ColumnStatistics> list = this.getMS().getPartitionColumnStatistics(catName, dbName, tblName, lowerCasePartNames, lowerCaseColNames);
                HashMap<String, List<ColumnStatisticsObj>> map = new HashMap<String, List<ColumnStatisticsObj>>();
                for (ColumnStatistics stat : list) {
                    map.put(stat.getStatsDesc().getPartName(), stat.getStatsObj());
                }
                result = new PartitionsStatsResult(map);
                this.endFunction("get_partitions_statistics_req", result == null, null, tblName);
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_statistics_req", result == null, null, tblName);
                throw throwable;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean update_table_column_statistics(ColumnStatistics colStats) throws TException {
            ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
            String catName = statsDesc.isSetCatName() ? statsDesc.getCatName().toLowerCase() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String dbName = statsDesc.getDbName().toLowerCase();
            String tableName = statsDesc.getTableName().toLowerCase();
            statsDesc.setCatName(catName);
            statsDesc.setDbName(dbName);
            statsDesc.setTableName(tableName);
            long time = System.currentTimeMillis() / 1000L;
            statsDesc.setLastAnalyzed(time);
            List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
            this.startFunction("write_column_statistics", ":  table=" + Warehouse.getCatalogQualifiedTableName(catName, dbName, tableName));
            for (ColumnStatisticsObj statsObj : statsObjs) {
                String colName = statsObj.getColName().toLowerCase();
                statsObj.setColName(colName);
                statsObj.setColType(statsObj.getColType().toLowerCase());
            }
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            boolean ret = false;
            try {
                boolean bl = ret = this.getMS().updateTableColumnStatistics(colStats);
                this.endFunction("write_column_statistics", ret, null, tableName);
                return bl;
            }
            catch (Throwable throwable) {
                this.endFunction("write_column_statistics", ret, null, tableName);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updatePartitonColStats(Table tbl, ColumnStatistics colStats) throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
            ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
            String catName = statsDesc.isSetCatName() ? statsDesc.getCatName().toLowerCase() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String dbName = statsDesc.getDbName().toLowerCase();
            String tableName = statsDesc.getTableName().toLowerCase();
            String partName = this.lowerCaseConvertPartName(statsDesc.getPartName());
            statsDesc.setCatName(catName);
            statsDesc.setDbName(dbName);
            statsDesc.setTableName(tableName);
            statsDesc.setPartName(partName);
            long time = System.currentTimeMillis() / 1000L;
            statsDesc.setLastAnalyzed(time);
            List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
            this.startFunction("write_partition_column_statistics", ":  db=" + dbName + " table=" + tableName + " part=" + partName);
            for (ColumnStatisticsObj statsObj : statsObjs) {
                String colName = statsObj.getColName().toLowerCase();
                statsObj.setColName(colName);
                statsObj.setColType(statsObj.getColType().toLowerCase());
            }
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            boolean ret = false;
            try {
                if (tbl == null) {
                    tbl = this.getTable(catName, dbName, tableName);
                }
                List<String> partVals = this.getPartValsFromName(tbl, partName);
                boolean bl = ret = this.getMS().updatePartitionColumnStatistics(colStats, partVals);
                this.endFunction("write_partition_column_statistics", ret, null, tableName);
                return bl;
            }
            catch (Throwable throwable) {
                this.endFunction("write_partition_column_statistics", ret, null, tableName);
                throw throwable;
            }
        }

        @Override
        public boolean update_partition_column_statistics(ColumnStatistics colStats) throws TException {
            return this.updatePartitonColStats(null, colStats);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete_partition_column_statistics(String dbName, String tableName, String partName, String colName) throws TException {
            dbName = dbName.toLowerCase();
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            tableName = tableName.toLowerCase();
            if (colName != null) {
                colName = colName.toLowerCase();
            }
            String convertedPartName = this.lowerCaseConvertPartName(partName);
            this.startFunction("delete_column_statistics_by_partition", ": table=" + Warehouse.getCatalogQualifiedTableName(parsedDbName[0], parsedDbName[1], tableName) + " partition=" + convertedPartName + " column=" + colName);
            boolean ret = false;
            try {
                List<String> partVals = this.getPartValsFromName(this.getMS(), parsedDbName[0], parsedDbName[1], tableName, convertedPartName);
                ret = this.getMS().deletePartitionColumnStatistics(parsedDbName[0], parsedDbName[1], tableName, convertedPartName, partVals, colName);
                this.endFunction("delete_column_statistics_by_partition", ret, null, tableName);
            }
            catch (Throwable throwable) {
                this.endFunction("delete_column_statistics_by_partition", ret, null, tableName);
                throw throwable;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete_table_column_statistics(String dbName, String tableName, String colName) throws TException {
            dbName = dbName.toLowerCase();
            tableName = tableName.toLowerCase();
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            if (colName != null) {
                colName = colName.toLowerCase();
            }
            this.startFunction("delete_column_statistics_by_table", ": table=" + Warehouse.getCatalogQualifiedTableName(parsedDbName[0], parsedDbName[1], tableName) + " column=" + colName);
            boolean ret = false;
            try {
                ret = this.getMS().deleteTableColumnStatistics(parsedDbName[0], parsedDbName[1], tableName, colName);
                this.endFunction("delete_column_statistics_by_table", ret, null, tableName);
            }
            catch (Throwable throwable) {
                this.endFunction("delete_column_statistics_by_table", ret, null, tableName);
                throw throwable;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Partition> get_partitions_by_filter(String dbName, String tblName, String filter, short maxParts) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            this.startTableFunction("get_partitions_by_filter", parsedDbName[0], parsedDbName[1], tblName);
            this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tblName);
            List<Partition> ret = null;
            Exception ex = null;
            try {
                this.checkLimitNumberOfPartitionsByFilter(parsedDbName[0], parsedDbName[1], tblName, filter, maxParts);
                this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tblName);
                ret = this.getMS().getPartitionsByFilter(parsedDbName[0], parsedDbName[1], tblName, filter, maxParts);
                ret = FilterUtils.filterPartitionsIfEnabled(this.isServerFilterEnabled, this.filterHook, ret);
                this.endFunction("get_partitions_by_filter", ret != null, ex, tblName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_partitions_by_filter", ret != null, ex, tblName);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_by_filter", ret != null, ex, tblName);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PartitionSpec> get_part_specs_by_filter(String dbName, String tblName, String filter, int maxParts) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            this.startTableFunction("get_partitions_by_filter_pspec", parsedDbName[0], parsedDbName[1], tblName);
            List<PartitionSpec> partitionSpecs = null;
            try {
                Table table = this.get_table_core(parsedDbName[0], parsedDbName[1], tblName);
                List<Partition> partitions = this.get_partitions_by_filter(dbName, tblName, filter, (short)maxParts);
                if (HMSHandler.is_partition_spec_grouping_enabled(table)) {
                    partitionSpecs = this.get_partitionspecs_grouped_by_storage_descriptor(table, partitions);
                } else {
                    PartitionSpec pSpec = new PartitionSpec();
                    pSpec.setPartitionList(new PartitionListComposingSpec(partitions));
                    pSpec.setRootPath(table.getSd().getLocation());
                    pSpec.setCatName(parsedDbName[0]);
                    pSpec.setDbName(parsedDbName[1]);
                    pSpec.setTableName(tblName);
                    partitionSpecs = Arrays.asList(pSpec);
                }
                List<PartitionSpec> list = partitionSpecs;
                this.endFunction("get_partitions_by_filter_pspec", partitionSpecs != null && !partitionSpecs.isEmpty(), null, tblName);
                return list;
            }
            catch (Throwable throwable) {
                this.endFunction("get_partitions_by_filter_pspec", partitionSpecs != null && !partitionSpecs.isEmpty(), null, tblName);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartitionsByExprResult get_partitions_by_expr(PartitionsByExprRequest req) throws TException {
            String dbName = req.getDbName();
            String tblName = req.getTblName();
            String catName = req.isSetCatName() ? req.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            this.startTableFunction("get_partitions_by_expr", catName, dbName, tblName);
            this.fireReadTablePreEvent(catName, dbName, tblName);
            PartitionsByExprResult ret = null;
            Exception ex = null;
            try {
                this.checkLimitNumberOfPartitionsByExpr(catName, dbName, tblName, req.getExpr(), -1);
                LinkedList<Partition> partitions = new LinkedList<Partition>();
                boolean hasUnknownPartitions = this.getMS().getPartitionsByExpr(catName, dbName, tblName, req.getExpr(), req.getDefaultPartitionName(), req.getMaxParts(), partitions);
                ret = new PartitionsByExprResult(partitions, hasUnknownPartitions);
                this.endFunction("get_partitions_by_expr", ret != null, ex, tblName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_partitions_by_expr", ret != null, ex, tblName);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_by_expr", ret != null, ex, tblName);
                    throw throwable;
                }
            }
            return ret;
        }

        private void rethrowException(Exception e) throws TException {
            if (e instanceof MetaException) {
                throw (MetaException)e;
            }
            if (e instanceof NoSuchObjectException) {
                throw (NoSuchObjectException)e;
            }
            if (e instanceof TException) {
                throw (TException)e;
            }
            throw HMSHandler.newMetaException(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int get_num_partitions_by_filter(String dbName, String tblName, String filter) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            this.startTableFunction("get_num_partitions_by_filter", parsedDbName[0], parsedDbName[1], tblName);
            int ret = -1;
            Exception ex = null;
            try {
                ret = this.getMS().getNumPartitionsByFilter(parsedDbName[0], parsedDbName[1], tblName, filter);
                this.endFunction("get_num_partitions_by_filter", ret != -1, ex, tblName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_num_partitions_by_filter", ret != -1, ex, tblName);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_num_partitions_by_filter", ret != -1, ex, tblName);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int get_num_partitions_by_expr(String catName, String dbName, String tblName, byte[] expr) throws TException {
            int ret = -1;
            Exception ex = null;
            try {
                ret = this.getMS().getNumPartitionsByExpr(catName, dbName, tblName, expr);
                this.endFunction("get_num_partitions_by_expr", ret != -1, ex, tblName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_num_partitions_by_expr", ret != -1, ex, tblName);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_num_partitions_by_expr", ret != -1, ex, tblName);
                    throw throwable;
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Partition> get_partitions_by_names(String dbName, String tblName, List<String> partNames) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            List<Partition> ret = null;
            Exception ex = null;
            this.startTableFunction("get_partitions_by_names", parsedDbName[0], parsedDbName[1], tblName);
            try {
                this.authorizeTableForPartitionMetadata(parsedDbName[0], parsedDbName[1], tblName);
                this.fireReadTablePreEvent(parsedDbName[0], parsedDbName[1], tblName);
                ret = this.getMS().getPartitionsByNames(parsedDbName[0], parsedDbName[1], tblName, partNames);
                ret = FilterUtils.filterPartitionsIfEnabled(this.isServerFilterEnabled, this.filterHook, ret);
                this.endFunction("get_partitions_by_names", ret != null, ex, tblName);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.rethrowException(e);
                    this.endFunction("get_partitions_by_names", ret != null, ex, tblName);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_partitions_by_names", ret != null, ex, tblName);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws TException {
            String catName;
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            String string = catName = hiveObject.isSetCatName() ? hiveObject.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            if (hiveObject.getObjectType() == HiveObjectType.COLUMN) {
                String partName = this.getPartName(hiveObject);
                return this.get_column_privilege_set(catName, hiveObject.getDbName(), hiveObject.getObjectName(), partName, hiveObject.getColumnName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                String partName = this.getPartName(hiveObject);
                return this.get_partition_privilege_set(catName, hiveObject.getDbName(), hiveObject.getObjectName(), partName, userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                return this.get_db_privilege_set(catName, hiveObject.getDbName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                return this.get_table_privilege_set(catName, hiveObject.getDbName(), hiveObject.getObjectName(), userName, groupNames);
            }
            if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                return this.get_user_privilege_set(userName, groupNames);
            }
            return null;
        }

        private String getPartName(HiveObjectRef hiveObject) throws MetaException {
            String partName = null;
            List<String> partValue = hiveObject.getPartValues();
            if (partValue != null && partValue.size() > 0) {
                try {
                    String catName = hiveObject.isSetCatName() ? hiveObject.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
                    Table table = this.get_table_core(catName, hiveObject.getDbName(), hiveObject.getObjectName());
                    partName = Warehouse.makePartName(table.getPartitionKeys(), partValue);
                }
                catch (NoSuchObjectException e) {
                    throw new MetaException(e.getMessage());
                }
            }
            return partName;
        }

        private PrincipalPrivilegeSet get_column_privilege_set(String catName, String dbName, String tableName, String partName, String columnName, String userName, List<String> groupNames) throws TException {
            PrincipalPrivilegeSet ret;
            this.incrementCounter("get_column_privilege_set");
            try {
                ret = this.getMS().getColumnPrivilegeSet(catName, dbName, tableName, partName, columnName, userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        private PrincipalPrivilegeSet get_db_privilege_set(String catName, String dbName, String userName, List<String> groupNames) throws TException {
            PrincipalPrivilegeSet ret;
            this.incrementCounter("get_db_privilege_set");
            try {
                ret = this.getMS().getDBPrivilegeSet(catName, dbName, userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        private PrincipalPrivilegeSet get_partition_privilege_set(String catName, String dbName, String tableName, String partName, String userName, List<String> groupNames) throws TException {
            PrincipalPrivilegeSet ret;
            this.incrementCounter("get_partition_privilege_set");
            try {
                ret = this.getMS().getPartitionPrivilegeSet(catName, dbName, tableName, partName, userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        private PrincipalPrivilegeSet get_table_privilege_set(String catName, String dbName, String tableName, String userName, List<String> groupNames) throws TException {
            PrincipalPrivilegeSet ret;
            this.incrementCounter("get_table_privilege_set");
            try {
                ret = this.getMS().getTablePrivilegeSet(catName, dbName, tableName, userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public boolean grant_role(String roleName, String principalName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws TException {
            Boolean ret;
            this.incrementCounter("add_role_member");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            if (HiveMetaStore.PUBLIC.equals(roleName)) {
                throw new MetaException("No user can be added to public. Since all users implicitly belong to public role.");
            }
            try {
                RawStore ms = this.getMS();
                Role role = ms.getRole(roleName);
                if (principalType == PrincipalType.ROLE && this.isNewRoleAParent(principalName, roleName)) {
                    throw new MetaException("Cannot grant role " + principalName + " to " + roleName + " as " + roleName + " already belongs to the role " + principalName + ". (no cycles allowed)");
                }
                ret = ms.grantRole(role, principalName, principalType, grantor, grantorType, grantOption);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidObjectException | NoSuchObjectException e) {
                ret = false;
                MetaStoreUtils.logAndThrowMetaException(e);
            }
            catch (Exception e) {
                throw new TException(e);
            }
            return ret;
        }

        private boolean isNewRoleAParent(String newRole, String curRole) throws MetaException {
            if (newRole.equals(curRole)) {
                return true;
            }
            List<Role> parentRoleMaps = this.getMS().listRoles(curRole, PrincipalType.ROLE);
            for (Role parentRole : parentRoleMaps) {
                if (!this.isNewRoleAParent(newRole, parentRole.getRoleName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<Role> list_roles(String principalName, PrincipalType principalType) throws TException {
            this.incrementCounter("list_roles");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            return this.getMS().listRoles(principalName, principalType);
        }

        @Override
        public boolean create_role(Role role) throws TException {
            Boolean ret;
            this.incrementCounter("create_role");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            if (HiveMetaStore.PUBLIC.equals(role.getRoleName())) {
                throw new MetaException("public role implicitly exists. It can't be created.");
            }
            try {
                ret = this.getMS().addRole(role.getRoleName(), role.getOwnerName());
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidObjectException | NoSuchObjectException e) {
                ret = false;
                MetaStoreUtils.logAndThrowMetaException(e);
            }
            catch (Exception e) {
                throw new TException(e);
            }
            return ret;
        }

        @Override
        public boolean drop_role(String roleName) throws TException {
            Boolean ret;
            this.incrementCounter("drop_role");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            if (HiveMetaStore.ADMIN.equals(roleName) || HiveMetaStore.PUBLIC.equals(roleName)) {
                throw new MetaException("public,admin roles can't be dropped.");
            }
            try {
                ret = this.getMS().removeRole(roleName);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                ret = false;
                MetaStoreUtils.logAndThrowMetaException(e);
            }
            catch (Exception e) {
                throw new TException(e);
            }
            return ret;
        }

        @Override
        public List<String> get_role_names() throws TException {
            this.incrementCounter("get_role_names");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            try {
                List<String> ret = this.getMS().listRoleNames();
                return ret;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean grant_privileges(PrivilegeBag privileges) throws TException {
            Boolean ret;
            this.incrementCounter("grant_privileges");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            try {
                ret = this.getMS().grantPrivileges(privileges);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidObjectException | NoSuchObjectException e) {
                ret = false;
                MetaStoreUtils.logAndThrowMetaException(e);
            }
            catch (Exception e) {
                throw new TException(e);
            }
            return ret;
        }

        @Override
        public boolean revoke_role(String roleName, String userName, PrincipalType principalType) throws TException {
            return this.revoke_role(roleName, userName, principalType, false);
        }

        private boolean revoke_role(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws TException {
            Boolean ret;
            this.incrementCounter("remove_role_member");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            if (HiveMetaStore.PUBLIC.equals(roleName)) {
                throw new MetaException("public role can't be revoked.");
            }
            try {
                RawStore ms = this.getMS();
                Role mRole = ms.getRole(roleName);
                ret = ms.revokeRole(mRole, userName, principalType, grantOption);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                ret = false;
                MetaStoreUtils.logAndThrowMetaException(e);
            }
            catch (Exception e) {
                throw new TException(e);
            }
            return ret;
        }

        @Override
        public GrantRevokeRoleResponse grant_revoke_role(GrantRevokeRoleRequest request) throws TException {
            GrantRevokeRoleResponse response = new GrantRevokeRoleResponse();
            boolean grantOption = false;
            if (request.isSetGrantOption()) {
                grantOption = request.isGrantOption();
            }
            switch (request.getRequestType()) {
                case GRANT: {
                    boolean result = this.grant_role(request.getRoleName(), request.getPrincipalName(), request.getPrincipalType(), request.getGrantor(), request.getGrantorType(), grantOption);
                    response.setSuccess(result);
                    break;
                }
                case REVOKE: {
                    boolean result = this.revoke_role(request.getRoleName(), request.getPrincipalName(), request.getPrincipalType(), grantOption);
                    response.setSuccess(result);
                    break;
                }
                default: {
                    throw new MetaException("Unknown request type " + request.getRequestType());
                }
            }
            return response;
        }

        @Override
        public GrantRevokePrivilegeResponse grant_revoke_privileges(GrantRevokePrivilegeRequest request) throws TException {
            GrantRevokePrivilegeResponse response = new GrantRevokePrivilegeResponse();
            switch (request.getRequestType()) {
                case GRANT: {
                    boolean result = this.grant_privileges(request.getPrivileges());
                    response.setSuccess(result);
                    break;
                }
                case REVOKE: {
                    boolean revokeGrantOption = false;
                    if (request.isSetRevokeGrantOption()) {
                        revokeGrantOption = request.isRevokeGrantOption();
                    }
                    boolean result = this.revoke_privileges(request.getPrivileges(), revokeGrantOption);
                    response.setSuccess(result);
                    break;
                }
                default: {
                    throw new MetaException("Unknown request type " + request.getRequestType());
                }
            }
            return response;
        }

        @Override
        public GrantRevokePrivilegeResponse refresh_privileges(HiveObjectRef objToRefresh, String authorizer, GrantRevokePrivilegeRequest grantRequest) throws TException {
            this.incrementCounter("refresh_privileges");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            GrantRevokePrivilegeResponse response = new GrantRevokePrivilegeResponse();
            try {
                boolean result = this.getMS().refreshPrivileges(objToRefresh, authorizer, grantRequest.getPrivileges());
                response.setSuccess(result);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return response;
        }

        @Override
        public boolean revoke_privileges(PrivilegeBag privileges) throws TException {
            return this.revoke_privileges(privileges, false);
        }

        public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws TException {
            Boolean ret;
            this.incrementCounter("revoke_privileges");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            try {
                ret = this.getMS().revokePrivileges(privileges, grantOption);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidObjectException | NoSuchObjectException e) {
                ret = false;
                MetaStoreUtils.logAndThrowMetaException(e);
            }
            catch (Exception e) {
                throw new TException(e);
            }
            return ret;
        }

        private PrincipalPrivilegeSet get_user_privilege_set(String userName, List<String> groupNames) throws TException {
            PrincipalPrivilegeSet ret;
            this.incrementCounter("get_user_privilege_set");
            try {
                ret = this.getMS().getUserPrivilegeSet(userName, groupNames);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public List<HiveObjectPrivilege> list_privileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObject) throws TException {
            String catName;
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            String string = catName = hiveObject.isSetCatName() ? hiveObject.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            if (hiveObject.getObjectType() == null) {
                return this.getAllPrivileges(principalName, principalType, catName);
            }
            if (hiveObject.getObjectType() == HiveObjectType.GLOBAL) {
                return this.list_global_privileges(principalName, principalType);
            }
            if (hiveObject.getObjectType() == HiveObjectType.DATABASE) {
                return this.list_db_privileges(principalName, principalType, catName, hiveObject.getDbName());
            }
            if (hiveObject.getObjectType() == HiveObjectType.TABLE) {
                return this.list_table_privileges(principalName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName());
            }
            if (hiveObject.getObjectType() == HiveObjectType.PARTITION) {
                return this.list_partition_privileges(principalName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues());
            }
            if (hiveObject.getObjectType() == HiveObjectType.COLUMN) {
                if (hiveObject.getPartValues() == null || hiveObject.getPartValues().isEmpty()) {
                    return this.list_table_column_privileges(principalName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getColumnName());
                }
                return this.list_partition_column_privileges(principalName, principalType, catName, hiveObject.getDbName(), hiveObject.getObjectName(), hiveObject.getPartValues(), hiveObject.getColumnName());
            }
            return null;
        }

        private List<HiveObjectPrivilege> getAllPrivileges(String principalName, PrincipalType principalType, String catName) throws TException {
            ArrayList<HiveObjectPrivilege> privs = new ArrayList<HiveObjectPrivilege>();
            privs.addAll(this.list_global_privileges(principalName, principalType));
            privs.addAll(this.list_db_privileges(principalName, principalType, catName, null));
            privs.addAll(this.list_table_privileges(principalName, principalType, catName, null, null));
            privs.addAll(this.list_partition_privileges(principalName, principalType, catName, null, null, null));
            privs.addAll(this.list_table_column_privileges(principalName, principalType, catName, null, null, null));
            privs.addAll(this.list_partition_column_privileges(principalName, principalType, catName, null, null, null, null));
            return privs;
        }

        private List<HiveObjectPrivilege> list_table_column_privileges(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, String columnName) throws TException {
            this.incrementCounter("list_table_column_privileges");
            try {
                if (dbName == null) {
                    return this.getMS().listPrincipalTableColumnGrantsAll(principalName, principalType);
                }
                if (principalName == null) {
                    return this.getMS().listTableColumnGrantsAll(catName, dbName, tableName, columnName);
                }
                return this.getMS().listPrincipalTableColumnGrants(principalName, principalType, catName, dbName, tableName, columnName);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private List<HiveObjectPrivilege> list_partition_column_privileges(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, List<String> partValues, String columnName) throws TException {
            this.incrementCounter("list_partition_column_privileges");
            try {
                if (dbName == null) {
                    return this.getMS().listPrincipalPartitionColumnGrantsAll(principalName, principalType);
                }
                Table tbl = this.get_table_core(catName, dbName, tableName);
                String partName = Warehouse.makePartName(tbl.getPartitionKeys(), partValues);
                if (principalName == null) {
                    return this.getMS().listPartitionColumnGrantsAll(catName, dbName, tableName, partName, columnName);
                }
                return this.getMS().listPrincipalPartitionColumnGrants(principalName, principalType, catName, dbName, tableName, partValues, partName, columnName);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private List<HiveObjectPrivilege> list_db_privileges(String principalName, PrincipalType principalType, String catName, String dbName) throws TException {
            this.incrementCounter("list_security_db_grant");
            try {
                if (dbName == null) {
                    return this.getMS().listPrincipalDBGrantsAll(principalName, principalType);
                }
                if (principalName == null) {
                    return this.getMS().listDBGrantsAll(catName, dbName);
                }
                return this.getMS().listPrincipalDBGrants(principalName, principalType, catName, dbName);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private List<HiveObjectPrivilege> list_partition_privileges(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, List<String> partValues) throws TException {
            this.incrementCounter("list_security_partition_grant");
            try {
                if (dbName == null) {
                    return this.getMS().listPrincipalPartitionGrantsAll(principalName, principalType);
                }
                Table tbl = this.get_table_core(catName, dbName, tableName);
                String partName = Warehouse.makePartName(tbl.getPartitionKeys(), partValues);
                if (principalName == null) {
                    return this.getMS().listPartitionGrantsAll(catName, dbName, tableName, partName);
                }
                return this.getMS().listPrincipalPartitionGrants(principalName, principalType, catName, dbName, tableName, partValues, partName);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private List<HiveObjectPrivilege> list_table_privileges(String principalName, PrincipalType principalType, String catName, String dbName, String tableName) throws TException {
            this.incrementCounter("list_security_table_grant");
            try {
                if (dbName == null) {
                    return this.getMS().listPrincipalTableGrantsAll(principalName, principalType);
                }
                if (principalName == null) {
                    return this.getMS().listTableGrantsAll(catName, dbName, tableName);
                }
                return this.getMS().listAllTableGrants(principalName, principalType, catName, dbName, tableName);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private List<HiveObjectPrivilege> list_global_privileges(String principalName, PrincipalType principalType) throws TException {
            this.incrementCounter("list_security_user_grant");
            try {
                if (principalName == null) {
                    return this.getMS().listGlobalGrantsAll();
                }
                return this.getMS().listPrincipalGlobalGrants(principalName, principalType);
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void cancel_delegation_token(String token_str_form) throws TException {
            this.startFunction("cancel_delegation_token");
            boolean success = false;
            Exception ex = null;
            try {
                HiveMetaStore.cancelDelegationToken(token_str_form);
                success = true;
            }
            catch (IOException e) {
                ex = e;
                throw new MetaException(e.getMessage());
            }
            catch (Exception e) {
                ex = e;
                throw HMSHandler.newMetaException(e);
            }
            finally {
                this.endFunction("cancel_delegation_token", success, ex);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long renew_delegation_token(String token_str_form) throws TException {
            this.startFunction("renew_delegation_token");
            Long ret = null;
            Exception ex = null;
            try {
                ret = HiveMetaStore.renewDelegationToken(token_str_form);
                this.endFunction("renew_delegation_token", ret != null, ex);
                return ret;
            }
            catch (IOException e) {
                try {
                    ex = e;
                    throw new MetaException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        throw HMSHandler.newMetaException(e2);
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("renew_delegation_token", ret != null, ex);
                    throw throwable;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String get_delegation_token(String token_owner, String renewer_kerberos_principal_name) throws TException {
            this.startFunction("get_delegation_token");
            String ret = null;
            Exception ex = null;
            try {
                ret = HiveMetaStore.getDelegationToken(token_owner, renewer_kerberos_principal_name, HMSHandler.getIPAddress());
                this.endFunction("get_delegation_token", ret != null, ex);
                return ret;
            }
            catch (IOException | InterruptedException e) {
                try {
                    ex = e;
                    throw new MetaException(e.getMessage());
                    catch (Exception e2) {
                        ex = e2;
                        throw HMSHandler.newMetaException(e2);
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_delegation_token", ret != null, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public boolean add_token(String token_identifier, String delegation_token) throws TException {
            this.startFunction("add_token", ": " + token_identifier);
            boolean ret = false;
            Exception ex = null;
            try {
                ret = this.getMS().addToken(token_identifier, delegation_token);
                this.endFunction("add_token", ret, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("add_token", ret, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public boolean remove_token(String token_identifier) throws TException {
            this.startFunction("remove_token", ": " + token_identifier);
            boolean ret = false;
            Exception ex = null;
            try {
                ret = this.getMS().removeToken(token_identifier);
                this.endFunction("remove_token", ret, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("remove_token", ret, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public String get_token(String token_identifier) throws TException {
            this.startFunction("get_token for", ": " + token_identifier);
            String ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getToken(token_identifier);
                this.endFunction("get_token", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_token", ret != null, ex);
                    throw throwable;
                }
            }
            return ret == null ? HiveMetaStore.NO_FILTER_STRING : ret;
        }

        @Override
        public List<String> get_all_token_identifiers() throws TException {
            List<String> ret;
            this.startFunction("get_all_token_identifiers.");
            Exception ex = null;
            try {
                ret = this.getMS().getAllTokenIdentifiers();
                this.endFunction("get_all_token_identifiers.", ex == null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_all_token_identifiers.", ex == null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public int add_master_key(String key) throws TException {
            int ret;
            this.startFunction("add_master_key.");
            Exception ex = null;
            try {
                ret = this.getMS().addMasterKey(key);
                this.endFunction("add_master_key.", ex == null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("add_master_key.", ex == null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public void update_master_key(int seq_number, String key) throws TException {
            this.startFunction("update_master_key.");
            Exception ex = null;
            try {
                this.getMS().updateMasterKey(seq_number, key);
                this.endFunction("update_master_key.", ex == null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("update_master_key.", ex == null, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public boolean remove_master_key(int key_seq) throws TException {
            boolean ret;
            this.startFunction("remove_master_key.");
            Exception ex = null;
            try {
                ret = this.getMS().removeMasterKey(key_seq);
                this.endFunction("remove_master_key.", ex == null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("remove_master_key.", ex == null, ex);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> get_master_keys() throws TException {
            this.startFunction("get_master_keys.");
            Exception ex = null;
            String[] ret = null;
            try {
                ret = this.getMS().getMasterKeys();
                this.endFunction("get_master_keys.", ret != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_master_keys.", ret != null, ex);
                    throw throwable;
                }
            }
            return Arrays.asList(ret);
        }

        @Override
        public void markPartitionForEvent(String db_name, String tbl_name, Map<String, String> partName, PartitionEventType evtType) throws TException {
            Table tbl = null;
            Exception ex = null;
            RawStore ms = this.getMS();
            boolean success = false;
            try {
                String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
                ms.openTransaction();
                this.startPartitionFunction("markPartitionForEvent", parsedDbName[0], parsedDbName[1], tbl_name, partName);
                this.firePreEvent(new PreLoadPartitionDoneEvent(parsedDbName[0], parsedDbName[1], tbl_name, partName, this));
                tbl = ms.markPartitionForEvent(parsedDbName[0], parsedDbName[1], tbl_name, partName, evtType);
                if (null == tbl) {
                    throw new UnknownTableException("Table: " + tbl_name + " not found.");
                }
                if (this.transactionalListeners.size() > 0) {
                    LoadPartitionDoneEvent lpde = new LoadPartitionDoneEvent(true, tbl, partName, this);
                    for (MetaStoreEventListener metaStoreEventListener : this.transactionalListeners) {
                        metaStoreEventListener.onLoadPartitionDone(lpde);
                    }
                }
                success = ms.commitTransaction();
                for (MetaStoreEventListener listener : this.listeners) {
                    listener.onLoadPartitionDone(new LoadPartitionDoneEvent(true, tbl, partName, this));
                }
                if (!success) {
                    ms.rollbackTransaction();
                }
                this.endFunction("markPartitionForEvent", tbl != null, ex, tbl_name);
            }
            catch (Exception original) {
                try {
                    ex = original;
                    LOG.error("Exception caught in mark partition event ", (Throwable)original);
                    if (original instanceof UnknownTableException) {
                        throw (UnknownTableException)original;
                    }
                    if (original instanceof UnknownPartitionException) {
                        throw (UnknownPartitionException)original;
                    }
                    if (original instanceof InvalidPartitionException) {
                        throw (InvalidPartitionException)original;
                    }
                    if (original instanceof MetaException) {
                        throw (MetaException)original;
                    }
                    throw HMSHandler.newMetaException(original);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ms.rollbackTransaction();
                    }
                    this.endFunction("markPartitionForEvent", tbl != null, ex, tbl_name);
                    throw throwable;
                }
            }
        }

        @Override
        public boolean isPartitionMarkedForEvent(String db_name, String tbl_name, Map<String, String> partName, PartitionEventType evtType) throws TException {
            String[] parsedDbName = MetaStoreUtils.parseDbName(db_name, this.conf);
            this.startPartitionFunction("isPartitionMarkedForEvent", parsedDbName[0], parsedDbName[1], tbl_name, partName);
            Boolean ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().isPartitionMarkedForEvent(parsedDbName[0], parsedDbName[1], tbl_name, partName, evtType);
                this.endFunction("isPartitionMarkedForEvent", ret != null, ex, tbl_name);
            }
            catch (Exception original) {
                try {
                    LOG.error("Exception caught for isPartitionMarkedForEvent ", (Throwable)original);
                    ex = original;
                    if (original instanceof UnknownTableException) {
                        throw (UnknownTableException)original;
                    }
                    if (original instanceof UnknownPartitionException) {
                        throw (UnknownPartitionException)original;
                    }
                    if (original instanceof InvalidPartitionException) {
                        throw (InvalidPartitionException)original;
                    }
                    if (original instanceof MetaException) {
                        throw (MetaException)original;
                    }
                    throw HMSHandler.newMetaException(original);
                }
                catch (Throwable throwable) {
                    this.endFunction("isPartitionMarkedForEvent", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return ret;
        }

        @Override
        public List<String> set_ugi(String username, List<String> groupNames) throws TException {
            Collections.addAll(groupNames, username);
            return groupNames;
        }

        @Override
        public boolean partition_name_has_valid_characters(List<String> part_vals, boolean throw_exception) throws TException {
            boolean ret;
            this.startFunction("partition_name_has_valid_characters");
            Exception ex = null;
            try {
                if (throw_exception) {
                    MetaStoreUtils.validatePartitionNameCharacters(part_vals, this.partitionValidationPattern);
                    ret = true;
                } else {
                    ret = MetaStoreUtils.partitionNameHasValidCharacters(part_vals, this.partitionValidationPattern);
                }
            }
            catch (Exception e) {
                ex = e;
                if (e instanceof MetaException) {
                    throw (MetaException)e;
                }
                throw HMSHandler.newMetaException(e);
            }
            this.endFunction("partition_name_has_valid_characters", true, ex);
            return ret;
        }

        private static MetaException newMetaException(Exception e) {
            if (e instanceof MetaException) {
                return (MetaException)e;
            }
            MetaException me = new MetaException(e.toString());
            me.initCause(e);
            return me;
        }

        private void validateFunctionInfo(Function func) throws InvalidObjectException, MetaException {
            if (!MetaStoreUtils.validateName(func.getFunctionName(), null)) {
                throw new InvalidObjectException(func.getFunctionName() + " is not a valid object name");
            }
            String className = func.getClassName();
            if (className == null) {
                throw new InvalidObjectException("Function class name cannot be null");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void create_function(Function func) throws TException {
            this.validateFunctionInfo(func);
            boolean success = false;
            RawStore ms = this.getMS();
            Map<String, String> transactionalListenerResponses = Collections.emptyMap();
            try {
                String catName;
                String string = catName = func.isSetCatName() ? func.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
                if (!func.isSetOwnerName()) {
                    try {
                        func.setOwnerName(SecurityUtils.getUGI().getShortUserName());
                    }
                    catch (Exception ex) {
                        LOG.error("Cannot obtain username from the session to create a function", (Throwable)ex);
                        throw new TException(ex);
                    }
                }
                ms.openTransaction();
                Database db = ms.getDatabase(catName, func.getDbName());
                if (db == null) {
                    throw new NoSuchObjectException("The database " + func.getDbName() + " does not exist");
                }
                Function existingFunc = ms.getFunction(catName, func.getDbName(), func.getFunctionName());
                if (existingFunc != null) {
                    throw new AlreadyExistsException("Function " + func.getFunctionName() + " already exists");
                }
                this.firePreEvent(new PreCreateFunctionEvent(func, (IHMSHandler)this));
                long time = System.currentTimeMillis() / 1000L;
                func.setCreateTime((int)time);
                ms.createFunction(func);
                if (!this.transactionalListeners.isEmpty()) {
                    transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.CREATE_FUNCTION, new CreateFunctionEvent(func, true, this));
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                if (!this.listeners.isEmpty()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_FUNCTION, new CreateFunctionEvent(func, success, this), null, transactionalListenerResponses, ms);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop_function(String dbName, String funcName) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
            boolean success = false;
            Function func = null;
            RawStore ms = this.getMS();
            Map<String, String> transactionalListenerResponses = Collections.emptyMap();
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            try {
                ms.openTransaction();
                func = ms.getFunction(parsedDbName[0], parsedDbName[1], funcName);
                if (func == null) {
                    throw new NoSuchObjectException("Function " + funcName + " does not exist");
                }
                Boolean isSourceOfReplication = ReplChangeManager.isSourceOfReplication(this.get_database_core(parsedDbName[0], parsedDbName[1]));
                this.firePreEvent(new PreDropFunctionEvent(func, (IHMSHandler)this));
                if (func.getResourceUris() != null && !func.getResourceUris().isEmpty()) {
                    for (ResourceUri uri : func.getResourceUris()) {
                        if (!uri.getUri().toLowerCase().startsWith("maprfs:") || !isSourceOfReplication.booleanValue()) continue;
                        this.wh.addToChangeManagement(new Path(uri.getUri()));
                    }
                }
                ms.dropFunction(parsedDbName[0], parsedDbName[1], funcName);
                if (this.transactionalListeners.size() > 0) {
                    transactionalListenerResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_FUNCTION, new DropFunctionEvent(func, true, this));
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                if (this.listeners.size() > 0) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_FUNCTION, new DropFunctionEvent(func, success, this), null, transactionalListenerResponses, ms);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void alter_function(String dbName, String funcName, Function newFunc) throws TException {
            this.validateFunctionInfo(newFunc);
            boolean success = false;
            RawStore ms = this.getMS();
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            try {
                ms.openTransaction();
                this.firePreEvent(new PreCreateFunctionEvent(newFunc, (IHMSHandler)this));
                ms.alterFunction(parsedDbName[0], parsedDbName[1], funcName, newFunc);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public List<String> get_functions(String dbName, String pattern) throws MetaException {
            this.startFunction("get_functions", ": db=" + dbName + " pat=" + pattern);
            RawStore ms = this.getMS();
            Exception ex = null;
            List<String> funcNames = null;
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            try {
                funcNames = ms.getFunctions(parsedDbName[0], parsedDbName[1], pattern);
                this.endFunction("get_functions", funcNames != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_functions", funcNames != null, ex);
                    throw throwable;
                }
            }
            return funcNames;
        }

        @Override
        public GetAllFunctionsResponse get_all_functions() throws MetaException {
            GetAllFunctionsResponse response = new GetAllFunctionsResponse();
            this.startFunction("get_all_functions");
            RawStore ms = this.getMS();
            List<Function> allFunctions = null;
            Exception ex = null;
            try {
                allFunctions = ms.getAllFunctions("hive");
                this.endFunction("get_all_functions", allFunctions != null, ex);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_all_functions", allFunctions != null, ex);
                    throw throwable;
                }
            }
            response.setFunctions(allFunctions);
            return response;
        }

        /*
         * Loose catch block
         */
        @Override
        public Function get_function(String dbName, String funcName) throws TException {
            this.startFunction("get_function", ": " + dbName + "." + funcName);
            RawStore ms = this.getMS();
            Function func = null;
            Exception ex = null;
            String[] parsedDbName = MetaStoreUtils.parseDbName(dbName, this.conf);
            try {
                func = ms.getFunction(parsedDbName[0], parsedDbName[1], funcName);
                if (func == null) {
                    throw new NoSuchObjectException("Function " + dbName + "." + funcName + " does not exist");
                }
                this.endFunction("get_function", func != null, ex);
            }
            catch (NoSuchObjectException e) {
                ex = e;
                this.rethrowException(e);
                this.endFunction("get_function", func != null, ex);
            }
            catch (Exception e2) {
                ex = e2;
                throw HMSHandler.newMetaException(e2);
                {
                    catch (Throwable throwable) {
                        this.endFunction("get_function", func != null, ex);
                        throw throwable;
                    }
                }
            }
            return func;
        }

        @Override
        public GetOpenTxnsResponse get_open_txns() throws TException {
            return this.getTxnHandler().getOpenTxns();
        }

        @Override
        public GetOpenTxnsInfoResponse get_open_txns_info() throws TException {
            return this.getTxnHandler().getOpenTxnsInfo();
        }

        @Override
        public OpenTxnsResponse open_txns(OpenTxnRequest rqst) throws TException {
            OpenTxnsResponse response = this.getTxnHandler().openTxns(rqst);
            List<Long> txnIds = response.getTxn_ids();
            if (txnIds != null && this.listeners != null && !this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.OPEN_TXN, new OpenTxnEvent(txnIds, (IHMSHandler)this));
            }
            return response;
        }

        @Override
        public void abort_txn(AbortTxnRequest rqst) throws TException {
            this.getTxnHandler().abortTxn(rqst);
            if (this.listeners != null && !this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ABORT_TXN, new AbortTxnEvent(rqst.getTxnid(), (IHMSHandler)this));
            }
        }

        @Override
        public void abort_txns(AbortTxnsRequest rqst) throws TException {
            this.getTxnHandler().abortTxns(rqst);
            if (this.listeners != null && !this.listeners.isEmpty()) {
                for (Long txnId : rqst.getTxn_ids()) {
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ABORT_TXN, new AbortTxnEvent(txnId, (IHMSHandler)this));
                }
            }
        }

        @Override
        public void commit_txn(CommitTxnRequest rqst) throws TException {
            this.getTxnHandler().commitTxn(rqst);
            if (this.listeners != null && !this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.COMMIT_TXN, new CommitTxnEvent(rqst.getTxnid(), (IHMSHandler)this));
            }
        }

        @Override
        public void repl_tbl_writeid_state(ReplTblWriteIdStateRequest rqst) throws TException {
            this.getTxnHandler().replTableWriteIdState(rqst);
        }

        @Override
        public GetValidWriteIdsResponse get_valid_write_ids(GetValidWriteIdsRequest rqst) throws TException {
            return this.getTxnHandler().getValidWriteIds(rqst);
        }

        @Override
        public AllocateTableWriteIdsResponse allocate_table_write_ids(AllocateTableWriteIdsRequest rqst) throws TException {
            AllocateTableWriteIdsResponse response = this.getTxnHandler().allocateTableWriteIds(rqst);
            if (this.listeners != null && !this.listeners.isEmpty()) {
                MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALLOC_WRITE_ID, new AllocWriteIdEvent(response.getTxnToWriteIds(), rqst.getDbName(), rqst.getTableName(), this));
            }
            return response;
        }

        @Override
        public LockResponse lock(LockRequest rqst) throws TException {
            return this.getTxnHandler().lock(rqst);
        }

        @Override
        public LockResponse check_lock(CheckLockRequest rqst) throws TException {
            return this.getTxnHandler().checkLock(rqst);
        }

        @Override
        public void unlock(UnlockRequest rqst) throws TException {
            this.getTxnHandler().unlock(rqst);
        }

        @Override
        public ShowLocksResponse show_locks(ShowLocksRequest rqst) throws TException {
            return this.getTxnHandler().showLocks(rqst);
        }

        @Override
        public void heartbeat(HeartbeatRequest ids) throws TException {
            this.getTxnHandler().heartbeat(ids);
        }

        @Override
        public HeartbeatTxnRangeResponse heartbeat_txn_range(HeartbeatTxnRangeRequest rqst) throws TException {
            return this.getTxnHandler().heartbeatTxnRange(rqst);
        }

        @Override
        @Deprecated
        public void compact(CompactionRequest rqst) throws TException {
            this.compact2(rqst);
        }

        @Override
        public CompactionResponse compact2(CompactionRequest rqst) throws TException {
            return this.getTxnHandler().compact(rqst);
        }

        @Override
        public ShowCompactResponse show_compact(ShowCompactRequest rqst) throws TException {
            return this.getTxnHandler().showCompact(rqst);
        }

        @Override
        public void flushCache() throws TException {
            this.getMS().flushCache();
        }

        @Override
        public void add_dynamic_partitions(AddDynamicPartitions rqst) throws TException {
            this.getTxnHandler().addDynamicPartitions(rqst);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest request) throws TException {
            this.incrementCounter("get_principals_in_role");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            Exception ex = null;
            GetPrincipalsInRoleResponse response = null;
            try {
                response = new GetPrincipalsInRoleResponse(this.getMS().listRoleMembers(request.getRoleName()));
                this.endFunction("get_principals_in_role", ex == null, ex);
                return response;
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        ex = e2;
                        this.rethrowException(e2);
                        this.endFunction("get_principals_in_role", ex == null, ex);
                        return response;
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_principals_in_role", ex == null, ex);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest request) throws TException {
            this.incrementCounter("get_role_grants_for_principal");
            this.firePreEvent(new PreAuthorizationCallEvent(this));
            Exception ex = null;
            List<RolePrincipalGrant> roleMaps = null;
            try {
                roleMaps = this.getMS().listRolesWithGrants(request.getPrincipal_name(), request.getPrincipal_type());
                this.endFunction("get_role_grants_for_principal", ex == null, ex);
                return new GetRoleGrantsForPrincipalResponse(roleMaps);
            }
            catch (MetaException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        ex = e2;
                        this.rethrowException(e2);
                        this.endFunction("get_role_grants_for_principal", ex == null, ex);
                        return new GetRoleGrantsForPrincipalResponse(roleMaps);
                    }
                }
                catch (Throwable throwable) {
                    this.endFunction("get_role_grants_for_principal", ex == null, ex);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AggrStats get_aggr_stats_for(PartitionsStatsRequest request) throws TException {
            String catName = request.isSetCatName() ? request.getCatName().toLowerCase() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String dbName = request.getDbName().toLowerCase();
            String tblName = request.getTblName().toLowerCase();
            this.startFunction("get_aggr_stats_for", ": table=" + Warehouse.getCatalogQualifiedTableName(catName, dbName, tblName));
            ArrayList<String> lowerCaseColNames = new ArrayList<String>(request.getColNames().size());
            for (String string : request.getColNames()) {
                lowerCaseColNames.add(string.toLowerCase());
            }
            ArrayList<String> lowerCasePartNames = new ArrayList<String>(request.getPartNames().size());
            for (String partName : request.getPartNames()) {
                lowerCasePartNames.add(this.lowerCaseConvertPartName(partName));
            }
            Object var7_9 = null;
            try {
                AggrStats aggrStats;
                AggrStats aggrStats2 = aggrStats = new AggrStats(this.getMS().get_aggr_stats_for(catName, dbName, tblName, lowerCasePartNames, lowerCaseColNames));
                this.endFunction("get_aggr_stats_for", aggrStats == null, null, request.getTblName());
                return aggrStats2;
            }
            catch (Throwable throwable) {
                this.endFunction("get_aggr_stats_for", var7_9 == null, null, request.getTblName());
                throw throwable;
            }
        }

        @Override
        public boolean set_aggr_stats_for(SetPartitionsStatsRequest request) throws TException {
            boolean ret = true;
            List<ColumnStatistics> csNews = request.getColStats();
            if (csNews == null || csNews.isEmpty()) {
                return ret;
            }
            ColumnStatistics firstColStats = csNews.get(0);
            ColumnStatisticsDesc statsDesc = firstColStats.getStatsDesc();
            String catName = statsDesc.isSetCatName() ? statsDesc.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String dbName = statsDesc.getDbName();
            String tableName = statsDesc.getTableName();
            ArrayList<String> colNames = new ArrayList<String>();
            for (ColumnStatisticsObj obj : firstColStats.getStatsObj()) {
                colNames.add(obj.getColName());
            }
            if (statsDesc.isIsTblLevel()) {
                if (request.getColStatsSize() != 1) {
                    throw new MetaException("Expecting only 1 ColumnStatistics for table's column stats, but find " + request.getColStatsSize());
                }
                if (request.isSetNeedMerge() && request.isNeedMerge()) {
                    ColumnStatistics csOld = this.getMS().getTableColumnStatistics(catName, dbName, tableName, colNames);
                    Table t = this.getTable(catName, dbName, tableName);
                    MetaStoreUtils.getMergableCols(firstColStats, t.getParameters());
                    if (csOld != null && csOld.getStatsObjSize() != 0 && !firstColStats.getStatsObj().isEmpty()) {
                        MetaStoreUtils.mergeColStats(firstColStats, csOld);
                    }
                    if (!firstColStats.getStatsObj().isEmpty()) {
                        return this.update_table_column_statistics(firstColStats);
                    }
                    LOG.debug("All the column stats are not accurate to merge.");
                    return true;
                }
                return this.update_table_column_statistics(firstColStats);
            }
            List<Object> partitions = new ArrayList();
            HashMap<String, ColumnStatistics> newStatsMap = new HashMap<String, ColumnStatistics>();
            for (ColumnStatistics csNew : csNews) {
                String partName = csNew.getStatsDesc().getPartName();
                if (newStatsMap.containsKey(partName)) {
                    MetaStoreUtils.mergeColStats(csNew, (ColumnStatistics)newStatsMap.get(partName));
                }
                newStatsMap.put(partName, csNew);
            }
            HashMap<String, ColumnStatistics> oldStatsMap = new HashMap<String, ColumnStatistics>();
            HashMap<String, Partition> mapToPart = new HashMap<String, Partition>();
            if (request.isSetNeedMerge() && request.isNeedMerge()) {
                ArrayList<String> partitionNames = new ArrayList<String>();
                partitionNames.addAll(newStatsMap.keySet());
                List<ColumnStatistics> csOlds = this.getMS().getPartitionColumnStatistics(catName, dbName, tableName, partitionNames, colNames);
                if (newStatsMap.values().size() != csOlds.size()) {
                    LOG.debug("Some of the partitions miss stats.");
                }
                for (ColumnStatistics csOld : csOlds) {
                    oldStatsMap.put(csOld.getStatsDesc().getPartName(), csOld);
                }
                partitions = this.getMS().getPartitionsByNames(catName, dbName, tableName, partitionNames);
                for (int index = 0; index < partitionNames.size(); ++index) {
                    mapToPart.put((String)partitionNames.get(index), (Partition)partitions.get(index));
                }
            }
            Table t = this.getTable(catName, dbName, tableName);
            for (Map.Entry entry : newStatsMap.entrySet()) {
                ColumnStatistics csNew = (ColumnStatistics)entry.getValue();
                ColumnStatistics csOld = (ColumnStatistics)oldStatsMap.get(entry.getKey());
                if (request.isSetNeedMerge() && request.isNeedMerge()) {
                    MetaStoreUtils.getMergableCols(csNew, ((Partition)mapToPart.get(entry.getKey())).getParameters());
                    if (csOld != null && csOld.getStatsObjSize() != 0 && !csNew.getStatsObj().isEmpty()) {
                        MetaStoreUtils.mergeColStats(csNew, csOld);
                    }
                    if (!csNew.getStatsObj().isEmpty()) {
                        ret = ret && this.updatePartitonColStats(t, csNew);
                        continue;
                    }
                    LOG.debug("All the column stats " + csNew.getStatsDesc().getPartName() + " are not accurate to merge.");
                    continue;
                }
                ret = ret && this.updatePartitonColStats(t, csNew);
            }
            return ret;
        }

        private Table getTable(String catName, String dbName, String tableName) throws MetaException, InvalidObjectException {
            Table t = this.getMS().getTable(catName, dbName, tableName);
            if (t == null) {
                throw new InvalidObjectException(Warehouse.getCatalogQualifiedTableName(catName, dbName, tableName) + " table not found");
            }
            return t;
        }

        @Override
        public NotificationEventResponse get_next_notification(NotificationEventRequest rqst) throws TException {
            try {
                this.authorizeProxyPrivilege();
            }
            catch (Exception ex) {
                LOG.error("Not authorized to make the get_next_notification call. You can try to disable " + MetastoreConf.ConfVars.EVENT_DB_NOTIFICATION_API_AUTH.toString(), (Throwable)ex);
                throw new TException(ex);
            }
            RawStore ms = this.getMS();
            return ms.getNextNotification(rqst);
        }

        @Override
        public CurrentNotificationEventId get_current_notificationEventId() throws TException {
            try {
                this.authorizeProxyPrivilege();
            }
            catch (Exception ex) {
                LOG.error("Not authorized to make the get_current_notificationEventId call. You can try to disable " + MetastoreConf.ConfVars.EVENT_DB_NOTIFICATION_API_AUTH.toString(), (Throwable)ex);
                throw new TException(ex);
            }
            RawStore ms = this.getMS();
            return ms.getCurrentNotificationEventId();
        }

        @Override
        public NotificationEventsCountResponse get_notification_events_count(NotificationEventsCountRequest rqst) throws TException {
            try {
                this.authorizeProxyPrivilege();
            }
            catch (Exception ex) {
                LOG.error("Not authorized to make the get_notification_events_count call. You can try to disable " + MetastoreConf.ConfVars.EVENT_DB_NOTIFICATION_API_AUTH.toString(), (Throwable)ex);
                throw new TException(ex);
            }
            RawStore ms = this.getMS();
            return ms.getNotificationEventsCount(rqst);
        }

        private void authorizeProxyPrivilege() throws Exception {
            if (!HiveMetaStore.isMetaStoreRemote() || !MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.EVENT_DB_NOTIFICATION_API_AUTH)) {
                return;
            }
            String user = null;
            try {
                user = SecurityUtils.getUGI().getShortUserName();
            }
            catch (Exception ex) {
                LOG.error("Cannot obtain username", (Throwable)ex);
                throw ex;
            }
            if (!MetaStoreUtils.checkUserHasHostProxyPrivileges(user, this.conf, HMSHandler.getIPAddress())) {
                throw new MetaException("User " + user + " is not allowed to perform this API call");
            }
        }

        @Override
        public FireEventResponse fire_listener_event(FireEventRequest rqst) throws TException {
            switch ((FireEventRequestData._Fields)rqst.getData().getSetField()) {
                case INSERT_DATA: {
                    String catName = rqst.isSetCatName() ? rqst.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
                    InsertEvent event = new InsertEvent(catName, rqst.getDbName(), rqst.getTableName(), rqst.getPartitionVals(), rqst.getData().getInsertData(), rqst.isSuccessful(), this);
                    MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.INSERT, event);
                    MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.INSERT, event);
                    return new FireEventResponse();
                }
            }
            throw new TException("Event type " + ((FireEventRequestData._Fields)rqst.getData().getSetField()).toString() + " not currently supported.");
        }

        @Override
        public GetFileMetadataByExprResult get_file_metadata_by_expr(GetFileMetadataByExprRequest req) throws TException {
            GetFileMetadataByExprResult result = new GetFileMetadataByExprResult();
            RawStore ms = this.getMS();
            if (!ms.isFileMetadataSupported()) {
                result.setIsSupported(false);
                result.setMetadata(EMPTY_MAP_FM2);
                return result;
            }
            result.setIsSupported(true);
            List<Long> fileIds = req.getFileIds();
            boolean needMetadata = !req.isSetDoGetFooters() || req.isDoGetFooters();
            FileMetadataExprType type = req.isSetType() ? req.getType() : FileMetadataExprType.ORC_SARG;
            ByteBuffer[] metadatas = needMetadata ? new ByteBuffer[fileIds.size()] : null;
            ByteBuffer[] ppdResults = new ByteBuffer[fileIds.size()];
            boolean[] eliminated = new boolean[fileIds.size()];
            this.getMS().getFileMetadataByExpr(fileIds, type, req.getExpr(), metadatas, ppdResults, eliminated);
            for (int i = 0; i < fileIds.size(); ++i) {
                if (!eliminated[i] && ppdResults[i] == null) continue;
                MetadataPpdResult mpr = new MetadataPpdResult();
                ByteBuffer ppdResult = eliminated[i] ? null : this.handleReadOnlyBufferForThrift(ppdResults[i]);
                mpr.setIncludeBitset(ppdResult);
                if (needMetadata) {
                    ByteBuffer metadata = eliminated[i] ? null : this.handleReadOnlyBufferForThrift(metadatas[i]);
                    mpr.setMetadata(metadata);
                }
                result.putToMetadata(fileIds.get(i), mpr);
            }
            if (!result.isSetMetadata()) {
                result.setMetadata(EMPTY_MAP_FM2);
            }
            return result;
        }

        @Override
        public GetFileMetadataResult get_file_metadata(GetFileMetadataRequest req) throws TException {
            GetFileMetadataResult result = new GetFileMetadataResult();
            RawStore ms = this.getMS();
            if (!ms.isFileMetadataSupported()) {
                result.setIsSupported(false);
                result.setMetadata(EMPTY_MAP_FM1);
                return result;
            }
            result.setIsSupported(true);
            List<Long> fileIds = req.getFileIds();
            ByteBuffer[] metadatas = ms.getFileMetadata(fileIds);
            assert (metadatas.length == fileIds.size());
            for (int i = 0; i < metadatas.length; ++i) {
                ByteBuffer bb = metadatas[i];
                if (bb == null) continue;
                bb = this.handleReadOnlyBufferForThrift(bb);
                result.putToMetadata(fileIds.get(i), bb);
            }
            if (!result.isSetMetadata()) {
                result.setMetadata(EMPTY_MAP_FM1);
            }
            return result;
        }

        private ByteBuffer handleReadOnlyBufferForThrift(ByteBuffer bb) {
            if (!bb.isReadOnly()) {
                return bb;
            }
            ByteBuffer copy = ByteBuffer.allocate(bb.capacity());
            copy.put(bb);
            copy.flip();
            return copy;
        }

        @Override
        public PutFileMetadataResult put_file_metadata(PutFileMetadataRequest req) throws TException {
            RawStore ms = this.getMS();
            if (ms.isFileMetadataSupported()) {
                ms.putFileMetadata(req.getFileIds(), req.getMetadata(), req.getType());
            }
            return new PutFileMetadataResult();
        }

        @Override
        public ClearFileMetadataResult clear_file_metadata(ClearFileMetadataRequest req) throws TException {
            this.getMS().putFileMetadata(req.getFileIds(), null, null);
            return new ClearFileMetadataResult();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CacheFileMetadataResult cache_file_metadata(CacheFileMetadataRequest req) throws TException {
            RawStore ms = this.getMS();
            if (!ms.isFileMetadataSupported()) {
                return new CacheFileMetadataResult(false);
            }
            String dbName = req.getDbName();
            String tblName = req.getTblName();
            String partName = req.isSetPartName() ? req.getPartName() : null;
            boolean isAllPart = req.isSetIsAllParts() && req.isIsAllParts();
            ms.openTransaction();
            boolean success = false;
            try {
                String tableInputFormat;
                Table tbl = ms.getTable("hive", dbName, tblName);
                if (tbl == null) {
                    throw new NoSuchObjectException(dbName + "." + tblName + " not found");
                }
                boolean isPartitioned = tbl.isSetPartitionKeys() && tbl.getPartitionKeysSize() > 0;
                String string = tableInputFormat = tbl.isSetSd() ? tbl.getSd().getInputFormat() : null;
                if (!isPartitioned) {
                    if (partName != null || isAllPart) {
                        throw new MetaException("Table is not partitioned");
                    }
                    if (!tbl.isSetSd() || !tbl.getSd().isSetLocation()) {
                        throw new MetaException("Table does not have storage location; this operation is not supported on views");
                    }
                    FileMetadataExprType type = this.expressionProxy.getMetadataType(tableInputFormat);
                    if (type == null) {
                        throw new MetaException("The operation is not supported for " + tableInputFormat);
                    }
                    this.fileMetadataManager.queueCacheMetadata(tbl.getSd().getLocation(), type);
                    success = true;
                } else {
                    List<String> partNames;
                    if (partName != null) {
                        partNames = Lists.newArrayList(partName);
                    } else if (isAllPart) {
                        partNames = ms.listPartitionNames("hive", dbName, tblName, (short)-1);
                    } else {
                        throw new MetaException("Table is partitioned");
                    }
                    int batchSize = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.BATCH_RETRIEVE_OBJECTS_MAX);
                    int index = 0;
                    int successCount = 0;
                    int failCount = 0;
                    HashSet<String> failFormats = null;
                    while (index < partNames.size()) {
                        int currentBatchSize = Math.min(batchSize, partNames.size() - index);
                        List<String> nameBatch = partNames.subList(index, index + currentBatchSize);
                        index += currentBatchSize;
                        List<Partition> parts = ms.getPartitionsByNames("hive", dbName, tblName, nameBatch);
                        for (Partition part : parts) {
                            if (!part.isSetSd() || !part.getSd().isSetLocation()) {
                                throw new MetaException("Partition does not have storage location; this operation is not supported on views");
                            }
                            String inputFormat = part.getSd().isSetInputFormat() ? part.getSd().getInputFormat() : tableInputFormat;
                            FileMetadataExprType type = this.expressionProxy.getMetadataType(inputFormat);
                            if (type == null) {
                                ++failCount;
                                if (failFormats == null) {
                                    failFormats = new HashSet<String>();
                                }
                                failFormats.add(inputFormat);
                                continue;
                            }
                            ++successCount;
                            this.fileMetadataManager.queueCacheMetadata(part.getSd().getLocation(), type);
                        }
                    }
                    success = true;
                    if (failCount > 0) {
                        String errorMsg = "The operation failed for " + failCount + " partitions and succeeded for " + successCount + " partitions; unsupported formats: ";
                        boolean isFirst = true;
                        for (String s : failFormats) {
                            if (!isFirst) {
                                errorMsg = errorMsg + ", ";
                            }
                            isFirst = false;
                            errorMsg = errorMsg + s;
                        }
                        throw new MetaException(errorMsg);
                    }
                }
            }
            finally {
                if (success) {
                    if (!ms.commitTransaction()) {
                        throw new MetaException("Failed to commit");
                    }
                } else {
                    ms.rollbackTransaction();
                }
            }
            return new CacheFileMetadataResult(true);
        }

        @VisibleForTesting
        void updateMetrics() throws MetaException {
            if (databaseCount != null) {
                tableCount.set(this.getMS().getTableCount());
                partCount.set(this.getMS().getPartitionCount());
                databaseCount.set(this.getMS().getDatabaseCount());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PrimaryKeysResponse get_primary_keys(PrimaryKeysRequest request) throws TException {
            String catName = request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String db_name = request.getDb_name();
            String tbl_name = request.getTbl_name();
            this.startTableFunction("get_primary_keys", catName, db_name, tbl_name);
            List<SQLPrimaryKey> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getPrimaryKeys(catName, db_name, tbl_name);
                this.endFunction("get_primary_keys", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.throwMetaException(e);
                    this.endFunction("get_primary_keys", ret != null, ex, tbl_name);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_primary_keys", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return new PrimaryKeysResponse(ret);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ForeignKeysResponse get_foreign_keys(ForeignKeysRequest request) throws TException {
            String catName = request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String parent_db_name = request.getParent_db_name();
            String parent_tbl_name = request.getParent_tbl_name();
            String foreign_db_name = request.getForeign_db_name();
            String foreign_tbl_name = request.getForeign_tbl_name();
            this.startFunction("get_foreign_keys", " : parentdb=" + parent_db_name + " parenttbl=" + parent_tbl_name + " foreigndb=" + foreign_db_name + " foreigntbl=" + foreign_tbl_name);
            List<SQLForeignKey> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getForeignKeys(catName, parent_db_name, parent_tbl_name, foreign_db_name, foreign_tbl_name);
                this.endFunction("get_foreign_keys", ret != null, ex, foreign_tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    this.throwMetaException(e);
                    this.endFunction("get_foreign_keys", ret != null, ex, foreign_tbl_name);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_foreign_keys", ret != null, ex, foreign_tbl_name);
                    throw throwable;
                }
            }
            return new ForeignKeysResponse(ret);
        }

        private void throwMetaException(Exception e) throws MetaException, NoSuchObjectException {
            if (e instanceof MetaException) {
                throw (MetaException)e;
            }
            if (e instanceof NoSuchObjectException) {
                throw (NoSuchObjectException)e;
            }
            throw HMSHandler.newMetaException(e);
        }

        @Override
        public UniqueConstraintsResponse get_unique_constraints(UniqueConstraintsRequest request) throws TException {
            String catName = request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String db_name = request.getDb_name();
            String tbl_name = request.getTbl_name();
            this.startTableFunction("get_unique_constraints", catName, db_name, tbl_name);
            List<SQLUniqueConstraint> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getUniqueConstraints(catName, db_name, tbl_name);
                this.endFunction("get_unique_constraints", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_unique_constraints", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return new UniqueConstraintsResponse(ret);
        }

        @Override
        public NotNullConstraintsResponse get_not_null_constraints(NotNullConstraintsRequest request) throws TException {
            String catName = request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String db_name = request.getDb_name();
            String tbl_name = request.getTbl_name();
            this.startTableFunction("get_not_null_constraints", catName, db_name, tbl_name);
            List<SQLNotNullConstraint> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getNotNullConstraints(catName, db_name, tbl_name);
                this.endFunction("get_not_null_constraints", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_not_null_constraints", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return new NotNullConstraintsResponse(ret);
        }

        @Override
        public DefaultConstraintsResponse get_default_constraints(DefaultConstraintsRequest request) throws TException {
            String catName = request.isSetCatName() ? request.getCatName() : MetaStoreUtils.getDefaultCatalog(this.conf);
            String db_name = request.getDb_name();
            String tbl_name = request.getTbl_name();
            this.startTableFunction("get_default_constraints", catName, db_name, tbl_name);
            List<SQLDefaultConstraint> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getDefaultConstraints(catName, db_name, tbl_name);
                this.endFunction("get_default_constraints", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_default_constraints", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return new DefaultConstraintsResponse(ret);
        }

        @Override
        public CheckConstraintsResponse get_check_constraints(CheckConstraintsRequest request) throws TException {
            String catName = request.getCatName();
            String db_name = request.getDb_name();
            String tbl_name = request.getTbl_name();
            this.startTableFunction("get_check_constraints", catName, db_name, tbl_name);
            List<SQLCheckConstraint> ret = null;
            Exception ex = null;
            try {
                ret = this.getMS().getCheckConstraints(catName, db_name, tbl_name);
                this.endFunction("get_check_constraints", ret != null, ex, tbl_name);
            }
            catch (Exception e) {
                try {
                    ex = e;
                    if (e instanceof MetaException) {
                        throw (MetaException)e;
                    }
                    throw HMSHandler.newMetaException(e);
                }
                catch (Throwable throwable) {
                    this.endFunction("get_check_constraints", ret != null, ex, tbl_name);
                    throw throwable;
                }
            }
            return new CheckConstraintsResponse(ret);
        }

        @Override
        public String get_metastore_db_uuid() throws TException {
            try {
                return this.getMS().getMetastoreDbUuid();
            }
            catch (MetaException e) {
                LOG.error("Exception thrown while querying metastore db uuid", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMCreateResourcePlanResponse create_resource_plan(WMCreateResourcePlanRequest request) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
            int defaultPoolSize = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.WM_DEFAULT_POOL_SIZE);
            WMResourcePlan plan = request.getResourcePlan();
            if (defaultPoolSize > 0 && plan.isSetQueryParallelism()) {
                defaultPoolSize = plan.getQueryParallelism();
            }
            try {
                this.getMS().createResourcePlan(plan, request.getCopyFrom(), defaultPoolSize);
                return new WMCreateResourcePlanResponse();
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to persist resource plan", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMGetResourcePlanResponse get_resource_plan(WMGetResourcePlanRequest request) throws NoSuchObjectException, MetaException, TException {
            try {
                WMFullResourcePlan rp = this.getMS().getResourcePlan(request.getResourcePlanName());
                WMGetResourcePlanResponse resp = new WMGetResourcePlanResponse();
                resp.setResourcePlan(rp);
                return resp;
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to retrieve resource plan", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMGetAllResourcePlanResponse get_all_resource_plans(WMGetAllResourcePlanRequest request) throws MetaException, TException {
            try {
                WMGetAllResourcePlanResponse resp = new WMGetAllResourcePlanResponse();
                resp.setResourcePlans(this.getMS().getAllResourcePlans());
                return resp;
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to retrieve resource plans", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMAlterResourcePlanResponse alter_resource_plan(WMAlterResourcePlanRequest request) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
            try {
                if ((request.isIsEnableAndActivate() ? 1 : 0) + (request.isIsReplace() ? 1 : 0) + (request.isIsForceDeactivate() ? 1 : 0) > 1) {
                    throw new MetaException("Invalid request; multiple flags are set");
                }
                WMAlterResourcePlanResponse response = new WMAlterResourcePlanResponse();
                WMFullResourcePlan fullPlanAfterAlter = this.getMS().alterResourcePlan(request.getResourcePlanName(), request.getResourcePlan(), request.isIsEnableAndActivate(), request.isIsForceDeactivate(), request.isIsReplace());
                if (fullPlanAfterAlter != null) {
                    response.setFullResourcePlan(fullPlanAfterAlter);
                }
                return response;
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to alter resource plan", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMGetActiveResourcePlanResponse get_active_resource_plan(WMGetActiveResourcePlanRequest request) throws MetaException, TException {
            try {
                WMGetActiveResourcePlanResponse response = new WMGetActiveResourcePlanResponse();
                response.setResourcePlan(this.getMS().getActiveResourcePlan());
                return response;
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to get active resource plan", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMValidateResourcePlanResponse validate_resource_plan(WMValidateResourcePlanRequest request) throws NoSuchObjectException, MetaException, TException {
            try {
                return this.getMS().validateResourcePlan(request.getResourcePlanName());
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to validate resource plan", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMDropResourcePlanResponse drop_resource_plan(WMDropResourcePlanRequest request) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
            try {
                this.getMS().dropResourcePlan(request.getResourcePlanName());
                return new WMDropResourcePlanResponse();
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to drop resource plan", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMCreateTriggerResponse create_wm_trigger(WMCreateTriggerRequest request) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
            try {
                this.getMS().createWMTrigger(request.getTrigger());
                return new WMCreateTriggerResponse();
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to create trigger", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMAlterTriggerResponse alter_wm_trigger(WMAlterTriggerRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
            try {
                this.getMS().alterWMTrigger(request.getTrigger());
                return new WMAlterTriggerResponse();
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to alter trigger", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMDropTriggerResponse drop_wm_trigger(WMDropTriggerRequest request) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
            try {
                this.getMS().dropWMTrigger(request.getResourcePlanName(), request.getTriggerName());
                return new WMDropTriggerResponse();
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to drop trigger.", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMGetTriggersForResourePlanResponse get_triggers_for_resourceplan(WMGetTriggersForResourePlanRequest request) throws NoSuchObjectException, MetaException, TException {
            try {
                List<WMTrigger> triggers = this.getMS().getTriggersForResourcePlan(request.getResourcePlanName());
                WMGetTriggersForResourePlanResponse response = new WMGetTriggersForResourePlanResponse();
                response.setTriggers(triggers);
                return response;
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to retrieve triggers plans", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMAlterPoolResponse alter_wm_pool(WMAlterPoolRequest request) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
            try {
                this.getMS().alterPool(request.getPool(), request.getPoolPath());
                return new WMAlterPoolResponse();
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to alter WMPool", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMCreatePoolResponse create_wm_pool(WMCreatePoolRequest request) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
            try {
                this.getMS().createPool(request.getPool());
                return new WMCreatePoolResponse();
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to create WMPool", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMDropPoolResponse drop_wm_pool(WMDropPoolRequest request) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
            try {
                this.getMS().dropWMPool(request.getResourcePlanName(), request.getPoolPath());
                return new WMDropPoolResponse();
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to drop WMPool", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMCreateOrUpdateMappingResponse create_or_update_wm_mapping(WMCreateOrUpdateMappingRequest request) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
            try {
                this.getMS().createOrUpdateWMMapping(request.getMapping(), request.isUpdate());
                return new WMCreateOrUpdateMappingResponse();
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to create or update WMMapping", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMDropMappingResponse drop_wm_mapping(WMDropMappingRequest request) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
            try {
                this.getMS().dropWMMapping(request.getMapping());
                return new WMDropMappingResponse();
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to drop WMMapping", (Throwable)e);
                throw e;
            }
        }

        @Override
        public WMCreateOrDropTriggerToPoolMappingResponse create_or_drop_wm_trigger_to_pool_mapping(WMCreateOrDropTriggerToPoolMappingRequest request) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
            try {
                if (request.isDrop()) {
                    this.getMS().dropWMTriggerToPoolMapping(request.getResourcePlanName(), request.getTriggerName(), request.getPoolPath());
                } else {
                    this.getMS().createWMTriggerToPoolMapping(request.getResourcePlanName(), request.getTriggerName(), request.getPoolPath());
                }
                return new WMCreateOrDropTriggerToPoolMappingResponse();
            }
            catch (MetaException e) {
                LOG.error("Exception while trying to create or drop pool mappings", (Throwable)e);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void create_ischema(ISchema schema) throws TException {
            this.startFunction("create_ischema", ": " + schema.getName());
            boolean success = false;
            TException ex = null;
            RawStore ms = this.getMS();
            try {
                this.firePreEvent(new PreCreateISchemaEvent(this, schema));
                Map<String, String> transactionalListenersResponses = Collections.emptyMap();
                ms.openTransaction();
                try {
                    ms.createISchema(schema);
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.CREATE_ISCHEMA, new CreateISchemaEvent(true, this, schema));
                    }
                    success = ms.commitTransaction();
                }
                finally {
                    if (!success) {
                        ms.rollbackTransaction();
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.CREATE_ISCHEMA, new CreateISchemaEvent(success, this, schema), null, transactionalListenersResponses, ms);
                    }
                }
                this.endFunction("create_ischema", success, ex);
            }
            catch (AlreadyExistsException | MetaException e) {
                try {
                    LOG.error("Caught exception creating schema", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("create_ischema", success, ex);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void alter_ischema(AlterISchemaRequest rqst) throws TException {
            this.startFunction("alter_ischema", ": " + rqst);
            boolean success = false;
            TException ex = null;
            RawStore ms = this.getMS();
            try {
                ISchema oldSchema = ms.getISchema(rqst.getName());
                if (oldSchema == null) {
                    throw new NoSuchObjectException("Could not find schema " + rqst.getName());
                }
                this.firePreEvent(new PreAlterISchemaEvent(this, oldSchema, rqst.getNewSchema()));
                Map<String, String> transactionalListenersResponses = Collections.emptyMap();
                ms.openTransaction();
                try {
                    ms.alterISchema(rqst.getName(), rqst.getNewSchema());
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_ISCHEMA, new AlterISchemaEvent(true, this, oldSchema, rqst.getNewSchema()));
                    }
                    success = ms.commitTransaction();
                }
                finally {
                    if (!success) {
                        ms.rollbackTransaction();
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_ISCHEMA, new AlterISchemaEvent(success, this, oldSchema, rqst.getNewSchema()), null, transactionalListenersResponses, ms);
                    }
                }
                this.endFunction("alter_ischema", success, ex);
            }
            catch (MetaException | NoSuchObjectException e) {
                try {
                    LOG.error("Caught exception altering schema", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("alter_ischema", success, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public ISchema get_ischema(ISchemaName schemaName) throws TException {
            this.startFunction("get_ischema", ": " + schemaName);
            MetaException ex = null;
            ISchema schema = null;
            try {
                schema = this.getMS().getISchema(schemaName);
                if (schema == null) {
                    throw new NoSuchObjectException("No schema named " + schemaName + " exists");
                }
                this.firePreEvent(new PreReadISchemaEvent(this, schema));
                ISchema iSchema = schema;
                this.endFunction("get_ischema", schema != null, ex);
                return iSchema;
            }
            catch (MetaException e) {
                try {
                    LOG.error("Caught exception getting schema", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_ischema", schema != null, ex);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop_ischema(ISchemaName schemaName) throws TException {
            this.startFunction("drop_ischema", ": " + schemaName);
            TException ex = null;
            boolean success = false;
            RawStore ms = this.getMS();
            try {
                SchemaVersion latest = ms.getLatestSchemaVersion(schemaName);
                if (latest != null) {
                    ex = new InvalidOperationException("Schema " + schemaName + " cannot be dropped, it has at least one valid version");
                    throw (InvalidObjectException)ex;
                }
                ISchema schema = ms.getISchema(schemaName);
                this.firePreEvent(new PreDropISchemaEvent(this, schema));
                Map<String, String> transactionalListenersResponses = Collections.emptyMap();
                ms.openTransaction();
                try {
                    ms.dropISchema(schemaName);
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_ISCHEMA, new DropISchemaEvent(true, this, schema));
                    }
                    success = ms.commitTransaction();
                }
                finally {
                    if (!success) {
                        ms.rollbackTransaction();
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_ISCHEMA, new DropISchemaEvent(success, this, schema), null, transactionalListenersResponses, ms);
                    }
                }
                this.endFunction("drop_ischema", success, ex);
            }
            catch (MetaException | NoSuchObjectException e) {
                try {
                    LOG.error("Caught exception dropping schema", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("drop_ischema", success, ex);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add_schema_version(SchemaVersion schemaVersion) throws TException {
            this.startFunction("add_schema_version", ": " + schemaVersion);
            boolean success = false;
            TException ex = null;
            RawStore ms = this.getMS();
            try {
                if (ms.getISchema(schemaVersion.getSchema()) == null) {
                    throw new NoSuchObjectException("No schema named " + schemaVersion.getSchema());
                }
                this.firePreEvent(new PreAddSchemaVersionEvent(this, schemaVersion));
                Map<String, String> transactionalListenersResponses = Collections.emptyMap();
                ms.openTransaction();
                try {
                    ms.addSchemaVersion(schemaVersion);
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ADD_SCHEMA_VERSION, new AddSchemaVersionEvent(true, this, schemaVersion));
                    }
                    success = ms.commitTransaction();
                }
                finally {
                    if (!success) {
                        ms.rollbackTransaction();
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ADD_SCHEMA_VERSION, new AddSchemaVersionEvent(success, this, schemaVersion), null, transactionalListenersResponses, ms);
                    }
                }
                this.endFunction("add_schema_version", success, ex);
            }
            catch (AlreadyExistsException | MetaException e) {
                try {
                    LOG.error("Caught exception adding schema version", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("add_schema_version", success, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public SchemaVersion get_schema_version(SchemaVersionDescriptor version) throws TException {
            this.startFunction("get_schema_version", ": " + version);
            MetaException ex = null;
            SchemaVersion schemaVersion = null;
            try {
                schemaVersion = this.getMS().getSchemaVersion(version);
                if (schemaVersion == null) {
                    throw new NoSuchObjectException("No schema version " + version + "exists");
                }
                this.firePreEvent(new PreReadhSchemaVersionEvent(this, Collections.singletonList(schemaVersion)));
                SchemaVersion schemaVersion2 = schemaVersion;
                this.endFunction("get_schema_version", schemaVersion != null, ex);
                return schemaVersion2;
            }
            catch (MetaException e) {
                try {
                    LOG.error("Caught exception getting schema version", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_schema_version", schemaVersion != null, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public SchemaVersion get_schema_latest_version(ISchemaName schemaName) throws TException {
            this.startFunction("get_latest_schema_version", ": " + schemaName);
            MetaException ex = null;
            SchemaVersion schemaVersion = null;
            try {
                schemaVersion = this.getMS().getLatestSchemaVersion(schemaName);
                if (schemaVersion == null) {
                    throw new NoSuchObjectException("No versions of schema " + schemaName + "exist");
                }
                this.firePreEvent(new PreReadhSchemaVersionEvent(this, Collections.singletonList(schemaVersion)));
                SchemaVersion schemaVersion2 = schemaVersion;
                this.endFunction("get_latest_schema_version", schemaVersion != null, ex);
                return schemaVersion2;
            }
            catch (MetaException e) {
                try {
                    LOG.error("Caught exception getting latest schema version", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_latest_schema_version", schemaVersion != null, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public List<SchemaVersion> get_schema_all_versions(ISchemaName schemaName) throws TException {
            this.startFunction("get_all_schema_versions", ": " + schemaName);
            MetaException ex = null;
            List<SchemaVersion> schemaVersions = null;
            try {
                schemaVersions = this.getMS().getAllSchemaVersion(schemaName);
                if (schemaVersions == null) {
                    throw new NoSuchObjectException("No versions of schema " + schemaName + "exist");
                }
                this.firePreEvent(new PreReadhSchemaVersionEvent(this, schemaVersions));
                List<SchemaVersion> list = schemaVersions;
                this.endFunction("get_all_schema_versions", schemaVersions != null, ex);
                return list;
            }
            catch (MetaException e) {
                try {
                    LOG.error("Caught exception getting all schema versions", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_all_schema_versions", schemaVersions != null, ex);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop_schema_version(SchemaVersionDescriptor version) throws TException {
            this.startFunction("drop_schema_version", ": " + version);
            TException ex = null;
            boolean success = false;
            RawStore ms = this.getMS();
            try {
                SchemaVersion schemaVersion = ms.getSchemaVersion(version);
                if (schemaVersion == null) {
                    throw new NoSuchObjectException("No schema version " + version);
                }
                this.firePreEvent(new PreDropSchemaVersionEvent(this, schemaVersion));
                Map<String, String> transactionalListenersResponses = Collections.emptyMap();
                ms.openTransaction();
                try {
                    ms.dropSchemaVersion(version);
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.DROP_SCHEMA_VERSION, new DropSchemaVersionEvent(true, this, schemaVersion));
                    }
                    success = ms.commitTransaction();
                }
                finally {
                    if (!success) {
                        ms.rollbackTransaction();
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.DROP_SCHEMA_VERSION, new DropSchemaVersionEvent(success, this, schemaVersion), null, transactionalListenersResponses, ms);
                    }
                }
                this.endFunction("drop_schema_version", success, ex);
            }
            catch (MetaException | NoSuchObjectException e) {
                try {
                    LOG.error("Caught exception dropping schema version", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("drop_schema_version", success, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public FindSchemasByColsResp get_schemas_by_cols(FindSchemasByColsRqst rqst) throws TException {
            this.startFunction("get_schemas_by_cols");
            MetaException ex = null;
            List<SchemaVersion> schemaVersions = Collections.emptyList();
            try {
                schemaVersions = this.getMS().getSchemaVersionsByColumns(rqst.getColName(), rqst.getColNamespace(), rqst.getType());
                this.firePreEvent(new PreReadhSchemaVersionEvent(this, schemaVersions));
                ArrayList<SchemaVersionDescriptor> entries = new ArrayList<SchemaVersionDescriptor>(schemaVersions.size());
                schemaVersions.forEach(schemaVersion -> entries.add(new SchemaVersionDescriptor(schemaVersion.getSchema(), schemaVersion.getVersion())));
                FindSchemasByColsResp findSchemasByColsResp = new FindSchemasByColsResp(entries);
                this.endFunction("get_schemas_by_cols", !schemaVersions.isEmpty(), ex);
                return findSchemasByColsResp;
            }
            catch (MetaException e) {
                try {
                    LOG.error("Caught exception doing schema version query", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_schemas_by_cols", !schemaVersions.isEmpty(), ex);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void map_schema_version_to_serde(MapSchemaVersionToSerdeRequest rqst) throws TException {
            this.startFunction("map_schema_version_to_serde, :" + rqst);
            boolean success = false;
            TException ex = null;
            RawStore ms = this.getMS();
            try {
                SchemaVersion oldSchemaVersion = ms.getSchemaVersion(rqst.getSchemaVersion());
                if (oldSchemaVersion == null) {
                    throw new NoSuchObjectException("No schema version " + rqst.getSchemaVersion());
                }
                SerDeInfo serde = ms.getSerDeInfo(rqst.getSerdeName());
                if (serde == null) {
                    throw new NoSuchObjectException("No SerDe named " + rqst.getSerdeName());
                }
                SchemaVersion newSchemaVersion = new SchemaVersion(oldSchemaVersion);
                newSchemaVersion.setSerDe(serde);
                this.firePreEvent(new PreAlterSchemaVersionEvent(this, oldSchemaVersion, newSchemaVersion));
                Map<String, String> transactionalListenersResponses = Collections.emptyMap();
                ms.openTransaction();
                try {
                    ms.alterSchemaVersion(rqst.getSchemaVersion(), newSchemaVersion);
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_SCHEMA_VERSION, new AlterSchemaVersionEvent(true, this, oldSchemaVersion, newSchemaVersion));
                    }
                    success = ms.commitTransaction();
                }
                finally {
                    if (!success) {
                        ms.rollbackTransaction();
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_SCHEMA_VERSION, new AlterSchemaVersionEvent(success, this, oldSchemaVersion, newSchemaVersion), null, transactionalListenersResponses, ms);
                    }
                }
                this.endFunction("map_schema_version_to_serde", success, ex);
            }
            catch (MetaException | NoSuchObjectException e) {
                try {
                    LOG.error("Caught exception mapping schema version to serde", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("map_schema_version_to_serde", success, ex);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_schema_version_state(SetSchemaVersionStateRequest rqst) throws TException {
            this.startFunction("set_schema_version_state, :" + rqst);
            boolean success = false;
            TException ex = null;
            RawStore ms = this.getMS();
            try {
                SchemaVersion oldSchemaVersion = ms.getSchemaVersion(rqst.getSchemaVersion());
                if (oldSchemaVersion == null) {
                    throw new NoSuchObjectException("No schema version " + rqst.getSchemaVersion());
                }
                SchemaVersion newSchemaVersion = new SchemaVersion(oldSchemaVersion);
                newSchemaVersion.setState(rqst.getState());
                this.firePreEvent(new PreAlterSchemaVersionEvent(this, oldSchemaVersion, newSchemaVersion));
                Map<String, String> transactionalListenersResponses = Collections.emptyMap();
                ms.openTransaction();
                try {
                    ms.alterSchemaVersion(rqst.getSchemaVersion(), newSchemaVersion);
                    if (!this.transactionalListeners.isEmpty()) {
                        transactionalListenersResponses = MetaStoreListenerNotifier.notifyEvent(this.transactionalListeners, EventMessage.EventType.ALTER_SCHEMA_VERSION, new AlterSchemaVersionEvent(true, this, oldSchemaVersion, newSchemaVersion));
                    }
                    success = ms.commitTransaction();
                }
                finally {
                    if (!success) {
                        ms.rollbackTransaction();
                    }
                    if (!this.listeners.isEmpty()) {
                        MetaStoreListenerNotifier.notifyEvent(this.listeners, EventMessage.EventType.ALTER_SCHEMA_VERSION, new AlterSchemaVersionEvent(success, this, oldSchemaVersion, newSchemaVersion), null, transactionalListenersResponses, ms);
                    }
                }
                this.endFunction("set_schema_version_state", success, ex);
            }
            catch (MetaException | NoSuchObjectException e) {
                try {
                    LOG.error("Caught exception changing schema version state", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("set_schema_version_state", success, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public void add_serde(SerDeInfo serde) throws TException {
            this.startFunction("create_serde", ": " + serde.getName());
            TException ex = null;
            boolean success = false;
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                ms.addSerde(serde);
                success = ms.commitTransaction();
            }
            catch (AlreadyExistsException | MetaException e) {
                LOG.error("Caught exception creating serde", (Throwable)e);
                ex = e;
                throw e;
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                this.endFunction("create_serde", success, ex);
            }
        }

        @Override
        public SerDeInfo get_serde(GetSerdeRequest rqst) throws TException {
            this.startFunction("get_serde", ": " + rqst);
            MetaException ex = null;
            SerDeInfo serde = null;
            try {
                serde = this.getMS().getSerDeInfo(rqst.getSerdeName());
                if (serde == null) {
                    throw new NoSuchObjectException("No serde named " + rqst.getSerdeName() + " exists");
                }
                SerDeInfo serDeInfo = serde;
                this.endFunction("get_serde", serde != null, ex);
                return serDeInfo;
            }
            catch (MetaException e) {
                try {
                    LOG.error("Caught exception getting serde", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_serde", serde != null, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public LockResponse get_lock_materialization_rebuild(String dbName, String tableName, long txnId) throws TException {
            return this.getTxnHandler().lockMaterializationRebuild(dbName, tableName, txnId);
        }

        @Override
        public boolean heartbeat_lock_materialization_rebuild(String dbName, String tableName, long txnId) throws TException {
            return this.getTxnHandler().heartbeatLockMaterializationRebuild(dbName, tableName, txnId);
        }

        @Override
        public void add_runtime_stats(RuntimeStat stat) throws TException {
            this.startFunction("store_runtime_stats");
            Exception ex = null;
            boolean success = false;
            RawStore ms = this.getMS();
            try {
                ms.openTransaction();
                ms.addRuntimeStat(stat);
                success = ms.commitTransaction();
            }
            catch (Exception e) {
                LOG.error("Caught exception", (Throwable)e);
                ex = e;
                throw e;
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
                this.endFunction("store_runtime_stats", success, ex);
            }
        }

        @Override
        public List<RuntimeStat> get_runtime_stats(GetRuntimeStatsRequest rqst) throws TException {
            this.startFunction("get_runtime_stats");
            MetaException ex = null;
            try {
                List<RuntimeStat> res;
                List<RuntimeStat> list = res = this.getMS().getRuntimeStats(rqst.getMaxWeight(), rqst.getMaxCreateTime());
                this.endFunction("get_runtime_stats", ex == null, ex);
                return list;
            }
            catch (MetaException e) {
                try {
                    LOG.error("Caught exception", (Throwable)e);
                    ex = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    this.endFunction("get_runtime_stats", ex == null, ex);
                    throw throwable;
                }
            }
        }

        @Override
        public boolean init_schema(String dbType, String username, String password) throws MetaException {
            try {
                this.authorizeProxyPrivilege();
                String[] args = new String[]{"-initSchema", "-dbType", dbType, "-userName", username, "-passWord", password};
                MetastoreSchemaTool.main(args);
                return true;
            }
            catch (Exception e) {
                throw new MetaException("init_schema failed: " + e.getMessage());
            }
        }

        static {
            threadLocalMS = new ThreadLocal<RawStore>(){

                @Override
                protected RawStore initialValue() {
                    return null;
                }
            };
            threadLocalTxn = new ThreadLocal<TxnStore>(){

                @Override
                protected TxnStore initialValue() {
                    return null;
                }
            };
            timerContexts = new ThreadLocal<Map<String, Timer.Context>>(){

                @Override
                protected Map<String, Timer.Context> initialValue() {
                    return new HashMap<String, Timer.Context>();
                }
            };
            threadLocalConf = new ThreadLocal<Configuration>(){

                @Override
                protected Configuration initialValue() {
                    return null;
                }
            };
            threadLocalHMSHandler = new ThreadLocal();
            threadLocalModifiedConfig = new ThreadLocal();
            auditLog = LoggerFactory.getLogger((String)(HiveMetaStore.class.getName() + ".audit"));
            nextSerialNum = 0;
            threadLocalId = new ThreadLocal<Integer>(){

                @Override
                protected Integer initialValue() {
                    return nextSerialNum++;
                }
            };
            threadLocalIpAddress = new ThreadLocal<String>(){

                @Override
                protected String initialValue() {
                    return null;
                }
            };
            EMPTY_MAP_FM1 = new HashMap<Long, ByteBuffer>(1);
            EMPTY_MAP_FM2 = new HashMap<Long, MetadataPpdResult>(1);
        }

        private static class StorageDescriptorKey {
            private final StorageDescriptor sd;

            StorageDescriptorKey(StorageDescriptor sd) {
                this.sd = sd;
            }

            StorageDescriptor getSd() {
                return this.sd;
            }

            private String hashCodeKey() {
                return this.sd.getInputFormat() + "\t" + this.sd.getOutputFormat() + "\t" + this.sd.getSerdeInfo().getSerializationLib() + "\t" + this.sd.getCols();
            }

            public int hashCode() {
                return this.hashCodeKey().hashCode();
            }

            public boolean equals(Object rhs) {
                if (rhs == this) {
                    return true;
                }
                if (!(rhs instanceof StorageDescriptorKey)) {
                    return false;
                }
                return this.hashCodeKey().equals(((StorageDescriptorKey)rhs).hashCodeKey());
            }
        }

        private static class PathAndPartValSize {
            public Path path;
            int partValSize;

            PathAndPartValSize(Path path, int partValSize) {
                this.path = path;
                this.partValSize = partValSize;
            }
        }

        private static class PartValEqWrapperLite {
            List<String> values;
            String location;

            PartValEqWrapperLite(Partition partition) {
                this.values = partition.isSetValues() ? partition.getValues() : null;
                this.location = partition.getSd().getLocation();
            }

            public int hashCode() {
                return this.values == null ? 0 : this.values.hashCode();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || !(obj instanceof PartValEqWrapperLite)) {
                    return false;
                }
                List<String> lhsValues = this.values;
                List<String> rhsValues = ((PartValEqWrapperLite)obj).values;
                if (lhsValues == null || rhsValues == null) {
                    return lhsValues == rhsValues;
                }
                if (lhsValues.size() != rhsValues.size()) {
                    return false;
                }
                for (int i = 0; i < lhsValues.size(); ++i) {
                    String lhsValue = lhsValues.get(i);
                    String rhsValue = rhsValues.get(i);
                    if ((lhsValue != null || rhsValue == null) && (lhsValue == null || lhsValue.equals(rhsValue))) continue;
                    return false;
                }
                return true;
            }
        }

        private static class PartValEqWrapper {
            Partition partition;

            PartValEqWrapper(Partition partition) {
                this.partition = partition;
            }

            public int hashCode() {
                return this.partition.isSetValues() ? this.partition.getValues().hashCode() : 0;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || !(obj instanceof PartValEqWrapper)) {
                    return false;
                }
                Partition p1 = this.partition;
                Partition p2 = ((PartValEqWrapper)obj).partition;
                if (!p1.isSetValues() || !p2.isSetValues()) {
                    return p1.isSetValues() == p2.isSetValues();
                }
                if (p1.getValues().size() != p2.getValues().size()) {
                    return false;
                }
                for (int i = 0; i < p1.getValues().size(); ++i) {
                    String v1 = p1.getValues().get(i);
                    String v2 = p2.getValues().get(i);
                    if (v1 == null && v2 == null || v1 != null && v1.equals(v2)) continue;
                    return false;
                }
                return true;
            }
        }
    }

    private static final class ChainedTTransportFactory
    extends TTransportFactory {
        private final TTransportFactory parentTransFactory;
        private final TTransportFactory childTransFactory;

        private ChainedTTransportFactory(TTransportFactory parentTransFactory, TTransportFactory childTransFactory) {
            this.parentTransFactory = parentTransFactory;
            this.childTransFactory = childTransFactory;
        }

        @Override
        public TTransport getTransport(TTransport trans) throws TTransportException {
            return this.childTransFactory.getTransport(this.parentTransFactory.getTransport(trans));
        }
    }
}

