/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop.example;

import hive.org.apache.parquet.column.ParquetProperties;
import hive.org.apache.parquet.conf.ParquetConfiguration;
import hive.org.apache.parquet.example.data.Group;
import hive.org.apache.parquet.hadoop.ParquetWriter;
import hive.org.apache.parquet.hadoop.api.WriteSupport;
import hive.org.apache.parquet.hadoop.example.GroupWriteSupport;
import hive.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import hive.org.apache.parquet.io.OutputFile;
import hive.org.apache.parquet.schema.MessageType;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class ExampleParquetWriter
extends ParquetWriter<Group> {
    public static Builder builder(Path file) {
        return new Builder(file);
    }

    public static Builder builder(OutputFile file) {
        return new Builder(file);
    }

    ExampleParquetWriter(Path file, WriteSupport<Group> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, boolean enableDictionary, boolean enableValidation, ParquetProperties.WriterVersion writerVersion, Configuration conf) throws IOException {
        super(file, writeSupport, compressionCodecName, blockSize, pageSize, pageSize, enableDictionary, enableValidation, writerVersion, conf);
    }

    public static class Builder
    extends ParquetWriter.Builder<Group, Builder> {
        private MessageType type = null;

        private Builder(Path file) {
            super(file);
        }

        private Builder(OutputFile file) {
            super(file);
        }

        public Builder withType(MessageType type) {
            this.type = type;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected WriteSupport<Group> getWriteSupport(Configuration conf) {
            return this.getWriteSupport((ParquetConfiguration)null);
        }

        @Override
        protected WriteSupport<Group> getWriteSupport(ParquetConfiguration conf) {
            return new GroupWriteSupport(this.type);
        }

        @Override
        public Builder withExtraMetaData(Map<String, String> extraMetaData) {
            return (Builder)super.withExtraMetaData(extraMetaData);
        }
    }
}

