/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import hive.com.google.common.base.Preconditions;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.PrunerOperatorFactory;
import org.apache.hadoop.hive.ql.optimizer.PrunerUtils;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

public class FixedBucketPruningOptimizer
extends Transform {
    private static final Log LOG = LogFactory.getLog((String)FixedBucketPruningOptimizer.class.getName());
    private final boolean compat;

    public FixedBucketPruningOptimizer(boolean compat) {
        this.compat = compat;
    }

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        FixedBucketPruningOptimizerCtxt opPartWalkerCtx = new FixedBucketPruningOptimizerCtxt(this.compat, pctx);
        PrunerUtils.walkOperatorTree(pctx, opPartWalkerCtx, new FixedBucketPartitionWalker(), new NoopWalker());
        if (opPartWalkerCtx.getNumBuckets() < 0) {
            return pctx;
        }
        PrunerUtils.walkOperatorTree(pctx, opPartWalkerCtx, new BucketBitsetGenerator(), new NoopWalker());
        return pctx;
    }

    public final class FixedBucketPruningOptimizerCtxt
    implements NodeProcessorCtx {
        public final ParseContext pctx;
        private final boolean compat;
        private int numBuckets;
        private PrunedPartitionList partitions;
        private List<String> bucketCols;
        private List<StructField> schema;

        public FixedBucketPruningOptimizerCtxt(boolean compat, ParseContext pctx) {
            this.compat = compat;
            this.pctx = pctx;
        }

        public void setSchema(ArrayList<StructField> fields) {
            this.schema = fields;
        }

        public List<StructField> getSchema() {
            return this.schema;
        }

        public void setBucketCols(List<String> bucketCols) {
            this.bucketCols = bucketCols;
        }

        public List<String> getBucketCols() {
            return this.bucketCols;
        }

        public void setPartitions(PrunedPartitionList partitions) {
            this.partitions = partitions;
        }

        public PrunedPartitionList getPartitions() {
            return this.partitions;
        }

        public int getNumBuckets() {
            return this.numBuckets;
        }

        public void setNumBuckets(int numBuckets) {
            this.numBuckets = numBuckets;
        }

        public boolean isCompat() {
            return this.compat;
        }
    }

    public static class BucketBitsetGenerator
    extends PrunerOperatorFactory.FilterPruner {
        @Override
        protected void generatePredicate(NodeProcessorCtx procCtx, FilterOperator fop, TableScanOperator top) throws SemanticException {
            FixedBucketPruningOptimizerCtxt ctxt = (FixedBucketPruningOptimizerCtxt)procCtx;
            if (ctxt.getNumBuckets() <= 0 || ctxt.getBucketCols().size() != 1) {
                return;
            }
            ExprNodeGenericFuncDesc filter = ((TableScanDesc)top.getConf()).getFilterExpr();
            if (filter == null) {
                return;
            }
            SearchArgument sarg = ConvertAstToSearchArg.create(ctxt.pctx.getConf(), filter);
            if (sarg == null) {
                return;
            }
            String bucketCol = ctxt.getBucketCols().get(0);
            StructField bucketField = null;
            for (StructField fs : ctxt.getSchema()) {
                if (!fs.getFieldName().equals(bucketCol)) continue;
                bucketField = fs;
            }
            Preconditions.checkArgument(bucketField != null);
            ArrayList<Object> literals = new ArrayList<Object>();
            List<PredicateLeaf> leaves = sarg.getLeaves();
            HashSet<PredicateLeaf> bucketLeaves = new HashSet<PredicateLeaf>();
            for (PredicateLeaf l : leaves) {
                if (!bucketCol.equals(l.getColumnName())) continue;
                switch (l.getOperator()) {
                    case EQUALS: 
                    case IN: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                bucketLeaves.add(l);
            }
            if (bucketLeaves.size() == 0) {
                return;
            }
            ExpressionTree expr = sarg.getExpression();
            if (expr.getOperator() == ExpressionTree.Operator.LEAF) {
                PredicateLeaf l;
                l = leaves.get(expr.getLeaf());
                if (!this.addLiteral(literals, l)) {
                    return;
                }
            } else if (expr.getOperator() == ExpressionTree.Operator.AND) {
                boolean found = false;
                for (ExpressionTree subExpr : expr.getChildren()) {
                    if (subExpr.getOperator() != ExpressionTree.Operator.LEAF) {
                        return;
                    }
                    PredicateLeaf l = leaves.get(subExpr.getLeaf());
                    if (!bucketLeaves.contains(l)) continue;
                    if (!this.addLiteral(literals, l)) {
                        return;
                    }
                    found = true;
                }
                if (!found) {
                    return;
                }
            } else if (expr.getOperator() == ExpressionTree.Operator.OR) {
                for (ExpressionTree subExpr : expr.getChildren()) {
                    if (subExpr.getOperator() != ExpressionTree.Operator.LEAF) {
                        return;
                    }
                    PredicateLeaf l = leaves.get(subExpr.getLeaf());
                    if (bucketLeaves.contains(l)) {
                        if (this.addLiteral(literals, l)) continue;
                        return;
                    }
                    return;
                }
            }
            BitSet bs = new BitSet(ctxt.getNumBuckets());
            bs.clear();
            PrimitiveObjectInspector bucketOI = (PrimitiveObjectInspector)bucketField.getFieldObjectInspector();
            AbstractPrimitiveWritableObjectInspector constOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(bucketOI.getPrimitiveCategory());
            int bucketingVersion = ((TableScanDesc)top.getConf()).getTableMetadata().getBucketingVersion();
            for (Object e : literals) {
                PrimitiveObjectInspector origOI = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(e.getClass());
                ObjectInspectorConverters.Converter conv = ObjectInspectorConverters.getConverter((ObjectInspector)origOI, (ObjectInspector)constOI);
                if (conv == null) {
                    return;
                }
                Object[] convCols = new Object[]{conv.convert(e)};
                int n = bucketingVersion == 2 ? ObjectInspectorUtils.getBucketNumber(convCols, new ObjectInspector[]{constOI}, ctxt.getNumBuckets()) : ObjectInspectorUtils.getBucketNumberOld(convCols, new ObjectInspector[]{constOI}, ctxt.getNumBuckets());
                bs.set(n);
                if (bucketingVersion != 1 || !ctxt.isCompat()) continue;
                int h = ObjectInspectorUtils.getBucketHashCodeOld(convCols, new ObjectInspector[]{constOI});
                n = ObjectInspectorUtils.getBucketNumber(Math.abs(h), ctxt.getNumBuckets());
                bs.set(n);
            }
            if (bs.cardinality() < ctxt.getNumBuckets()) {
                ((TableScanDesc)top.getConf()).setIncludedBuckets(bs);
                ((TableScanDesc)top.getConf()).setNumBuckets(ctxt.getNumBuckets());
            }
        }

        private boolean addLiteral(List<Object> literals, PredicateLeaf leaf) {
            switch (leaf.getOperator()) {
                case EQUALS: {
                    return literals.add(this.convertLiteral(leaf.getLiteral()));
                }
                case IN: {
                    return literals.addAll(leaf.getLiteralList().stream().map(l -> this.convertLiteral(l)).collect(Collectors.toList()));
                }
            }
            return false;
        }

        private Object convertLiteral(Object o) {
            if (o instanceof Date) {
                return org.apache.hadoop.hive.common.type.Date.valueOf(o.toString());
            }
            if (o instanceof Timestamp) {
                return org.apache.hadoop.hive.common.type.Timestamp.valueOf(o.toString());
            }
            return o;
        }
    }

    public class FixedBucketPartitionWalker
    extends PrunerOperatorFactory.FilterPruner {
        @Override
        protected void generatePredicate(NodeProcessorCtx procCtx, FilterOperator fop, TableScanOperator top) throws SemanticException {
            FixedBucketPruningOptimizerCtxt ctxt = (FixedBucketPruningOptimizerCtxt)procCtx;
            Table tbl = ((TableScanDesc)top.getConf()).getTableMetadata();
            if (tbl.getNumBuckets() > 0) {
                int nbuckets = tbl.getNumBuckets();
                ctxt.setNumBuckets(nbuckets);
                ctxt.setBucketCols(tbl.getBucketCols());
                ctxt.setSchema(tbl.getFields());
                if (tbl.isPartitioned()) {
                    PrunedPartitionList prunedPartList;
                    ParseContext parseCtx = ctxt.pctx;
                    try {
                        String alias = (String)parseCtx.getTopOps().keySet().toArray()[0];
                        prunedPartList = PartitionPruner.prune(top, parseCtx, alias);
                    }
                    catch (HiveException e) {
                        throw new SemanticException(e.getMessage(), e);
                    }
                    if (prunedPartList != null) {
                        ctxt.setPartitions(prunedPartList);
                        for (Partition p : prunedPartList.getPartitions()) {
                            if (nbuckets == p.getBucketCount()) continue;
                            ctxt.setNumBuckets(-1);
                            break;
                        }
                    }
                }
            }
        }
    }

    public class NoopWalker
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }
}

