/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorFileSinkDesc;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class VectorFileSinkOperator
extends FileSinkOperator
implements VectorizationOperator {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private VectorFileSinkDesc vectorDesc;
    private transient boolean firstBatch;
    private transient VectorExtractRow vectorExtractRow;
    protected transient Object[] singleRow;

    public VectorFileSinkOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) {
        this(ctx);
        this.conf = (FileSinkDesc)conf;
        this.vContext = vContext;
        this.vectorDesc = (VectorFileSinkDesc)vectorDesc;
    }

    @VisibleForTesting
    public VectorFileSinkOperator() {
    }

    public VectorFileSinkOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        this.inputObjInspectors[0] = VectorizedBatchUtil.convertToStandardStructObjectInspector((StructObjectInspector)this.inputObjInspectors[0]);
        super.initializeOp(hconf);
        this.firstBatch = true;
    }

    @Override
    public void process(Object data, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)data;
        if (this.firstBatch) {
            this.vectorExtractRow = new VectorExtractRow();
            this.vectorExtractRow.init((StructObjectInspector)this.inputObjInspectors[0], this.vContext.getProjectedColumns());
            this.singleRow = new Object[this.vectorExtractRow.getCount()];
            this.firstBatch = false;
        }
        if (batch.selectedInUse) {
            int[] selected = batch.selected;
            for (int logical = 0; logical < batch.size; ++logical) {
                int batchIndex = selected[logical];
                this.vectorExtractRow.extractRow(batch, batchIndex, this.singleRow);
                super.process(this.singleRow, tag);
            }
        } else {
            for (int batchIndex = 0; batchIndex < batch.size; ++batchIndex) {
                this.vectorExtractRow.extractRow(batch, batchIndex, this.singleRow);
                super.process(this.singleRow, tag);
            }
        }
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }
}

