/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status;

import hive.com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.RemoteSparkJobStatus;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.util.StringUtils;
import org.apache.spark.JobExecutionStatus;

public class RemoteSparkJobMonitor
extends SparkJobMonitor {
    private int sparkJobMaxTaskCount = -1;
    private int sparkStageMaxTaskCount = -1;
    private int totalTaskCount = 0;
    private int stageMaxTaskCount = 0;
    private RemoteSparkJobStatus sparkJobStatus;
    private final HiveConf hiveConf;

    public RemoteSparkJobMonitor(HiveConf hiveConf, RemoteSparkJobStatus sparkJobStatus) {
        super(hiveConf);
        this.sparkJobStatus = sparkJobStatus;
        this.hiveConf = hiveConf;
        this.sparkJobMaxTaskCount = hiveConf.getIntVar(HiveConf.ConfVars.SPARK_JOB_MAX_TASKS);
        this.sparkStageMaxTaskCount = hiveConf.getIntVar(HiveConf.ConfVars.SPARK_STAGE_MAX_TASKS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int startMonitor() {
        running = false;
        done = false;
        rc = 0;
        lastProgressMap = null;
        this.perfLogger.PerfLogBegin(RemoteSparkJobMonitor.CLASS_NAME, "SparkRunJob");
        this.perfLogger.PerfLogBegin(RemoteSparkJobMonitor.CLASS_NAME, "SparkSubmitToRunning");
        this.startTime = System.currentTimeMillis();
        state = null;
        while (true) {
            try {
                state = this.sparkJobStatus.getRemoteJobState();
                Preconditions.checkState(this.sparkJobStatus.isRemoteActive(), "Connection to remote Spark driver was lost");
                switch (1.$SwitchMap$org$apache$hive$spark$client$JobHandle$State[state.ordinal()]) {
                    case 1: 
                    case 2: {
                        timeCount = (System.currentTimeMillis() - this.startTime) / 1000L;
                        if (timeCount > this.monitorTimeoutInterval) {
                            he = new HiveException(ErrorMsg.SPARK_JOB_MONITOR_TIMEOUT, new String[]{Long.toString(timeCount)});
                            this.console.printError(he.getMessage());
                            this.sparkJobStatus.setError(he);
                            running = false;
                            done = true;
                            rc = 2;
                        }
                        if (!RemoteSparkJobMonitor.LOG.isDebugEnabled()) break;
                        this.console.printInfo("Spark job state = " + state);
                        break;
                    }
                    case 3: {
                        sparkJobState = this.sparkJobStatus.getState();
                        if (sparkJobState != JobExecutionStatus.RUNNING) break;
                        progressMap = this.sparkJobStatus.getSparkStageProgress();
                        if (!running) {
                            this.perfLogger.PerfLogEnd(RemoteSparkJobMonitor.CLASS_NAME, "SparkSubmitToRunning");
                            this.printAppInfo();
                            this.console.printInfo("Hive on Spark Session Web UI URL: " + this.sparkJobStatus.getWebUIURL());
                            this.console.printInfo("\nQuery Hive on Spark job[" + this.sparkJobStatus.getJobId() + "] stages: " + Arrays.toString(this.sparkJobStatus.getStageIds()));
                            this.console.printInfo("Spark job[" + this.sparkJobStatus.getJobId() + "] status = RUNNING");
                            running = true;
                            format = "Job Progress Format\nCurrentTime StageId_StageAttemptId: SucceededTasksCount(+RunningTasksCount-FailedTasksCount)/TotalTasksCount";
                            if (!this.inPlaceUpdate) {
                                this.console.printInfo(format);
                            } else {
                                this.console.logInfo(format);
                            }
                        } else {
                            if (this.sparkStageMaxTaskCount != -1 && this.stageMaxTaskCount == 0) {
                                this.stageMaxTaskCount = this.getStageMaxTaskCount(progressMap);
                                if (this.stageMaxTaskCount > this.sparkStageMaxTaskCount) {
                                    rc = 4;
                                    done = true;
                                    this.console.printInfo("\nThe number of task in one stage of the Spark job [" + this.stageMaxTaskCount + "] is greater than the limit [" + this.sparkStageMaxTaskCount + "]. The Spark job will be cancelled.");
                                }
                            }
                            if (this.sparkJobMaxTaskCount != -1 && this.totalTaskCount == 0) {
                                this.totalTaskCount = this.getTotalTaskCount(progressMap);
                                if (this.totalTaskCount > this.sparkJobMaxTaskCount) {
                                    rc = 4;
                                    done = true;
                                    this.console.printInfo("\nThe total number of task in the Spark job [" + this.totalTaskCount + "] is greater than the limit [" + this.sparkJobMaxTaskCount + "]. The Spark job will be cancelled.");
                                }
                            }
                        }
                        this.printStatus(progressMap, lastProgressMap);
                        lastProgressMap = progressMap;
                        break;
                    }
                    case 4: {
                        progressMap = this.sparkJobStatus.getSparkStageProgress();
                        this.printStatus(progressMap, lastProgressMap);
                        lastProgressMap = progressMap;
                        duration = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
                        this.console.printInfo("Spark job[" + this.sparkJobStatus.getJobId() + "] finished successfully in " + String.format("%.2f second(s)", new Object[]{duration}));
                        running = false;
                        done = true;
                        break;
                    }
                    case 5: {
                        detail = this.sparkJobStatus.getError().getMessage();
                        errBuilder = new StringBuilder();
                        errBuilder.append("Job failed with ");
                        if (detail == null) {
                            errBuilder.append("UNKNOWN reason");
                        } else {
                            CAUSE_CAPTION = "Caused by: ";
                            index = detail.lastIndexOf("Caused by: ");
                            if (index != -1) {
                                rootCause = detail.substring(index + "Caused by: ".length());
                                if ((index = rootCause.indexOf(System.getProperty("line.separator"))) != -1) {
                                    errBuilder.append(rootCause.substring(0, index));
                                } else {
                                    errBuilder.append(rootCause);
                                }
                            } else {
                                errBuilder.append((String)detail);
                            }
                            detail = System.getProperty("line.separator") + (String)detail;
                        }
                        this.console.printError(errBuilder.toString(), (String)detail);
                        running = false;
                        done = true;
                        rc = 3;
                        break;
                    }
                    case 6: {
                        this.console.printInfo("Spark job[" + this.sparkJobStatus.getJobId() + " was cancelled");
                        running = false;
                        done = true;
                        rc = 3;
                    }
                }
                if (done) continue;
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                finalException = e;
                if (e instanceof InterruptedException || e instanceof HiveException && e.getCause() instanceof InterruptedException) {
                    finalException = new HiveException(e, ErrorMsg.SPARK_JOB_INTERRUPTED);
                    RemoteSparkJobMonitor.LOG.warn("Interrupted while monitoring the Hive on Spark application, exiting");
                } else {
                    msg = " with exception '" + Utilities.getNameMessage(e) + "' Last known state = " + (state != null ? state.name() : "UNKNOWN");
                    msg = "Failed to monitor Job[" + this.sparkJobStatus.getJobId() + "]" + msg;
                    this.console.printError(msg, "\n" + StringUtils.stringifyException((Throwable)e));
                }
                rc = 1;
                done = true;
                this.sparkJobStatus.setError(finalException);
            }
            finally {
                if (done) ** break;
                continue;
            }
            break;
        }
        this.perfLogger.PerfLogEnd(RemoteSparkJobMonitor.CLASS_NAME, "SparkRunJob");
        return rc;
    }

    private void printAppInfo() {
        String appID;
        String sparkMaster = this.hiveConf.get("spark.master");
        if (sparkMaster != null && sparkMaster.startsWith("yarn") && (appID = this.sparkJobStatus.getAppID()) != null) {
            this.console.printInfo("Running with YARN Application = " + appID);
            this.console.printInfo("Kill Command = " + HiveConf.getVar(this.hiveConf, HiveConf.ConfVars.YARNBIN) + " application -kill " + appID);
        }
    }
}

