/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.apache.thrift.transport.TTransportInputStream;
import org.apache.thrift.transport.TTransportOutputStream;

public class TZlibTransport
extends TIOStreamTransport {
    private TTransport transport_ = null;

    public TZlibTransport(TTransport transport) throws TTransportException {
        this(transport, 9);
    }

    public TZlibTransport(TTransport transport, int compressionLevel) throws TTransportException {
        super(Objects.isNull(transport.getConfiguration()) ? new TConfiguration() : transport.getConfiguration());
        this.transport_ = transport;
        this.inputStream_ = new InflaterInputStream(new TTransportInputStream(this.transport_), new Inflater());
        this.outputStream_ = new DeflaterOutputStream((OutputStream)new TTransportOutputStream(this.transport_), new Deflater(compressionLevel, false), true);
    }

    @Override
    public boolean isOpen() {
        return this.transport_.isOpen();
    }

    @Override
    public void open() throws TTransportException {
        this.transport_.open();
    }

    @Override
    public void close() {
        super.close();
        if (this.transport_.isOpen()) {
            this.transport_.close();
        }
    }

    public static class Factory
    extends TTransportFactory {
        @Override
        public TTransport getTransport(TTransport base) throws TTransportException {
            return new TZlibTransport(base);
        }
    }
}

