/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import hive.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.io.TableUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.common.util.Ref;
import org.apache.orc.FileFormatException;
import org.apache.orc.impl.OrcAcidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidUtils {
    public static final String CONF_ACID_KEY = "hive.doing.acid";
    public static final String BASE_PREFIX = "base_";
    public static final PathFilter baseFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.BASE_PREFIX);
        }
    };
    public static final String DELTA_PREFIX = "delta_";
    public static final String DELETE_DELTA_PREFIX = "delete_delta_";
    public static final String DELTA_SIDE_FILE_SUFFIX = "_flush_length";
    public static final PathFilter deltaFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.DELTA_PREFIX);
        }
    };
    public static final PathFilter deleteEventDeltaDirFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.DELETE_DELTA_PREFIX);
        }
    };
    public static final String BUCKET_PREFIX = "bucket_";
    public static final PathFilter bucketFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.BUCKET_PREFIX) && !path.getName().endsWith(AcidUtils.DELTA_SIDE_FILE_SUFFIX);
        }
    };
    public static final String BUCKET_DIGITS = "%05d";
    public static final String LEGACY_FILE_BUCKET_DIGITS = "%06d";
    public static final String DELTA_DIGITS = "%07d";
    public static final String STATEMENT_DIGITS = "%04d";
    public static final int MAX_STATEMENTS_PER_TXN = 10000;
    public static final Pattern BUCKET_DIGIT_PATTERN = Pattern.compile("[0-9]{5}$");
    public static final Pattern LEGACY_BUCKET_DIGIT_PATTERN = Pattern.compile("^[0-9]{6}");
    public static final PathFilter originalBucketFilter = new PathFilter(){

        public boolean accept(Path path) {
            return ORIGINAL_PATTERN.matcher(path.getName()).matches() || ORIGINAL_PATTERN_COPY.matcher(path.getName()).matches();
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(AcidUtils.class);
    public static final Pattern BUCKET_PATTERN = Pattern.compile("bucket__[0-9]{5}$");
    public static final Pattern ORIGINAL_PATTERN = Pattern.compile("[0-9]+_[0-9]+");
    public static final Pattern ORIGINAL_PATTERN_COPY = Pattern.compile("[0-9]+_[0-9]+_copy_[0-9]+");
    public static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };
    private static final HadoopShims SHIMS = ShimLoader.getHadoopShims();

    private AcidUtils() {
    }

    public static Path createBucketFile(Path subdir, int bucket) {
        return AcidUtils.createBucketFile(subdir, bucket, true);
    }

    private static Path createBucketFile(Path subdir, int bucket, boolean isAcidSchema) {
        if (isAcidSchema) {
            return new Path(subdir, BUCKET_PREFIX + String.format(BUCKET_DIGITS, bucket));
        }
        return new Path(subdir, String.format(BUCKET_DIGITS, bucket));
    }

    public static String deltaSubdir(long min, long max) {
        return DELTA_PREFIX + String.format(DELTA_DIGITS, min) + "_" + String.format(DELTA_DIGITS, max);
    }

    public static String deltaSubdir(long min, long max, int statementId) {
        return AcidUtils.deltaSubdir(min, max) + "_" + String.format(STATEMENT_DIGITS, statementId);
    }

    @VisibleForTesting
    public static String deleteDeltaSubdir(long min, long max) {
        return DELETE_DELTA_PREFIX + String.format(DELTA_DIGITS, min) + "_" + String.format(DELTA_DIGITS, max);
    }

    @VisibleForTesting
    public static String deleteDeltaSubdir(long min, long max, int statementId) {
        return AcidUtils.deleteDeltaSubdir(min, max) + "_" + String.format(STATEMENT_DIGITS, statementId);
    }

    public static String baseDir(long writeId) {
        return BASE_PREFIX + String.format(DELTA_DIGITS, writeId);
    }

    public static String baseOrDeltaSubdir(boolean baseDirRequired, long min, long max, int statementId) {
        if (!baseDirRequired) {
            return AcidUtils.deltaSubdir(min, max, statementId);
        }
        return AcidUtils.baseDir(min);
    }

    public static Path createFilename(Path directory, AcidOutputFormat.Options options) {
        if (options.getOldStyle()) {
            return new Path(directory, String.format(LEGACY_FILE_BUCKET_DIGITS, options.getBucketId()) + "_0");
        }
        Object subdir = options.isWritingBase() ? BASE_PREFIX + String.format(DELTA_DIGITS, options.getMaximumWriteId()) : (options.getStatementId() == -1 ? (options.isWritingDeleteDelta() ? AcidUtils.deleteDeltaSubdir(options.getMinimumWriteId(), options.getMaximumWriteId()) : AcidUtils.deltaSubdir(options.getMinimumWriteId(), options.getMaximumWriteId())) : (options.isWritingDeleteDelta() ? AcidUtils.deleteDeltaSubdir(options.getMinimumWriteId(), options.getMaximumWriteId(), options.getStatementId()) : AcidUtils.deltaSubdir(options.getMinimumWriteId(), options.getMaximumWriteId(), options.getStatementId())));
        return AcidUtils.createBucketFile(new Path(directory, (String)subdir), options.getBucketId());
    }

    public static long parseBase(Path path) {
        String filename = path.getName();
        if (filename.startsWith(BASE_PREFIX)) {
            return Long.parseLong(filename.substring(BASE_PREFIX.length()));
        }
        throw new IllegalArgumentException(filename + " does not start with base_");
    }

    public static int parseBucketId(Path bucketFile) {
        String filename = bucketFile.getName();
        if (ORIGINAL_PATTERN.matcher(filename).matches() || ORIGINAL_PATTERN_COPY.matcher(filename).matches()) {
            return Integer.parseInt(filename.substring(0, filename.indexOf(95)));
        }
        if (filename.startsWith(BUCKET_PREFIX)) {
            return Integer.parseInt(filename.substring(filename.indexOf(95) + 1));
        }
        return -1;
    }

    public static AcidOutputFormat.Options parseBaseOrDeltaBucketFilename(Path bucketFile, Configuration conf) throws IOException {
        AcidOutputFormat.Options result = new AcidOutputFormat.Options(conf);
        String filename = bucketFile.getName();
        int bucket = AcidUtils.parseBucketId(bucketFile);
        if (ORIGINAL_PATTERN.matcher(filename).matches()) {
            result.setOldStyle(true).minimumWriteId(0L).maximumWriteId(0L).bucket(bucket).writingBase(!bucketFile.getParent().getName().startsWith(DELTA_PREFIX));
        } else if (ORIGINAL_PATTERN_COPY.matcher(filename).matches()) {
            int copyNumber = Integer.parseInt(filename.substring(filename.lastIndexOf(95) + 1));
            result.setOldStyle(true).minimumWriteId(0L).maximumWriteId(0L).bucket(bucket).copyNumber(copyNumber).writingBase(!bucketFile.getParent().getName().startsWith(DELTA_PREFIX));
        } else if (filename.startsWith(BUCKET_PREFIX)) {
            if (bucketFile.getParent().getName().startsWith(BASE_PREFIX)) {
                result.setOldStyle(false).minimumWriteId(0L).maximumWriteId(AcidUtils.parseBase(bucketFile.getParent())).bucket(bucket).writingBase(true);
            } else if (bucketFile.getParent().getName().startsWith(DELTA_PREFIX)) {
                ParsedDelta parsedDelta = AcidUtils.parsedDelta(bucketFile.getParent(), DELTA_PREFIX, bucketFile.getFileSystem(conf));
                result.setOldStyle(false).minimumWriteId(parsedDelta.minWriteId).maximumWriteId(parsedDelta.maxWriteId).bucket(bucket);
            } else if (bucketFile.getParent().getName().startsWith(DELETE_DELTA_PREFIX)) {
                ParsedDelta parsedDelta = AcidUtils.parsedDelta(bucketFile.getParent(), DELETE_DELTA_PREFIX, bucketFile.getFileSystem(conf));
                result.setOldStyle(false).minimumWriteId(parsedDelta.minWriteId).maximumWriteId(parsedDelta.maxWriteId).bucket(bucket);
            }
        } else {
            result.setOldStyle(true).bucket(bucket).minimumWriteId(0L).maximumWriteId(0L);
        }
        return result;
    }

    public static DataOperationType toDataOperationType(Operation op) {
        switch (op) {
            case NOT_ACID: {
                return DataOperationType.UNSET;
            }
            case INSERT: {
                return DataOperationType.INSERT;
            }
            case UPDATE: {
                return DataOperationType.UPDATE;
            }
            case DELETE: {
                return DataOperationType.DELETE;
            }
        }
        throw new IllegalArgumentException("Unexpected Operation: " + op);
    }

    public static Path[] getPaths(List<ParsedDelta> deltas) {
        Path[] result = new Path[deltas.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = deltas.get(i).getPath();
        }
        return result;
    }

    public static List<AcidInputFormat.DeltaMetaData> serializeDeltas(List<ParsedDelta> deltas) {
        ArrayList<AcidInputFormat.DeltaMetaData> result = new ArrayList<AcidInputFormat.DeltaMetaData>(deltas.size());
        AcidInputFormat.DeltaMetaData last = null;
        for (ParsedDelta parsedDelta : deltas) {
            if (last != null && last.getMinWriteId() == parsedDelta.getMinWriteId() && last.getMaxWriteId() == parsedDelta.getMaxWriteId()) {
                last.getStmtIds().add(parsedDelta.getStatementId());
                continue;
            }
            last = new AcidInputFormat.DeltaMetaData(parsedDelta.getMinWriteId(), parsedDelta.getMaxWriteId(), new ArrayList<Integer>());
            result.add(last);
            if (parsedDelta.statementId < 0) continue;
            last.getStmtIds().add(parsedDelta.getStatementId());
        }
        return result;
    }

    public static Path[] deserializeDeleteDeltas(Path root, List<AcidInputFormat.DeltaMetaData> deleteDeltas) throws IOException {
        ArrayList<Path> results = new ArrayList<Path>(deleteDeltas.size());
        for (AcidInputFormat.DeltaMetaData dmd : deleteDeltas) {
            if (dmd.getStmtIds().isEmpty()) {
                results.add(new Path(root, AcidUtils.deleteDeltaSubdir(dmd.getMinWriteId(), dmd.getMaxWriteId())));
                continue;
            }
            for (Integer stmtId : dmd.getStmtIds()) {
                results.add(new Path(root, AcidUtils.deleteDeltaSubdir(dmd.getMinWriteId(), dmd.getMaxWriteId(), stmtId)));
            }
        }
        return results.toArray(new Path[results.size()]);
    }

    public static ParsedDelta parsedDelta(Path deltaDir, FileSystem fs) throws IOException {
        String deltaDirName = deltaDir.getName();
        if (deltaDirName.startsWith(DELETE_DELTA_PREFIX)) {
            return AcidUtils.parsedDelta(deltaDir, DELETE_DELTA_PREFIX, fs);
        }
        return AcidUtils.parsedDelta(deltaDir, DELTA_PREFIX, fs);
    }

    private static ParsedDelta parseDelta(FileStatus path, String deltaPrefix, FileSystem fs) throws IOException {
        ParsedDelta p = AcidUtils.parsedDelta(path.getPath(), deltaPrefix, fs);
        boolean isDeleteDelta = deltaPrefix.equals(DELETE_DELTA_PREFIX);
        return new ParsedDelta(p.getMinWriteId(), p.getMaxWriteId(), path, p.statementId, isDeleteDelta, p.isRawFormat());
    }

    public static ParsedDelta parsedDelta(Path deltaDir, String deltaPrefix, FileSystem fs) throws IOException {
        String filename = deltaDir.getName();
        boolean isDeleteDelta = deltaPrefix.equals(DELETE_DELTA_PREFIX);
        if (filename.startsWith(deltaPrefix)) {
            long max;
            boolean isRawFormat = !isDeleteDelta && MetaDataFile.isRawFormat(deltaDir, fs);
            String rest = filename.substring(deltaPrefix.length());
            int split = rest.indexOf(95);
            int split2 = rest.indexOf(95, split + 1);
            long min = Long.parseLong(rest.substring(0, split));
            long l = max = split2 == -1 ? Long.parseLong(rest.substring(split + 1)) : Long.parseLong(rest.substring(split + 1, split2));
            if (split2 == -1) {
                return new ParsedDelta(min, max, null, isDeleteDelta, isRawFormat);
            }
            int statementId = Integer.parseInt(rest.substring(split2 + 1));
            return new ParsedDelta(min, max, null, statementId, isDeleteDelta, isRawFormat);
        }
        throw new IllegalArgumentException(deltaDir + " does not start with " + deltaPrefix);
    }

    public static boolean isAcid(Path directory, Configuration conf) throws IOException {
        FileSystem fs = directory.getFileSystem(conf);
        for (FileStatus file : fs.listStatus(directory)) {
            String filename = file.getPath().getName();
            if (!filename.startsWith(BASE_PREFIX) && !filename.startsWith(DELTA_PREFIX) && !filename.startsWith(DELETE_DELTA_PREFIX) || !file.isDir()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public static Directory getAcidState(Path directory, Configuration conf, ValidWriteIdList writeIdList) throws IOException {
        return AcidUtils.getAcidState(directory, conf, writeIdList, false, false);
    }

    public static Directory getAcidState(Path directory, Configuration conf, ValidWriteIdList writeIdList, boolean useFileIds, boolean ignoreEmptyFiles) throws IOException {
        return AcidUtils.getAcidState(directory, conf, writeIdList, Ref.from(useFileIds), ignoreEmptyFiles, null);
    }

    public static Directory getAcidState(Path directory, Configuration conf, ValidWriteIdList writeIdList, Ref<Boolean> useFileIds, boolean ignoreEmptyFiles, Map<String, String> tblproperties) throws IOException {
        List<HadoopShims.HdfsFileStatusWithId> childrenWithId;
        ArrayList<FileStatus> abortedDirectories;
        ArrayList<FileStatus> obsolete;
        ArrayList<FileStatus> originalDirectories;
        ArrayList<ParsedDelta> working;
        ArrayList<ParsedDelta> deltas;
        FileSystem fs;
        block17: {
            fs = directory.getFileSystem(conf);
            deltas = new ArrayList<ParsedDelta>();
            working = new ArrayList<ParsedDelta>();
            originalDirectories = new ArrayList<FileStatus>();
            obsolete = new ArrayList<FileStatus>();
            abortedDirectories = new ArrayList<FileStatus>();
            childrenWithId = null;
            Boolean val = (Boolean)useFileIds.value;
            if (val == null || val.booleanValue()) {
                try {
                    childrenWithId = SHIMS.listLocatedHdfsStatus(fs, directory, hiddenFileFilter);
                    if (val == null) {
                        useFileIds.value = true;
                    }
                }
                catch (Throwable t) {
                    LOG.error("Failed to get files with ID; using regular API: " + t.getMessage());
                    if (val != null || !(t instanceof UnsupportedOperationException)) break block17;
                    useFileIds.value = false;
                }
            }
        }
        TxnBase bestBase = new TxnBase();
        ArrayList<HadoopShims.HdfsFileStatusWithId> original = new ArrayList<HadoopShims.HdfsFileStatusWithId>();
        if (childrenWithId != null) {
            for (HadoopShims.HdfsFileStatusWithId hdfsFileStatusWithId : childrenWithId) {
                AcidUtils.getChildState(hdfsFileStatusWithId.getFileStatus(), hdfsFileStatusWithId, writeIdList, working, originalDirectories, original, obsolete, bestBase, ignoreEmptyFiles, abortedDirectories, tblproperties, fs);
            }
        } else {
            Iterator children = HdfsUtils.listLocatedStatus(fs, directory, hiddenFileFilter);
            Iterator<FileStatus> iterator = children.iterator();
            while (iterator.hasNext()) {
                FileStatus child2 = iterator.next();
                AcidUtils.getChildState(child2, null, writeIdList, working, originalDirectories, original, obsolete, bestBase, ignoreEmptyFiles, abortedDirectories, tblproperties, fs);
            }
        }
        if (bestBase.status != null) {
            for (HadoopShims.HdfsFileStatusWithId hdfsFileStatusWithId : original) {
                obsolete.add(hdfsFileStatusWithId.getFileStatus());
            }
            obsolete.addAll(originalDirectories);
            original.clear();
            originalDirectories.clear();
        } else {
            for (FileStatus fileStatus : originalDirectories) {
                AcidUtils.findOriginals(fs, fileStatus, original, useFileIds, ignoreEmptyFiles, true);
            }
        }
        Collections.sort(working);
        long current = bestBase.writeId;
        int lastStmtId = -1;
        ParsedDelta prev = null;
        for (ParsedDelta next : working) {
            if (next.maxWriteId > current) {
                if (writeIdList.isWriteIdRangeValid(current + 1L, next.maxWriteId) == ValidWriteIdList.RangeResponse.NONE) continue;
                deltas.add(next);
                current = next.maxWriteId;
                lastStmtId = next.statementId;
                prev = next;
                continue;
            }
            if (next.maxWriteId == current && lastStmtId >= 0) {
                deltas.add(next);
                prev = next;
                continue;
            }
            if (prev != null && next.maxWriteId == prev.maxWriteId && next.minWriteId == prev.minWriteId && next.statementId == prev.statementId) {
                deltas.add(next);
                prev = next;
                continue;
            }
            obsolete.add(next.path);
        }
        if (bestBase.oldestBase != null && bestBase.status == null) {
            long[] exceptions = writeIdList.getInvalidWriteIds();
            String minOpenWriteId = exceptions != null && exceptions.length > 0 ? Long.toString(exceptions[0]) : "x";
            throw new IOException(ErrorMsg.ACID_NOT_ENOUGH_HISTORY.format(Long.toString(writeIdList.getHighWatermark()), minOpenWriteId, bestBase.oldestBase.toString()));
        }
        Path base = bestBase.status == null ? null : bestBase.status.getPath();
        LOG.debug("in directory " + directory.toUri().toString() + " base = " + base + " deltas = " + deltas.size());
        Collections.sort(original, (o1, o2) -> o1.getFileStatus().compareTo(o2.getFileStatus()));
        boolean isBaseInRawFormat = base != null && MetaDataFile.isRawFormat(base, fs);
        return new DirectoryImpl(abortedDirectories, isBaseInRawFormat, original, obsolete, deltas, base);
    }

    private static boolean isValidBase(long baseWriteId, ValidWriteIdList writeIdList, Path baseDir, FileSystem fs) throws IOException {
        if (baseWriteId == Long.MIN_VALUE) {
            return true;
        }
        if (!MetaDataFile.isCompacted(baseDir, fs)) {
            return writeIdList.isWriteIdValid(baseWriteId);
        }
        return writeIdList.isValidBase(baseWriteId);
    }

    private static void getChildState(FileStatus child, HadoopShims.HdfsFileStatusWithId childWithId, ValidWriteIdList writeIdList, List<ParsedDelta> working, List<FileStatus> originalDirectories, List<HadoopShims.HdfsFileStatusWithId> original, List<FileStatus> obsolete, TxnBase bestBase, boolean ignoreEmptyFiles, List<FileStatus> aborted, Map<String, String> tblproperties, FileSystem fs) throws IOException {
        Path p = child.getPath();
        String fn = p.getName();
        if (!child.isDirectory()) {
            if (!ignoreEmptyFiles || child.getLen() != 0L) {
                original.add(AcidUtils.createOriginalObj(childWithId, child));
            }
            return;
        }
        if (fn.startsWith(BASE_PREFIX)) {
            long writeId = AcidUtils.parseBase(p);
            if (bestBase.oldestBaseWriteId > writeId) {
                bestBase.oldestBase = p;
                bestBase.oldestBaseWriteId = writeId;
            }
            if (bestBase.status == null) {
                if (AcidUtils.isValidBase(writeId, writeIdList, p, fs)) {
                    bestBase.status = child;
                    bestBase.writeId = writeId;
                }
            } else if (bestBase.writeId < writeId) {
                if (AcidUtils.isValidBase(writeId, writeIdList, p, fs)) {
                    obsolete.add(bestBase.status);
                    bestBase.status = child;
                    bestBase.writeId = writeId;
                }
            } else {
                obsolete.add(child);
            }
        } else if (fn.startsWith(DELTA_PREFIX) || fn.startsWith(DELETE_DELTA_PREFIX)) {
            String deltaPrefix = fn.startsWith(DELTA_PREFIX) ? DELTA_PREFIX : DELETE_DELTA_PREFIX;
            ParsedDelta delta = AcidUtils.parseDelta(child, deltaPrefix, fs);
            if (tblproperties != null && AcidUtils.isTransactionalTable(tblproperties) && ValidWriteIdList.RangeResponse.ALL == writeIdList.isWriteIdRangeAborted(delta.minWriteId, delta.maxWriteId)) {
                aborted.add(child);
            }
            if (writeIdList.isWriteIdRangeValid(delta.minWriteId, delta.maxWriteId) != ValidWriteIdList.RangeResponse.NONE) {
                working.add(delta);
            }
        } else {
            originalDirectories.add(child);
        }
    }

    public static HadoopShims.HdfsFileStatusWithId createOriginalObj(HadoopShims.HdfsFileStatusWithId childWithId, FileStatus child) {
        return childWithId != null ? childWithId : new HdfsFileStatusWithoutId(child);
    }

    public static void findOriginals(FileSystem fs, FileStatus stat, List<HadoopShims.HdfsFileStatusWithId> original, Ref<Boolean> useFileIds, boolean ignoreEmptyFiles, boolean recursive) throws IOException {
        List<HadoopShims.HdfsFileStatusWithId> childrenWithId;
        block11: {
            assert (stat.isDir());
            childrenWithId = null;
            Boolean val = (Boolean)useFileIds.value;
            if (val == null || val.booleanValue()) {
                try {
                    childrenWithId = SHIMS.listLocatedHdfsStatus(fs, stat.getPath(), hiddenFileFilter);
                    if (val == null) {
                        useFileIds.value = true;
                    }
                }
                catch (Throwable t) {
                    LOG.error("Failed to get files with ID; using regular API: " + t.getMessage());
                    if (val != null || !(t instanceof UnsupportedOperationException)) break block11;
                    useFileIds.value = false;
                }
            }
        }
        if (childrenWithId != null) {
            for (HadoopShims.HdfsFileStatusWithId child : childrenWithId) {
                if (child.getFileStatus().isDirectory()) {
                    if (!recursive) continue;
                    AcidUtils.findOriginals(fs, child.getFileStatus(), original, useFileIds, ignoreEmptyFiles, true);
                    continue;
                }
                if (ignoreEmptyFiles && child.getFileStatus().getLen() <= 0L) continue;
                original.add(child);
            }
        } else {
            List<FileStatus> children = HdfsUtils.listLocatedStatus(fs, stat.getPath(), hiddenFileFilter);
            for (FileStatus child : children) {
                if (child.isDir()) {
                    if (!recursive) continue;
                    AcidUtils.findOriginals(fs, child, original, useFileIds, ignoreEmptyFiles, true);
                    continue;
                }
                if (ignoreEmptyFiles && child.getLen() <= 0L) continue;
                original.add(AcidUtils.createOriginalObj(null, child));
            }
        }
    }

    public static boolean isTablePropertyTransactional(Properties props) {
        String resultStr = props.getProperty("transactional");
        if (resultStr == null) {
            resultStr = props.getProperty("transactional".toUpperCase());
        }
        return resultStr != null && resultStr.equalsIgnoreCase("true");
    }

    public static boolean isTablePropertyTransactional(Map<String, String> parameters) {
        String resultStr = parameters.get("transactional");
        if (resultStr == null) {
            resultStr = parameters.get("transactional".toUpperCase());
        }
        return resultStr != null && resultStr.equalsIgnoreCase("true");
    }

    public static boolean isTablePropertyTransactional(Configuration conf) {
        String resultStr = conf.get("transactional");
        if (resultStr == null) {
            resultStr = conf.get("transactional".toUpperCase());
        }
        return resultStr != null && resultStr.equalsIgnoreCase("true");
    }

    public static boolean isDeleteDelta(Path p) {
        return p.getName().startsWith(DELETE_DELTA_PREFIX);
    }

    public static boolean isTransactionalTable(CreateTableDesc table) {
        if (table == null || table.getTblProps() == null) {
            return false;
        }
        return AcidUtils.isTransactionalTable(table.getTblProps());
    }

    public static boolean isTransactionalTable(Map<String, String> props) {
        String tableIsTransactional = props.get("transactional");
        if (tableIsTransactional == null) {
            tableIsTransactional = props.get("transactional".toUpperCase());
        }
        return tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true");
    }

    public static boolean isFullAcidTable(Table table) {
        return AcidUtils.isFullAcidTable(table == null ? null : table.getTTable());
    }

    public static boolean isTransactionalTable(Table table) {
        return AcidUtils.isTransactionalTable(table == null ? null : table.getTTable());
    }

    public static boolean isFullAcidTable(org.apache.hadoop.hive.metastore.api.Table table) {
        return AcidUtils.isTransactionalTable(table) && !AcidUtils.isInsertOnlyTable(table.getParameters());
    }

    public static boolean isFullAcidTable(Map<String, String> params) {
        return AcidUtils.isTransactionalTable(params) && !AcidUtils.isInsertOnlyTable(params);
    }

    public static boolean isTransactionalTable(org.apache.hadoop.hive.metastore.api.Table table) {
        return table != null && table.getParameters() != null && AcidUtils.isTablePropertyTransactional(table.getParameters());
    }

    public static boolean isFullAcidTable(CreateTableDesc td) {
        if (td == null || td.getTblProps() == null) {
            return false;
        }
        String tableIsTransactional = td.getTblProps().get("transactional");
        if (tableIsTransactional == null) {
            tableIsTransactional = td.getTblProps().get("transactional".toUpperCase());
        }
        return tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true") && !AcidUtils.isInsertOnlyTable(td.getTblProps());
    }

    public static boolean isFullAcidScan(Configuration conf) {
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN)) {
            return false;
        }
        int propInt = conf.getInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, -1);
        if (propInt == -1) {
            return true;
        }
        AcidOperationalProperties props = AcidOperationalProperties.parseInt(propInt);
        return !props.isInsertOnly();
    }

    public static void setAcidOperationalProperties(Configuration conf, boolean isTxnTable, AcidOperationalProperties properties) {
        if (isTxnTable) {
            HiveConf.setBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, isTxnTable);
            if (properties != null) {
                HiveConf.setIntVar(conf, HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES, properties.toInt());
            }
        } else {
            conf.unset(HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN.varname);
            conf.unset(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname);
        }
    }

    public static void setAcidOperationalProperties(Map<String, String> parameters, boolean isTxnTable, AcidOperationalProperties properties) {
        parameters.put(HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN.varname, Boolean.toString(isTxnTable));
        if (properties != null) {
            parameters.put(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, properties.toString());
        }
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Table table) {
        String transactionalProperties = table.getProperty("transactional_properties");
        if (transactionalProperties == null) {
            return AcidOperationalProperties.getDefault();
        }
        return AcidOperationalProperties.parseString(transactionalProperties);
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Configuration conf) {
        return AcidOperationalProperties.parseInt(HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES));
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Properties props) {
        String resultStr = props.getProperty("transactional_properties");
        if (resultStr == null) {
            return AcidOperationalProperties.getDefault();
        }
        return AcidOperationalProperties.parseString(resultStr);
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Map<String, String> parameters) {
        String resultStr = parameters.get("transactional_properties");
        if (resultStr == null) {
            return AcidOperationalProperties.getDefault();
        }
        return AcidOperationalProperties.parseString(resultStr);
    }

    public static long getLogicalLength(FileSystem fs, FileStatus file) throws IOException {
        Path lengths = OrcAcidUtils.getSideFile(file.getPath());
        if (!fs.exists(lengths)) {
            return file.getLen();
        }
        long len = OrcAcidUtils.getLastFlushLength(fs, file.getPath());
        if (len >= 0L) {
            return len;
        }
        throw new IOException(lengths + " found but is not readable.  Consider waiting or orcfiledump --recover");
    }

    public static boolean isInsertOnlyTable(Map<String, String> params) {
        return AcidUtils.isInsertOnlyTable(params, false);
    }

    public static boolean isInsertOnlyTable(Table table) {
        return AcidUtils.isTransactionalTable(table) && AcidUtils.getAcidOperationalProperties(table).isInsertOnly();
    }

    public static boolean isInsertOnlyTable(Map<String, String> params, boolean isCtas) {
        String transactionalProp = params.get("transactional_properties");
        return transactionalProp != null && "insert_only".equalsIgnoreCase(transactionalProp);
    }

    public static boolean isInsertOnlyTable(Properties params) {
        String transactionalProp = params.getProperty("transactional_properties");
        return transactionalProp != null && "insert_only".equalsIgnoreCase(transactionalProp);
    }

    public static Boolean isToInsertOnlyTable(Table tbl, Map<String, String> props) {
        String transactional = props.get("transactional");
        String transactionalProp = props.get("transactional_properties");
        if (transactional == null && transactionalProp == null) {
            return null;
        }
        if (transactional == null && tbl != null) {
            transactional = tbl.getParameters().get("transactional");
        }
        boolean isSetToTxn = "true".equalsIgnoreCase(transactional);
        if (transactionalProp == null) {
            if (isSetToTxn || tbl == null) {
                return false;
            }
            throw new RuntimeException("Cannot change 'transactional' without 'transactional_properties'");
        }
        if (!"insert_only".equalsIgnoreCase(transactionalProp)) {
            return false;
        }
        if (!isSetToTxn) {
            if (tbl == null) {
                return true;
            }
            throw new RuntimeException("Cannot set 'transactional_properties' to 'insert_only' without setting 'transactional' to 'true'");
        }
        return true;
    }

    public static boolean isRemovedInsertOnlyTable(Set<String> removedSet) {
        boolean hasTxn = removedSet.contains("transactional");
        boolean hasProps = removedSet.contains("transactional_properties");
        return hasTxn || hasProps;
    }

    public static ValidTxnWriteIdList getValidTxnWriteIdList(Configuration conf) {
        String txnString = conf.get("hive.txn.tables.valid.writeids");
        ValidTxnWriteIdList validTxnList = new ValidTxnWriteIdList(txnString);
        return validTxnList;
    }

    public static ValidWriteIdList getTableValidWriteIdList(Configuration conf, String fullTableName) {
        ValidTxnWriteIdList validTxnList = AcidUtils.getValidTxnWriteIdList(conf);
        return validTxnList.getTableValidWriteIdList(fullTableName);
    }

    public static void setValidWriteIdList(Configuration conf, ValidWriteIdList validWriteIds) {
        conf.set("hive.txn.valid.writeids", validWriteIds.toString());
        LOG.debug("Setting ValidWriteIdList: " + validWriteIds.toString() + " isAcidTable: " + HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, false) + " acidProperty: " + AcidUtils.getAcidOperationalProperties(conf));
    }

    public static void setValidWriteIdList(Configuration conf, TableScanDesc tsDesc) {
        if (tsDesc.isTranscationalTable()) {
            String tableName;
            String dbName = tsDesc.getDatabaseName();
            ValidWriteIdList validWriteIdList = AcidUtils.getTableValidWriteIdList(conf, AcidUtils.getFullTableName(dbName, tableName = tsDesc.getTableName()));
            if (validWriteIdList != null) {
                AcidUtils.setValidWriteIdList(conf, validWriteIdList);
            } else {
                LOG.error("setValidWriteIdList on table: " + AcidUtils.getFullTableName(dbName, tableName) + " isAcidTable: true acidProperty: " + AcidUtils.getAcidOperationalProperties(conf) + " couldn't find the ValidWriteId list from ValidTxnWriteIdList: " + conf.get("hive.txn.tables.valid.writeids"));
                throw new IllegalStateException("ACID table: " + AcidUtils.getFullTableName(dbName, tableName) + " is missing from the ValidWriteIdList config: " + conf.get("hive.txn.tables.valid.writeids"));
            }
        }
    }

    public static String getFullTableName(String dbName, String tableName) {
        return dbName.toLowerCase() + "." + tableName.toLowerCase();
    }

    public static List<FileStatus> getAcidFilesForStats(Table table, Path dir, Configuration jc, FileSystem fs) throws IOException {
        ArrayList<FileStatus> fileList = new ArrayList<FileStatus>();
        ValidWriteIdList idList = AcidUtils.getTableValidWriteIdList(jc, AcidUtils.getFullTableName(table.getDbName(), table.getTableName()));
        if (idList == null) {
            LOG.warn("Cannot get ACID state for " + table.getDbName() + "." + table.getTableName() + " from " + jc.get("hive.txn.tables.valid.writeids"));
            return null;
        }
        Directory acidInfo = AcidUtils.getAcidState(dir, jc, idList);
        if (!acidInfo.getCurrentDirectories().isEmpty() && AcidUtils.isFullAcidTable(table)) {
            Utilities.FILE_OP_LOGGER.warn("Computing stats for an ACID table; stats may be inaccurate");
        }
        if (fs == null) {
            fs = dir.getFileSystem(jc);
        }
        for (HadoopShims.HdfsFileStatusWithId hfs : acidInfo.getOriginalFiles()) {
            fileList.add(hfs.getFileStatus());
        }
        for (ParsedDelta delta : acidInfo.getCurrentDirectories()) {
            for (FileStatus f : HiveStatsUtils.getFileStatusRecurse(delta.getPath(), -1, fs)) {
                fileList.add(f);
            }
        }
        if (acidInfo.getBaseDirectory() != null) {
            for (FileStatus f : HiveStatsUtils.getFileStatusRecurse(acidInfo.getBaseDirectory(), -1, fs)) {
                fileList.add(f);
            }
        }
        return fileList;
    }

    public static List<Path> getValidDataPaths(Path dataPath, Configuration conf, String validWriteIdStr) throws IOException {
        ArrayList<Path> pathList = new ArrayList<Path>();
        if (validWriteIdStr == null || validWriteIdStr.isEmpty()) {
            pathList.add(dataPath);
            return pathList;
        }
        ValidReaderWriteIdList validWriteIdList = new ValidReaderWriteIdList(validWriteIdStr);
        Directory acidInfo = AcidUtils.getAcidState(dataPath, conf, validWriteIdList);
        for (HadoopShims.HdfsFileStatusWithId hfs : acidInfo.getOriginalFiles()) {
            pathList.add(hfs.getFileStatus().getPath());
        }
        for (ParsedDelta delta : acidInfo.getCurrentDirectories()) {
            pathList.add(delta.getPath());
        }
        if (acidInfo.getBaseDirectory() != null) {
            pathList.add(acidInfo.getBaseDirectory());
        }
        return pathList;
    }

    public static String getAcidSubDir(Path dataPath) {
        String dataDir = dataPath.getName();
        if (dataDir.startsWith(BASE_PREFIX) || dataDir.startsWith(DELTA_PREFIX) || dataDir.startsWith(DELETE_DELTA_PREFIX)) {
            return dataDir;
        }
        return null;
    }

    public static boolean isAcidEnabled(HiveConf hiveConf) {
        String txnMgr = hiveConf.getVar(HiveConf.ConfVars.HIVE_TXN_MANAGER);
        boolean concurrency = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        String dbTxnMgr = "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager";
        return txnMgr.equals(dbTxnMgr) && concurrency;
    }

    public static Long extractWriteId(Path file) {
        String fileName = file.getName();
        if (!fileName.startsWith(DELTA_PREFIX) && !fileName.startsWith(BASE_PREFIX)) {
            LOG.trace("Cannot extract write ID for a MM table: {}", (Object)file);
            return null;
        }
        Object[] parts = fileName.split("_", 4);
        if (parts.length < 2) {
            LOG.debug("Cannot extract write ID for a MM table: " + file + " (" + Arrays.toString(parts) + ")");
            return null;
        }
        long writeId = -1L;
        try {
            writeId = Long.parseLong((String)parts[1]);
        }
        catch (NumberFormatException ex) {
            LOG.debug("Cannot extract write ID for a MM table: " + file + "; parsing " + (String)parts[1] + " got " + ex.getMessage());
            return null;
        }
        return writeId;
    }

    public static void setNonTransactional(Map<String, String> tblProps) {
        tblProps.put("transactional", "false");
        tblProps.remove("transactional_properties");
    }

    public static boolean isAcidTable(ASTNode tree, HiveConf conf) throws SemanticException {
        return AcidUtils.isFullAcidTable(TableUtils.findTable(tree, conf));
    }

    public static class IdPathFilter
    implements PathFilter {
        private String baseDirName;
        private String deltaDirName;
        private final boolean isDeltaPrefix;

        public IdPathFilter(long writeId, int stmtId) {
            String deltaDirName = null;
            deltaDirName = AcidUtils.DELTA_PREFIX + String.format(AcidUtils.DELTA_DIGITS, writeId) + "_" + String.format(AcidUtils.DELTA_DIGITS, writeId);
            boolean bl = this.isDeltaPrefix = stmtId < 0;
            if (!this.isDeltaPrefix) {
                deltaDirName = deltaDirName + "_" + String.format(AcidUtils.STATEMENT_DIGITS, stmtId);
            }
            this.baseDirName = AcidUtils.BASE_PREFIX + String.format(AcidUtils.DELTA_DIGITS, writeId);
            this.deltaDirName = deltaDirName;
        }

        public boolean accept(Path path) {
            String name = path.getName();
            return name.equals(this.baseDirName) || this.isDeltaPrefix && name.startsWith(this.deltaDirName) || !this.isDeltaPrefix && name.equals(this.deltaDirName);
        }
    }

    public static class AnyIdDirFilter
    implements PathFilter {
        public boolean accept(Path path) {
            return AcidUtils.extractWriteId(path) != null;
        }
    }

    public static final class OrcAcidVersion {
        private static final String ACID_VERSION_KEY = "hive.acid.version";
        private static final String ACID_FORMAT = "_orc_acid_version";
        private static final Charset UTF8 = Charset.forName("UTF-8");
        public static final int ORC_ACID_VERSION_DEFAULT = 0;
        public static final int ORC_ACID_VERSION = 2;

        public static void setAcidVersionInDataFile(Writer writer) {
            writer.addUserMetadata(ACID_VERSION_KEY, UTF8.encode(String.valueOf(2)));
        }

        @VisibleForTesting
        public static int getAcidVersionFromDataFile(Path dataFile, FileSystem fs) throws IOException {
            FileStatus fileStatus = fs.getFileStatus(dataFile);
            Reader orcReader = OrcFile.createReader(dataFile, OrcFile.readerOptions(fs.getConf()).filesystem(fs).maxLength(AcidUtils.getLogicalLength(fs, fileStatus)));
            if (orcReader.hasMetadataValue(ACID_VERSION_KEY)) {
                char[] versionChar = UTF8.decode(orcReader.getMetadataValue(ACID_VERSION_KEY)).array();
                String version = new String(versionChar);
                return Integer.valueOf(version);
            }
            return 0;
        }

        public static void writeVersionFile(Path deltaOrBaseDir, FileSystem fs) throws IOException {
            Path formatFile = OrcAcidVersion.getVersionFilePath(deltaOrBaseDir);
            if (!fs.exists(formatFile)) {
                try (FSDataOutputStream strm = fs.create(formatFile, false);){
                    strm.write(UTF8.encode(String.valueOf(2)).array());
                }
                catch (IOException ioe) {
                    LOG.error("Failed to create " + formatFile + " due to: " + ioe.getMessage(), (Throwable)ioe);
                    throw ioe;
                }
            }
        }

        public static Path getVersionFilePath(Path deltaOrBase) {
            return new Path(deltaOrBase, ACID_FORMAT);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @VisibleForTesting
        public static int getAcidVersionFromMetaFile(Path deltaOrBaseDir, FileSystem fs) throws IOException {
            Path formatFile = OrcAcidVersion.getVersionFilePath(deltaOrBaseDir);
            if (!fs.exists(formatFile)) {
                LOG.debug(formatFile + " not found, returning default: 0");
                return 0;
            }
            try (FSDataInputStream inputStream = fs.open(formatFile);){
                byte[] bytes = new byte[1];
                int read = inputStream.read(bytes);
                if (read != -1) {
                    String version = new String(bytes, UTF8);
                    int n2 = Integer.valueOf(version);
                    return n2;
                }
                int n = 0;
                return n;
            }
            catch (IOException ex) {
                LOG.error(formatFile + " is unreadable due to: " + ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    public static class MetaDataFile {
        private static final String METADATA_FILE = "_metadata_acid";
        private static final String CURRENT_VERSION = "0";

        public static void createCompactorMarker(Path baseOrDeltaDir, FileSystem fs) throws IOException {
            Path formatFile = new Path(baseOrDeltaDir, METADATA_FILE);
            HashMap<String, String> metaData = new HashMap<String, String>();
            metaData.put("thisFileVersion", CURRENT_VERSION);
            metaData.put("dataFormat", "compacted");
            try (FSDataOutputStream strm = fs.create(formatFile, false);){
                new ObjectMapper().writeValue((OutputStream)strm, metaData);
            }
            catch (IOException ioe) {
                String msg = "Failed to create " + baseOrDeltaDir + "/_metadata_acid: " + ioe.getMessage();
                LOG.error(msg, (Throwable)ioe);
                throw ioe;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static boolean isCompacted(Path baseOrDeltaDir, FileSystem fs) throws IOException {
            Path formatFile = new Path(baseOrDeltaDir, METADATA_FILE);
            if (!fs.exists(formatFile)) {
                return false;
            }
            try (FSDataInputStream strm = fs.open(formatFile);){
                String dataFormat;
                Map metaData = new ObjectMapper().readValue((InputStream)strm, Map.class);
                if (!CURRENT_VERSION.equalsIgnoreCase((String)metaData.get("thisFileVersion"))) {
                    throw new IllegalStateException("Unexpected Meta Data version: " + (String)metaData.get("thisFileVersion"));
                }
                switch (dataFormat = metaData.getOrDefault("dataFormat", "null")) {
                    case "compacted": {
                        boolean bl = true;
                        return bl;
                    }
                }
                throw new IllegalArgumentException("Unexpected value for dataFormat: " + dataFormat);
            }
            catch (IOException e) {
                String msg = "Failed to read " + baseOrDeltaDir + "/_metadata_acid: " + e.getMessage();
                LOG.error(msg, (Throwable)e);
                throw e;
            }
        }

        private static Path chooseFile(Path baseOrDeltaDir, FileSystem fs) throws IOException {
            if (!baseOrDeltaDir.getName().startsWith(AcidUtils.BASE_PREFIX) && !baseOrDeltaDir.getName().startsWith(AcidUtils.DELTA_PREFIX)) {
                throw new IllegalArgumentException(baseOrDeltaDir + " is not a base/delta");
            }
            FileStatus[] dataFiles = fs.listStatus(new Path[]{baseOrDeltaDir}, originalBucketFilter);
            return dataFiles != null && dataFiles.length > 0 ? dataFiles[0].getPath() : null;
        }

        public static boolean isRawFormat(Path baseOrDeltaDir, FileSystem fs) throws IOException {
            Path dataFile = MetaDataFile.chooseFile(baseOrDeltaDir, fs);
            if (dataFile == null) {
                return false;
            }
            return MetaDataFile.isRawFormatFile(dataFile, fs);
        }

        public static boolean isRawFormatFile(Path dataFile, FileSystem fs) throws IOException {
            try {
                Reader reader = OrcFile.createReader(dataFile, OrcFile.readerOptions(fs.getConf()));
                return OrcInputFormat.isOriginal(reader);
            }
            catch (FileFormatException ex) {
                LOG.debug("isRawFormat() called on " + dataFile + " which is not an ORC file: " + ex.getMessage());
                return true;
            }
        }

        private static interface Value {
            public static final String COMPACTED = "compacted";
        }

        private static interface Field {
            public static final String VERSION = "thisFileVersion";
            public static final String DATA_FORMAT = "dataFormat";
        }
    }

    private static class HdfsFileStatusWithoutId
    implements HadoopShims.HdfsFileStatusWithId {
        private final FileStatus fs;

        public HdfsFileStatusWithoutId(FileStatus fs) {
            this.fs = fs;
        }

        @Override
        public FileStatus getFileStatus() {
            return this.fs;
        }

        @Override
        public Long getFileId() {
            return null;
        }
    }

    private static class TxnBase {
        private FileStatus status;
        private long writeId = 0L;
        private long oldestBaseWriteId = Long.MAX_VALUE;
        private Path oldestBase = null;

        private TxnBase() {
        }
    }

    public static final class ParsedDelta
    implements Comparable<ParsedDelta> {
        private final long minWriteId;
        private final long maxWriteId;
        private final FileStatus path;
        private final int statementId;
        private final boolean isDeleteDelta;
        private final boolean isRawFormat;

        private ParsedDelta(long min, long max, FileStatus path, boolean isDeleteDelta, boolean isRawFormat) {
            this(min, max, path, -1, isDeleteDelta, isRawFormat);
        }

        private ParsedDelta(long min, long max, FileStatus path, int statementId, boolean isDeleteDelta, boolean isRawFormat) {
            this.minWriteId = min;
            this.maxWriteId = max;
            this.path = path;
            this.statementId = statementId;
            this.isDeleteDelta = isDeleteDelta;
            this.isRawFormat = isRawFormat;
            assert (!isDeleteDelta || !isRawFormat) : " deleteDelta should not be raw format";
        }

        public long getMinWriteId() {
            return this.minWriteId;
        }

        public long getMaxWriteId() {
            return this.maxWriteId;
        }

        public Path getPath() {
            return this.path.getPath();
        }

        public int getStatementId() {
            return this.statementId == -1 ? 0 : this.statementId;
        }

        public boolean isDeleteDelta() {
            return this.isDeleteDelta;
        }

        public boolean isRawFormat() {
            return this.isRawFormat;
        }

        @Override
        public int compareTo(ParsedDelta parsedDelta) {
            if (this.minWriteId != parsedDelta.minWriteId) {
                if (this.minWriteId < parsedDelta.minWriteId) {
                    return -1;
                }
                return 1;
            }
            if (this.maxWriteId != parsedDelta.maxWriteId) {
                if (this.maxWriteId < parsedDelta.maxWriteId) {
                    return 1;
                }
                return -1;
            }
            if (this.statementId != parsedDelta.statementId) {
                if (this.statementId < parsedDelta.statementId) {
                    return -1;
                }
                return 1;
            }
            return this.path.compareTo(parsedDelta.path);
        }
    }

    public static interface Directory {
        public Path getBaseDirectory();

        public boolean isBaseInRawFormat();

        public List<HadoopShims.HdfsFileStatusWithId> getOriginalFiles();

        public List<ParsedDelta> getCurrentDirectories();

        public List<FileStatus> getObsolete();

        public List<FileStatus> getAbortedDirectories();
    }

    public static class AcidOperationalProperties {
        private int description = 0;
        public static final int SPLIT_UPDATE_BIT = 1;
        public static final String SPLIT_UPDATE_STRING = "split_update";
        public static final int HASH_BASED_MERGE_BIT = 2;
        public static final String HASH_BASED_MERGE_STRING = "hash_merge";
        public static final int INSERT_ONLY_BIT = 4;
        public static final String INSERT_ONLY_STRING = "insert_only";
        public static final String DEFAULT_VALUE_STRING = "default";
        public static final String INSERTONLY_VALUE_STRING = "insert_only";

        private AcidOperationalProperties() {
        }

        public static AcidOperationalProperties getDefault() {
            AcidOperationalProperties obj = new AcidOperationalProperties();
            obj.setSplitUpdate(true);
            obj.setHashBasedMerge(false);
            obj.setInsertOnly(false);
            return obj;
        }

        public static AcidOperationalProperties getInsertOnly() {
            AcidOperationalProperties obj = new AcidOperationalProperties();
            obj.setInsertOnly(true);
            return obj;
        }

        public static AcidOperationalProperties parseString(String propertiesStr) {
            String[] options;
            if (propertiesStr == null) {
                return AcidOperationalProperties.getDefault();
            }
            if (propertiesStr.equalsIgnoreCase(DEFAULT_VALUE_STRING)) {
                return AcidOperationalProperties.getDefault();
            }
            if (propertiesStr.equalsIgnoreCase("insert_only")) {
                return AcidOperationalProperties.getInsertOnly();
            }
            AcidOperationalProperties obj = new AcidOperationalProperties();
            block8: for (String option : options = propertiesStr.split("\\|")) {
                if (option.trim().length() == 0) continue;
                switch (option) {
                    case "split_update": {
                        obj.setSplitUpdate(true);
                        continue block8;
                    }
                    case "hash_merge": {
                        obj.setHashBasedMerge(true);
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value " + option + " for ACID operational properties!");
                    }
                }
            }
            return obj;
        }

        public static AcidOperationalProperties parseInt(int properties) {
            AcidOperationalProperties obj = new AcidOperationalProperties();
            if ((properties & 1) > 0) {
                obj.setSplitUpdate(true);
            }
            if ((properties & 2) > 0) {
                obj.setHashBasedMerge(true);
            }
            if ((properties & 4) > 0) {
                obj.setInsertOnly(true);
            }
            return obj;
        }

        public AcidOperationalProperties setSplitUpdate(boolean isSplitUpdate) {
            this.description = isSplitUpdate ? this.description | 1 : this.description & 0xFFFFFFFE;
            return this;
        }

        public AcidOperationalProperties setHashBasedMerge(boolean isHashBasedMerge) {
            this.description = isHashBasedMerge ? this.description | 2 : this.description & 0xFFFFFFFD;
            return this;
        }

        public AcidOperationalProperties setInsertOnly(boolean isInsertOnly) {
            this.description = isInsertOnly ? this.description | 4 : this.description & 0xFFFFFFFB;
            return this;
        }

        public boolean isSplitUpdate() {
            return (this.description & 1) > 0;
        }

        public boolean isHashBasedMerge() {
            return (this.description & 2) > 0;
        }

        public boolean isInsertOnly() {
            return (this.description & 4) > 0;
        }

        public int toInt() {
            return this.description;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            if (this.isSplitUpdate()) {
                str.append("|split_update");
            }
            if (this.isHashBasedMerge()) {
                str.append("|hash_merge");
            }
            if (this.isInsertOnly()) {
                str.append("|insert_only");
            }
            return str.toString();
        }
    }

    public static class AcidBaseFileInfo {
        private final HadoopShims.HdfsFileStatusWithId fileId;
        private final AcidBaseFileType acidBaseFileType;

        public AcidBaseFileInfo(HadoopShims.HdfsFileStatusWithId fileId, AcidBaseFileType acidBaseFileType) {
            this.fileId = fileId;
            this.acidBaseFileType = acidBaseFileType;
        }

        public boolean isOriginal() {
            return this.acidBaseFileType == AcidBaseFileType.ORIGINAL_BASE;
        }

        public boolean isAcidSchema() {
            return this.acidBaseFileType == AcidBaseFileType.ACID_SCHEMA;
        }

        public HadoopShims.HdfsFileStatusWithId getHdfsFileStatusWithId() {
            return this.fileId;
        }
    }

    public static enum AcidBaseFileType {
        ORIGINAL_BASE,
        ACID_SCHEMA;

    }

    public static enum Operation implements Serializable
    {
        NOT_ACID,
        INSERT,
        UPDATE,
        DELETE;

    }

    public static final class DirectoryImpl
    implements Directory {
        private final List<FileStatus> abortedDirectories;
        private final boolean isBaseInRawFormat;
        private final List<HadoopShims.HdfsFileStatusWithId> original;
        private final List<FileStatus> obsolete;
        private final List<ParsedDelta> deltas;
        private final Path base;

        public DirectoryImpl(List<FileStatus> abortedDirectories, boolean isBaseInRawFormat, List<HadoopShims.HdfsFileStatusWithId> original, List<FileStatus> obsolete, List<ParsedDelta> deltas, Path base) {
            this.abortedDirectories = abortedDirectories;
            this.isBaseInRawFormat = isBaseInRawFormat;
            this.original = original;
            this.obsolete = obsolete;
            this.deltas = deltas;
            this.base = base;
        }

        @Override
        public Path getBaseDirectory() {
            return this.base;
        }

        @Override
        public boolean isBaseInRawFormat() {
            return this.isBaseInRawFormat;
        }

        @Override
        public List<HadoopShims.HdfsFileStatusWithId> getOriginalFiles() {
            return this.original;
        }

        @Override
        public List<ParsedDelta> getCurrentDirectories() {
            return this.deltas;
        }

        @Override
        public List<FileStatus> getObsolete() {
            return this.obsolete;
        }

        @Override
        public List<FileStatus> getAbortedDirectories() {
            return this.abortedDirectories;
        }
    }
}

