/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

@Description(name="sum", value="_FUNC_(expr) - Returns the sum value of expr (vectorized, type: decimal64)")
public class VectorUDAFSumDecimal64ToDecimal
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private int inputScale;
    private DecimalTypeInfo outputDecimalTypeInfo;
    private final transient HiveDecimalWritable temp = new HiveDecimalWritable();

    public VectorUDAFSumDecimal64ToDecimal() {
    }

    public VectorUDAFSumDecimal64ToDecimal(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
        this.init();
    }

    private void init() {
        this.inputScale = ((DecimalTypeInfo)this.inputTypeInfo).getScale();
        this.outputDecimalTypeInfo = (DecimalTypeInfo)this.outputTypeInfo;
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregateIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        Decimal64ColumnVector inputVector = (Decimal64ColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        long[] vector = inputVector.vector;
        if (inputVector.noNulls) {
            if (inputVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector[0], batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize);
            }
        } else if (inputVector.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsRepeatingSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector[0], batchSize, batch.selected, inputVector.isNull);
            } else {
                this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector[0], batchSize, inputVector.isNull);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize, batch.selected, inputVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize, inputVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long value, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long[] values, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(values[selection[i]]);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(values[i]);
        }
    }

    private void iterateHasNullsRepeatingSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long value, int batchSize, int[] selection, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long value, int batchSize, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(value);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long[] values, int batchSize, int[] selection, boolean[] isNull) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selection[j];
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, j);
            myagg.sumValue(values[i]);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long[] values, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.sumValue(values[i]);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        Decimal64ColumnVector inputVector = (Decimal64ColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        long[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls || !inputVector.isNull[0]) {
                if (myagg.isNull) {
                    myagg.isNull = false;
                    myagg.sum = 0L;
                }
                myagg.sumValueNoCheck(vector[0] * (long)batchSize);
            }
            return;
        }
        if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, vector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, vector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, long[] vector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            long value = vector[i];
            if (myagg.isNull) {
                myagg.isNull = false;
                myagg.sum = 0L;
            }
            myagg.sumValueNoCheck(value);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, long[] vector, int batchSize, int[] selected) {
        if (myagg.isNull) {
            myagg.sum = 0L;
            myagg.isNull = false;
        }
        for (int i = 0; i < batchSize; ++i) {
            long value = vector[selected[i]];
            myagg.sumValueNoCheck(value);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, long[] vector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            long value = vector[i];
            if (myagg.isNull) {
                myagg.sum = 0L;
                myagg.isNull = false;
            }
            myagg.sumValueNoCheck(value);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, long[] vector, int batchSize) {
        if (myagg.isNull) {
            myagg.sum = 0L;
            myagg.isNull = false;
        }
        for (int i = 0; i < batchSize; ++i) {
            long value = vector[i];
            myagg.sumValueNoCheck(value);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation(this.inputScale, this.temp);
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp(model.object(), model.memoryAlign());
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return name.equals("sum") && inputColVectorType == ColumnVector.Type.DECIMAL_64 && outputColVectorType == ColumnVector.Type.DECIMAL;
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        boolean isNull;
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[columnNum];
        Aggregation myagg = (Aggregation)agg;
        if (!myagg.isNull) {
            if (!myagg.usingRegularDecimal) {
                myagg.regularDecimalSum.deserialize64(myagg.sum, this.inputScale);
            } else {
                myagg.temp.deserialize64(myagg.sum, this.inputScale);
                myagg.regularDecimalSum.mutateAdd(myagg.temp);
            }
            myagg.regularDecimalSum.mutateEnforcePrecisionScale(this.outputDecimalTypeInfo.getPrecision(), this.outputDecimalTypeInfo.getScale());
            isNull = !myagg.regularDecimalSum.isSet();
        } else {
            isNull = true;
        }
        if (isNull) {
            outputColVector.noNulls = false;
            outputColVector.isNull[batchIndex] = true;
            return;
        }
        outputColVector.isNull[batchIndex] = false;
        outputColVector.set(batchIndex, myagg.regularDecimalSum);
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private static final long nearDecimal64Max = HiveDecimalWritable.getDecimal64AbsMax(17);
        private final int inputScale;
        private final HiveDecimalWritable temp;
        private long sum;
        private final HiveDecimalWritable regularDecimalSum = new HiveDecimalWritable(0L);
        private boolean isNull = true;
        private boolean usingRegularDecimal = false;

        public Aggregation(int inputScale, HiveDecimalWritable temp) {
            this.inputScale = inputScale;
            this.temp = temp;
        }

        public void sumValue(long value) {
            if (this.isNull) {
                this.sum = value;
                this.isNull = false;
            } else if (Math.abs(this.sum) > nearDecimal64Max) {
                if (!this.usingRegularDecimal) {
                    this.usingRegularDecimal = true;
                    this.regularDecimalSum.deserialize64(this.sum, this.inputScale);
                } else {
                    this.temp.deserialize64(this.sum, this.inputScale);
                    this.regularDecimalSum.mutateAdd(this.temp);
                }
                this.sum = value;
            } else {
                this.sum += value;
            }
        }

        public void sumValueNoCheck(long value) {
            if (Math.abs(this.sum) > nearDecimal64Max) {
                if (!this.usingRegularDecimal) {
                    this.usingRegularDecimal = true;
                    this.regularDecimalSum.deserialize64(this.sum, this.inputScale);
                } else {
                    this.temp.deserialize64(this.sum, this.inputScale);
                    this.regularDecimalSum.mutateAdd(this.temp);
                }
                this.sum = value;
            } else {
                this.sum += value;
            }
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.usingRegularDecimal = false;
            this.sum = 0L;
            this.regularDecimalSum.setFromLong(0L);
        }
    }
}

