/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

import hive.com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;

@VisibleForTesting
public class CacheChunk
extends DiskRangeList {
    protected MemoryBuffer buffer;

    public CacheChunk(MemoryBuffer buffer, long offset, long end) {
        super(offset, end);
        this.buffer = buffer;
        this.offset = offset;
        this.end = end;
    }

    @Override
    public boolean hasData() {
        return this.buffer != null;
    }

    @Override
    public ByteBuffer getData() {
        return this.buffer.getByteBufferRaw();
    }

    @Override
    public String toString() {
        return "start: " + this.offset + " end: " + this.end + " cache buffer: " + this.getBuffer();
    }

    @Override
    public DiskRange sliceAndShift(long offset, long end, long shiftBy) {
        throw new UnsupportedOperationException("Cache chunk cannot be sliced - attempted [" + this.offset + ", " + this.end + ") to [" + offset + ", " + end + ") ");
    }

    public MemoryBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(MemoryBuffer buffer) {
        this.buffer = buffer;
    }

    public void handleCacheCollision(DataCache cache, MemoryBuffer replacementBuffer, List<MemoryBuffer> cacheBuffers) {
        throw new UnsupportedOperationException();
    }

    public void adjustEnd(long l) {
        this.end += l;
    }
}

