/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop;

import hive.org.apache.parquet.Preconditions;
import hive.org.apache.parquet.column.ParquetProperties;
import hive.org.apache.parquet.hadoop.CodecFactory;
import hive.org.apache.parquet.hadoop.InternalParquetRecordWriter;
import hive.org.apache.parquet.hadoop.MemoryManager;
import hive.org.apache.parquet.hadoop.ParquetFileWriter;
import hive.org.apache.parquet.hadoop.api.WriteSupport;
import hive.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import hive.org.apache.parquet.schema.MessageType;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ParquetRecordWriter<T>
extends RecordWriter<Void, T> {
    private final InternalParquetRecordWriter<T> internalWriter;
    private final MemoryManager memoryManager;
    private final CodecFactory codecFactory;

    @Deprecated
    public ParquetRecordWriter(ParquetFileWriter w, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, int blockSize, int pageSize, CodecFactory.BytesCompressor compressor, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion) {
        ParquetProperties props = ParquetProperties.builder().withPageSize(pageSize).withDictionaryPageSize(dictionaryPageSize).withDictionaryEncoding(enableDictionary).withWriterVersion(writerVersion).build();
        this.internalWriter = new InternalParquetRecordWriter<T>(w, writeSupport, schema, extraMetaData, blockSize, compressor, validating, props);
        this.memoryManager = null;
        this.codecFactory = null;
    }

    @Deprecated
    public ParquetRecordWriter(ParquetFileWriter w, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, long blockSize, int pageSize, CodecFactory.BytesCompressor compressor, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, MemoryManager memoryManager) {
        ParquetProperties props = ParquetProperties.builder().withPageSize(pageSize).withDictionaryPageSize(dictionaryPageSize).withDictionaryEncoding(enableDictionary).withWriterVersion(writerVersion).build();
        this.internalWriter = new InternalParquetRecordWriter<T>(w, writeSupport, schema, extraMetaData, blockSize, compressor, validating, props);
        this.memoryManager = Preconditions.checkNotNull(memoryManager, "memoryManager");
        memoryManager.addWriter(this.internalWriter, blockSize);
        this.codecFactory = null;
    }

    ParquetRecordWriter(ParquetFileWriter w, WriteSupport<T> writeSupport, MessageType schema, Map<String, String> extraMetaData, long blockSize, CompressionCodecName codec, boolean validating, ParquetProperties props, MemoryManager memoryManager, Configuration conf) {
        this.codecFactory = new CodecFactory(conf, props.getPageSizeThreshold());
        this.internalWriter = new InternalParquetRecordWriter<T>(w, writeSupport, schema, extraMetaData, blockSize, this.codecFactory.getCompressor(codec), validating, props);
        this.memoryManager = Preconditions.checkNotNull(memoryManager, "memoryManager");
        memoryManager.addWriter(this.internalWriter, blockSize);
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            this.internalWriter.close();
        }
        finally {
            if (this.codecFactory != null) {
                this.codecFactory.release();
            }
            if (this.memoryManager != null) {
                this.memoryManager.removeWriter(this.internalWriter);
            }
        }
    }

    public void write(Void key, T value) throws IOException, InterruptedException {
        this.internalWriter.write(value);
    }
}

