/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import hive.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRelColumnsAlignment;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.PlanModifierUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanModifierForASTConv {
    private static final Logger LOG = LoggerFactory.getLogger(PlanModifierForASTConv.class);

    public static RelNode convertOpTree(RelNode rel, List<FieldSchema> resultSchema, boolean alignColumns) throws CalciteSemanticException {
        RelNode newTopNode = rel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Original plan for PlanModifier\n " + RelOptUtil.toString((RelNode)newTopNode));
        }
        if (!(newTopNode instanceof Project) && !(newTopNode instanceof Sort)) {
            newTopNode = PlanModifierForASTConv.introduceDerivedTable(newTopNode);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Plan after top-level introduceDerivedTable\n " + RelOptUtil.toString((RelNode)newTopNode));
            }
        }
        PlanModifierForASTConv.convertOpTree(newTopNode, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Plan after nested convertOpTree\n " + RelOptUtil.toString((RelNode)newTopNode));
        }
        if (alignColumns) {
            HiveRelColumnsAlignment propagator = new HiveRelColumnsAlignment(HiveRelFactories.HIVE_BUILDER.create(newTopNode.getCluster(), null));
            newTopNode = propagator.align(newTopNode);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Plan after propagating order\n " + RelOptUtil.toString((RelNode)newTopNode));
            }
        }
        Pair<RelNode, RelNode> topSelparentPair = HiveCalciteUtil.getTopLevelSelect(newTopNode);
        PlanModifierUtil.fixTopOBSchema(newTopNode, topSelparentPair, resultSchema, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Plan after fixTopOBSchema\n " + RelOptUtil.toString((RelNode)newTopNode));
        }
        topSelparentPair = HiveCalciteUtil.getTopLevelSelect(newTopNode);
        newTopNode = PlanModifierForASTConv.renameTopLevelSelectInResultSchema(newTopNode, topSelparentPair, resultSchema);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Final plan after modifier\n " + RelOptUtil.toString((RelNode)newTopNode));
        }
        return newTopNode;
    }

    private static String getTblAlias(RelNode rel) {
        if (null == rel) {
            return null;
        }
        if (rel instanceof HiveTableScan) {
            return ((HiveTableScan)rel).getTableAlias();
        }
        if (rel instanceof DruidQuery) {
            DruidQuery dq = (DruidQuery)rel;
            return ((HiveTableScan)dq.getTableScan()).getTableAlias();
        }
        if (rel instanceof Project) {
            return null;
        }
        if (rel.getInputs().size() == 1) {
            return PlanModifierForASTConv.getTblAlias(rel.getInput(0));
        }
        return null;
    }

    private static void convertOpTree(RelNode rel, RelNode parent) {
        if (rel instanceof HepRelVertex) {
            throw new RuntimeException("Found HepRelVertex");
        }
        if (rel instanceof Join) {
            String leftChild;
            if (!PlanModifierForASTConv.validJoinParent(rel, parent)) {
                PlanModifierForASTConv.introduceDerivedTable(rel, parent);
            }
            if (null != (leftChild = PlanModifierForASTConv.getTblAlias(((Join)rel).getLeft())) && leftChild.equalsIgnoreCase(PlanModifierForASTConv.getTblAlias(((Join)rel).getRight()))) {
                PlanModifierForASTConv.introduceDerivedTable(((Join)rel).getLeft(), rel);
            }
        } else {
            if (rel instanceof MultiJoin) {
                throw new RuntimeException("Found MultiJoin");
            }
            if (rel instanceof RelSubset) {
                throw new RuntimeException("Found RelSubset");
            }
            if (rel instanceof SetOp) {
                if (!PlanModifierForASTConv.validSetopParent(rel, parent)) {
                    PlanModifierForASTConv.introduceDerivedTable(rel, parent);
                }
                SetOp setop = (SetOp)rel;
                for (RelNode inputRel : setop.getInputs()) {
                    if (PlanModifierForASTConv.validSetopChild(inputRel)) continue;
                    PlanModifierForASTConv.introduceDerivedTable(inputRel, (RelNode)setop);
                }
            } else if (rel instanceof SingleRel) {
                if (rel instanceof Filter) {
                    if (!PlanModifierForASTConv.validFilterParent(rel, parent)) {
                        PlanModifierForASTConv.introduceDerivedTable(rel, parent);
                    }
                } else if (rel instanceof HiveSortLimit) {
                    if (!PlanModifierForASTConv.validSortParent(rel, parent)) {
                        PlanModifierForASTConv.introduceDerivedTable(rel, parent);
                    }
                    if (!PlanModifierForASTConv.validSortChild((HiveSortLimit)rel)) {
                        PlanModifierForASTConv.introduceDerivedTable(((HiveSortLimit)rel).getInput(), rel);
                    }
                } else if (rel instanceof HiveAggregate) {
                    RelNode newParent = parent;
                    if (!PlanModifierForASTConv.validGBParent(rel, parent)) {
                        newParent = PlanModifierForASTConv.introduceDerivedTable(rel, parent);
                    }
                    if (PlanModifierForASTConv.isEmptyGrpAggr(rel)) {
                        PlanModifierForASTConv.replaceEmptyGroupAggr(rel, newParent);
                    }
                }
            }
        }
        List childNodes = rel.getInputs();
        if (childNodes != null) {
            for (RelNode r : childNodes) {
                PlanModifierForASTConv.convertOpTree(r, rel);
            }
        }
    }

    public static RelNode renameTopLevelSelectInResultSchema(RelNode rootRel, Pair<RelNode, RelNode> topSelparentPair, List<FieldSchema> resultSchema) throws CalciteSemanticException {
        RelNode parentOforiginalProjRel = (RelNode)topSelparentPair.getKey();
        HiveProject originalProjRel = (HiveProject)topSelparentPair.getValue();
        List rootChildExps = originalProjRel.getChildExps();
        if (resultSchema.size() != rootChildExps.size()) {
            LOG.error(PlanModifierUtil.generateInvalidSchemaMessage(originalProjRel, resultSchema, 0));
            throw new CalciteSemanticException("Result Schema didn't match Optimized Op Tree Schema");
        }
        ArrayList<String> newSelAliases = new ArrayList<String>();
        for (int i = 0; i < rootChildExps.size(); ++i) {
            String colAlias = resultSchema.get(i).getName();
            colAlias = PlanModifierForASTConv.getNewColAlias(newSelAliases, colAlias);
            newSelAliases.add(colAlias);
        }
        HiveProject replacementProjectRel = HiveProject.create(originalProjRel.getInput(), originalProjRel.getChildExps(), newSelAliases);
        if (rootRel == originalProjRel) {
            return replacementProjectRel;
        }
        parentOforiginalProjRel.replaceInput(0, (RelNode)replacementProjectRel);
        return rootRel;
    }

    private static String getNewColAlias(List<String> newSelAliases, String colAlias) {
        int index = 1;
        Object newColAlias = colAlias;
        while (newSelAliases.contains(newColAlias)) {
            newColAlias = colAlias + "_" + index++;
        }
        return newColAlias;
    }

    private static RelNode introduceDerivedTable(RelNode rel) {
        List<RexNode> projectList = HiveCalciteUtil.getProjsFromBelowAsInputRef(rel);
        HiveProject select = HiveProject.create(rel.getCluster(), rel, projectList, rel.getRowType(), rel.getCollationList());
        return select;
    }

    private static RelNode introduceDerivedTable(RelNode rel, RelNode parent) {
        int i = 0;
        int pos = -1;
        List childList = parent.getInputs();
        for (RelNode child : childList) {
            if (child == rel) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos == -1) {
            throw new RuntimeException("Couldn't find child node in parent's inputs");
        }
        RelNode select = PlanModifierForASTConv.introduceDerivedTable(rel);
        parent.replaceInput(pos, select);
        return select;
    }

    private static boolean validJoinParent(RelNode joinNode, RelNode parent) {
        boolean validParent = true;
        if (parent instanceof Join) {
            if (((Join)parent).getRight() == joinNode && (((Join)parent).getLeft() instanceof Join || parent instanceof HiveSemiJoin)) {
                validParent = false;
            }
        } else if (parent instanceof SetOp) {
            validParent = false;
        }
        return validParent;
    }

    private static boolean validFilterParent(RelNode filterNode, RelNode parent) {
        boolean validParent = true;
        if (parent instanceof Filter || parent instanceof Join || parent instanceof SetOp || parent instanceof Aggregate && filterNode.getInputs().get(0) instanceof Aggregate) {
            validParent = false;
        }
        return validParent;
    }

    private static boolean validGBParent(RelNode gbNode, RelNode parent) {
        boolean validParent = true;
        if (parent instanceof Join || parent instanceof SetOp || parent instanceof Aggregate || parent instanceof Filter && ((Aggregate)gbNode).getGroupSet().isEmpty()) {
            validParent = false;
        }
        if (parent instanceof Project) {
            for (RexNode child : parent.getChildExps()) {
                if (!(child instanceof RexOver) && !(child instanceof Window.RexWinAggCall)) continue;
                return false;
            }
        }
        return validParent;
    }

    private static boolean validSortParent(RelNode sortNode, RelNode parent) {
        boolean validParent = true;
        if (!(parent == null || parent instanceof Project || HiveCalciteUtil.pureLimitRelNode(parent) && HiveCalciteUtil.pureOrderRelNode(sortNode))) {
            validParent = false;
        }
        return validParent;
    }

    private static boolean validSortChild(HiveSortLimit sortNode) {
        boolean validChild = true;
        RelNode child = sortNode.getInput();
        if (!(child instanceof Project || HiveCalciteUtil.pureLimitRelNode(sortNode) && HiveCalciteUtil.pureOrderRelNode(child))) {
            validChild = false;
        }
        return validChild;
    }

    private static boolean validSetopParent(RelNode setop, RelNode parent) {
        boolean validChild = true;
        if (parent != null && !(parent instanceof Project)) {
            validChild = false;
        }
        return validChild;
    }

    private static boolean validSetopChild(RelNode setopChild) {
        boolean validChild = true;
        if (!(setopChild instanceof Project)) {
            validChild = false;
        }
        return validChild;
    }

    private static boolean isEmptyGrpAggr(RelNode gbNode) {
        Aggregate aggrnode = (Aggregate)gbNode;
        return aggrnode.getGroupSet().isEmpty() && aggrnode.getAggCallList().isEmpty();
    }

    private static void replaceEmptyGroupAggr(RelNode rel, RelNode parent) {
        List exps = parent.getChildExps();
        for (RexNode rexNode : exps) {
            if (((Boolean)rexNode.accept((RexVisitor)new HiveCalciteUtil.ConstantFinder())).booleanValue()) continue;
            throw new RuntimeException("We expect " + parent.toString() + " to contain only constants. However, " + rexNode.toString() + " is " + rexNode.getKind());
        }
        HiveAggregate oldAggRel = (HiveAggregate)rel;
        RelDataTypeFactory typeFactory = oldAggRel.getCluster().getTypeFactory();
        RelDataType longType = TypeConverter.convert(TypeInfoFactory.longTypeInfo, typeFactory);
        RelDataType intType = TypeConverter.convert(TypeInfoFactory.intTypeInfo, typeFactory);
        SqlAggFunction countFn = SqlFunctionConverter.getCalciteAggFn("count", false, ImmutableList.of(intType), longType);
        ImmutableList<Integer> argList = ImmutableList.of(Integer.valueOf(0));
        AggregateCall dummyCall = new AggregateCall(countFn, false, argList, longType, null);
        Aggregate newAggRel = oldAggRel.copy(oldAggRel.getTraitSet(), oldAggRel.getInput(), oldAggRel.indicator, oldAggRel.getGroupSet(), oldAggRel.getGroupSets(), ImmutableList.of(dummyCall));
        RelNode select = PlanModifierForASTConv.introduceDerivedTable((RelNode)newAggRel);
        parent.replaceInput(0, select);
    }
}

