/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.keyseries;

import hive.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.keyseries.VectorKeySeriesSerialized;
import org.apache.hadoop.hive.ql.exec.vector.keyseries.VectorKeySeriesSerializedImpl;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;

public class VectorKeySeriesLongSerialized<T extends SerializeWrite>
extends VectorKeySeriesSerializedImpl<T>
implements VectorKeySeriesSerialized {
    private final int columnNum;
    private PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
    private int currentKeyStart;

    public VectorKeySeriesLongSerialized(int columnNum, PrimitiveTypeInfo primitiveTypeInfo, T serializeWrite) {
        super(serializeWrite);
        this.columnNum = columnNum;
        this.primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
    }

    @Override
    public void processBatch(VectorizedRowBatch batch) throws IOException {
        this.currentBatchSize = batch.size;
        Preconditions.checkState(this.currentBatchSize > 0);
        LongColumnVector longColVector = (LongColumnVector)batch.cols[this.columnNum];
        long[] vector = longColVector.vector;
        this.currentKeyStart = 0;
        this.output.reset();
        if (longColVector.isRepeating) {
            this.duplicateCounts[0] = this.currentBatchSize;
            if (longColVector.noNulls || !longColVector.isNull[0]) {
                this.seriesIsAllNull[0] = false;
                this.serialize(0, vector[0]);
                this.nonNullKeyCount = 1;
            } else {
                this.seriesIsAllNull[0] = true;
                this.nonNullKeyCount = 0;
            }
            this.seriesCount = 1;
            Preconditions.checkState(this.seriesCount <= this.currentBatchSize);
        } else {
            this.seriesCount = 0;
            this.nonNullKeyCount = 0;
            if (batch.selectedInUse) {
                int[] selected = batch.selected;
                if (longColVector.noNulls) {
                    this.duplicateCounts[0] = 1;
                    long prevKey = vector[selected[0]];
                    this.serialize(0, prevKey);
                    for (int logical = 1; logical < this.currentBatchSize; ++logical) {
                        long currentKey = vector[selected[logical]];
                        if (prevKey == currentKey) {
                            int n = this.seriesCount;
                            this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                            continue;
                        }
                        this.duplicateCounts[++this.seriesCount] = 1;
                        this.serialize(this.seriesCount, currentKey);
                        prevKey = currentKey;
                    }
                    Arrays.fill(this.seriesIsAllNull, 0, ++this.seriesCount, false);
                    this.nonNullKeyCount = this.seriesCount;
                    Preconditions.checkState(this.seriesCount <= this.currentBatchSize);
                } else {
                    boolean prevKeyIsNull;
                    boolean[] isNull = longColVector.isNull;
                    long prevKey = 0L;
                    this.duplicateCounts[0] = 1;
                    int index = selected[0];
                    if (isNull[index]) {
                        this.seriesIsAllNull[0] = true;
                        prevKeyIsNull = true;
                        this.nonNullKeyCount = 0;
                    } else {
                        this.seriesIsAllNull[0] = false;
                        prevKeyIsNull = false;
                        prevKey = vector[index];
                        this.serialize(0, prevKey);
                        this.nonNullKeyCount = 1;
                    }
                    for (int logical = 1; logical < this.currentBatchSize; ++logical) {
                        index = selected[logical];
                        if (isNull[index]) {
                            if (prevKeyIsNull) {
                                int n = this.seriesCount;
                                this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                                continue;
                            }
                            this.duplicateCounts[++this.seriesCount] = 1;
                            this.seriesIsAllNull[this.seriesCount] = true;
                            prevKeyIsNull = true;
                            continue;
                        }
                        long currentKey = vector[index];
                        if (!prevKeyIsNull && prevKey == currentKey) {
                            int n = this.seriesCount;
                            this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                            continue;
                        }
                        this.duplicateCounts[++this.seriesCount] = 1;
                        this.seriesIsAllNull[this.seriesCount] = false;
                        this.serialize(this.nonNullKeyCount++, currentKey);
                        prevKeyIsNull = false;
                        prevKey = currentKey;
                    }
                    ++this.seriesCount;
                    Preconditions.checkState(this.seriesCount <= this.currentBatchSize);
                }
            } else if (longColVector.noNulls) {
                this.duplicateCounts[0] = 1;
                long prevKey = vector[0];
                this.serialize(0, prevKey);
                for (int index = 1; index < this.currentBatchSize; ++index) {
                    long currentKey = vector[index];
                    if (prevKey == currentKey) {
                        int n = this.seriesCount;
                        this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                        continue;
                    }
                    this.duplicateCounts[++this.seriesCount] = 1;
                    this.serialize(this.seriesCount, currentKey);
                    prevKey = currentKey;
                }
                Arrays.fill(this.seriesIsAllNull, 0, ++this.seriesCount, false);
                this.nonNullKeyCount = this.seriesCount;
                Preconditions.checkState(this.seriesCount <= this.currentBatchSize);
            } else {
                boolean prevKeyIsNull;
                boolean[] isNull = longColVector.isNull;
                long prevKey = 0L;
                this.duplicateCounts[0] = 1;
                if (isNull[0]) {
                    this.seriesIsAllNull[0] = true;
                    prevKeyIsNull = true;
                    this.nonNullKeyCount = 0;
                } else {
                    this.seriesIsAllNull[0] = false;
                    prevKeyIsNull = false;
                    prevKey = vector[0];
                    this.serialize(0, prevKey);
                    this.nonNullKeyCount = 1;
                }
                for (int index = 1; index < this.currentBatchSize; ++index) {
                    if (isNull[index]) {
                        if (prevKeyIsNull) {
                            int n = this.seriesCount;
                            this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                            continue;
                        }
                        this.duplicateCounts[++this.seriesCount] = 1;
                        this.seriesIsAllNull[this.seriesCount] = true;
                        prevKeyIsNull = true;
                        continue;
                    }
                    long currentKey = vector[index];
                    if (!prevKeyIsNull && prevKey == currentKey) {
                        int n = this.seriesCount;
                        this.duplicateCounts[n] = this.duplicateCounts[n] + 1;
                        continue;
                    }
                    this.duplicateCounts[++this.seriesCount] = 1;
                    this.seriesIsAllNull[this.seriesCount] = false;
                    this.serialize(this.nonNullKeyCount++, currentKey);
                    prevKeyIsNull = false;
                    prevKey = currentKey;
                }
                ++this.seriesCount;
                Preconditions.checkState(this.seriesCount <= this.currentBatchSize);
            }
        }
        this.computeSerializedHashCodes();
        this.positionToFirst();
        Preconditions.checkState(this.validate());
    }

    private void serialize(int pos, long value) throws IOException {
        this.serializeWrite.setAppend(this.output);
        switch (this.primitiveCategory) {
            case BOOLEAN: {
                this.serializeWrite.writeBoolean(value != 0L);
                break;
            }
            case BYTE: {
                this.serializeWrite.writeByte((byte)value);
                break;
            }
            case SHORT: {
                this.serializeWrite.writeShort((short)value);
                break;
            }
            case INT: {
                this.serializeWrite.writeInt((int)value);
                break;
            }
            case LONG: {
                this.serializeWrite.writeLong(value);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected primitive category " + this.primitiveCategory.name());
            }
        }
        int outputNewPosition = this.output.getLength();
        this.serializedKeyLengths[pos] = outputNewPosition - this.currentKeyStart;
        this.currentKeyStart = outputNewPosition;
    }
}

