/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import hive.com.google.common.annotations.VisibleForTesting;
import hive.com.google.common.base.Strings;
import hive.com.google.common.collect.ImmutableMap;
import hive.org.apache.commons.lang3.tuple.ImmutablePair;
import hive.org.apache.commons.lang3.tuple.Pair;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.HiveDriverRunHookContextImpl;
import org.apache.hadoop.hive.ql.HookRunner;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.MapRedStats;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.cache.results.CacheUsage;
import org.apache.hadoop.hive.ql.cache.results.QueryResultsCache;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hadoop.hive.ql.hooks.PrivateHookContext;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.JsonMetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContextImpl;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.Query;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.security.authorization.command.CommandAuthorizer;
import org.apache.hadoop.hive.ql.session.LineageState;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.WmContext;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.hive.common.util.TxnIdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements IDriver {
    private static final String CLASS_NAME = Driver.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final Logger AUDIT_LOG = LoggerFactory.getLogger((String)(CLASS_NAME + ".audit"));
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    static final int SHUTDOWN_HOOK_PRIORITY = 0;
    private final QueryInfo queryInfo;
    private Runnable shutdownRunner = null;
    private int maxRows = 100;
    ByteStream.Output bos = new ByteStream.Output();
    private final HiveConf conf;
    private final boolean isParallelEnabled;
    private DataInput resStream;
    private Context ctx;
    private DriverContext driverCxt;
    private QueryPlan plan;
    private Schema schema;
    private String errorMessage;
    private String SQLState;
    private Throwable downstreamError;
    private FetchTask fetchTask;
    List<HiveLock> hiveLocks = new ArrayList<HiveLock>();
    private int maxthreads;
    private String userName;
    private String operationId;
    private final QueryDisplay queryDisplay = new QueryDisplay();
    private LockedDriverState lDrvState = new LockedDriverState();
    private final QueryState queryState;
    private HookRunner hookRunner;
    private final HiveTxnManager initTxnMgr;
    private HiveTxnManager queryTxnMgr;
    private StatsSource statsSource;
    private boolean validTxnListsGenerated;
    private CacheUsage cacheUsage;
    private QueryResultsCache.CacheEntry usedCacheEntry;
    private ValidWriteIdList compactionWriteIds = null;
    private Context backupContext = null;
    private boolean retrial = false;
    private static final ReentrantLock globalCompileLock = new ReentrantLock();

    private boolean checkConcurrency() {
        boolean supportConcurrency = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        if (!supportConcurrency) {
            LOG.info("Concurrency mode is disabled, not creating a lock manager");
            return false;
        }
        return true;
    }

    public ClusterStatus getClusterStatus() throws Exception {
        ClusterStatus cs;
        try {
            JobConf job = new JobConf((Configuration)this.conf);
            JobClient jc = new JobClient(job);
            cs = jc.getClusterStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info("Returning cluster status: " + cs.toString());
        return cs;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    public Schema getExplainSchema() {
        return new Schema(ExplainTask.getResultSchema(), null);
    }

    @Override
    public Context getContext() {
        return this.ctx;
    }

    public PlanMapper getPlanMapper() {
        return this.ctx.getPlanMapper();
    }

    private static Schema getSchema(BaseSemanticAnalyzer sem, HiveConf conf) {
        Schema schema = null;
        if (sem != null) {
            if (sem.getResultSchema() != null) {
                List<FieldSchema> lst = sem.getResultSchema();
                schema = new Schema(lst, null);
            } else if (sem.getFetchTask() != null) {
                FetchTask ft = sem.getFetchTask();
                TableDesc td = ft.getTblDesc();
                if (td == null && ft.getWork() != null && ((FetchWork)ft.getWork()).getPartDesc() != null && ((FetchWork)ft.getWork()).getPartDesc().size() > 0) {
                    td = ((FetchWork)ft.getWork()).getPartDesc().get(0).getTableDesc();
                }
                if (td == null) {
                    LOG.info("No returning schema.");
                } else {
                    String tableName = "result";
                    List<FieldSchema> lst = null;
                    try {
                        lst = HiveMetaStoreUtils.getFieldsFromDeserializer(tableName, td.getDeserializer(conf));
                    }
                    catch (Exception e) {
                        LOG.warn("Error getting schema: " + StringUtils.stringifyException((Throwable)e));
                    }
                    if (lst != null) {
                        schema = new Schema(lst, null);
                    }
                }
            }
        }
        if (schema == null) {
            schema = new Schema();
        }
        LOG.info("Returning Hive schema: " + schema);
        return schema;
    }

    public Schema getThriftSchema() throws Exception {
        Schema schema;
        try {
            List<FieldSchema> lst;
            schema = this.getSchema();
            if (schema != null && (lst = schema.getFieldSchemas()) != null) {
                for (FieldSchema f : lst) {
                    f.setType(ColumnType.typeToThriftType(f.getType()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOG.info("Returning Thrift schema: " + schema);
        return schema;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public Driver(HiveConf conf) {
        this(new QueryState.Builder().withGenerateNewQueryId(true).withHiveConf(conf).build(), null);
    }

    public Driver(HiveConf conf, LineageState lineageState) {
        this(Driver.getNewQueryState(conf, lineageState), null);
    }

    public Driver(HiveConf conf, Context ctx, LineageState lineageState) {
        this(Driver.getNewQueryState(conf, lineageState), null, null);
        this.ctx = ctx;
    }

    public Driver(HiveConf conf, String userName, LineageState lineageState) {
        this(Driver.getNewQueryState(conf, lineageState), userName, null);
    }

    public Driver(QueryState queryState, String userName) {
        this(queryState, userName, null, null);
    }

    public Driver(QueryState queryState, String userName, QueryInfo queryInfo) {
        this(queryState, userName, queryInfo, null);
    }

    public Driver(QueryState queryState, String userName, QueryInfo queryInfo, HiveTxnManager txnMgr) {
        this.queryState = queryState;
        this.conf = queryState.getConf();
        this.isParallelEnabled = this.conf != null && HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION);
        this.userName = userName;
        this.hookRunner = new HookRunner(this.conf, console);
        this.queryInfo = queryInfo;
        this.initTxnMgr = txnMgr;
    }

    private static QueryState getNewQueryState(HiveConf conf, LineageState lineageState) {
        return new QueryState.Builder().withGenerateNewQueryId(true).withHiveConf(conf).withLineageState(lineageState).build();
    }

    @Override
    public int compile(String command) {
        return this.compile(command, true);
    }

    public int compile(String command, boolean resetTaskIds) {
        try {
            this.compile(command, resetTaskIds, false);
            return 0;
        }
        catch (CommandProcessorResponse cpr) {
            return cpr.getErrorCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void compile(String command, boolean resetTaskIds, boolean deferClose) throws CommandProcessorResponse {
        boolean compileError;
        String queryId;
        PerfLogger perfLogger;
        block54: {
            perfLogger = SessionState.getPerfLogger(true);
            perfLogger.PerfLogBegin(CLASS_NAME, "Driver.run");
            perfLogger.PerfLogBegin(CLASS_NAME, "compile");
            this.lDrvState.stateLock.lock();
            try {
                this.lDrvState.driverState = DriverState.COMPILING;
            }
            finally {
                this.lDrvState.stateLock.unlock();
            }
            String queryStr = command = new VariableSubstitution(new HiveVariableSource(){

                @Override
                public Map<String, String> getHiveVariable() {
                    return SessionState.get().getHiveVariables();
                }
            }).substitute(this.conf, command);
            try {
                queryStr = HookUtils.redactLogString(this.conf, command);
            }
            catch (Exception e) {
                LOG.warn("WARNING! Query command could not be redacted." + e);
            }
            this.checkInterrupted("at beginning of compilation.", null, null);
            if (this.ctx != null && this.ctx.getExplainAnalyze() != ExplainConfiguration.AnalyzeState.RUNNING) {
                this.closeInProcess(false);
            }
            if (resetTaskIds) {
                TaskFactory.resetId();
            }
            LockedDriverState.setLockedDriverState(this.lDrvState);
            queryId = this.queryState.getQueryId();
            if (this.ctx != null) {
                this.setTriggerContext(queryId);
            }
            this.queryDisplay.setQueryStr(queryStr);
            this.queryDisplay.setQueryId(queryId);
            LOG.info("Compiling command(queryId=" + queryId + "): " + queryStr);
            this.conf.setQueryString(queryStr);
            if (SessionState.get() != null) {
                SessionState.get().getConf().setQueryString(queryStr);
                SessionState.get().setupQueryCurrentTimestamp();
            }
            compileError = false;
            boolean parseError = false;
            try {
                String explainOutput;
                ASTNode tree;
                this.queryTxnMgr = this.initTxnMgr != null ? this.initTxnMgr : SessionState.get().initTxnMgr(this.conf);
                if (this.queryTxnMgr instanceof Configurable) {
                    ((Configurable)this.queryTxnMgr).setConf((Configuration)this.conf);
                }
                this.queryState.setTxnManager(this.queryTxnMgr);
                ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
                final HiveTxnManager txnMgr = this.queryTxnMgr;
                this.shutdownRunner = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Driver.this.releaseLocksAndCommitOrRollback(false, txnMgr);
                        }
                        catch (LockException e) {
                            LOG.warn("Exception when releasing locks in ShutdownHook for Driver: " + e.getMessage());
                        }
                    }
                };
                ShutdownHookManager.addShutdownHook(this.shutdownRunner, 0);
                this.checkInterrupted("before parsing and analysing the query", null, null);
                if (this.ctx == null) {
                    this.ctx = new Context(this.conf);
                    this.setTriggerContext(queryId);
                }
                this.ctx.setHiveTxnManager(this.queryTxnMgr);
                this.ctx.setStatsSource(this.statsSource);
                this.ctx.setCmd(command);
                this.ctx.setHDFSCleanup(true);
                perfLogger.PerfLogBegin(CLASS_NAME, "parse");
                this.hookRunner.runBeforeParseHook(command);
                try {
                    tree = ParseUtils.parse(command, this.ctx, this.conf);
                }
                catch (ParseException e) {
                    parseError = true;
                    throw e;
                }
                finally {
                    this.hookRunner.runAfterParseHook(command, parseError);
                }
                perfLogger.PerfLogEnd(CLASS_NAME, "parse");
                this.hookRunner.runBeforeCompileHook(command);
                SessionState.get().getCurrentFunctionsInUse().clear();
                perfLogger.PerfLogBegin(CLASS_NAME, "semanticAnalyze");
                Hive.get().getMSC().flushCache();
                this.backupContext = new Context(this.ctx);
                boolean executeHooks = this.hookRunner.hasPreAnalyzeHooks();
                HiveSemanticAnalyzerHookContextImpl hookCtx = new HiveSemanticAnalyzerHookContextImpl();
                if (executeHooks) {
                    hookCtx.setConf(this.conf);
                    hookCtx.setUserName(this.userName);
                    hookCtx.setIpAddress(SessionState.get().getUserIpAddress());
                    hookCtx.setCommand(command);
                    hookCtx.setHiveOperation(this.queryState.getHiveOperation());
                    tree = this.hookRunner.runPreAnalyzeHooks(hookCtx, tree);
                }
                BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.queryState, tree);
                if (!this.retrial) {
                    this.openTransaction();
                    this.generateValidTxnList();
                }
                sem.analyze(tree, this.ctx);
                if (executeHooks) {
                    hookCtx.update(sem);
                    this.hookRunner.runPostAnalyzeHooks(hookCtx, sem.getAllRootTasks());
                }
                LOG.info("Semantic Analysis Completed (retrial = {})", (Object)this.retrial);
                if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_QUERY_RESULTS_CACHE_ENABLED)) {
                    this.cacheUsage = sem.getCacheUsage();
                }
                sem.validate();
                perfLogger.PerfLogEnd(CLASS_NAME, "semanticAnalyze");
                this.checkInterrupted("after analyzing query.", null, null);
                this.schema = Driver.getSchema(sem, this.conf);
                this.plan = new QueryPlan(queryStr, sem, perfLogger.getStartTime("Driver.run"), queryId, this.queryState.getHiveOperation(), this.schema);
                this.conf.set("mapreduce.workflow.id", "hive_" + queryId);
                this.conf.set("mapreduce.workflow.name", queryStr);
                if (this.plan.getFetchTask() != null) {
                    this.plan.getFetchTask().initialize(this.queryState, this.plan, null, this.ctx.getOpContext());
                }
                if (!sem.skipAuthorization() && HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
                    try {
                        perfLogger.PerfLogBegin(CLASS_NAME, "doAuthorization");
                        CommandAuthorizer.doAuthorization(this.queryState.getHiveOperation(), sem, command);
                    }
                    catch (AuthorizationException authExp) {
                        console.printError("Authorization failed:" + authExp.getMessage() + ". Use SHOW GRANT to get more details.");
                        this.errorMessage = authExp.getMessage();
                        this.SQLState = "42000";
                        throw this.createProcessorResponse(403);
                    }
                    finally {
                        perfLogger.PerfLogEnd(CLASS_NAME, "doAuthorization");
                    }
                }
                if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_LOG_EXPLAIN_OUTPUT) && (explainOutput = this.getExplainOutput(sem, this.plan, tree)) != null) {
                    LOG.info("EXPLAIN output for queryid " + queryId + " : " + explainOutput);
                    if (this.conf.isWebUiQueryInfoCacheEnabled()) {
                        this.queryDisplay.setExplainPlan(explainOutput);
                    }
                }
                if (parseError) break block54;
            }
            catch (CommandProcessorResponse cpr) {
                try {
                    throw cpr;
                    catch (Exception e) {
                        this.checkInterrupted("during query compilation: " + e.getMessage(), null, null);
                        compileError = true;
                        ErrorMsg error = ErrorMsg.getErrorMsg(e.getMessage());
                        this.errorMessage = "FAILED: " + e.getClass().getSimpleName();
                        if (error != ErrorMsg.GENERIC_ERROR) {
                            this.errorMessage = this.errorMessage + " [Error " + error.getErrorCode() + "]:";
                        }
                        this.errorMessage = e instanceof IllegalArgumentException && e.getMessage() == null && e.getCause() != null ? this.errorMessage + " " + e.getCause().getMessage() : this.errorMessage + " " + e.getMessage();
                        if (error == ErrorMsg.TXNMGR_NOT_ACID) {
                            this.errorMessage = this.errorMessage + ". Failed command: " + queryStr;
                        }
                        this.SQLState = error.getSQLState();
                        this.downstreamError = e;
                        console.printError(this.errorMessage, "\n" + StringUtils.stringifyException((Throwable)e));
                        throw this.createProcessorResponse(error.getErrorCode());
                    }
                }
                catch (Throwable throwable) {
                    if (!parseError) {
                        try {
                            this.hookRunner.runAfterCompilationHook(command, compileError);
                        }
                        catch (Exception e) {
                            LOG.warn("Failed when invoking query after-compilation hook.", (Throwable)e);
                        }
                    }
                    double duration2 = (double)perfLogger.PerfLogEnd(CLASS_NAME, "compile") / 1000.0;
                    ImmutableMap<String, Long> compileHMSTimings2 = this.dumpMetaCallTimingWithoutEx("compilation");
                    this.queryDisplay.setHmsTimings(QueryDisplay.Phase.COMPILATION, compileHMSTimings2);
                    boolean isInterrupted2 = this.lDrvState.isAborted();
                    if (isInterrupted2 && !deferClose) {
                        this.closeInProcess(true);
                    }
                    this.lDrvState.stateLock.lock();
                    try {
                        this.lDrvState.driverState = isInterrupted2 ? (deferClose ? DriverState.EXECUTING : DriverState.ERROR) : (compileError ? DriverState.ERROR : DriverState.COMPILED);
                    }
                    finally {
                        this.lDrvState.stateLock.unlock();
                    }
                    if (isInterrupted2) {
                        LOG.info("Compiling command(queryId=" + queryId + ") has been interrupted after " + duration2 + " seconds");
                        throw throwable;
                    }
                    LOG.info("Completed compiling command(queryId=" + queryId + "); Time taken: " + duration2 + " seconds");
                    throw throwable;
                }
            }
            try {
                this.hookRunner.runAfterCompilationHook(command, compileError);
            }
            catch (Exception e) {
                LOG.warn("Failed when invoking query after-compilation hook.", (Throwable)e);
            }
        }
        double duration = (double)perfLogger.PerfLogEnd(CLASS_NAME, "compile") / 1000.0;
        ImmutableMap<String, Long> compileHMSTimings = this.dumpMetaCallTimingWithoutEx("compilation");
        this.queryDisplay.setHmsTimings(QueryDisplay.Phase.COMPILATION, compileHMSTimings);
        boolean isInterrupted = this.lDrvState.isAborted();
        if (isInterrupted && !deferClose) {
            this.closeInProcess(true);
        }
        this.lDrvState.stateLock.lock();
        try {
            this.lDrvState.driverState = isInterrupted ? (deferClose ? DriverState.EXECUTING : DriverState.ERROR) : (compileError ? DriverState.ERROR : DriverState.COMPILED);
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
        if (isInterrupted) {
            LOG.info("Compiling command(queryId=" + queryId + ") has been interrupted after " + duration + " seconds");
            return;
        }
        LOG.info("Completed compiling command(queryId=" + queryId + "); Time taken: " + duration + " seconds");
    }

    private boolean isValidTxnListState() throws LockException {
        String txnString = this.conf.get("hive.txn.valid.txns");
        if (txnString == null) {
            return true;
        }
        ValidTxnList currentTxnList = this.queryTxnMgr.getValidTxns();
        String currentTxnString = currentTxnList.toString();
        if (currentTxnString.equals(txnString)) {
            return true;
        }
        if (this.ctx.getHiveLocks() == null || this.ctx.getHiveLocks().isEmpty()) {
            return true;
        }
        HashSet<String> nonSharedLocks = new HashSet<String>();
        for (HiveLock lock2 : this.ctx.getHiveLocks()) {
            if (lock2.mayContainComponents()) {
                for (LockComponent lckCmp : lock2.getHiveLockComponents()) {
                    if (lckCmp.getType() != LockType.EXCLUSIVE && lckCmp.getType() != LockType.SHARED_WRITE || lckCmp.getTablename() == null) continue;
                    nonSharedLocks.add(Warehouse.getQualifiedName(lckCmp.getDbname(), lckCmp.getTablename()));
                }
                continue;
            }
            if (lock2.getHiveLockMode() != HiveLockMode.EXCLUSIVE && lock2.getHiveLockMode() != HiveLockMode.SEMI_SHARED || lock2.getHiveLockObject().getPaths().length != 2) continue;
            nonSharedLocks.add(Warehouse.getQualifiedName(lock2.getHiveLockObject().getPaths()[0], lock2.getHiveLockObject().getPaths()[1]));
        }
        String txnWriteIdListStr = this.conf.get("hive.txn.tables.valid.writeids");
        if (txnWriteIdListStr == null || txnWriteIdListStr.length() == 0) {
            return true;
        }
        ValidTxnWriteIdList txnWriteIdList = new ValidTxnWriteIdList(txnWriteIdListStr);
        List<Pair<String, Table>> writtenTables = this.getWrittenTableList(this.plan);
        ValidTxnWriteIdList currentTxnWriteIds = this.queryTxnMgr.getValidWriteIds(writtenTables.stream().filter(e -> AcidUtils.isTransactionalTable((Table)e.getRight())).map(e -> (String)e.getLeft()).collect(Collectors.toList()), currentTxnString);
        for (Pair<String, Table> tableInfo : writtenTables) {
            String fullQNameForLock = Warehouse.getQualifiedName(tableInfo.getRight().getDbName(), MetaStoreUtils.encodeTableName(tableInfo.getRight().getTableName()));
            if (!nonSharedLocks.contains(fullQNameForLock)) continue;
            if (AcidUtils.isTransactionalTable(tableInfo.getRight()) && !TxnIdUtils.checkEquivalentWriteIds(txnWriteIdList.getTableValidWriteIdList(tableInfo.getLeft()), currentTxnWriteIds.getTableValidWriteIdList(tableInfo.getLeft()))) {
                return false;
            }
            nonSharedLocks.remove(fullQNameForLock);
        }
        if (!nonSharedLocks.isEmpty()) {
            throw new LockException("Wrong state: non-shared locks contain information for tables that have not been visited when trying to validate the locks from query tables.\nTables: " + writtenTables.stream().map(e -> (String)e.getLeft()).collect(Collectors.toList()) + "\nRemaining locks after check: " + nonSharedLocks);
        }
        return true;
    }

    private void setTriggerContext(String queryId) {
        long queryStartTime = this.queryInfo != null ? this.queryInfo.getBeginTime() : this.queryDisplay.getQueryStartTime();
        WmContext wmContext = new WmContext(queryStartTime, queryId);
        this.ctx.setWmContext(wmContext);
    }

    private void openTransaction() throws LockException, CommandProcessorResponse {
        if (this.checkConcurrency() && this.startImplicitTxn(this.queryTxnMgr)) {
            String userFromUGI = this.getUserFromUGI();
            if (!this.queryTxnMgr.isTxnOpen()) {
                if (userFromUGI == null) {
                    throw this.createProcessorResponse(10);
                }
                long l = this.queryTxnMgr.openTxn(this.ctx, userFromUGI);
            }
        }
    }

    private void generateValidTxnList() throws LockException {
        this.validTxnListsGenerated = false;
        String currentTxnString = this.conf.get("hive.txn.valid.txns");
        if (this.queryTxnMgr.isTxnOpen() && (currentTxnString == null || currentTxnString.isEmpty())) {
            try {
                this.recordValidTxns(this.queryTxnMgr);
                this.validTxnListsGenerated = true;
            }
            catch (LockException e) {
                LOG.error("Exception while acquiring valid txn list", (Throwable)e);
                throw e;
            }
        }
    }

    private boolean startImplicitTxn(HiveTxnManager txnManager) throws LockException {
        boolean shouldOpenImplicitTxn = !this.ctx.isExplainPlan();
        switch (this.queryState.getHiveOperation() == null ? HiveOperation.QUERY : this.queryState.getHiveOperation()) {
            case COMMIT: 
            case ROLLBACK: {
                if (!txnManager.isTxnOpen()) {
                    throw new LockException(null, ErrorMsg.OP_NOT_ALLOWED_WITHOUT_TXN, this.queryState.getHiveOperation().getOperationName());
                }
            }
            case SWITCHDATABASE: 
            case SET_AUTOCOMMIT: 
            case SHOWDATABASES: 
            case SHOWTABLES: 
            case SHOWCOLUMNS: 
            case SHOWFUNCTIONS: 
            case SHOWPARTITIONS: 
            case SHOWLOCKS: 
            case SHOWVIEWS: 
            case SHOW_ROLES: 
            case SHOW_ROLE_PRINCIPALS: 
            case SHOW_COMPACTIONS: 
            case SHOW_TRANSACTIONS: 
            case ABORT_TRANSACTIONS: 
            case KILL_QUERY: {
                shouldOpenImplicitTxn = false;
            }
        }
        return shouldOpenImplicitTxn;
    }

    private int handleInterruptionWithHook(String msg, HookContext hookContext, PerfLogger perfLogger) {
        this.SQLState = "HY008";
        this.errorMessage = "FAILED: command has been interrupted: " + msg;
        console.printError(this.errorMessage);
        if (hookContext != null) {
            try {
                this.invokeFailureHooks(perfLogger, hookContext, this.errorMessage, null);
            }
            catch (Exception e) {
                LOG.warn("Caught exception attempting to invoke Failure Hooks", (Throwable)e);
            }
        }
        return 1000;
    }

    private void checkInterrupted(String msg, HookContext hookContext, PerfLogger perfLogger) throws CommandProcessorResponse {
        if (this.lDrvState.isAborted()) {
            throw this.createProcessorResponse(this.handleInterruptionWithHook(msg, hookContext, perfLogger));
        }
    }

    private ImmutableMap<String, Long> dumpMetaCallTimingWithoutEx(String phase) {
        try {
            return Hive.get().dumpAndClearMetaCallTiming(phase);
        }
        catch (HiveException he) {
            LOG.warn("Caught exception attempting to write metadata call information " + he, (Throwable)he);
            return null;
        }
    }

    private String getExplainOutput(BaseSemanticAnalyzer sem, QueryPlan plan, ASTNode astTree) throws IOException {
        String ret = null;
        ExplainTask task = new ExplainTask();
        task.initialize(this.queryState, plan, null, this.ctx.getOpContext());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            List<Task<?>> rootTasks = sem.getAllRootTasks();
            task.getJSONPlan(ps, rootTasks, sem.getFetchTask(), false, true, true);
            ret = baos.toString();
        }
        catch (Exception e) {
            LOG.warn("Exception generating explain output: " + e, (Throwable)e);
        }
        return ret;
    }

    @Override
    public HiveConf getConf() {
        return this.conf;
    }

    @Override
    public QueryPlan getPlan() {
        return this.plan;
    }

    @Override
    public FetchTask getFetchTask() {
        return this.fetchTask;
    }

    private void recordValidTxns(HiveTxnManager txnMgr) throws LockException {
        String oldTxnString = this.conf.get("hive.txn.valid.txns");
        if (oldTxnString != null && oldTxnString.length() > 0) {
            throw new IllegalStateException("calling recordValidTxn() more than once in the same " + JavaUtils.txnIdToString(txnMgr.getCurrentTxnId()));
        }
        ValidTxnList txnList = txnMgr.getValidTxns();
        String txnStr = txnList.toString();
        this.conf.set("hive.txn.valid.txns", txnStr);
        LOG.debug("Encoding valid txns info " + txnStr + " txnid:" + txnMgr.getCurrentTxnId());
    }

    private void recordValidWriteIds(HiveTxnManager txnMgr) throws LockException {
        Operator<?> source;
        String txnString = this.conf.get("hive.txn.valid.txns");
        if (txnString == null || txnString.isEmpty()) {
            throw new IllegalStateException("calling recordValidWritsIdss() without initializing ValidTxnList " + JavaUtils.txnIdToString(txnMgr.getCurrentTxnId()));
        }
        List<String> txnTables = this.getTransactionalTableList(this.plan);
        ValidTxnWriteIdList txnWriteIds = null;
        if (this.compactionWriteIds != null) {
            if (txnTables.size() != 1) {
                throw new LockException("Unexpected tables in compaction: " + txnTables);
            }
            String fullTableName = txnTables.get(0);
            txnWriteIds = new ValidTxnWriteIdList(0L);
            txnWriteIds.addTableValidWriteIdList(this.compactionWriteIds);
        } else {
            txnWriteIds = txnMgr.getValidWriteIds(txnTables, txnString);
        }
        String writeIdStr = txnWriteIds.toString();
        this.conf.set("hive.txn.tables.valid.writeids", writeIdStr);
        if (this.plan.getFetchTask() != null && (source = ((FetchWork)this.plan.getFetchTask().getWork()).getSource()) instanceof TableScanOperator) {
            TableScanOperator tsOp = (TableScanOperator)source;
            String fullTableName = AcidUtils.getFullTableName(((TableScanDesc)tsOp.getConf()).getDatabaseName(), ((TableScanDesc)tsOp.getConf()).getTableName());
            ValidWriteIdList writeIdList = txnWriteIds.getTableValidWriteIdList(fullTableName);
            if (((TableScanDesc)tsOp.getConf()).isTranscationalTable() && writeIdList == null) {
                throw new IllegalStateException("ACID table: " + fullTableName + " is missing from the ValidWriteIdList config: " + writeIdStr);
            }
            if (writeIdList != null) {
                this.plan.getFetchTask().setValidWriteIdList(writeIdList.toString());
            }
        }
        LOG.debug("Encoding valid txn write ids info " + writeIdStr + " txnid:" + txnMgr.getCurrentTxnId());
    }

    private List<String> getTransactionalTableList(QueryPlan plan) {
        HashSet<String> tableList = new HashSet<String>();
        for (ReadEntity input : plan.getInputs()) {
            this.addTableFromEntity(input, tableList);
        }
        for (WriteEntity output : plan.getOutputs()) {
            this.addTableFromEntity(output, tableList);
        }
        return new ArrayList<String>(tableList);
    }

    private void addTableFromEntity(Entity entity, Collection<String> tableList) {
        Table tbl;
        switch (entity.getType()) {
            case TABLE: {
                tbl = entity.getTable();
                break;
            }
            case PARTITION: 
            case DUMMYPARTITION: {
                tbl = entity.getPartition().getTable();
                break;
            }
            default: {
                return;
            }
        }
        if (!AcidUtils.isTransactionalTable(tbl)) {
            return;
        }
        String fullTableName = AcidUtils.getFullTableName(tbl.getDbName(), tbl.getTableName());
        tableList.add(fullTableName);
    }

    private List<Pair<String, Table>> getWrittenTableList(QueryPlan plan) {
        ArrayList<Pair<String, Table>> result = new ArrayList<Pair<String, Table>>();
        HashSet<String> tableList = new HashSet<String>();
        block4: for (WriteEntity output : plan.getOutputs()) {
            String fullTableName;
            Table tbl;
            switch (output.getType()) {
                case TABLE: {
                    tbl = output.getTable();
                    break;
                }
                case PARTITION: 
                case DUMMYPARTITION: {
                    tbl = output.getPartition().getTable();
                    break;
                }
                default: {
                    continue block4;
                }
            }
            if (!tableList.add(fullTableName = AcidUtils.getFullTableName(tbl.getDbName(), tbl.getTableName()))) continue;
            result.add(new ImmutablePair<String, Table>(fullTableName, tbl));
        }
        return result;
    }

    private String getUserFromUGI() {
        try {
            return this.conf.getUser();
        }
        catch (IOException e) {
            this.errorMessage = "FAILED: Error in determining user while acquiring locks: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            this.downstreamError = e;
            console.printError(this.errorMessage, "\n" + StringUtils.stringifyException((Throwable)e));
            return null;
        }
    }

    private void acquireLocks() throws CommandProcessorResponse {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "acquireReadWriteLocks");
        if (!this.queryTxnMgr.isTxnOpen() && this.queryTxnMgr.supportsAcid()) {
            return;
        }
        try {
            DDLDesc.DDLDescWithWriteId acidDdlDesc;
            String userFromUGI = this.getUserFromUGI();
            if (userFromUGI == null) {
                throw this.createProcessorResponse(10);
            }
            if (!this.plan.getAcidSinks().isEmpty()) {
                ArrayList<FileSinkDesc> acidSinks = new ArrayList<FileSinkDesc>(this.plan.getAcidSinks());
                acidSinks.sort((fsd1, fsd2) -> fsd1.getDirName().compareTo(fsd2.getDirName()));
                for (FileSinkDesc desc : acidSinks) {
                    TableDesc tableInfo = desc.getTableInfo();
                    long writeId = this.queryTxnMgr.getTableWriteId(Utilities.getDatabaseName(tableInfo.getTableName()), Utilities.getTableName(tableInfo.getTableName()));
                    desc.setTableWriteId(writeId);
                    desc.setStatementId(this.queryTxnMgr.getStmtIdAndIncrement());
                    String unionAllSubdir = "/HIVE_UNION_SUBDIR_";
                    if (!desc.getInsertOverwrite() || !desc.getDirName().toString().contains(unionAllSubdir) || !desc.isFullAcidTable()) continue;
                    throw new UnsupportedOperationException("QueryId=" + this.plan.getQueryId() + " is not supported due to OVERWRITE and UNION ALL.  Please use truncate + insert");
                }
            }
            if ((acidDdlDesc = this.plan.getAcidDdlDesc()) != null && acidDdlDesc.mayNeedWriteId()) {
                String fqTableName = acidDdlDesc.getFullTableName();
                long writeId = this.queryTxnMgr.getTableWriteId(Utilities.getDatabaseName(fqTableName), Utilities.getTableName(fqTableName));
                acidDdlDesc.setWriteId(writeId);
            }
            this.queryTxnMgr.acquireLocks(this.plan, this.ctx, userFromUGI, this.lDrvState);
            if (this.queryTxnMgr.recordSnapshot(this.plan) && !this.validTxnListsGenerated) {
                throw new IllegalStateException("calling recordValidTxn() more than once in the same " + JavaUtils.txnIdToString(this.queryTxnMgr.getCurrentTxnId()));
            }
            if (this.plan.hasAcidResourcesInQuery()) {
                this.recordValidWriteIds(this.queryTxnMgr);
            }
        }
        catch (Exception e) {
            this.errorMessage = "FAILED: Error in acquiring locks: " + e.getMessage();
            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
            this.downstreamError = e;
            console.printError(this.errorMessage, "\n" + StringUtils.stringifyException((Throwable)e));
            throw this.createProcessorResponse(10);
        }
        finally {
            perfLogger.PerfLogEnd(CLASS_NAME, "acquireReadWriteLocks");
        }
    }

    public void releaseLocksAndCommitOrRollback(boolean commit) throws LockException {
        this.releaseLocksAndCommitOrRollback(commit, this.queryTxnMgr);
    }

    @VisibleForTesting
    public void releaseLocksAndCommitOrRollback(boolean commit, HiveTxnManager txnManager) throws LockException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "releaseLocks");
        HiveTxnManager txnMgr = txnManager == null ? this.queryTxnMgr : txnManager;
        this.conf.unset("hive.txn.valid.txns");
        this.conf.unset("hive.txn.tables.valid.writeids");
        if (!this.checkConcurrency()) {
            return;
        }
        if (txnMgr.isTxnOpen()) {
            if (commit) {
                if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && this.conf.getBoolVar(HiveConf.ConfVars.HIVETESTMODEROLLBACKTXN)) {
                    txnMgr.rollbackTxn();
                } else {
                    txnMgr.commitTxn();
                }
            } else {
                txnMgr.rollbackTxn();
            }
        } else {
            if (this.ctx != null && this.ctx.getHiveLocks() != null) {
                this.hiveLocks.addAll(this.ctx.getHiveLocks());
            }
            txnMgr.releaseLocks(this.hiveLocks);
        }
        this.hiveLocks.clear();
        if (this.ctx != null) {
            this.ctx.setHiveLocks(null);
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "releaseLocks");
    }

    public void releaseResources() {
        this.releasePlan();
        this.releaseDriverContext();
    }

    @Override
    public CommandProcessorResponse run(String command) {
        return this.run(command, false);
    }

    @Override
    public CommandProcessorResponse run() {
        return this.run(null, true);
    }

    public CommandProcessorResponse run(String command, boolean alreadyCompiled) {
        try {
            this.runInternal(command, alreadyCompiled);
            return this.createProcessorResponse(0);
        }
        catch (CommandProcessorResponse cpr) {
            SessionState ss = SessionState.get();
            if (ss == null) {
                return cpr;
            }
            MetaDataFormatter mdf = MetaDataFormatUtils.getFormatter(ss.getConf());
            if (!(mdf instanceof JsonMetaDataFormatter)) {
                return cpr;
            }
            try {
                if (this.downstreamError == null) {
                    mdf.error(ss.out, this.errorMessage, cpr.getResponseCode(), this.SQLState);
                    return cpr;
                }
                ErrorMsg canonicalErr = ErrorMsg.getErrorMsg(cpr.getResponseCode());
                if (canonicalErr != null && canonicalErr != ErrorMsg.GENERIC_ERROR) {
                    mdf.error(ss.out, this.errorMessage, cpr.getResponseCode(), this.SQLState, null);
                    return cpr;
                }
                if (this.downstreamError instanceof HiveException) {
                    HiveException rc = (HiveException)this.downstreamError;
                    mdf.error(ss.out, this.errorMessage, rc.getCanonicalErrorMsg().getErrorCode(), this.SQLState, rc.getCanonicalErrorMsg() == ErrorMsg.GENERIC_ERROR ? StringUtils.stringifyException((Throwable)rc) : null);
                } else {
                    ErrorMsg canonicalMsg = ErrorMsg.getErrorMsg(this.downstreamError.getMessage());
                    mdf.error(ss.out, this.errorMessage, canonicalMsg.getErrorCode(), this.SQLState, StringUtils.stringifyException((Throwable)this.downstreamError));
                }
            }
            catch (HiveException ex) {
                console.printError("Unable to JSON-encode the error", StringUtils.stringifyException((Throwable)ex));
            }
            return cpr;
        }
    }

    @Override
    public CommandProcessorResponse compileAndRespond(String command) {
        return this.compileAndRespond(command, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandProcessorResponse compileAndRespond(String command, boolean cleanupTxnList) {
        try {
            this.compileInternal(command, false);
            CommandProcessorResponse commandProcessorResponse = this.createProcessorResponse(0);
            return commandProcessorResponse;
        }
        catch (CommandProcessorResponse e) {
            CommandProcessorResponse commandProcessorResponse = e;
            return commandProcessorResponse;
        }
        finally {
            if (cleanupTxnList) {
                this.conf.unset("hive.txn.valid.txns");
            }
        }
    }

    public void lockAndRespond() throws CommandProcessorResponse {
        if (this.plan == null) {
            throw new IllegalStateException("No previously compiled query for driver - queryId=" + this.queryState.getQueryId());
        }
        if (this.requiresLock()) {
            try {
                this.acquireLocks();
            }
            catch (CommandProcessorResponse cpr) {
                this.rollback(cpr);
                throw cpr;
            }
        }
    }

    private void compileInternal(String command, boolean deferClose) throws CommandProcessorResponse {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            metrics.incrementCounter("waiting_compile_ops", 1L);
        }
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "waitCompile");
        ReentrantLock compileLock = this.tryAcquireCompileLock(this.isParallelEnabled, command);
        perfLogger.PerfLogEnd(CLASS_NAME, "waitCompile");
        if (metrics != null) {
            metrics.decrementCounter("waiting_compile_ops", 1L);
        }
        if (compileLock == null) {
            throw this.createProcessorResponse(ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCode());
        }
        try {
            this.compile(command, true, deferClose);
        }
        catch (CommandProcessorResponse cpr) {
            try {
                this.releaseLocksAndCommitOrRollback(false);
            }
            catch (LockException e) {
                LOG.warn("Exception in releasing locks. " + StringUtils.stringifyException((Throwable)e));
            }
            throw cpr;
        }
        finally {
            compileLock.unlock();
        }
        this.queryDisplay.setPerfLogStarts(QueryDisplay.Phase.COMPILATION, perfLogger.getStartTimes());
        this.queryDisplay.setPerfLogEnds(QueryDisplay.Phase.COMPILATION, perfLogger.getEndTimes());
    }

    private ReentrantLock tryAcquireCompileLock(boolean isParallelEnabled, String command) {
        ReentrantLock compileLock;
        block10: {
            compileLock = isParallelEnabled ? SessionState.get().getCompileLock() : globalCompileLock;
            long maxCompileLockWaitTime = HiveConf.getTimeVar(this.conf, HiveConf.ConfVars.HIVE_SERVER2_COMPILE_LOCK_TIMEOUT, TimeUnit.SECONDS);
            String lockAcquiredMsg = "Acquired the compile lock.";
            try {
                if (compileLock.tryLock(0L, TimeUnit.SECONDS)) {
                    LOG.debug("Acquired the compile lock.");
                    return compileLock;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Interrupted Exception ignored", (Throwable)e);
                }
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waiting to acquire compile lock: " + command);
            }
            if (maxCompileLockWaitTime > 0L) {
                try {
                    if (!compileLock.tryLock(maxCompileLockWaitTime, TimeUnit.SECONDS)) {
                        this.errorMessage = ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCodedMsg();
                        LOG.error(this.errorMessage + ": " + command);
                        return null;
                    }
                    break block10;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Interrupted Exception ignored", (Throwable)e);
                    }
                    return null;
                }
            }
            compileLock.lock();
        }
        LOG.debug("Acquired the compile lock.");
        return compileLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runInternal(String command, boolean alreadyCompiled) throws CommandProcessorResponse {
        boolean isFinishedWithError;
        block38: {
            block37: {
                this.errorMessage = null;
                this.SQLState = null;
                this.downstreamError = null;
                LockedDriverState.setLockedDriverState(this.lDrvState);
                this.lDrvState.stateLock.lock();
                try {
                    if (alreadyCompiled) {
                        if (this.lDrvState.driverState != DriverState.COMPILED) {
                            this.errorMessage = "FAILED: Precompiled query has been cancelled or closed.";
                            console.printError(this.errorMessage);
                            throw this.createProcessorResponse(12);
                        }
                        this.lDrvState.driverState = DriverState.EXECUTING;
                    } else {
                        this.lDrvState.driverState = DriverState.COMPILING;
                    }
                }
                finally {
                    this.lDrvState.stateLock.unlock();
                }
                isFinishedWithError = true;
                try {
                    PerfLogger perfLogger;
                    HiveDriverRunHookContextImpl hookContext;
                    block36: {
                        hookContext = new HiveDriverRunHookContextImpl(this.conf, alreadyCompiled ? this.ctx.getCmd() : command);
                        try {
                            this.hookRunner.runPreDriverHooks(hookContext);
                        }
                        catch (Exception e) {
                            this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
                            this.SQLState = ErrorMsg.findSQLState(e.getMessage());
                            this.downstreamError = e;
                            console.printError(this.errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
                            throw this.createProcessorResponse(12);
                        }
                        perfLogger = null;
                        if (!alreadyCompiled) {
                            this.compileInternal(command, true);
                            perfLogger = SessionState.getPerfLogger();
                        } else {
                            perfLogger = SessionState.getPerfLogger();
                            this.plan.setQueryStartTime(perfLogger.getStartTime("Driver.run"));
                        }
                        this.ctx.setHiveTxnManager(this.queryTxnMgr);
                        this.checkInterrupted("at acquiring the lock.", null, null);
                        this.lockAndRespond();
                        try {
                            if (!this.isValidTxnListState()) {
                                LOG.info("Compiling after acquiring locks");
                                this.retrial = true;
                                this.backupContext.addRewrittenStatementContext(this.ctx);
                                this.backupContext.setHiveLocks(this.ctx.getHiveLocks());
                                this.ctx = this.backupContext;
                                this.conf.set("hive.txn.valid.txns", this.queryTxnMgr.getValidTxns().toString());
                                if (this.plan.hasAcidResourcesInQuery()) {
                                    this.recordValidWriteIds(this.queryTxnMgr);
                                }
                                if (!alreadyCompiled) {
                                    this.compileInternal(command, true);
                                } else {
                                    this.plan.setQueryStartTime(this.queryDisplay.getQueryStartTime());
                                }
                                if (!this.isValidTxnListState()) {
                                    throw this.handleHiveException(new HiveException("Operation could not be executed"), 14);
                                }
                                perfLogger = SessionState.getPerfLogger(true);
                                this.ctx.setHiveTxnManager(this.queryTxnMgr);
                            }
                        }
                        catch (LockException e) {
                            throw this.handleHiveException(e, 13);
                        }
                        try {
                            this.execute();
                        }
                        catch (CommandProcessorResponse cpr) {
                            this.rollback(cpr);
                            throw cpr;
                        }
                        try {
                            if (this.queryTxnMgr.isImplicitTransactionOpen() || this.plan.getOperation() == HiveOperation.COMMIT) {
                                this.releaseLocksAndCommitOrRollback(true);
                                break block36;
                            }
                            if (this.plan.getOperation() == HiveOperation.ROLLBACK) {
                                this.releaseLocksAndCommitOrRollback(false);
                            }
                        }
                        catch (LockException e) {
                            throw this.handleHiveException(e, 12);
                        }
                    }
                    perfLogger.PerfLogEnd(CLASS_NAME, "Driver.run");
                    this.queryDisplay.setPerfLogStarts(QueryDisplay.Phase.EXECUTION, perfLogger.getStartTimes());
                    this.queryDisplay.setPerfLogEnds(QueryDisplay.Phase.EXECUTION, perfLogger.getEndTimes());
                    try {
                        this.hookRunner.runPostDriverHooks(hookContext);
                    }
                    catch (Exception e) {
                        this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
                        this.SQLState = ErrorMsg.findSQLState(e.getMessage());
                        this.downstreamError = e;
                        console.printError(this.errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
                        throw this.createProcessorResponse(12);
                    }
                    isFinishedWithError = false;
                    if (!this.lDrvState.isAborted()) break block37;
                    this.closeInProcess(true);
                    break block38;
                }
                catch (Throwable throwable) {
                    if (this.lDrvState.isAborted()) {
                        this.closeInProcess(true);
                    } else {
                        this.releaseResources();
                    }
                    this.lDrvState.stateLock.lock();
                    try {
                        this.lDrvState.driverState = isFinishedWithError ? DriverState.ERROR : DriverState.EXECUTED;
                        throw throwable;
                    }
                    finally {
                        this.lDrvState.stateLock.unlock();
                    }
                }
            }
            this.releaseResources();
        }
        this.lDrvState.stateLock.lock();
        try {
            this.lDrvState.driverState = isFinishedWithError ? DriverState.ERROR : DriverState.EXECUTED;
            return;
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
    }

    private CommandProcessorResponse rollback(CommandProcessorResponse cpr) throws CommandProcessorResponse {
        try {
            this.releaseLocksAndCommitOrRollback(false);
        }
        catch (LockException e) {
            LOG.error("rollback() FAILED: " + cpr);
            this.handleHiveException(e, 12, "Additional info in hive.log at \"rollback() FAILED\"");
        }
        return cpr;
    }

    private CommandProcessorResponse handleHiveException(HiveException e, int ret) throws CommandProcessorResponse {
        return this.handleHiveException(e, ret, null);
    }

    private CommandProcessorResponse handleHiveException(HiveException e, int ret, String rootMsg) throws CommandProcessorResponse {
        this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
        if (rootMsg != null) {
            this.errorMessage = this.errorMessage + "\n" + rootMsg;
        }
        this.SQLState = e.getCanonicalErrorMsg() != null ? e.getCanonicalErrorMsg().getSQLState() : ErrorMsg.findSQLState(e.getMessage());
        this.downstreamError = e;
        console.printError(this.errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
        throw this.createProcessorResponse(ret);
    }

    private boolean requiresLock() {
        if (!this.checkConcurrency()) {
            return false;
        }
        if (this.isExplicitLockOperation()) {
            return false;
        }
        if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_LOCK_MAPRED_ONLY)) {
            return true;
        }
        LinkedList<Task<? extends Serializable>> taskQueue = new LinkedList<Task<? extends Serializable>>();
        taskQueue.addAll(this.plan.getRootTasks());
        while (taskQueue.peek() != null) {
            Task tsk = (Task)taskQueue.remove();
            if (tsk.requireLock()) {
                return true;
            }
            if (tsk instanceof ConditionalTask) {
                taskQueue.addAll(((ConditionalTask)tsk).getListTasks());
            }
            if (tsk.getChildTasks() == null) continue;
            taskQueue.addAll(tsk.getChildTasks());
        }
        return false;
    }

    private boolean isExplicitLockOperation() {
        HiveOperation currentOpt = this.plan.getOperation();
        if (currentOpt != null) {
            switch (currentOpt) {
                case LOCKDB: 
                case UNLOCKDB: 
                case LOCKTABLE: 
                case UNLOCKTABLE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private CommandProcessorResponse createProcessorResponse(int ret) {
        ErrorMsg em;
        SessionState.getPerfLogger().cleanupPerfLogMetrics();
        this.queryDisplay.setErrorMessage(this.errorMessage);
        if (this.downstreamError != null && this.downstreamError instanceof HiveException && (em = ((HiveException)this.downstreamError).getCanonicalErrorMsg()) != null) {
            return new CommandProcessorResponse(ret, this.errorMessage, this.SQLState, this.schema, this.downstreamError, em.getErrorCode(), null);
        }
        return new CommandProcessorResponse(ret, this.errorMessage, this.SQLState, this.downstreamError);
    }

    private void useFetchFromCache(QueryResultsCache.CacheEntry cacheEntry) {
        FetchTask fetchTaskFromCache = (FetchTask)TaskFactory.get(cacheEntry.getFetchWork());
        fetchTaskFromCache.initialize(this.queryState, this.plan, null, this.ctx.getOpContext());
        this.plan.setFetchTask(fetchTaskFromCache);
        this.cacheUsage = new CacheUsage(CacheUsage.CacheStatus.QUERY_USING_CACHE, cacheEntry);
    }

    private void preExecutionCacheActions() throws Exception {
        if (this.cacheUsage != null && this.cacheUsage.getStatus() == CacheUsage.CacheStatus.CAN_CACHE_QUERY_RESULTS && this.plan.getFetchTask() != null) {
            QueryResultsCache.CacheEntry pendingCacheEntry;
            ValidTxnWriteIdList txnWriteIdList = null;
            if (this.plan.hasAcidResourcesInQuery()) {
                txnWriteIdList = AcidUtils.getValidTxnWriteIdList(this.conf);
            }
            if ((pendingCacheEntry = QueryResultsCache.getInstance().addToCache(this.cacheUsage.getQueryInfo(), txnWriteIdList)) != null) {
                this.cacheUsage.setCacheEntry(pendingCacheEntry);
            }
        }
    }

    private void postExecutionCacheActions() throws Exception {
        if (this.cacheUsage != null) {
            if (this.cacheUsage.getStatus() == CacheUsage.CacheStatus.QUERY_USING_CACHE) {
                QueryResultsCache.CacheEntry cacheEntry;
                this.usedCacheEntry = cacheEntry = this.cacheUsage.getCacheEntry();
            } else if (this.cacheUsage.getStatus() == CacheUsage.CacheStatus.CAN_CACHE_QUERY_RESULTS && this.cacheUsage.getCacheEntry() != null && this.plan.getFetchTask() != null) {
                PerfLogger perfLogger = SessionState.getPerfLogger();
                perfLogger.PerfLogBegin(CLASS_NAME, "saveToResultsCache");
                ValidTxnWriteIdList txnWriteIdList = null;
                if (this.plan.hasAcidResourcesInQuery()) {
                    txnWriteIdList = AcidUtils.getValidTxnWriteIdList(this.conf);
                }
                boolean savedToCache = QueryResultsCache.getInstance().setEntryValid(this.cacheUsage.getCacheEntry(), (FetchWork)this.plan.getFetchTask().getWork());
                LOG.info("savedToCache: {}", (Object)savedToCache);
                if (savedToCache) {
                    this.useFetchFromCache(this.cacheUsage.getCacheEntry());
                    this.usedCacheEntry = this.cacheUsage.getCacheEntry();
                }
                perfLogger.PerfLogEnd(CLASS_NAME, "saveToResultsCache");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute() throws CommandProcessorResponse {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "Driver.execute");
        boolean noName = hive.org.apache.commons.lang.StringUtils.isEmpty(this.conf.get("mapreduce.job.name"));
        int maxlen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
        Metrics metrics = MetricsFactory.getInstance();
        String queryId = this.queryState.getQueryId();
        String queryStr = this.conf.getQueryString();
        this.lDrvState.stateLock.lock();
        try {
            if (this.lDrvState.driverState != DriverState.COMPILED && this.lDrvState.driverState != DriverState.EXECUTING) {
                this.SQLState = "HY008";
                this.errorMessage = "FAILED: unexpected driverstate: " + this.lDrvState + ", for query " + queryStr;
                console.printError(this.errorMessage);
                throw this.createProcessorResponse(1000);
            }
            this.lDrvState.driverState = DriverState.EXECUTING;
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
        this.maxthreads = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.EXECPARALLETHREADNUMBER);
        PrivateHookContext hookContext = null;
        boolean executionError = false;
        try {
            LOG.info("Executing command(queryId=" + queryId + "): " + queryStr);
            Hive.get().clearMetaCallTiming();
            this.plan.setStarted();
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().startQuery(queryStr, queryId);
                SessionState.get().getHiveHistory().logPlanProgress(this.plan);
            }
            this.resStream = null;
            SessionState ss = SessionState.get();
            hookContext = new PrivateHookContext(this.plan, this.queryState, this.ctx.getPathToCS(), SessionState.get().getUserName(), ss.getUserIpAddress(), InetAddress.getLocalHost().getHostAddress(), this.operationId, ss.getSessionId(), Thread.currentThread().getName(), ss.isHiveServerQuery(), perfLogger, this.queryInfo, this.ctx);
            hookContext.setHookType(HookContext.HookType.PRE_EXEC_HOOK);
            this.hookRunner.runPreHooks(hookContext);
            this.hookRunner.runBeforeExecutionHook(queryStr, hookContext);
            this.setQueryDisplays(this.plan.getRootTasks());
            int mrJobs = Utilities.getMRTasks(this.plan.getRootTasks()).size();
            int jobs = mrJobs + Utilities.getTezTasks(this.plan.getRootTasks()).size() + Utilities.getSparkTasks(this.plan.getRootTasks()).size();
            if (jobs > 0) {
                this.logMrWarning(mrJobs);
                console.printInfo("Query ID = " + queryId);
                console.printInfo("Total jobs = " + jobs);
            }
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_NUM_TASKS, String.valueOf(jobs));
                SessionState.get().getHiveHistory().setIdToTableMap(this.plan.getIdToTableNameMap());
            }
            String jobname = Utilities.abbreviate(queryStr, maxlen - 6);
            this.checkInterrupted("before running tasks.", hookContext, perfLogger);
            DriverContext driverCxt = new DriverContext(this.ctx);
            driverCxt.prepare(this.plan);
            this.ctx.setHDFSCleanup(true);
            this.driverCxt = driverCxt;
            SessionState.get().setMapRedStats(new LinkedHashMap<String, MapRedStats>());
            SessionState.get().setStackTraces(new HashMap<String, List<List<String>>>());
            SessionState.get().setLocalMapRedErrors(new HashMap<String, List<String>>());
            for (Task<? extends Serializable> tsk : this.plan.getRootTasks()) {
                assert (tsk.getParentTasks() == null || tsk.getParentTasks().isEmpty());
                driverCxt.addToRunnable(tsk);
                if (metrics == null) continue;
                tsk.updateTaskMetrics(metrics);
            }
            this.preExecutionCacheActions();
            perfLogger.PerfLogBegin(CLASS_NAME, "runTasks");
            while (driverCxt.isRunning()) {
                boolean isReplicationOperation;
                TaskRunner runner;
                Task<? extends Serializable> task;
                while ((task = driverCxt.getRunnable(this.maxthreads)) != null && (runner = this.launchTask(task, queryId, noName, jobname, jobs, driverCxt)).isRunning()) {
                }
                TaskRunner tskRun = driverCxt.pollFinished();
                if (tskRun == null) continue;
                String string = this.plan.getOperationName();
                boolean bl = isReplicationOperation = string.equals(HiveOperation.REPLDUMP.getOperationName()) || string.equals(HiveOperation.REPLLOAD.getOperationName());
                if (!isReplicationOperation) {
                    hookContext.addCompleteTask(tskRun);
                }
                this.queryDisplay.setTaskResult(tskRun.getTask().getId(), tskRun.getTaskResult());
                Task<? extends Serializable> tsk = tskRun.getTask();
                TaskResult result = tskRun.getTaskResult();
                int exitVal = result.getExitVal();
                this.checkInterrupted("when checking the execution result.", hookContext, perfLogger);
                if (exitVal != 0) {
                    ErrorMsg errorMsg;
                    Task<Serializable> backupTask = tsk.getAndInitBackupTask();
                    if (backupTask != null) {
                        this.setErrorMsgAndDetail(exitVal, result.getTaskError(), tsk);
                        console.printError(this.errorMessage);
                        this.errorMessage = "ATTEMPT: Execute BackupTask: " + backupTask.getClass().getName();
                        console.printError(this.errorMessage);
                        if (!DriverContext.isLaunchable(backupTask)) continue;
                        driverCxt.addToRunnable(backupTask);
                        continue;
                    }
                    this.setErrorMsgAndDetail(exitVal, result.getTaskError(), tsk);
                    if (driverCxt.isShutdown()) {
                        this.errorMessage = "FAILED: Operation cancelled. " + this.errorMessage;
                    }
                    this.invokeFailureHooks(perfLogger, hookContext, this.errorMessage + Strings.nullToEmpty(tsk.getDiagnosticsMessage()), result.getTaskError());
                    this.SQLState = "08S01";
                    if (result.getTaskError() instanceof HiveException && (errorMsg = ((HiveException)result.getTaskError()).getCanonicalErrorMsg()) != ErrorMsg.GENERIC_ERROR) {
                        this.SQLState = errorMsg.getSQLState();
                    }
                    console.printError(this.errorMessage);
                    driverCxt.shutdown();
                    this.ctx.restoreOriginalTracker();
                    throw this.createProcessorResponse(exitVal);
                }
                driverCxt.finished(tskRun);
                if (SessionState.get() != null) {
                    SessionState.get().getHiveHistory().setTaskProperty(queryId, tsk.getId(), HiveHistory.Keys.TASK_RET_CODE, String.valueOf(exitVal));
                    SessionState.get().getHiveHistory().endTask(queryId, tsk);
                }
                if (tsk.getChildTasks() == null) continue;
                for (Task<Serializable> child : tsk.getChildTasks()) {
                    if (!DriverContext.isLaunchable(child)) continue;
                    driverCxt.addToRunnable(child);
                }
            }
            perfLogger.PerfLogEnd(CLASS_NAME, "runTasks");
            this.postExecutionCacheActions();
            this.ctx.restoreOriginalTracker();
            if (driverCxt.isShutdown()) {
                this.SQLState = "HY008";
                this.errorMessage = "FAILED: Operation cancelled";
                this.invokeFailureHooks(perfLogger, hookContext, this.errorMessage, null);
                console.printError(this.errorMessage);
                throw this.createProcessorResponse(1000);
            }
            LinkedHashSet<WriteEntity> remOutputs = new LinkedHashSet<WriteEntity>();
            for (WriteEntity writeEntity : this.plan.getOutputs()) {
                if (writeEntity.isComplete()) continue;
                remOutputs.add(writeEntity);
            }
            for (WriteEntity writeEntity : remOutputs) {
                this.plan.getOutputs().remove(writeEntity);
            }
            hookContext.setHookType(HookContext.HookType.POST_EXEC_HOOK);
            this.hookRunner.runPostExecHooks(hookContext);
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(0));
                SessionState.get().getHiveHistory().printRowCount(queryId);
            }
            this.releasePlan(this.plan);
        }
        catch (CommandProcessorResponse cpr) {
            try {
                executionError = true;
                throw cpr;
                catch (Throwable e) {
                    executionError = true;
                    this.checkInterrupted("during query execution: \n" + e.getMessage(), hookContext, perfLogger);
                    this.ctx.restoreOriginalTracker();
                    if (SessionState.get() != null) {
                        SessionState.get().getHiveHistory().setQueryProperty(queryId, HiveHistory.Keys.QUERY_RET_CODE, String.valueOf(12));
                    }
                    this.errorMessage = "FAILED: Hive Internal Error: " + Utilities.getNameMessage(e);
                    if (hookContext != null) {
                        try {
                            this.invokeFailureHooks(perfLogger, hookContext, this.errorMessage, e);
                        }
                        catch (Exception t) {
                            LOG.warn("Failed to invoke failure hook", (Throwable)t);
                        }
                    }
                    this.SQLState = "08S01";
                    this.downstreamError = e;
                    console.printError(this.errorMessage + "\n" + StringUtils.stringifyException((Throwable)e));
                    throw this.createProcessorResponse(12);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.hookRunner.runAfterExecutionHook(queryStr, hookContext, executionError);
                }
                catch (Exception e) {
                    LOG.warn("Failed when invoking query after execution hook", (Throwable)e);
                }
                if (SessionState.get() != null) {
                    SessionState.get().getHiveHistory().endQuery(queryId);
                }
                if (noName) {
                    this.conf.set("mapreduce.job.name", "");
                }
                double duration2 = (double)perfLogger.PerfLogEnd(CLASS_NAME, "Driver.execute") / 1000.0;
                ImmutableMap<String, Long> executionHMSTimings2 = this.dumpMetaCallTimingWithoutEx("execution");
                this.queryDisplay.setHmsTimings(QueryDisplay.Phase.EXECUTION, executionHMSTimings2);
                Map<String, MapRedStats> stats2 = SessionState.get().getMapRedStats();
                if (stats2 != null && !stats2.isEmpty()) {
                    long totalCpu = 0L;
                    console.printInfo("MapReduce Jobs Launched: ");
                    for (Map.Entry<String, MapRedStats> entry : stats2.entrySet()) {
                        console.printInfo("Stage-" + entry.getKey() + ": " + entry.getValue());
                        totalCpu += entry.getValue().getCpuMSec();
                    }
                    console.printInfo("Total MapReduce CPU Time Spent: " + Utilities.formatMsecToStr(totalCpu));
                }
                this.lDrvState.stateLock.lock();
                try {
                    this.lDrvState.driverState = executionError ? DriverState.ERROR : DriverState.EXECUTED;
                }
                finally {
                    this.lDrvState.stateLock.unlock();
                }
                if (this.lDrvState.isAborted()) {
                    LOG.info("Executing command(queryId=" + queryId + ") has been interrupted after " + duration2 + " seconds");
                    throw throwable;
                }
                LOG.info("Completed executing command(queryId=" + queryId + "); Time taken: " + duration2 + " seconds");
                this.logAudit();
                throw throwable;
            }
        }
        try {
            this.hookRunner.runAfterExecutionHook(queryStr, hookContext, executionError);
        }
        catch (Exception e) {
            LOG.warn("Failed when invoking query after execution hook", (Throwable)e);
        }
        if (SessionState.get() != null) {
            SessionState.get().getHiveHistory().endQuery(queryId);
        }
        if (noName) {
            this.conf.set("mapreduce.job.name", "");
        }
        double duration = (double)perfLogger.PerfLogEnd(CLASS_NAME, "Driver.execute") / 1000.0;
        ImmutableMap<String, Long> executionHMSTimings = this.dumpMetaCallTimingWithoutEx("execution");
        this.queryDisplay.setHmsTimings(QueryDisplay.Phase.EXECUTION, executionHMSTimings);
        Map<String, MapRedStats> stats = SessionState.get().getMapRedStats();
        if (stats != null && !stats.isEmpty()) {
            long totalCpu = 0L;
            console.printInfo("MapReduce Jobs Launched: ");
            for (Map.Entry entry : stats.entrySet()) {
                console.printInfo("Stage-" + (String)entry.getKey() + ": " + entry.getValue());
                totalCpu += ((MapRedStats)entry.getValue()).getCpuMSec();
            }
            console.printInfo("Total MapReduce CPU Time Spent: " + Utilities.formatMsecToStr(totalCpu));
        }
        this.lDrvState.stateLock.lock();
        try {
            this.lDrvState.driverState = executionError ? DriverState.ERROR : DriverState.EXECUTED;
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
        if (this.lDrvState.isAborted()) {
            LOG.info("Executing command(queryId=" + queryId + ") has been interrupted after " + duration + " seconds");
        } else {
            LOG.info("Completed executing command(queryId=" + queryId + "); Time taken: " + duration + " seconds");
            this.logAudit();
        }
        if (console == null) return;
        console.printInfo("OK");
    }

    private void logAudit() {
        String queryId = this.queryState.getQueryId();
        String queryStr = this.queryState.getQueryString().replace("\n", " ");
        String cmdType = this.queryState.getCommandType();
        String address = "unknown-ip-addr";
        if (SessionState.get() != null && SessionState.get().getUserIpAddress() != null) {
            address = SessionState.get().getUserIpAddress();
        }
        AUDIT_LOG.info("user={} ip={} queryId={} query type={} queryStr={}", new Object[]{this.userName, address, queryId, cmdType, queryStr});
    }

    private void releasePlan(QueryPlan plan) {
        this.lDrvState.stateLock.lock();
        try {
            if (plan != null) {
                plan.setDone();
                if (SessionState.get() != null) {
                    try {
                        SessionState.get().getHiveHistory().logPlanProgress(plan);
                    }
                    catch (Exception e) {
                        LOG.warn("Could not log query plan progress", (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
    }

    private void setQueryDisplays(List<Task<? extends Serializable>> tasks) {
        if (tasks != null) {
            HashSet<Task<? extends Serializable>> visited = new HashSet<Task<? extends Serializable>>();
            while (!tasks.isEmpty()) {
                tasks = this.setQueryDisplays(tasks, visited);
            }
        }
    }

    private List<Task<? extends Serializable>> setQueryDisplays(List<Task<? extends Serializable>> tasks, Set<Task<? extends Serializable>> visited) {
        ArrayList<Task<? extends Serializable>> childTasks = new ArrayList<Task<? extends Serializable>>();
        for (Task<? extends Serializable> task : tasks) {
            if (visited.contains(task)) continue;
            task.setQueryDisplay(this.queryDisplay);
            if (task.getDependentTasks() != null) {
                childTasks.addAll(task.getDependentTasks());
            }
            visited.add(task);
        }
        return childTasks;
    }

    private void logMrWarning(int mrJobs) {
        if (mrJobs <= 0 || !"mr".equals(HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
            return;
        }
        String warning = HiveConf.generateMrDeprecationWarning();
        LOG.warn(warning);
    }

    private void setErrorMsgAndDetail(int exitVal, Throwable downstreamError, Task tsk) {
        this.downstreamError = downstreamError;
        this.errorMessage = "FAILED: Execution Error, return code " + exitVal + " from " + tsk.getClass().getName();
        if (downstreamError != null) {
            this.errorMessage = this.errorMessage + ". " + downstreamError.getMessage();
        } else {
            ErrorMsg em = ErrorMsg.getErrorMsg(exitVal);
            if (em != null) {
                this.errorMessage = this.errorMessage + ". " + em.getMsg();
            }
        }
    }

    private void invokeFailureHooks(PerfLogger perfLogger, HookContext hookContext, String errorMessage, Throwable exception) throws Exception {
        hookContext.setHookType(HookContext.HookType.ON_FAILURE_HOOK);
        hookContext.setErrorMessage(errorMessage);
        hookContext.setException(exception);
        this.hookRunner.runFailureHooks(hookContext);
    }

    private TaskRunner launchTask(Task<? extends Serializable> tsk, String queryId, boolean noName, String jobname, int jobs, DriverContext cxt) throws HiveException {
        if (SessionState.get() != null) {
            SessionState.get().getHiveHistory().startTask(queryId, tsk, tsk.getClass().getName());
        }
        if (tsk.isMapRedTask() && !(tsk instanceof ConditionalTask)) {
            if (noName) {
                this.conf.set("mapreduce.job.name", jobname + " (" + tsk.getId() + ")");
            }
            this.conf.set("mapreduce.workflow.node.name", tsk.getId());
            Utilities.setWorkflowAdjacencies(this.conf, this.plan);
            cxt.incCurJobNo(1);
            console.printInfo("Launching Job " + cxt.getCurJobNo() + " out of " + jobs);
        }
        tsk.initialize(this.queryState, this.plan, cxt, this.ctx.getOpContext());
        TaskRunner tskRun = new TaskRunner(tsk);
        cxt.launching(tskRun);
        if (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.EXECPARALLEL) && tsk.canExecuteInParallel()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting task [" + tsk + "] in parallel");
            }
            tskRun.start();
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting task [" + tsk + "] in serial mode");
            }
            tskRun.runSequential();
        }
        return tskRun;
    }

    @Override
    public boolean isFetchingTable() {
        return this.fetchTask != null;
    }

    @Override
    public boolean getResults(List res) throws IOException {
        if (this.lDrvState.driverState == DriverState.DESTROYED || this.lDrvState.driverState == DriverState.CLOSED) {
            throw new IOException("FAILED: query has been cancelled, closed, or destroyed.");
        }
        if (this.isFetchingTable()) {
            if (((FetchWork)this.fetchTask.getWork()).isUsingThriftJDBCBinarySerDe()) {
                this.maxRows = 1;
            }
            this.fetchTask.setMaxRows(this.maxRows);
            return this.fetchTask.fetch(res);
        }
        if (this.resStream == null) {
            this.resStream = this.ctx.getStream();
        }
        if (this.resStream == null) {
            return false;
        }
        int numRows = 0;
        String row = null;
        while (numRows < this.maxRows) {
            Utilities.StreamStatus ss;
            if (this.resStream == null) {
                return numRows > 0;
            }
            this.bos.reset();
            try {
                ss = Utilities.readColumn(this.resStream, this.bos);
                if (this.bos.getLength() > 0) {
                    row = new String(this.bos.getData(), 0, this.bos.getLength(), "UTF-8");
                } else if (ss == Utilities.StreamStatus.TERMINATED) {
                    row = new String();
                }
                if (row != null) {
                    ++numRows;
                    res.add(row);
                }
                row = null;
            }
            catch (IOException e) {
                console.printError("FAILED: Unexpected IO exception : " + e.getMessage());
                return false;
            }
            if (ss != Utilities.StreamStatus.EOF) continue;
            this.resStream = this.ctx.getStream();
        }
        return true;
    }

    @Override
    public void resetFetch() throws IOException {
        if (this.lDrvState.driverState == DriverState.DESTROYED || this.lDrvState.driverState == DriverState.CLOSED) {
            throw new IOException("FAILED: driver has been cancelled, closed or destroyed.");
        }
        if (this.isFetchingTable()) {
            try {
                this.fetchTask.clearFetch();
            }
            catch (Exception e) {
                throw new IOException("Error closing the current fetch task", e);
            }
            this.fetchTask.initialize(this.queryState, null, null, this.ctx.getOpContext());
        } else {
            this.ctx.resetStream();
            this.resStream = null;
        }
    }

    private void releaseDriverContext() {
        this.lDrvState.stateLock.lock();
        try {
            if (this.driverCxt != null) {
                this.driverCxt.shutdown();
                this.driverCxt = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while shutting down the task runner", (Throwable)e);
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
    }

    private void releasePlan() {
        try {
            if (this.plan != null) {
                this.fetchTask = this.plan.getFetchTask();
                if (this.fetchTask != null) {
                    this.fetchTask.setDriverContext(null);
                    this.fetchTask.setQueryPlan(null);
                }
            }
            this.plan = null;
        }
        catch (Exception e) {
            LOG.debug("Exception while clearing the Fetch task", (Throwable)e);
        }
    }

    private void releaseContext() {
        try {
            if (this.ctx != null) {
                this.ctx.clear();
                if (this.ctx.getHiveLocks() != null) {
                    this.hiveLocks.addAll(this.ctx.getHiveLocks());
                    this.ctx.setHiveLocks(null);
                }
                this.ctx = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while clearing the context ", (Throwable)e);
        }
    }

    private void releaseResStream() {
        try {
            if (this.resStream != null) {
                ((FSDataInputStream)this.resStream).close();
                this.resStream = null;
            }
        }
        catch (Exception e) {
            LOG.debug(" Exception while closing the resStream ", (Throwable)e);
        }
    }

    private void releaseFetchTask() {
        try {
            if (this.fetchTask != null) {
                this.fetchTask.clearFetch();
                this.fetchTask = null;
            }
        }
        catch (Exception e) {
            LOG.debug(" Exception while clearing the FetchTask ", (Throwable)e);
        }
    }

    private boolean hasBadCacheAttempt() {
        return this.cacheUsage != null && this.cacheUsage.getStatus() == CacheUsage.CacheStatus.CAN_CACHE_QUERY_RESULTS && this.cacheUsage.getCacheEntry() != null;
    }

    private void releaseCachedResult() {
        if (this.usedCacheEntry != null) {
            this.usedCacheEntry.releaseReader();
            this.usedCacheEntry = null;
        } else if (this.hasBadCacheAttempt()) {
            try {
                QueryResultsCache.getInstance().removeEntry(this.cacheUsage.getCacheEntry());
            }
            catch (Exception err) {
                LOG.error("Error removing failed cache entry " + this.cacheUsage.getCacheEntry(), (Throwable)err);
            }
        }
        this.cacheUsage = null;
    }

    private int closeInProcess(boolean destroyed) {
        this.releaseDriverContext();
        this.releasePlan();
        this.releaseCachedResult();
        this.releaseFetchTask();
        this.releaseResStream();
        this.releaseContext();
        if (destroyed) {
            if (!this.hiveLocks.isEmpty()) {
                try {
                    this.releaseLocksAndCommitOrRollback(false);
                }
                catch (LockException e) {
                    LOG.warn("Exception when releasing locking in destroy: " + e.getMessage());
                }
            }
            ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
        }
        return 0;
    }

    @Override
    public void close() {
        this.lDrvState.stateLock.lock();
        try {
            this.releaseDriverContext();
            if (this.lDrvState.driverState == DriverState.COMPILING || this.lDrvState.driverState == DriverState.EXECUTING) {
                this.lDrvState.abort();
            }
            this.releasePlan();
            this.releaseCachedResult();
            this.releaseFetchTask();
            this.releaseResStream();
            this.releaseContext();
            this.lDrvState.driverState = DriverState.CLOSED;
        }
        finally {
            this.lDrvState.stateLock.unlock();
            LockedDriverState.removeLockedDriverState();
        }
        this.destroy();
    }

    @Override
    public void destroy() {
        this.lDrvState.stateLock.lock();
        try {
            if (this.lDrvState.driverState == DriverState.DESTROYED) {
                return;
            }
            this.lDrvState.driverState = DriverState.DESTROYED;
        }
        finally {
            this.lDrvState.stateLock.unlock();
        }
        if (!this.hiveLocks.isEmpty()) {
            try {
                this.releaseLocksAndCommitOrRollback(false);
            }
            catch (LockException e) {
                LOG.warn("Exception when releasing locking in destroy: " + e.getMessage());
            }
        }
        ShutdownHookManager.removeShutdownHook(this.shutdownRunner);
    }

    public Query getQueryPlan() throws IOException {
        return this.plan.getQueryPlan();
    }

    public String getErrorMsg() {
        return this.errorMessage;
    }

    @Override
    public QueryDisplay getQueryDisplay() {
        return this.queryDisplay;
    }

    @Override
    public void setOperationId(String opId) {
        this.operationId = opId;
    }

    public QueryState getQueryState() {
        return this.queryState;
    }

    public HookRunner getHookRunner() {
        return this.hookRunner;
    }

    public void setStatsSource(StatsSource runtimeStatsSource) {
        this.statsSource = runtimeStatsSource;
    }

    public StatsSource getStatsSource() {
        return this.statsSource;
    }

    @Override
    public boolean hasResultSet() {
        for (Task<? extends Serializable> task : this.plan.getRootTasks()) {
            if (task.getClass() != ExplainTask.class) continue;
            return true;
        }
        return this.plan.getFetchTask() != null && this.schema != null && this.schema.isSetFieldSchemas();
    }

    public void setCompactionWriteIds(ValidWriteIdList val) {
        this.compactionWriteIds = val;
    }

    public static class LockedDriverState {
        public final ReentrantLock stateLock = new ReentrantLock();
        public DriverState driverState = DriverState.INITIALIZED;
        public AtomicBoolean aborted = new AtomicBoolean();
        private static ThreadLocal<LockedDriverState> lds = new ThreadLocal<LockedDriverState>(){

            @Override
            protected LockedDriverState initialValue() {
                return new LockedDriverState();
            }
        };

        public static void setLockedDriverState(LockedDriverState lDrv) {
            lds.set(lDrv);
        }

        public static LockedDriverState getLockedDriverState() {
            return lds.get();
        }

        public static void removeLockedDriverState() {
            if (lds != null) {
                lds.remove();
            }
        }

        public boolean isAborted() {
            return this.aborted.get();
        }

        public void abort() {
            this.aborted.set(true);
        }

        public String toString() {
            return String.format("%s(aborted:%s)", new Object[]{this.driverState, this.aborted.get()});
        }
    }

    private static enum DriverState {
        INITIALIZED,
        COMPILING,
        COMPILED,
        EXECUTING,
        EXECUTED,
        CLOSED,
        DESTROYED,
        ERROR;

    }
}

