/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.metrics.metrics2;

import hive.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleReporter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.com.codahale.metrics.MetricRegistry;
import org.apache.hive.com.codahale.metrics.json.MetricsModule;
import org.apache.hive.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.com.fasterxml.jackson.databind.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileMetricsReporter
implements CodahaleReporter,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonFileMetricsReporter.class);
    private static final FileAttribute<Set<PosixFilePermission>> FILE_ATTRS = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--"));
    private static final FileAttribute<Set<PosixFilePermission>> DIR_ATTRS = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-xr-x"));
    private static final String JSON_REPORTER_THREAD_NAME = "json-metric-reporter";
    private final MetricRegistry metricRegistry;
    private final ObjectWriter jsonWriter;
    private ScheduledExecutorService executorService;
    private final long interval;
    private final Path path;
    private final Path metricsDir;

    public JsonFileMetricsReporter(MetricRegistry registry, HiveConf conf) {
        this.metricRegistry = registry;
        this.jsonWriter = new ObjectMapper().registerModule(new MetricsModule(TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS, false)).writerWithDefaultPrettyPrinter();
        this.interval = conf.getTimeVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_INTERVAL, TimeUnit.MILLISECONDS);
        String pathString = conf.getVar(HiveConf.ConfVars.HIVE_METRICS_JSON_FILE_LOCATION);
        this.path = Paths.get(pathString, new String[0]).toAbsolutePath();
        LOGGER.info("Reporting metrics to {}", (Object)this.path);
        this.metricsDir = this.path.getParent();
    }

    @Override
    public void start() {
        if (!this.metricsDir.toFile().exists()) {
            LOGGER.warn("Metrics directory {} does not exist, creating one", (Object)this.metricsDir);
            try {
                Files.createDirectories(this.metricsDir, DIR_ATTRS);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create directory {}: {}", (Object)this.metricsDir, (Object)e.getMessage());
                return;
            }
        }
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat(JSON_REPORTER_THREAD_NAME).build());
        this.executorService.scheduleWithFixedDelay(this, 0L, this.interval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

