/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.mapreduce;

import hive.org.apache.avro.generic.GenericData;
import hive.org.apache.avro.hadoop.io.AvroDatumConverter;
import hive.org.apache.avro.hadoop.io.AvroDatumConverterFactory;
import hive.org.apache.avro.hadoop.io.AvroSerialization;
import hive.org.apache.avro.mapreduce.AvroKeyValueRecordWriter;
import hive.org.apache.avro.mapreduce.AvroOutputFormatBase;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AvroKeyValueOutputFormat<K, V>
extends AvroOutputFormatBase<K, V> {
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        AvroDatumConverterFactory converterFactory = new AvroDatumConverterFactory(conf);
        AvroDatumConverter keyConverter = converterFactory.create(context.getOutputKeyClass());
        AvroDatumConverter valueConverter = converterFactory.create(context.getOutputValueClass());
        GenericData dataModel = AvroSerialization.createDataModel(conf);
        OutputStream out = this.getAvroFileOutputStream(context);
        try {
            return new AvroKeyValueRecordWriter(keyConverter, valueConverter, dataModel, AvroKeyValueOutputFormat.getCompressionCodec(context), out, AvroKeyValueOutputFormat.getSyncInterval(context));
        }
        catch (IOException e) {
            out.close();
            throw e;
        }
    }
}

