/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import hive.org.apache.commons.lang.builder.HashCodeBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.DataReader;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.DataReaderProperties;
import org.apache.orc.impl.DirectDecompressionCodec;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.HadoopShimsFactory;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.OrcCodecPool;
import org.apache.orc.impl.OrcIndex;
import org.apache.orc.impl.ReaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordReaderUtils {
    private static final HadoopShims SHIMS = HadoopShimsFactory.get();
    private static final Logger LOG = LoggerFactory.getLogger(RecordReaderUtils.class);
    private static final int BYTE_STREAM_POSITIONS = 1;
    private static final int RUN_LENGTH_BYTE_POSITIONS = 2;
    private static final int BITFIELD_POSITIONS = 3;
    private static final int RUN_LENGTH_INT_POSITIONS = 2;
    static final int WORST_UNCOMPRESSED_SLOP = 4098;

    static boolean hadBadBloomFilters(TypeDescription.Category category, OrcFile.WriterVersion version) {
        switch (category) {
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return !version.includes(OrcFile.WriterVersion.HIVE_12055);
            }
            case DECIMAL: {
                return true;
            }
            case TIMESTAMP: {
                return !version.includes(OrcFile.WriterVersion.ORC_135);
            }
        }
        return false;
    }

    public static DiskRangeList planIndexReading(TypeDescription fileSchema, OrcProto.StripeFooter footer, boolean ignoreNonUtf8BloomFilter, boolean[] fileIncluded, boolean[] sargColumns, OrcFile.WriterVersion version, OrcProto.Stream.Kind[] bloomFilterKinds) {
        DiskRangeList.CreateHelper result = new DiskRangeList.CreateHelper();
        List<OrcProto.Stream> streams = footer.getStreamsList();
        if (sargColumns != null) {
            for (OrcProto.Stream stream : streams) {
                int column;
                if (!stream.hasKind() || !stream.hasColumn() || !sargColumns[column = stream.getColumn()]) continue;
                switch (stream.getKind()) {
                    case BLOOM_FILTER: {
                        if (bloomFilterKinds[column] != null || ignoreNonUtf8BloomFilter && RecordReaderUtils.hadBadBloomFilters(fileSchema.findSubtype(column).getCategory(), version)) break;
                        bloomFilterKinds[column] = OrcProto.Stream.Kind.BLOOM_FILTER;
                        break;
                    }
                    case BLOOM_FILTER_UTF8: {
                        bloomFilterKinds[column] = OrcProto.Stream.Kind.BLOOM_FILTER_UTF8;
                        break;
                    }
                }
            }
        }
        long offset = 0L;
        for (OrcProto.Stream stream : footer.getStreamsList()) {
            if (stream.hasKind() && stream.hasColumn()) {
                int column = stream.getColumn();
                if (fileIncluded == null || fileIncluded[column]) {
                    boolean needStream = false;
                    switch (stream.getKind()) {
                        case ROW_INDEX: {
                            needStream = true;
                            break;
                        }
                        case BLOOM_FILTER: {
                            needStream = bloomFilterKinds[column] == OrcProto.Stream.Kind.BLOOM_FILTER;
                            break;
                        }
                        case BLOOM_FILTER_UTF8: {
                            needStream = bloomFilterKinds[column] == OrcProto.Stream.Kind.BLOOM_FILTER_UTF8;
                            break;
                        }
                    }
                    if (needStream) {
                        result.addOrMerge(offset, offset + stream.getLength(), true, false);
                    }
                }
            }
            offset += stream.getLength();
        }
        return result.get();
    }

    public static DataReader createDefaultDataReader(DataReaderProperties properties) {
        return new DefaultDataReader(properties);
    }

    public static boolean[] findPresentStreamsByColumn(List<OrcProto.Stream> streamList, List<OrcProto.Type> types) {
        boolean[] hasNull = new boolean[types.size()];
        for (OrcProto.Stream stream : streamList) {
            if (!stream.hasKind() || stream.getKind() != OrcProto.Stream.Kind.PRESENT) continue;
            hasNull[stream.getColumn()] = true;
        }
        return hasNull;
    }

    static boolean overlap(long leftA, long rightA, long leftB, long rightB) {
        if (leftA <= leftB) {
            return rightA >= leftB;
        }
        return rightB >= leftA;
    }

    public static void addEntireStreamToRanges(long offset, long length, DiskRangeList.CreateHelper list, boolean doMergeBuffers) {
        list.addOrMerge(offset, offset + length, doMergeBuffers, false);
    }

    public static void addRgFilteredStreamToRanges(OrcProto.Stream stream, boolean[] includedRowGroups, boolean isCompressed, OrcProto.RowIndex index, OrcProto.ColumnEncoding encoding, OrcProto.Type type, int compressionSize, boolean hasNull, long offset, long length, DiskRangeList.CreateHelper list, boolean doMergeBuffers) {
        for (int group = 0; group < includedRowGroups.length; ++group) {
            if (!includedRowGroups[group]) continue;
            int posn = RecordReaderUtils.getIndexPosition(encoding.getKind(), type.getKind(), stream.getKind(), isCompressed, hasNull);
            long start = index.getEntry(group).getPositions(posn);
            boolean isLast = group == includedRowGroups.length - 1;
            long nextGroupOffset = isLast ? length : index.getEntry(group + 1).getPositions(posn);
            long end = offset + RecordReaderUtils.estimateRgEndOffset(isCompressed, isLast, nextGroupOffset, length, compressionSize);
            list.addOrMerge(start += offset, end, doMergeBuffers, true);
        }
    }

    public static long estimateRgEndOffset(boolean isCompressed, boolean isLast, long nextGroupOffset, long streamLength, int bufferSize) {
        long slop = isCompressed ? (long)(2 * (3 + bufferSize)) : 4098L;
        return isLast ? streamLength : Math.min(streamLength, nextGroupOffset + slop);
    }

    public static int getIndexPosition(OrcProto.ColumnEncoding.Kind columnEncoding, OrcProto.Type.Kind columnType, OrcProto.Stream.Kind streamType, boolean isCompressed, boolean hasNulls) {
        if (streamType == OrcProto.Stream.Kind.PRESENT) {
            return 0;
        }
        int compressionValue = isCompressed ? 1 : 0;
        int base = hasNulls ? 3 + compressionValue : 0;
        switch (columnType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case STRUCT: 
            case MAP: 
            case LIST: 
            case UNION: {
                return base;
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                if (columnEncoding == OrcProto.ColumnEncoding.Kind.DICTIONARY || columnEncoding == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                    return base;
                }
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case BINARY: {
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case DECIMAL: {
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 1 + compressionValue;
            }
            case TIMESTAMP: {
                if (streamType == OrcProto.Stream.Kind.DATA) {
                    return base;
                }
                return base + 2 + compressionValue;
            }
        }
        throw new IllegalArgumentException("Unknown type " + columnType);
    }

    public static boolean isDictionary(OrcProto.Stream.Kind kind, OrcProto.ColumnEncoding encoding) {
        assert (kind != OrcProto.Stream.Kind.DICTIONARY_COUNT);
        OrcProto.ColumnEncoding.Kind encodingKind = encoding.getKind();
        return kind == OrcProto.Stream.Kind.DICTIONARY_DATA || kind == OrcProto.Stream.Kind.LENGTH && (encodingKind == OrcProto.ColumnEncoding.Kind.DICTIONARY || encodingKind == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2);
    }

    public static String stringifyDiskRanges(DiskRangeList range) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean isFirst = true;
        while (range != null) {
            if (!isFirst) {
                buffer.append(", {");
            } else {
                buffer.append("{");
            }
            isFirst = false;
            buffer.append(range.toString());
            buffer.append("}");
            range = range.next;
        }
        buffer.append("]");
        return buffer.toString();
    }

    static DiskRangeList readDiskRanges(FSDataInputStream file, HadoopShims.ZeroCopyReaderShim zcr, long base, DiskRangeList range, boolean doForceDirect, int maxChunkLimit) throws IOException {
        if (range == null) {
            return null;
        }
        DiskRangeList prev = range.prev;
        if (prev == null) {
            prev = new DiskRangeList.MutateHelper(range);
        }
        while (range != null) {
            if (range.hasData()) {
                range = range.next;
                continue;
            }
            boolean firstRead = true;
            long len = range.getEnd() - range.getOffset();
            long off = range.getOffset();
            while (len > 0L) {
                ByteBuffer partial;
                int readSize;
                int n = readSize = len >= (long)maxChunkLimit ? maxChunkLimit : (int)len;
                if (zcr != null) {
                    if (firstRead) {
                        file.seek(base + off);
                    }
                    partial = zcr.readBuffer(readSize, false);
                    readSize = partial.remaining();
                } else {
                    byte[] buffer = new byte[readSize];
                    file.readFully(base + off, buffer, 0, buffer.length);
                    if (doForceDirect) {
                        partial = ByteBuffer.allocateDirect(readSize);
                        partial.put(buffer);
                        partial.position(0);
                        partial.limit(readSize);
                    } else {
                        partial = ByteBuffer.wrap(buffer);
                    }
                }
                BufferChunk bc = new BufferChunk(partial, off);
                if (firstRead) {
                    range.replaceSelfWith(bc);
                } else {
                    range.insertAfter(bc);
                }
                firstRead = false;
                range = bc;
                len -= (long)readSize;
                off += (long)readSize;
            }
            range = range.next;
        }
        return prev.next;
    }

    static List<DiskRange> getStreamBuffers(DiskRangeList range, long offset, long length) {
        ArrayList<DiskRange> buffers = new ArrayList<DiskRange>();
        if (length == 0L) {
            return buffers;
        }
        long streamEnd = offset + length;
        boolean inRange = false;
        while (range != null) {
            if (!inRange) {
                if (range.getEnd() <= offset) {
                    range = range.next;
                    continue;
                }
                inRange = true;
                if (range.getOffset() < offset) {
                    buffers.add(range.sliceAndShift(offset, Math.min(streamEnd, range.getEnd()), -offset));
                    if (range.getEnd() >= streamEnd) break;
                    range = range.next;
                    continue;
                }
            } else if (range.getOffset() >= streamEnd) break;
            if (range.getEnd() > streamEnd) {
                buffers.add(range.sliceAndShift(range.getOffset(), streamEnd, -offset));
                break;
            }
            buffers.add(range.sliceAndShift(range.getOffset(), range.getEnd(), -offset));
            if (range.getEnd() == streamEnd) break;
            range = range.next;
        }
        return buffers;
    }

    static HadoopShims.ZeroCopyReaderShim createZeroCopyShim(FSDataInputStream file, CompressionCodec codec, ByteBufferAllocatorPool pool) throws IOException {
        if (codec == null || codec instanceof DirectDecompressionCodec && ((DirectDecompressionCodec)codec).isAvailable()) {
            return SHIMS.getZeroCopyReader(file, pool);
        }
        return null;
    }

    public static final class ByteBufferAllocatorPool
    implements HadoopShims.ByteBufferPoolShim {
        private final TreeMap<Key, ByteBuffer> buffers = new TreeMap();
        private final TreeMap<Key, ByteBuffer> directBuffers = new TreeMap();
        private long currentGeneration = 0L;

        private final TreeMap<Key, ByteBuffer> getBufferTree(boolean direct) {
            return direct ? this.directBuffers : this.buffers;
        }

        public void clear() {
            this.buffers.clear();
            this.directBuffers.clear();
        }

        @Override
        public ByteBuffer getBuffer(boolean direct, int length) {
            TreeMap<Key, ByteBuffer> tree = this.getBufferTree(direct);
            Map.Entry<Key, ByteBuffer> entry = tree.ceilingEntry(new Key(length, 0L));
            if (entry == null) {
                return direct ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
            }
            tree.remove(entry.getKey());
            return entry.getValue();
        }

        @Override
        public void putBuffer(ByteBuffer buffer) {
            Key key;
            TreeMap<Key, ByteBuffer> tree = this.getBufferTree(buffer.isDirect());
            while (tree.containsKey(key = new Key(buffer.capacity(), this.currentGeneration++))) {
            }
            tree.put(key, buffer);
        }

        private static final class Key
        implements Comparable<Key> {
            private final int capacity;
            private final long insertionGeneration;

            Key(int capacity, long insertionGeneration) {
                this.capacity = capacity;
                this.insertionGeneration = insertionGeneration;
            }

            @Override
            public int compareTo(Key other) {
                if (this.capacity != other.capacity) {
                    return this.capacity - other.capacity;
                }
                return Long.compare(this.insertionGeneration, other.insertionGeneration);
            }

            public boolean equals(Object rhs) {
                if (rhs == null) {
                    return false;
                }
                try {
                    Key o = (Key)rhs;
                    return this.compareTo(o) == 0;
                }
                catch (ClassCastException e) {
                    return false;
                }
            }

            public int hashCode() {
                return new HashCodeBuilder().append(this.capacity).append(this.insertionGeneration).toHashCode();
            }
        }
    }

    private static class DefaultDataReader
    implements DataReader {
        private FSDataInputStream file;
        private ByteBufferAllocatorPool pool;
        private HadoopShims.ZeroCopyReaderShim zcr = null;
        private final Supplier<FileSystem> fileSystemSupplier;
        private final Path path;
        private final boolean useZeroCopy;
        private CompressionCodec codec;
        private final int bufferSize;
        private final int typeCount;
        private CompressionKind compressionKind;
        private final int maxDiskRangeChunkLimit;
        private boolean isOpen = false;

        private DefaultDataReader(DataReaderProperties properties) {
            this.fileSystemSupplier = properties.getFileSystemSupplier();
            this.path = properties.getPath();
            this.file = properties.getFile();
            this.useZeroCopy = properties.getZeroCopy();
            this.compressionKind = properties.getCompression();
            this.codec = OrcCodecPool.getCodec(this.compressionKind);
            this.bufferSize = properties.getBufferSize();
            this.typeCount = properties.getTypeCount();
            this.maxDiskRangeChunkLimit = properties.getMaxDiskRangeChunkLimit();
        }

        @Override
        public void open() throws IOException {
            if (this.file == null) {
                this.file = this.fileSystemSupplier.get().open(this.path);
            }
            if (this.useZeroCopy) {
                this.pool = new ByteBufferAllocatorPool();
                this.zcr = RecordReaderUtils.createZeroCopyShim(this.file, this.codec, this.pool);
            } else {
                this.zcr = null;
            }
            this.isOpen = true;
        }

        @Override
        public OrcIndex readRowIndex(StripeInformation stripe, TypeDescription fileSchema, OrcProto.StripeFooter footer, boolean ignoreNonUtf8BloomFilter, boolean[] included, OrcProto.RowIndex[] indexes, boolean[] sargColumns, OrcFile.WriterVersion version, OrcProto.Stream.Kind[] bloomFilterKinds, OrcProto.BloomFilterIndex[] bloomFilterIndices) throws IOException {
            if (!this.isOpen) {
                this.open();
            }
            if (footer == null) {
                footer = this.readStripeFooter(stripe);
            }
            if (indexes == null) {
                indexes = new OrcProto.RowIndex[this.typeCount];
            }
            if (bloomFilterKinds == null) {
                bloomFilterKinds = new OrcProto.Stream.Kind[this.typeCount];
            }
            if (bloomFilterIndices == null) {
                bloomFilterIndices = new OrcProto.BloomFilterIndex[this.typeCount];
            }
            DiskRangeList ranges = RecordReaderUtils.planIndexReading(fileSchema, footer, ignoreNonUtf8BloomFilter, included, sargColumns, version, bloomFilterKinds);
            ranges = RecordReaderUtils.readDiskRanges(this.file, this.zcr, stripe.getOffset(), ranges, false, this.maxDiskRangeChunkLimit);
            long offset = 0L;
            DiskRangeList range = ranges;
            for (OrcProto.Stream stream : footer.getStreamsList()) {
                while (range != null && range.getEnd() <= offset) {
                    range = range.next;
                }
                if (range == null) break;
                int column = stream.getColumn();
                if (stream.hasKind() && range.getOffset() <= offset) {
                    switch (stream.getKind()) {
                        case ROW_INDEX: {
                            if (included != null && !included[column]) break;
                            ByteBuffer bb = range.getData().duplicate();
                            bb.position((int)(offset - range.getOffset()));
                            bb.limit((int)((long)bb.position() + stream.getLength()));
                            indexes[column] = OrcProto.RowIndex.parseFrom(InStream.createCodedInputStream("index", ReaderImpl.singleton(new BufferChunk(bb, 0L)), stream.getLength(), this.codec, this.bufferSize));
                            break;
                        }
                        case BLOOM_FILTER: 
                        case BLOOM_FILTER_UTF8: {
                            if (sargColumns == null || !sargColumns[column]) break;
                            ByteBuffer bb = range.getData().duplicate();
                            bb.position((int)(offset - range.getOffset()));
                            bb.limit((int)((long)bb.position() + stream.getLength()));
                            bloomFilterIndices[column] = OrcProto.BloomFilterIndex.parseFrom(InStream.createCodedInputStream("bloom_filter", ReaderImpl.singleton(new BufferChunk(bb, 0L)), stream.getLength(), this.codec, this.bufferSize));
                            break;
                        }
                    }
                }
                offset += stream.getLength();
            }
            return new OrcIndex(indexes, bloomFilterKinds, bloomFilterIndices);
        }

        @Override
        public OrcProto.StripeFooter readStripeFooter(StripeInformation stripe) throws IOException {
            if (!this.isOpen) {
                this.open();
            }
            long offset = stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength();
            int tailLength = (int)stripe.getFooterLength();
            ByteBuffer tailBuf = ByteBuffer.allocate(tailLength);
            this.file.readFully(offset, tailBuf.array(), tailBuf.arrayOffset(), tailLength);
            return OrcProto.StripeFooter.parseFrom(InStream.createCodedInputStream("footer", ReaderImpl.singleton(new BufferChunk(tailBuf, 0L)), tailLength, this.codec, this.bufferSize));
        }

        @Override
        public DiskRangeList readFileData(DiskRangeList range, long baseOffset, boolean doForceDirect) throws IOException {
            return RecordReaderUtils.readDiskRanges(this.file, this.zcr, baseOffset, range, doForceDirect, this.maxDiskRangeChunkLimit);
        }

        @Override
        public void close() throws IOException {
            if (this.codec != null) {
                OrcCodecPool.returnCodec(this.compressionKind, this.codec);
                this.codec = null;
            }
            if (this.pool != null) {
                this.pool.clear();
            }
            try (HadoopShims.ZeroCopyReaderShim myZcr = this.zcr;){
                if (this.file != null) {
                    this.file.close();
                    this.file = null;
                }
            }
        }

        @Override
        public boolean isTrackingDiskRanges() {
            return this.zcr != null;
        }

        @Override
        public void releaseBuffer(ByteBuffer buffer) {
            this.zcr.releaseBuffer(buffer);
        }

        @Override
        public DataReader clone() {
            if (this.file != null) {
                LOG.warn("Cloning an opened DataReader; the stream will be reused and closed twice");
            }
            try {
                DefaultDataReader clone = (DefaultDataReader)super.clone();
                if (this.codec != null) {
                    clone.codec = OrcCodecPool.getCodec(clone.compressionKind);
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new UnsupportedOperationException("uncloneable", e);
            }
        }

        @Override
        public CompressionCodec getCompressionCodec() {
            return this.codec;
        }
    }
}

