/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import hive.org.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;

public class DropTableEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Log LOG = LogFactory.getLog(DropTableEvent.class);
    private String COMMAND_STR = "Drop table";

    public DropTableEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.DROPTABLE, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> DropTableEvent.getInputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreDropTableEvent event = (PreDropTableEvent)this.preEventContext;
        Table table = event.getTable();
        ret.add(this.getHivePrivilegeObject(table));
        this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, table);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== DropTableEvent.getInputHObjs(): ret=" + ret));
        }
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        return Collections.emptyList();
    }

    private String buildCommandString(String cmdStr, Table tbl) {
        Object ret = cmdStr;
        if (tbl != null) {
            String tblName = tbl.getTableName();
            ret = (String)ret + (String)(StringUtils.isNotEmpty(tblName) ? " " + tblName : "");
        }
        return ret;
    }
}

