/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.io;

import java.io.IOException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.JsonWriter;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;

public class DBSerializer
implements JsonWriter.Serializer {
    public static final String FIELD_NAME = "db";
    private final Database dbObject;

    public DBSerializer(Database dbObject) {
        this.dbObject = dbObject;
    }

    @Override
    public void writeTo(JsonWriter writer, ReplicationSpec additionalPropertiesProvider) throws SemanticException, IOException {
        this.dbObject.putToParameters(ReplicationSpec.KEY.CURR_STATE_ID.toString(), additionalPropertiesProvider.getCurrentReplicationState());
        try {
            TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
            String value = serializer.toString(this.dbObject);
            writer.jsonGenerator.writeStringField(FIELD_NAME, value);
        }
        catch (TException e) {
            throw new SemanticException(ErrorMsg.ERROR_SERIALIZE_METASTORE.getMsg(), e);
        }
    }
}

