/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.ImmutableMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveReduceExpressionsRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSortLimitPullUpConstantsRule
extends RelOptRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveSortLimitPullUpConstantsRule.class);
    public static final HiveSortLimitPullUpConstantsRule INSTANCE = new HiveSortLimitPullUpConstantsRule(HiveSortLimit.class, HiveRelFactories.HIVE_BUILDER);

    private HiveSortLimitPullUpConstantsRule(Class<? extends Sort> sortClass, RelBuilderFactory relBuilderFactory) {
        super(HiveSortLimitPullUpConstantsRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveSortLimitPullUpConstantsRule.unordered((RelOptRuleOperand)HiveSortLimitPullUpConstantsRule.operand(sortClass, (RelOptRuleOperandChildren)HiveSortLimitPullUpConstantsRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0])), relBuilderFactory, null);
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode parent = call.rel(0);
        Sort sort = (Sort)call.rel(1);
        int count = sort.getInput().getRowType().getFieldCount();
        if (count == 1) {
            return;
        }
        RexBuilder rexBuilder = sort.getCluster().getRexBuilder();
        RelMetadataQuery mq = call.getMetadataQuery();
        RelOptPredicateList predicates = mq.getPulledUpPredicates(sort.getInput());
        if (predicates == null) {
            return;
        }
        ImmutableMap conditionsExtracted = HiveReduceExpressionsRule.predicateConstants(RexNode.class, (RexBuilder)rexBuilder, (RelOptPredicateList)predicates);
        HashMap<RexInputRef, RexNode> constants = new HashMap<RexInputRef, RexNode>();
        for (int i = 0; i < count; ++i) {
            RexInputRef expr = rexBuilder.makeInputRef(sort.getInput(), i);
            if (!conditionsExtracted.containsKey(expr)) continue;
            constants.put(expr, (RexNode)conditionsExtracted.get(expr));
        }
        if (constants.isEmpty()) {
            return;
        }
        if (count == constants.size()) {
            constants.remove(constants.keySet().iterator().next());
        }
        List fields = sort.getInput().getRowType().getFieldList();
        ArrayList<Pair> newChildExprs = new ArrayList<Pair>();
        AbstractCollection topChildExprs = new ArrayList<Object>();
        ArrayList<String> topChildExprsFields = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            RexInputRef expr = rexBuilder.makeInputRef(sort.getInput(), i);
            RelDataTypeField field = (RelDataTypeField)fields.get(i);
            if (constants.containsKey(expr)) {
                topChildExprs.add((RexNode)constants.get(expr));
                topChildExprsFields.add(field.getName());
                continue;
            }
            newChildExprs.add(Pair.of((Object)expr, (Object)field.getName()));
            topChildExprs.add(expr);
            topChildExprsFields.add(field.getName());
        }
        Mapping mapping = RelOptUtil.permutation((List)Pair.left(newChildExprs), (RelDataType)sort.getInput().getRowType()).inverse();
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        for (RelFieldCollation fc : sort.getCollation().getFieldCollations()) {
            int target = mapping.getTargetOpt(fc.getFieldIndex());
            if (target < 0) continue;
            fieldCollations.add(fc.copy(target));
        }
        topChildExprs = ImmutableList.copyOf(RexUtil.apply((Mappings.TargetMapping)mapping, topChildExprs));
        RelBuilder relBuilder = call.builder();
        relBuilder.push(sort.getInput());
        relBuilder.project((Iterable)Pair.left(newChildExprs), (Iterable)Pair.right(newChildExprs));
        ImmutableList sortFields = relBuilder.fields(RelCollations.of(fieldCollations));
        relBuilder.sortLimit(sort.offset == null ? -1 : RexLiteral.intValue((RexNode)sort.offset), sort.fetch == null ? -1 : RexLiteral.intValue((RexNode)sort.fetch), (Iterable)sortFields);
        relBuilder.project(topChildExprs, topChildExprsFields);
        relBuilder.convert(sort.getRowType(), false);
        ArrayList<RelNode> inputs = new ArrayList<RelNode>();
        for (RelNode child : parent.getInputs()) {
            if (!((HepRelVertex)child).getCurrentRel().equals(sort)) {
                inputs.add(child);
                continue;
            }
            inputs.add(relBuilder.build());
        }
        call.transformTo(parent.copy(parent.getTraitSet(), inputs));
    }
}

