/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import hive.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.UserPoolMapping;
import org.apache.hadoop.hive.ql.exec.tez.WorkloadManagerFederation;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.TezJobMonitor;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MergeJoinWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.UnionWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.WmContext;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hive.common.util.Ref;
import org.apache.tez.client.CallerContext;
import org.apache.tez.client.TezClient;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.common.security.DAGAccessControls;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.json.JSONObject;

public class TezTask
extends Task<TezWork> {
    private static final String CLASS_NAME = TezTask.class.getName();
    private final PerfLogger perfLogger = SessionState.getPerfLogger();
    private static final String TEZ_MEMORY_RESERVE_FRACTION = "tez.task.scale.memory.reserve-fraction";
    private TezCounters counters;
    private final DagUtils utils;
    private final Object dagClientLock = new Object();
    private volatile boolean isShutdown = false;
    private DAGClient dagClient = null;
    Map<BaseWork, Vertex> workToVertex = new HashMap<BaseWork, Vertex>();
    Map<BaseWork, JobConf> workToConf = new HashMap<BaseWork, JobConf>();

    public TezTask() {
        this(DagUtils.getInstance());
    }

    public TezTask(DagUtils utils) {
        this.utils = utils;
    }

    public TezCounters getTezCounters() {
        return this.counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(DriverContext driverContext) {
        int rc;
        block61: {
            rc = 1;
            boolean cleanContext = false;
            Context ctx = null;
            Ref<Object> sessionRef = Ref.from(null);
            try {
                TezSessionState tezSessionState;
                Object ss;
                TezSessionState object;
                ctx = driverContext.getCtx();
                if (ctx == null) {
                    ctx = new Context(this.conf);
                    cleanContext = true;
                    String queryId = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYID);
                    WmContext wmContext = new WmContext(System.currentTimeMillis(), queryId);
                    ctx.setWmContext(wmContext);
                }
                if ((object = (sessionRef.value = ((SessionState)(ss = SessionState.get())).getTezSession())) != null && !object.isOpen()) {
                    LOG.warn("The session: " + object + " has not been opened");
                }
                String userName = this.getUserNameForGroups((SessionState)ss);
                List groups = null;
                if (userName == null) {
                    userName = "anonymous";
                } else {
                    try {
                        groups = UserGroupInformation.createRemoteUser((String)userName).getGroups();
                    }
                    catch (Exception ex) {
                        LOG.warn("Cannot obtain groups for " + userName, (Throwable)ex);
                    }
                }
                UserPoolMapping.MappingInput mi = new UserPoolMapping.MappingInput(userName, groups, ((SessionState)ss).getHiveVariables().get("wmpool"), ((SessionState)ss).getHiveVariables().get("wmapp"));
                WmContext wmContext = ctx.getWmContext();
                JobConf jobConf = this.utils.createConfiguration(this.conf);
                String[] allNonConfFiles = ((TezWork)this.work).configureJobConfAndExtractJars(jobConf);
                Path scratchDir = this.utils.createTezDir(ctx.getMRScratchDir(), this.conf);
                CallerContext callerContext = CallerContext.create((String)"HIVE", (String)this.queryPlan.getQueryId(), (String)"HIVE_QUERY_ID", (String)this.queryPlan.getQueryStr());
                this.perfLogger.PerfLogBegin(CLASS_NAME, "TezGetSession");
                sessionRef.value = WorkloadManagerFederation.getSession((TezSessionState)sessionRef.value, this.conf, mi, ((TezWork)this.getWork()).getLlapMode(), wmContext);
                TezSessionState tezSessionState2 = sessionRef.value;
                this.perfLogger.PerfLogEnd(CLASS_NAME, "TezGetSession");
                try {
                    ((SessionState)ss).setTezSession(tezSessionState2);
                    LOG.info("Subscribed to counters: {} for queryId: {}", wmContext.getSubscribedCounters(), (Object)wmContext.getQueryId());
                    this.ensureSessionHasResources(tezSessionState2, allNonConfFiles);
                    List<LocalResource> allNonAppResources = tezSessionState2.getLocalizedResources();
                    this.logResources(allNonAppResources);
                    Map<String, LocalResource> allResources = DagUtils.createTezLrMap(tezSessionState2.getAppJarLr(), allNonAppResources);
                    DAG dag = this.build(jobConf, (TezWork)this.work, scratchDir, ctx, allResources);
                    dag.setCallerContext(callerContext);
                    if (this.isShutdown) {
                        throw new HiveException("Operation cancelled");
                    }
                    DAGClient dagClient = this.submit(jobConf, dag, sessionRef);
                    tezSessionState = (TezSessionState)sessionRef.value;
                    boolean wasShutdown = false;
                    Object object2 = this.dagClientLock;
                    synchronized (object2) {
                        assert (this.dagClient == null);
                        wasShutdown = this.isShutdown;
                        if (!wasShutdown) {
                            this.dagClient = dagClient;
                        }
                    }
                    if (wasShutdown) {
                        this.closeDagClientOnCancellation(dagClient);
                        throw new HiveException("Operation cancelled");
                    }
                    TezJobMonitor monitor = new TezJobMonitor(((TezWork)this.work).getAllWork(), dagClient, this.conf, dag, ctx);
                    rc = monitor.monitorExecution();
                    if (rc != 0) {
                        this.setException(new HiveException(monitor.getDiagnostics()));
                    }
                    try {
                        EnumSet<StatusGetOpts> statusGetOpts = EnumSet.of(StatusGetOpts.GET_COUNTERS);
                        this.counters = dagClient.getDAGStatus(statusGetOpts).getDAGCounters();
                    }
                    catch (Exception err) {
                        LOG.warn("Failed to get counters. Ignoring, summary info will be incomplete. " + err, (Throwable)err);
                        this.counters = null;
                    }
                    wmContext = ctx.getWmContext();
                }
                catch (Throwable throwable) {
                    wmContext = ctx.getWmContext();
                    try {
                        if (sessionRef.value != null) {
                            ((TezSessionState)sessionRef.value).returnToSessionManager();
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Failed to return session: {} to pool", (Object)tezSessionState2, (Object)e);
                        throw e;
                    }
                    if (!this.conf.getVar(HiveConf.ConfVars.TEZ_SESSION_EVENTS_SUMMARY).equalsIgnoreCase("none") && wmContext != null) {
                        if (this.conf.getVar(HiveConf.ConfVars.TEZ_SESSION_EVENTS_SUMMARY).equalsIgnoreCase("json")) {
                            wmContext.printJson(this.console);
                        } else if (this.conf.getVar(HiveConf.ConfVars.TEZ_SESSION_EVENTS_SUMMARY).equalsIgnoreCase("text")) {
                            wmContext.print(this.console);
                        }
                    }
                    throw throwable;
                }
                try {
                    if (sessionRef.value != null) {
                        ((TezSessionState)sessionRef.value).returnToSessionManager();
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to return session: {} to pool", (Object)tezSessionState, (Object)e);
                    throw e;
                }
                if (!this.conf.getVar(HiveConf.ConfVars.TEZ_SESSION_EVENTS_SUMMARY).equalsIgnoreCase("none") && wmContext != null) {
                    if (this.conf.getVar(HiveConf.ConfVars.TEZ_SESSION_EVENTS_SUMMARY).equalsIgnoreCase("json")) {
                        wmContext.printJson(this.console);
                    } else if (this.conf.getVar(HiveConf.ConfVars.TEZ_SESSION_EVENTS_SUMMARY).equalsIgnoreCase("text")) {
                        wmContext.print(this.console);
                    }
                }
                if (LOG.isInfoEnabled() && this.counters != null && (HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.TEZ_EXEC_SUMMARY) || Utilities.isPerfOrAboveLogging(this.conf))) {
                    for (CounterGroup group : this.counters) {
                        LOG.info(group.getDisplayName() + ":");
                        for (TezCounter counter : group) {
                            LOG.info("   " + counter.getDisplayName() + ": " + counter.getValue());
                        }
                    }
                }
                Utilities.clearWork(this.conf);
            }
            catch (Exception e) {
                LOG.error("Failed to execute tez graph.", (Throwable)e);
                break block61;
            }
            finally {
                Utilities.clearWork(this.conf);
                for (BaseWork baseWork : ((TezWork)this.work).getAllWork()) {
                    JobConf workCfg = this.workToConf.get(baseWork);
                    if (workCfg == null) continue;
                    Utilities.clearWorkMapForConf((Configuration)workCfg);
                }
                if (cleanContext) {
                    try {
                        ctx.clear();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to clean up after tez job", (Throwable)e);
                    }
                }
                DAGClient dagClient = null;
                Object object = this.dagClientLock;
                synchronized (object) {
                    dagClient = this.dagClient;
                    this.dagClient = null;
                }
                if (dagClient != null) {
                    rc = this.close((TezWork)this.work, rc, dagClient);
                }
            }
            for (BaseWork baseWork : ((TezWork)this.work).getAllWork()) {
                JobConf workCfg = this.workToConf.get(baseWork);
                if (workCfg == null) continue;
                Utilities.clearWorkMapForConf((Configuration)workCfg);
            }
            if (cleanContext) {
                try {
                    ctx.clear();
                }
                catch (Exception e) {
                    LOG.warn("Failed to clean up after tez job", (Throwable)e);
                }
            }
            DAGClient dagClient = null;
            Object object = this.dagClientLock;
            synchronized (object) {
                dagClient = this.dagClient;
                this.dagClient = null;
            }
            if (dagClient != null) {
                rc = this.close((TezWork)this.work, rc, dagClient);
            }
        }
        return rc;
    }

    private String getUserNameForGroups(SessionState ss) {
        String userName;
        if (ss.getAuthenticator() != null && (userName = ss.getAuthenticator().getUserName()) != null) {
            return userName;
        }
        return ss.getUserName();
    }

    private void closeDagClientOnCancellation(DAGClient dagClient) {
        try {
            dagClient.tryKillDAG();
            LOG.info("Waiting for Tez task to shut down: " + this);
            dagClient.waitForCompletion();
        }
        catch (Exception ex) {
            LOG.warn("Failed to shut down TezTask" + this, (Throwable)ex);
        }
        TezTask.closeDagClientWithoutEx(dagClient);
    }

    private void logResources(List<LocalResource> additionalLr) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        if (additionalLr == null || additionalLr.size() == 0) {
            LOG.debug("No local resources to process (other than hive-exec)");
        } else {
            for (LocalResource lr : additionalLr) {
                LOG.debug("Adding local resource: " + lr.getResource());
            }
        }
    }

    @VisibleForTesting
    void ensureSessionHasResources(TezSessionState session, String[] nonConfResources) throws Exception {
        TezClient client = session.getSession();
        if (client == null) {
            LOG.info("Tez session hasn't been created yet. Opening session");
            session.open(nonConfResources);
        } else {
            LOG.info("Session is already open");
            session.ensureLocalResources(this.conf, nonConfResources);
        }
    }

    void checkOutputSpec(BaseWork work, JobConf jc) throws IOException {
        for (Operator<?> op : work.getAllOperators()) {
            if (!(op instanceof FileSinkOperator)) continue;
            ((FileSinkOperator)op).checkOutputSpecs(null, jc);
        }
    }

    DAG build(JobConf conf, TezWork work, Path scratchDir, Context ctx, Map<String, LocalResource> vertexResources) throws Exception {
        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezBuildDag");
        List<BaseWork> ws = work.getAllWork();
        Collections.reverse(ws);
        FileSystem fs = scratchDir.getFileSystem((Configuration)conf);
        String dagName = this.utils.createDagName((Configuration)conf, this.queryPlan);
        LOG.info("Dag name: " + dagName);
        DAG dag = DAG.create((String)dagName);
        JSONObject json = new JSONObject(new LinkedHashMap()).put("context", "Hive").put("description", ctx.getCmd());
        String dagInfo = json.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("DagInfo: " + dagInfo);
        }
        dag.setDAGInfo(dagInfo);
        dag.setCredentials(conf.getCredentials());
        TezTask.setAccessControlsForCurrentUser(dag, this.queryPlan.getQueryId(), (Configuration)conf);
        for (BaseWork w : ws) {
            boolean isFinal = work.getLeaves().contains(w);
            this.perfLogger.PerfLogBegin(CLASS_NAME, "TezCreateVertex." + w.getName());
            if (w instanceof UnionWork) {
                LinkedList<BaseWork> unionWorkItems = new LinkedList<BaseWork>();
                LinkedList<BaseWork> children = new LinkedList<BaseWork>();
                for (BaseWork v : work.getChildren(w)) {
                    TezEdgeProperty.EdgeType type = work.getEdgeProperty(w, v).getEdgeType();
                    if (type == TezEdgeProperty.EdgeType.CONTAINS) {
                        unionWorkItems.add(v);
                        continue;
                    }
                    children.add(v);
                }
                JobConf parentConf = this.workToConf.get(unionWorkItems.get(0));
                this.checkOutputSpec(w, parentConf);
                Vertex[] vertexArray = new Vertex[unionWorkItems.size()];
                int i = 0;
                for (BaseWork v : unionWorkItems) {
                    vertexArray[i++] = this.workToVertex.get(v);
                }
                VertexGroup group = dag.createVertexGroup(w.getName(), vertexArray);
                for (BaseWork v : children) {
                    GroupInputEdge e = this.utils.createEdge(group, parentConf, this.workToVertex.get(v), work.getEdgeProperty(w, v), v, work);
                    dag.addEdge(e);
                }
                continue;
            }
            JobConf wxConf = this.utils.initializeVertexConf(conf, ctx, w);
            this.checkOutputSpec(w, wxConf);
            Vertex wx = this.utils.createVertex(wxConf, w, scratchDir, fs, ctx, !isFinal, work, work.getVertexType(w), vertexResources);
            if (w.getReservedMemoryMB() > 0) {
                double frac = DagUtils.adjustMemoryReserveFraction(w.getReservedMemoryMB(), this.conf);
                LOG.info("Setting tez.task.scale.memory.reserve-fraction to " + frac);
                wx.setConf(TEZ_MEMORY_RESERVE_FRACTION, Double.toString(frac));
            }
            dag.addVertex(wx);
            this.utils.addCredentials(w, dag);
            this.perfLogger.PerfLogEnd(CLASS_NAME, "TezCreateVertex." + w.getName());
            this.workToVertex.put(w, wx);
            this.workToConf.put(w, wxConf);
            for (BaseWork v : work.getChildren(w)) {
                assert (this.workToVertex.containsKey(v));
                Edge e = null;
                TezEdgeProperty edgeProp = work.getEdgeProperty(w, v);
                e = this.utils.createEdge(wxConf, wx, this.workToVertex.get(v), edgeProp, v, work);
                dag.addEdge(e);
            }
        }
        Utilities.clearWorkMap((Configuration)conf);
        this.perfLogger.PerfLogEnd(CLASS_NAME, "TezBuildDag");
        return dag;
    }

    private static void setAccessControlsForCurrentUser(DAG dag, String queryId, Configuration conf) throws IOException {
        String user = SessionState.getUserFromAuthenticator();
        UserGroupInformation loginUserUgi = UserGroupInformation.getLoginUser();
        String loginUser = loginUserUgi == null ? null : loginUserUgi.getShortUserName();
        boolean addHs2User = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVETEZHS2USERACCESS);
        String viewStr = Utilities.getAclStringWithHiveModification(conf, "tez.am.view-acls", addHs2User, user, loginUser);
        String modifyStr = Utilities.getAclStringWithHiveModification(conf, "tez.am.modify-acls", addHs2User, user, loginUser);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting Tez DAG access for queryId={} with viewAclString={}, modifyStr={}", new Object[]{queryId, viewStr, modifyStr});
        }
        DAGAccessControls ac = new DAGAccessControls(viewStr, modifyStr);
        dag.setAccessControls(ac);
    }

    private TezSessionState getNewTezSessionOnError(TezSessionState oldSession) throws Exception {
        TezSessionState newSession = oldSession.reopen();
        this.console.printInfo("Session re-established.");
        return newSession;
    }

    DAGClient submit(JobConf conf, DAG dag, Ref<TezSessionState> sessionStateRef) throws Exception {
        this.perfLogger.PerfLogBegin(CLASS_NAME, "TezSubmitDag");
        DAGClient dagClient = null;
        TezSessionState sessionState = (TezSessionState)sessionStateRef.value;
        try {
            try {
                dagClient = sessionState.getSession().submitDAG(dag);
            }
            catch (SessionNotRunning nr) {
                this.console.printInfo("Tez session was closed. Reopening...");
                sessionStateRef.value = null;
                sessionState = this.getNewTezSessionOnError(sessionState);
                sessionStateRef.value = sessionState;
                this.console.printInfo("Session re-established.");
                dagClient = sessionState.getSession().submitDAG(dag);
            }
        }
        catch (Exception e) {
            try {
                this.console.printInfo("Dag submit failed due to " + e.getMessage() + " stack trace: " + Arrays.toString(e.getStackTrace()) + " retrying...");
                sessionStateRef.value = null;
                sessionState = this.getNewTezSessionOnError(sessionState);
                sessionStateRef.value = sessionState;
                dagClient = sessionState.getSession().submitDAG(dag);
            }
            catch (Exception retryException) {
                sessionStateRef.value = null;
                sessionState.destroy();
                throw retryException;
            }
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "TezSubmitDag");
        return new SyncDagClient(dagClient);
    }

    @VisibleForTesting
    int close(TezWork work, int rc, DAGClient dagClient) {
        block6: {
            try {
                List<BaseWork> ws = work.getAllWork();
                for (BaseWork w : ws) {
                    if (w instanceof MergeJoinWork) {
                        w = ((MergeJoinWork)w).getMainWork();
                    }
                    for (Operator<?> op : w.getAllOperators()) {
                        op.jobClose(this.conf, rc == 0);
                    }
                }
            }
            catch (Exception e) {
                if (rc != 0) break block6;
                rc = 3;
                String mesg = "Job Commit failed with exception '" + Utilities.getNameMessage(e) + "'";
                this.console.printError(mesg, "\n" + StringUtils.stringifyException((Throwable)e));
            }
        }
        if (dagClient != null) {
            TezTask.closeDagClientWithoutEx(dagClient);
        }
        return rc;
    }

    private static void closeDagClientWithoutEx(DAGClient dagClient) {
        try {
            dagClient.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to close DagClient", (Throwable)e);
        }
    }

    @Override
    public void updateTaskMetrics(Metrics metrics) {
        metrics.incrementCounter("hive_tez_tasks");
    }

    @Override
    public boolean isMapRedTask() {
        return true;
    }

    @Override
    public StageType getType() {
        return StageType.MAPRED;
    }

    @Override
    public String getName() {
        return "TEZ";
    }

    @Override
    public Collection<MapWork> getMapWork() {
        LinkedList<MapWork> result = new LinkedList<MapWork>();
        TezWork work = (TezWork)this.getWork();
        for (BaseWork w : work.getAllWorkUnsorted()) {
            if (!(w instanceof MapWork)) continue;
            List<BaseWork> parents = work.getParents(w);
            boolean candidate = true;
            for (BaseWork parent : parents) {
                if (parent instanceof UnionWork) continue;
                candidate = false;
            }
            if (!candidate) continue;
            result.add((MapWork)w);
        }
        return result;
    }

    @Override
    public Operator<? extends OperatorDesc> getReducer(MapWork mapWork) {
        List<BaseWork> children = ((TezWork)this.getWork()).getChildren(mapWork);
        if (children.size() != 1) {
            return null;
        }
        if (!(children.get(0) instanceof ReduceWork)) {
            return null;
        }
        return ((ReduceWork)children.get(0)).getReducer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        super.shutdown();
        DAGClient dagClient = null;
        Object object = this.dagClientLock;
        synchronized (object) {
            this.isShutdown = true;
            dagClient = this.dagClient;
        }
        LOG.info("Shutting down Tez task " + this + " " + (dagClient == null ? " before submit" : ""));
        if (dagClient == null) {
            return;
        }
        this.closeDagClientOnCancellation(dagClient);
    }

    public class SyncDagClient
    extends DAGClient {
        private final DAGClient dagClient;

        public SyncDagClient(DAGClient dagClient) {
            this.dagClient = dagClient;
        }

        public void close() throws IOException {
            this.dagClient.close();
        }

        public String getDagIdentifierString() {
            return null;
        }

        public String getSessionIdentifierString() {
            return null;
        }

        public String getExecutionContext() {
            return this.dagClient.getExecutionContext();
        }

        @InterfaceAudience.Private
        protected ApplicationReport getApplicationReportInternal() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DAGStatus getDAGStatus(@Nullable Set<StatusGetOpts> statusOptions) throws IOException, TezException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                return this.dagClient.getDAGStatus(statusOptions);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DAGStatus getDAGStatus(@Nullable Set<StatusGetOpts> statusOptions, long timeout) throws IOException, TezException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                return this.dagClient.getDAGStatus(statusOptions, timeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VertexStatus getVertexStatus(String vertexName, Set<StatusGetOpts> statusOptions) throws IOException, TezException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                return this.dagClient.getVertexStatus(vertexName, statusOptions);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tryKillDAG() throws IOException, TezException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                this.dagClient.tryKillDAG();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DAGStatus waitForCompletion() throws IOException, TezException, InterruptedException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                return this.dagClient.waitForCompletion();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DAGStatus waitForCompletionWithStatusUpdates(@Nullable Set<StatusGetOpts> statusGetOpts) throws IOException, TezException, InterruptedException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                return this.dagClient.waitForCompletionWithStatusUpdates(statusGetOpts);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getWebUIAddress() throws IOException, TezException {
            DAGClient dAGClient = this.dagClient;
            synchronized (dAGClient) {
                return this.dagClient.getWebUIAddress();
            }
        }
    }
}

