/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.util.UUID;

public class DaemonId {
    private final String userName;
    private final String clusterName;
    private final String appId;
    private final String hostName;
    private final long startTimeMs;
    private final String uuidString;

    public DaemonId(String userName, String clusterName, String hostName, String appId, long startTime) {
        this.userName = userName;
        this.clusterName = clusterName;
        this.appId = appId;
        this.hostName = hostName;
        this.startTimeMs = startTime;
        this.uuidString = UUID.randomUUID().toString();
    }

    public String getClusterString() {
        return DaemonId.createClusterString(this.userName, this.clusterName);
    }

    public static String createClusterString(String userName, String clusterName) {
        return userName + "_" + clusterName;
    }

    public String getApplicationId() {
        return this.appId;
    }

    public String getUniqueNodeIdInCluster() {
        return this.hostName + "_" + this.startTimeMs + "_" + this.uuidString;
    }
}

