/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop.util;

import hive.org.apache.parquet.bytes.ByteBufferAllocator;
import hive.org.apache.parquet.hadoop.util.wrapped.io.VectorIoBridge;
import hive.org.apache.parquet.io.DelegatingSeekableInputStream;
import hive.org.apache.parquet.io.ParquetFileRange;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;

class H2SeekableInputStream
extends DelegatingSeekableInputStream {
    private final FSDataInputStream stream;
    private final Reader reader;

    public H2SeekableInputStream(FSDataInputStream stream) {
        super((InputStream)stream);
        this.stream = stream;
        this.reader = new H2Reader();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public long getPos() throws IOException {
        return this.stream.getPos();
    }

    @Override
    public void seek(long newPos) throws IOException {
        this.stream.seek(newPos);
    }

    @Override
    public void readFully(byte[] bytes, int start, int len) throws IOException {
        this.stream.readFully(bytes, start, len);
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        return this.stream.read(buf);
    }

    @Override
    public void readFully(ByteBuffer buf) throws IOException {
        H2SeekableInputStream.readFully(this.reader, buf);
    }

    @Override
    public boolean readVectoredAvailable(ByteBufferAllocator allocator) {
        return VectorIoBridge.instance().readVectoredAvailable(this.stream, allocator);
    }

    @Override
    public void readVectored(List<ParquetFileRange> ranges, ByteBufferAllocator allocator) throws IOException {
        VectorIoBridge.instance().readVectoredRanges(this.stream, ranges, allocator);
    }

    public static void readFully(Reader reader, ByteBuffer buf) throws IOException {
        while (buf.hasRemaining()) {
            int readCount = reader.read(buf);
            if (readCount != -1) continue;
            throw new EOFException("Reached the end of stream. Still have: " + buf.remaining() + " bytes left");
        }
    }

    private class H2Reader
    implements Reader {
        private H2Reader() {
        }

        @Override
        public int read(ByteBuffer buf) throws IOException {
            return H2SeekableInputStream.this.stream.read(buf);
        }
    }

    static interface Reader {
        public int read(ByteBuffer var1) throws IOException;
    }
}

