/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.mapred;

import hive.org.apache.avro.mapred.AvroCollector;
import hive.org.apache.avro.mapred.AvroKey;
import hive.org.apache.avro.mapred.AvroValue;
import hive.org.apache.avro.mapred.AvroWrapper;
import hive.org.apache.avro.mapred.Pair;
import java.io.IOException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.OutputCollector;

class MapCollector<OUT, K, V, KO, VO>
extends AvroCollector<OUT> {
    private final AvroWrapper<OUT> wrapper = new AvroWrapper<Object>(null);
    private final AvroKey<K> keyWrapper = new AvroKey<Object>(null);
    private final AvroValue<V> valueWrapper = new AvroValue<Object>(null);
    private OutputCollector<KO, VO> collector;
    private boolean isMapOnly;

    public MapCollector(OutputCollector<KO, VO> collector, boolean isMapOnly) {
        this.collector = collector;
        this.isMapOnly = isMapOnly;
    }

    @Override
    public void collect(OUT datum) throws IOException {
        if (this.isMapOnly) {
            this.wrapper.datum(datum);
            this.collector.collect(this.wrapper, (Object)NullWritable.get());
        } else {
            Pair pair = (Pair)datum;
            this.keyWrapper.datum(pair.key());
            this.valueWrapper.datum(pair.value());
            this.collector.collect(this.keyWrapper, this.valueWrapper);
        }
    }
}

