/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import hive.org.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.PreDropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;

public class DropPartitionEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Log LOG = LogFactory.getLog(DropPartitionEvent.class);
    private String COMMAND_STR = "alter table %s drop partition %s";

    public DropPartitionEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.ALTERTABLE_DROPPARTS, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> DropPartitionEvent.getInputHObjs()");
        }
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreDropPartitionEvent event = (PreDropPartitionEvent)this.preEventContext;
        Table table = event.getTable();
        ret.add(this.getHivePrivilegeObject(table));
        this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, table);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== DropPartitionEvent.getInputHObjs(): ret=" + ret));
        }
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        return this.getInputHObjs();
    }

    private String buildCommandString(String cmdStr, Table tbl) {
        String ret = cmdStr;
        if (tbl != null) {
            String tblName = StringUtils.isNotEmpty(tbl.getTableName()) ? " " + tbl.getTableName() : "";
            StringBuilder partitions = new StringBuilder();
            List<FieldSchema> fieldSchemas = tbl.getPartitionKeys();
            for (FieldSchema fieldSchema : fieldSchemas) {
                partitions.append(" ");
                partitions.append(fieldSchema.getName());
            }
            ret = String.format(cmdStr, tblName, partitions.toString());
        }
        return ret;
    }
}

