/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import hive.com.google.common.annotations.VisibleForTesting;
import hive.com.google.common.collect.Lists;
import hive.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.CommandUtil;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.session.SessionState;

public class ResetProcessor
implements CommandProcessor {
    private static final String DEFAULT_ARG = "-d";

    @Override
    public CommandProcessorResponse run(String command) {
        return this.run(SessionState.get(), command);
    }

    @VisibleForTesting
    CommandProcessorResponse run(SessionState ss, String command) {
        CommandProcessorResponse authErrResp = CommandUtil.authorizeCommand(ss, HiveOperationType.RESET, Arrays.asList(command));
        if (authErrResp != null) {
            return authErrResp;
        }
        if (StringUtils.isBlank(command = command.trim())) {
            ResetProcessor.resetOverridesOnly(ss);
            return new CommandProcessorResponse(0);
        }
        String[] parts = command.split("\\s+");
        boolean isDefault = false;
        ArrayList<String> varnames = new ArrayList<String>(parts.length);
        for (String part : parts) {
            if (part.isEmpty()) continue;
            if (DEFAULT_ARG.equals(part)) {
                isDefault = true;
                continue;
            }
            varnames.add(part);
        }
        if (varnames.isEmpty()) {
            return new CommandProcessorResponse(1, "No variable names specified", "42000");
        }
        Object message = "";
        for (String varname : varnames) {
            if (isDefault) {
                if (!((String)message).isEmpty()) {
                    message = (String)message + ", ";
                }
                message = (String)message + varname;
                ResetProcessor.resetToDefault(ss, varname);
                continue;
            }
            ResetProcessor.resetOverrideOnly(ss, varname);
        }
        return new CommandProcessorResponse(0, isDefault ? Lists.newArrayList("Resetting " + (String)message + " to default values") : null);
    }

    private static void resetOverridesOnly(SessionState ss) {
        if (ss.getOverriddenConfigurations().isEmpty()) {
            return;
        }
        HiveConf conf = new HiveConf();
        for (String key : ss.getOverriddenConfigurations().keySet()) {
            ResetProcessor.setSessionVariableFromConf(ss, key, conf);
        }
        ss.getOverriddenConfigurations().clear();
    }

    private static void resetOverrideOnly(SessionState ss, String varname) {
        if (!ss.getOverriddenConfigurations().containsKey(varname)) {
            return;
        }
        ResetProcessor.setSessionVariableFromConf(ss, varname, new HiveConf());
        ss.getOverriddenConfigurations().remove(varname);
    }

    private static void setSessionVariableFromConf(SessionState ss, String varname, HiveConf conf) {
        String value = conf.get(varname);
        if (value != null) {
            SetProcessor.setConf(ss, varname, varname, value, false);
        }
    }

    private static CommandProcessorResponse resetToDefault(SessionState ss, String varname) {
        varname = varname.trim();
        try {
            String nonErrorMessage = null;
            if (varname.startsWith("hiveconf:")) {
                String propName = varname.substring("hiveconf:".length());
                nonErrorMessage = SetProcessor.setConf(varname, propName, ResetProcessor.getConfVar(propName).getDefaultValue(), false);
            } else if (varname.startsWith("metaconf:")) {
                String propName = varname.substring("metaconf:".length());
                HiveConf.ConfVars confVars = ResetProcessor.getConfVar(propName);
                Hive.get(ss.getConf()).setMetaConf(propName, new VariableSubstitution(new HiveVariableSource(){

                    @Override
                    public Map<String, String> getHiveVariable() {
                        return SessionState.get().getHiveVariables();
                    }
                }).substitute(ss.getConf(), confVars.getDefaultValue()));
            } else {
                String defaultVal = ResetProcessor.getConfVar(varname).getDefaultValue();
                nonErrorMessage = SetProcessor.setConf(varname, varname, defaultVal, true);
                if (varname.equals(HiveConf.ConfVars.HIVE_SESSION_HISTORY_ENABLED.toString())) {
                    SessionState.get().updateHistory(Boolean.parseBoolean(defaultVal), ss);
                }
            }
            return nonErrorMessage == null ? new CommandProcessorResponse(0) : new CommandProcessorResponse(0, Lists.newArrayList(nonErrorMessage));
        }
        catch (Exception e) {
            return new CommandProcessorResponse(1, e.getMessage(), "42000", e instanceof IllegalArgumentException ? null : e);
        }
    }

    private static HiveConf.ConfVars getConfVar(String propName) {
        HiveConf.ConfVars confVars = HiveConf.getConfVars(propName);
        if (confVars == null) {
            throw new IllegalArgumentException(propName + " not found");
        }
        return confVars;
    }

    @Override
    public void close() throws Exception {
    }
}

