/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import hive.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.hooks.Redactor;

public class HookUtils {
    public static String redactLogString(HiveConf conf, String logString) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String redactedString = logString;
        if (conf != null && logString != null) {
            List<Redactor> queryRedactors = HookUtils.readHooksFromConf(conf, HiveConf.ConfVars.QUERYREDACTORHOOKS);
            for (Redactor redactor : queryRedactors) {
                redactor.setConf(conf);
                redactedString = redactor.redactQuery(redactedString);
            }
        }
        return redactedString;
    }

    public static <T extends Hook> List<T> readHooksFromConf(HiveConf conf, HiveConf.ConfVars hookConfVar) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String[] hookClasses;
        String csHooks = conf.getVar(hookConfVar);
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        if (StringUtils.isBlank(csHooks)) {
            return hooks;
        }
        for (String hookClass : hookClasses = csHooks.split(",")) {
            Hook hook = (Hook)Class.forName(hookClass.trim(), true, Utilities.getSessionSpecifiedClassLoader()).newInstance();
            hooks.add(hook);
        }
        return hooks;
    }
}

