/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import hive.com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorDecimalFirstValue
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorDecimalFirstValue.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected boolean haveFirstValue;
    protected boolean isGroupResultNull;
    protected HiveDecimalWritable firstValue = new HiveDecimalWritable();

    public VectorPTFEvaluatorDecimalFirstValue(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        if (!this.haveFirstValue) {
            int size = batch.size;
            if (size == 0) {
                return;
            }
            DecimalColumnVector decimalColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum];
            if (decimalColVector.isRepeating) {
                if (decimalColVector.noNulls || !decimalColVector.isNull[0]) {
                    this.firstValue.set(decimalColVector.vector[0]);
                    this.isGroupResultNull = false;
                }
            } else if (decimalColVector.noNulls) {
                this.firstValue.set(decimalColVector.vector[0]);
                this.isGroupResultNull = false;
            } else if (!decimalColVector.isNull[0]) {
                this.firstValue.set(decimalColVector.vector[0]);
                this.isGroupResultNull = false;
            }
            this.haveFirstValue = true;
        }
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumnNum];
        outputColVector.isRepeating = true;
        if (this.isGroupResultNull) {
            outputColVector.noNulls = false;
            outputColVector.isNull[0] = true;
        } else {
            outputColVector.isNull[0] = false;
            outputColVector.set(0, this.firstValue);
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DECIMAL;
    }

    @Override
    public void resetEvaluator() {
        this.haveFirstValue = false;
        this.isGroupResultNull = true;
        this.firstValue.set(HiveDecimal.ZERO);
    }
}

