/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexBaseScalar;

public class VectorUDFMapIndexDoubleScalar
extends VectorUDFMapIndexBaseScalar {
    private static final long serialVersionUID = 1L;
    private double key;

    public VectorUDFMapIndexDoubleScalar() {
    }

    public VectorUDFMapIndexDoubleScalar(int mapColumnNum, double key, int outputColumnNum) {
        super(mapColumnNum, outputColumnNum);
        this.key = key;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.getMapColumnNum()) + ", key: " + this.key;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.MAP, VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }

    @Override
    public int findScalarInMap(MapColumnVector mapColumnVector, int mapBatchIndex) {
        int offset = (int)mapColumnVector.offsets[mapBatchIndex];
        int count = (int)mapColumnVector.lengths[mapBatchIndex];
        double[] keys = ((DoubleColumnVector)mapColumnVector.keys).vector;
        for (int i = 0; i < count; ++i) {
            if (this.key != keys[offset + i]) continue;
            return offset + i;
        }
        return -1;
    }
}

