/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PutFileMetadataRequest
implements TBase<PutFileMetadataRequest, _Fields>,
Serializable,
Cloneable,
Comparable<PutFileMetadataRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("PutFileMetadataRequest");
    private static final TField FILE_IDS_FIELD_DESC = new TField("fileIds", 15, 1);
    private static final TField METADATA_FIELD_DESC = new TField("metadata", 15, 2);
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 3);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new PutFileMetadataRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new PutFileMetadataRequestTupleSchemeFactory();
    @Nullable
    private List<Long> fileIds;
    @Nullable
    private List<ByteBuffer> metadata;
    @Nullable
    private FileMetadataExprType type;
    private static final _Fields[] optionals = new _Fields[]{_Fields.TYPE};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public PutFileMetadataRequest() {
    }

    public PutFileMetadataRequest(List<Long> fileIds, List<ByteBuffer> metadata) {
        this();
        this.fileIds = fileIds;
        this.metadata = metadata;
    }

    public PutFileMetadataRequest(PutFileMetadataRequest other) {
        if (other.isSetFileIds()) {
            ArrayList<Long> __this__fileIds = new ArrayList<Long>(other.fileIds);
            this.fileIds = __this__fileIds;
        }
        if (other.isSetMetadata()) {
            ArrayList<ByteBuffer> __this__metadata = new ArrayList<ByteBuffer>(other.metadata);
            this.metadata = __this__metadata;
        }
        if (other.isSetType()) {
            this.type = other.type;
        }
    }

    @Override
    public PutFileMetadataRequest deepCopy() {
        return new PutFileMetadataRequest(this);
    }

    @Override
    public void clear() {
        this.fileIds = null;
        this.metadata = null;
        this.type = null;
    }

    public int getFileIdsSize() {
        return this.fileIds == null ? 0 : this.fileIds.size();
    }

    @Nullable
    public Iterator<Long> getFileIdsIterator() {
        return this.fileIds == null ? null : this.fileIds.iterator();
    }

    public void addToFileIds(long elem) {
        if (this.fileIds == null) {
            this.fileIds = new ArrayList<Long>();
        }
        this.fileIds.add(elem);
    }

    @Nullable
    public List<Long> getFileIds() {
        return this.fileIds;
    }

    public void setFileIds(@Nullable List<Long> fileIds) {
        this.fileIds = fileIds;
    }

    public void unsetFileIds() {
        this.fileIds = null;
    }

    public boolean isSetFileIds() {
        return this.fileIds != null;
    }

    public void setFileIdsIsSet(boolean value) {
        if (!value) {
            this.fileIds = null;
        }
    }

    public int getMetadataSize() {
        return this.metadata == null ? 0 : this.metadata.size();
    }

    @Nullable
    public Iterator<ByteBuffer> getMetadataIterator() {
        return this.metadata == null ? null : this.metadata.iterator();
    }

    public void addToMetadata(ByteBuffer elem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<ByteBuffer>();
        }
        this.metadata.add(elem);
    }

    @Nullable
    public List<ByteBuffer> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable List<ByteBuffer> metadata) {
        this.metadata = metadata;
    }

    public void unsetMetadata() {
        this.metadata = null;
    }

    public boolean isSetMetadata() {
        return this.metadata != null;
    }

    public void setMetadataIsSet(boolean value) {
        if (!value) {
            this.metadata = null;
        }
    }

    @Nullable
    public FileMetadataExprType getType() {
        return this.type;
    }

    public void setType(@Nullable FileMetadataExprType type) {
        this.type = type;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case FILE_IDS: {
                if (value == null) {
                    this.unsetFileIds();
                    break;
                }
                this.setFileIds((List)value);
                break;
            }
            case METADATA: {
                if (value == null) {
                    this.unsetMetadata();
                    break;
                }
                this.setMetadata((List)value);
                break;
            }
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((FileMetadataExprType)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case FILE_IDS: {
                return this.getFileIds();
            }
            case METADATA: {
                return this.getMetadata();
            }
            case TYPE: {
                return this.getType();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case FILE_IDS: {
                return this.isSetFileIds();
            }
            case METADATA: {
                return this.isSetMetadata();
            }
            case TYPE: {
                return this.isSetType();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof PutFileMetadataRequest) {
            return this.equals((PutFileMetadataRequest)that);
        }
        return false;
    }

    public boolean equals(PutFileMetadataRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_fileIds = this.isSetFileIds();
        boolean that_present_fileIds = that.isSetFileIds();
        if (this_present_fileIds || that_present_fileIds) {
            if (!this_present_fileIds || !that_present_fileIds) {
                return false;
            }
            if (!this.fileIds.equals(that.fileIds)) {
                return false;
            }
        }
        boolean this_present_metadata = this.isSetMetadata();
        boolean that_present_metadata = that.isSetMetadata();
        if (this_present_metadata || that_present_metadata) {
            if (!this_present_metadata || !that_present_metadata) {
                return false;
            }
            if (!this.metadata.equals(that.metadata)) {
                return false;
            }
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals(that.type)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetFileIds() ? 131071 : 524287);
        if (this.isSetFileIds()) {
            hashCode = hashCode * 8191 + this.fileIds.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetMetadata() ? 131071 : 524287);
        if (this.isSetMetadata()) {
            hashCode = hashCode * 8191 + this.metadata.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetType() ? 131071 : 524287);
        if (this.isSetType()) {
            hashCode = hashCode * 8191 + this.type.getValue();
        }
        return hashCode;
    }

    @Override
    public int compareTo(PutFileMetadataRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetFileIds(), other.isSetFileIds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFileIds() && (lastComparison = TBaseHelper.compareTo(this.fileIds, other.fileIds)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMetadata(), other.isSetMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMetadata() && (lastComparison = TBaseHelper.compareTo(this.metadata, other.metadata)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetType(), other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)other.type))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        PutFileMetadataRequest.scheme(iprot).read(iprot, (PutFileMetadataRequest)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        PutFileMetadataRequest.scheme(oprot).write(oprot, (PutFileMetadataRequest)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PutFileMetadataRequest(");
        boolean first = true;
        sb.append("fileIds:");
        if (this.fileIds == null) {
            sb.append("null");
        } else {
            sb.append(this.fileIds);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("metadata:");
        if (this.metadata == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.metadata, sb);
        }
        first = false;
        if (this.isSetType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("type:");
            if (this.type == null) {
                sb.append("null");
            } else {
                sb.append(this.type);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetFileIds()) {
            throw new TProtocolException("Required field 'fileIds' is unset! Struct:" + this.toString());
        }
        if (!this.isSetMetadata()) {
            throw new TProtocolException("Required field 'metadata' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.FILE_IDS, new FieldMetaData("fileIds", 1, new ListMetaData(15, new FieldValueMetaData(10))));
        tmpMap.put(_Fields.METADATA, new FieldMetaData("metadata", 1, new ListMetaData(15, new FieldValueMetaData(11, true))));
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 2, new EnumMetaData(16, FileMetadataExprType.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(PutFileMetadataRequest.class, metaDataMap);
    }

    private static class PutFileMetadataRequestTupleScheme
    extends TupleScheme<PutFileMetadataRequest> {
        private PutFileMetadataRequestTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, PutFileMetadataRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.fileIds.size());
            Iterator<Comparable<Long>> iterator = struct.fileIds.iterator();
            while (iterator.hasNext()) {
                long _iter792 = iterator.next();
                oprot.writeI64(_iter792);
            }
            oprot.writeI32(struct.metadata.size());
            for (ByteBuffer _iter793 : struct.metadata) {
                oprot.writeBinary(_iter793);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetType()) {
                optionals.set(0);
            }
            oprot.writeBitSet(optionals, 1);
            if (struct.isSetType()) {
                oprot.writeI32(struct.type.getValue());
            }
        }

        @Override
        public void read(TProtocol prot, PutFileMetadataRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TList _list794 = iprot.readListBegin((byte)10);
            struct.fileIds = new ArrayList<Long>(_list794.size);
            for (int _i796 = 0; _i796 < _list794.size; ++_i796) {
                long _elem795 = iprot.readI64();
                struct.fileIds.add(_elem795);
            }
            struct.setFileIdsIsSet(true);
            TList _list797 = iprot.readListBegin((byte)11);
            struct.metadata = new ArrayList<ByteBuffer>(_list797.size);
            for (int _i799 = 0; _i799 < _list797.size; ++_i799) {
                ByteBuffer _elem798 = iprot.readBinary();
                struct.metadata.add(_elem798);
            }
            struct.setMetadataIsSet(true);
            BitSet incoming = iprot.readBitSet(1);
            if (incoming.get(0)) {
                struct.type = FileMetadataExprType.findByValue(iprot.readI32());
                struct.setTypeIsSet(true);
            }
        }
    }

    private static class PutFileMetadataRequestTupleSchemeFactory
    implements SchemeFactory {
        private PutFileMetadataRequestTupleSchemeFactory() {
        }

        public PutFileMetadataRequestTupleScheme getScheme() {
            return new PutFileMetadataRequestTupleScheme();
        }
    }

    private static class PutFileMetadataRequestStandardScheme
    extends StandardScheme<PutFileMetadataRequest> {
        private PutFileMetadataRequestStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, PutFileMetadataRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list784 = iprot.readListBegin();
                            struct.fileIds = new ArrayList<Long>(_list784.size);
                            for (int _i786 = 0; _i786 < _list784.size; ++_i786) {
                                long _elem785 = iprot.readI64();
                                struct.fileIds.add(_elem785);
                            }
                            iprot.readListEnd();
                            struct.setFileIdsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list787 = iprot.readListBegin();
                            struct.metadata = new ArrayList<ByteBuffer>(_list787.size);
                            for (int _i789 = 0; _i789 < _list787.size; ++_i789) {
                                ByteBuffer _elem788 = iprot.readBinary();
                                struct.metadata.add(_elem788);
                            }
                            iprot.readListEnd();
                            struct.setMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.type = FileMetadataExprType.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, PutFileMetadataRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.fileIds != null) {
                oprot.writeFieldBegin(FILE_IDS_FIELD_DESC);
                oprot.writeListBegin(new TList(10, struct.fileIds.size()));
                Iterator<Comparable<Long>> iterator = struct.fileIds.iterator();
                while (iterator.hasNext()) {
                    long _iter790 = (Long)iterator.next();
                    oprot.writeI64(_iter790);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.metadata != null) {
                oprot.writeFieldBegin(METADATA_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.metadata.size()));
                for (ByteBuffer _iter791 : struct.metadata) {
                    oprot.writeBinary(_iter791);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.type != null && struct.isSetType()) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class PutFileMetadataRequestStandardSchemeFactory
    implements SchemeFactory {
        private PutFileMetadataRequestStandardSchemeFactory() {
        }

        public PutFileMetadataRequestStandardScheme getScheme() {
            return new PutFileMetadataRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        FILE_IDS(1, "fileIds"),
        METADATA(2, "metadata"),
        TYPE(3, "type");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return FILE_IDS;
                }
                case 2: {
                    return METADATA;
                }
                case 3: {
                    return TYPE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

