/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PartitionsByExprRequest
implements TBase<PartitionsByExprRequest, _Fields>,
Serializable,
Cloneable,
Comparable<PartitionsByExprRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("PartitionsByExprRequest");
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 1);
    private static final TField TBL_NAME_FIELD_DESC = new TField("tblName", 11, 2);
    private static final TField EXPR_FIELD_DESC = new TField("expr", 11, 3);
    private static final TField DEFAULT_PARTITION_NAME_FIELD_DESC = new TField("defaultPartitionName", 11, 4);
    private static final TField MAX_PARTS_FIELD_DESC = new TField("maxParts", 6, 5);
    private static final TField CAT_NAME_FIELD_DESC = new TField("catName", 11, 6);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new PartitionsByExprRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new PartitionsByExprRequestTupleSchemeFactory();
    @Nullable
    private String dbName;
    @Nullable
    private String tblName;
    @Nullable
    private ByteBuffer expr;
    @Nullable
    private String defaultPartitionName;
    private short maxParts;
    @Nullable
    private String catName;
    private static final int __MAXPARTS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.DEFAULT_PARTITION_NAME, _Fields.MAX_PARTS, _Fields.CAT_NAME};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public PartitionsByExprRequest() {
        this.maxParts = (short)-1;
    }

    public PartitionsByExprRequest(String dbName, String tblName, ByteBuffer expr) {
        this();
        this.dbName = dbName;
        this.tblName = tblName;
        this.expr = TBaseHelper.copyBinary(expr);
    }

    public PartitionsByExprRequest(PartitionsByExprRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetTblName()) {
            this.tblName = other.tblName;
        }
        if (other.isSetExpr()) {
            this.expr = TBaseHelper.copyBinary(other.expr);
        }
        if (other.isSetDefaultPartitionName()) {
            this.defaultPartitionName = other.defaultPartitionName;
        }
        this.maxParts = other.maxParts;
        if (other.isSetCatName()) {
            this.catName = other.catName;
        }
    }

    @Override
    public PartitionsByExprRequest deepCopy() {
        return new PartitionsByExprRequest(this);
    }

    @Override
    public void clear() {
        this.dbName = null;
        this.tblName = null;
        this.expr = null;
        this.defaultPartitionName = null;
        this.maxParts = (short)-1;
        this.catName = null;
    }

    @Nullable
    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(@Nullable String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    @Nullable
    public String getTblName() {
        return this.tblName;
    }

    public void setTblName(@Nullable String tblName) {
        this.tblName = tblName;
    }

    public void unsetTblName() {
        this.tblName = null;
    }

    public boolean isSetTblName() {
        return this.tblName != null;
    }

    public void setTblNameIsSet(boolean value) {
        if (!value) {
            this.tblName = null;
        }
    }

    public byte[] getExpr() {
        this.setExpr(TBaseHelper.rightSize(this.expr));
        return this.expr == null ? null : this.expr.array();
    }

    public ByteBuffer bufferForExpr() {
        return TBaseHelper.copyBinary(this.expr);
    }

    public void setExpr(byte[] expr) {
        this.expr = expr == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])expr.clone());
    }

    public void setExpr(@Nullable ByteBuffer expr) {
        this.expr = TBaseHelper.copyBinary(expr);
    }

    public void unsetExpr() {
        this.expr = null;
    }

    public boolean isSetExpr() {
        return this.expr != null;
    }

    public void setExprIsSet(boolean value) {
        if (!value) {
            this.expr = null;
        }
    }

    @Nullable
    public String getDefaultPartitionName() {
        return this.defaultPartitionName;
    }

    public void setDefaultPartitionName(@Nullable String defaultPartitionName) {
        this.defaultPartitionName = defaultPartitionName;
    }

    public void unsetDefaultPartitionName() {
        this.defaultPartitionName = null;
    }

    public boolean isSetDefaultPartitionName() {
        return this.defaultPartitionName != null;
    }

    public void setDefaultPartitionNameIsSet(boolean value) {
        if (!value) {
            this.defaultPartitionName = null;
        }
    }

    public short getMaxParts() {
        return this.maxParts;
    }

    public void setMaxParts(short maxParts) {
        this.maxParts = maxParts;
        this.setMaxPartsIsSet(true);
    }

    public void unsetMaxParts() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetMaxParts() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setMaxPartsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    @Nullable
    public String getCatName() {
        return this.catName;
    }

    public void setCatName(@Nullable String catName) {
        this.catName = catName;
    }

    public void unsetCatName() {
        this.catName = null;
    }

    public boolean isSetCatName() {
        return this.catName != null;
    }

    public void setCatNameIsSet(boolean value) {
        if (!value) {
            this.catName = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case DB_NAME: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case TBL_NAME: {
                if (value == null) {
                    this.unsetTblName();
                    break;
                }
                this.setTblName((String)value);
                break;
            }
            case EXPR: {
                if (value == null) {
                    this.unsetExpr();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setExpr((byte[])value);
                    break;
                }
                this.setExpr((ByteBuffer)value);
                break;
            }
            case DEFAULT_PARTITION_NAME: {
                if (value == null) {
                    this.unsetDefaultPartitionName();
                    break;
                }
                this.setDefaultPartitionName((String)value);
                break;
            }
            case MAX_PARTS: {
                if (value == null) {
                    this.unsetMaxParts();
                    break;
                }
                this.setMaxParts((Short)value);
                break;
            }
            case CAT_NAME: {
                if (value == null) {
                    this.unsetCatName();
                    break;
                }
                this.setCatName((String)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case DB_NAME: {
                return this.getDbName();
            }
            case TBL_NAME: {
                return this.getTblName();
            }
            case EXPR: {
                return this.getExpr();
            }
            case DEFAULT_PARTITION_NAME: {
                return this.getDefaultPartitionName();
            }
            case MAX_PARTS: {
                return this.getMaxParts();
            }
            case CAT_NAME: {
                return this.getCatName();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case DB_NAME: {
                return this.isSetDbName();
            }
            case TBL_NAME: {
                return this.isSetTblName();
            }
            case EXPR: {
                return this.isSetExpr();
            }
            case DEFAULT_PARTITION_NAME: {
                return this.isSetDefaultPartitionName();
            }
            case MAX_PARTS: {
                return this.isSetMaxParts();
            }
            case CAT_NAME: {
                return this.isSetCatName();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof PartitionsByExprRequest) {
            return this.equals((PartitionsByExprRequest)that);
        }
        return false;
    }

    public boolean equals(PartitionsByExprRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_tblName = this.isSetTblName();
        boolean that_present_tblName = that.isSetTblName();
        if (this_present_tblName || that_present_tblName) {
            if (!this_present_tblName || !that_present_tblName) {
                return false;
            }
            if (!this.tblName.equals(that.tblName)) {
                return false;
            }
        }
        boolean this_present_expr = this.isSetExpr();
        boolean that_present_expr = that.isSetExpr();
        if (this_present_expr || that_present_expr) {
            if (!this_present_expr || !that_present_expr) {
                return false;
            }
            if (!this.expr.equals(that.expr)) {
                return false;
            }
        }
        boolean this_present_defaultPartitionName = this.isSetDefaultPartitionName();
        boolean that_present_defaultPartitionName = that.isSetDefaultPartitionName();
        if (this_present_defaultPartitionName || that_present_defaultPartitionName) {
            if (!this_present_defaultPartitionName || !that_present_defaultPartitionName) {
                return false;
            }
            if (!this.defaultPartitionName.equals(that.defaultPartitionName)) {
                return false;
            }
        }
        boolean this_present_maxParts = this.isSetMaxParts();
        boolean that_present_maxParts = that.isSetMaxParts();
        if (this_present_maxParts || that_present_maxParts) {
            if (!this_present_maxParts || !that_present_maxParts) {
                return false;
            }
            if (this.maxParts != that.maxParts) {
                return false;
            }
        }
        boolean this_present_catName = this.isSetCatName();
        boolean that_present_catName = that.isSetCatName();
        if (this_present_catName || that_present_catName) {
            if (!this_present_catName || !that_present_catName) {
                return false;
            }
            if (!this.catName.equals(that.catName)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetDbName() ? 131071 : 524287);
        if (this.isSetDbName()) {
            hashCode = hashCode * 8191 + this.dbName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTblName() ? 131071 : 524287);
        if (this.isSetTblName()) {
            hashCode = hashCode * 8191 + this.tblName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetExpr() ? 131071 : 524287);
        if (this.isSetExpr()) {
            hashCode = hashCode * 8191 + this.expr.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDefaultPartitionName() ? 131071 : 524287);
        if (this.isSetDefaultPartitionName()) {
            hashCode = hashCode * 8191 + this.defaultPartitionName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetMaxParts() ? 131071 : 524287);
        if (this.isSetMaxParts()) {
            hashCode = hashCode * 8191 + this.maxParts;
        }
        hashCode = hashCode * 8191 + (this.isSetCatName() ? 131071 : 524287);
        if (this.isSetCatName()) {
            hashCode = hashCode * 8191 + this.catName.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(PartitionsByExprRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetDbName(), other.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo(this.dbName, other.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTblName(), other.isSetTblName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTblName() && (lastComparison = TBaseHelper.compareTo(this.tblName, other.tblName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetExpr(), other.isSetExpr());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExpr() && (lastComparison = TBaseHelper.compareTo(this.expr, other.expr)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDefaultPartitionName(), other.isSetDefaultPartitionName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDefaultPartitionName() && (lastComparison = TBaseHelper.compareTo(this.defaultPartitionName, other.defaultPartitionName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMaxParts(), other.isSetMaxParts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxParts() && (lastComparison = TBaseHelper.compareTo(this.maxParts, other.maxParts)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCatName(), other.isSetCatName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCatName() && (lastComparison = TBaseHelper.compareTo(this.catName, other.catName)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        PartitionsByExprRequest.scheme(iprot).read(iprot, (PartitionsByExprRequest)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        PartitionsByExprRequest.scheme(oprot).write(oprot, (PartitionsByExprRequest)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionsByExprRequest(");
        boolean first = true;
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tblName:");
        if (this.tblName == null) {
            sb.append("null");
        } else {
            sb.append(this.tblName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("expr:");
        if (this.expr == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.expr, sb);
        }
        first = false;
        if (this.isSetDefaultPartitionName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("defaultPartitionName:");
            if (this.defaultPartitionName == null) {
                sb.append("null");
            } else {
                sb.append(this.defaultPartitionName);
            }
            first = false;
        }
        if (this.isSetMaxParts()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("maxParts:");
            sb.append(this.maxParts);
            first = false;
        }
        if (this.isSetCatName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("catName:");
            if (this.catName == null) {
                sb.append("null");
            } else {
                sb.append(this.catName);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetDbName()) {
            throw new TProtocolException("Required field 'dbName' is unset! Struct:" + this.toString());
        }
        if (!this.isSetTblName()) {
            throw new TProtocolException("Required field 'tblName' is unset! Struct:" + this.toString());
        }
        if (!this.isSetExpr()) {
            throw new TProtocolException("Required field 'expr' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TBL_NAME, new FieldMetaData("tblName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.EXPR, new FieldMetaData("expr", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.DEFAULT_PARTITION_NAME, new FieldMetaData("defaultPartitionName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.MAX_PARTS, new FieldMetaData("maxParts", 2, new FieldValueMetaData(6)));
        tmpMap.put(_Fields.CAT_NAME, new FieldMetaData("catName", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(PartitionsByExprRequest.class, metaDataMap);
    }

    private static class PartitionsByExprRequestTupleScheme
    extends TupleScheme<PartitionsByExprRequest> {
        private PartitionsByExprRequestTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, PartitionsByExprRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.dbName);
            oprot.writeString(struct.tblName);
            oprot.writeBinary(struct.expr);
            BitSet optionals = new BitSet();
            if (struct.isSetDefaultPartitionName()) {
                optionals.set(0);
            }
            if (struct.isSetMaxParts()) {
                optionals.set(1);
            }
            if (struct.isSetCatName()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetDefaultPartitionName()) {
                oprot.writeString(struct.defaultPartitionName);
            }
            if (struct.isSetMaxParts()) {
                oprot.writeI16(struct.maxParts);
            }
            if (struct.isSetCatName()) {
                oprot.writeString(struct.catName);
            }
        }

        @Override
        public void read(TProtocol prot, PartitionsByExprRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.dbName = iprot.readString();
            struct.setDbNameIsSet(true);
            struct.tblName = iprot.readString();
            struct.setTblNameIsSet(true);
            struct.expr = iprot.readBinary();
            struct.setExprIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.defaultPartitionName = iprot.readString();
                struct.setDefaultPartitionNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.maxParts = iprot.readI16();
                struct.setMaxPartsIsSet(true);
            }
            if (incoming.get(2)) {
                struct.catName = iprot.readString();
                struct.setCatNameIsSet(true);
            }
        }
    }

    private static class PartitionsByExprRequestTupleSchemeFactory
    implements SchemeFactory {
        private PartitionsByExprRequestTupleSchemeFactory() {
        }

        public PartitionsByExprRequestTupleScheme getScheme() {
            return new PartitionsByExprRequestTupleScheme();
        }
    }

    private static class PartitionsByExprRequestStandardScheme
    extends StandardScheme<PartitionsByExprRequest> {
        private PartitionsByExprRequestStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, PartitionsByExprRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.dbName = iprot.readString();
                            struct.setDbNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.tblName = iprot.readString();
                            struct.setTblNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.expr = iprot.readBinary();
                            struct.setExprIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.defaultPartitionName = iprot.readString();
                            struct.setDefaultPartitionNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 6) {
                            struct.maxParts = iprot.readI16();
                            struct.setMaxPartsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.catName = iprot.readString();
                            struct.setCatNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, PartitionsByExprRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.dbName != null) {
                oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
                oprot.writeString(struct.dbName);
                oprot.writeFieldEnd();
            }
            if (struct.tblName != null) {
                oprot.writeFieldBegin(TBL_NAME_FIELD_DESC);
                oprot.writeString(struct.tblName);
                oprot.writeFieldEnd();
            }
            if (struct.expr != null) {
                oprot.writeFieldBegin(EXPR_FIELD_DESC);
                oprot.writeBinary(struct.expr);
                oprot.writeFieldEnd();
            }
            if (struct.defaultPartitionName != null && struct.isSetDefaultPartitionName()) {
                oprot.writeFieldBegin(DEFAULT_PARTITION_NAME_FIELD_DESC);
                oprot.writeString(struct.defaultPartitionName);
                oprot.writeFieldEnd();
            }
            if (struct.isSetMaxParts()) {
                oprot.writeFieldBegin(MAX_PARTS_FIELD_DESC);
                oprot.writeI16(struct.maxParts);
                oprot.writeFieldEnd();
            }
            if (struct.catName != null && struct.isSetCatName()) {
                oprot.writeFieldBegin(CAT_NAME_FIELD_DESC);
                oprot.writeString(struct.catName);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class PartitionsByExprRequestStandardSchemeFactory
    implements SchemeFactory {
        private PartitionsByExprRequestStandardSchemeFactory() {
        }

        public PartitionsByExprRequestStandardScheme getScheme() {
            return new PartitionsByExprRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        DB_NAME(1, "dbName"),
        TBL_NAME(2, "tblName"),
        EXPR(3, "expr"),
        DEFAULT_PARTITION_NAME(4, "defaultPartitionName"),
        MAX_PARTS(5, "maxParts"),
        CAT_NAME(6, "catName");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DB_NAME;
                }
                case 2: {
                    return TBL_NAME;
                }
                case 3: {
                    return EXPR;
                }
                case 4: {
                    return DEFAULT_PARTITION_NAME;
                }
                case 5: {
                    return MAX_PARTS;
                }
                case 6: {
                    return CAT_NAME;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

