/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.cli;

import hive.org.apache.commons.lang.StringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.hive.common.cli.IHiveFileProcessor;
import org.apache.hadoop.io.IOUtils;

public abstract class HiveFileProcessor
implements IHiveFileProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processFile(String fileName) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = this.loadFile(fileName);
            int n = this.processReader(bufferedReader);
            return n;
        }
        finally {
            IOUtils.closeStream((Closeable)bufferedReader);
        }
    }

    protected abstract BufferedReader loadFile(String var1) throws IOException;

    protected int processReader(BufferedReader reader) throws IOException {
        String line;
        StringBuilder qsb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("--")) continue;
            qsb.append(line);
        }
        return this.processLine(qsb.toString());
    }

    protected int processLine(String line) {
        int lastRet = 0;
        int ret = 0;
        Object command = "";
        for (String oneCmd : line.split(";")) {
            command = StringUtils.indexOf(oneCmd, "\\") != -1 ? (String)command + StringUtils.join(oneCmd.split("\\\\")) : (String)command + oneCmd;
            if (StringUtils.isBlank((String)command)) continue;
            ret = this.processCmd((String)command);
            command = "";
            lastRet = ret;
            if (ret == 0) continue;
            return ret;
        }
        return lastRet;
    }

    protected abstract int processCmd(String var1);
}

