/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop;

import hive.org.apache.parquet.conf.ParquetConfiguration;
import hive.org.apache.parquet.crypto.EncryptionPropertiesFactory;
import hive.org.apache.parquet.crypto.FileEncryptionProperties;
import hive.org.apache.parquet.hadoop.api.WriteSupport;
import hive.org.apache.parquet.hadoop.util.ConfigurationUtil;
import hive.org.apache.parquet.io.OutputFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

final class EncryptionPropertiesHelper {
    EncryptionPropertiesHelper() {
    }

    static FileEncryptionProperties createEncryptionProperties(ParquetConfiguration fileParquetConfig, OutputFile file, WriteSupport.WriteContext fileWriteContext) {
        EncryptionPropertiesFactory cryptoFactory = EncryptionPropertiesFactory.loadFactory(fileParquetConfig);
        if (null == cryptoFactory) {
            return null;
        }
        Configuration hadoopConf = ConfigurationUtil.createHadoopConfiguration(fileParquetConfig);
        return cryptoFactory.getFileEncryptionProperties(hadoopConf, file == null ? null : new Path(file.getPath()), fileWriteContext);
    }

    static FileEncryptionProperties createEncryptionProperties(Configuration fileHadoopConfig, Path tempFilePath, WriteSupport.WriteContext fileWriteContext) {
        EncryptionPropertiesFactory cryptoFactory = EncryptionPropertiesFactory.loadFactory(fileHadoopConfig);
        if (null == cryptoFactory) {
            return null;
        }
        return cryptoFactory.getFileEncryptionProperties(fileHadoopConfig, tempFilePath, fileWriteContext);
    }
}

