/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.values.deltalengthbytearray;

import hive.org.apache.parquet.bytes.ByteBufferInputStream;
import hive.org.apache.parquet.column.values.ValuesReader;
import hive.org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import hive.org.apache.parquet.io.ParquetDecodingException;
import hive.org.apache.parquet.io.api.Binary;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaLengthByteArrayValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(DeltaLengthByteArrayValuesReader.class);
    private ValuesReader lengthReader = new DeltaBinaryPackingValuesReader();
    private ByteBufferInputStream in;

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream stream) throws IOException {
        LOG.debug("init from page at offset {} for length {}", (Object)stream.position(), (Object)stream.available());
        this.lengthReader.initFromPage(valueCount, stream);
        this.in = stream.remainingStream();
    }

    @Override
    public Binary readBytes() {
        int length = this.lengthReader.readInteger();
        try {
            return Binary.fromConstantByteBuffer(this.in.slice(length));
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read " + length + " bytes");
        }
    }

    @Override
    public void skip() {
        this.skip(1);
    }

    @Override
    public void skip(int n) {
        int length = 0;
        for (int i = 0; i < n; ++i) {
            length += this.lengthReader.readInteger();
        }
        try {
            this.in.skipFully(length);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to skip " + length + " bytes");
        }
    }
}

