/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.hadoop.file;

import hive.org.apache.avro.AvroRuntimeException;
import hive.org.apache.avro.file.CodecFactory;
import java.util.HashMap;
import java.util.Map;

public class HadoopCodecFactory {
    private static final Map<String, String> HADOOP_AVRO_NAME_MAP = new HashMap<String, String>();

    public static CodecFactory fromHadoopString(String hadoopCodecClass) {
        CodecFactory o = null;
        try {
            String avroCodec = HADOOP_AVRO_NAME_MAP.get(hadoopCodecClass);
            if (avroCodec != null) {
                o = CodecFactory.fromString(avroCodec);
            }
        }
        catch (Exception e) {
            throw new AvroRuntimeException("Unrecognized hadoop codec: " + hadoopCodecClass, e);
        }
        return o;
    }

    public static String getAvroCodecName(String hadoopCodecClass) {
        return HADOOP_AVRO_NAME_MAP.get(hadoopCodecClass);
    }

    static {
        HADOOP_AVRO_NAME_MAP.put("org.apache.hadoop.io.compress.DeflateCodec", "deflate");
        HADOOP_AVRO_NAME_MAP.put("org.apache.hadoop.io.compress.SnappyCodec", "snappy");
        HADOOP_AVRO_NAME_MAP.put("org.apache.hadoop.io.compress.BZip2Codec", "bzip2");
        HADOOP_AVRO_NAME_MAP.put("org.apache.hadoop.io.compress.GZipCodec", "deflate");
    }
}

