/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import hive.org.apache.commons.lang3.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ValidationUtility;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.OutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Explain(displayName="Create Table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateTableDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = LoggerFactory.getLogger(CreateTableDesc.class);
    String databaseName;
    String tableName;
    boolean isExternal;
    List<FieldSchema> cols;
    List<FieldSchema> partCols;
    List<String> bucketCols;
    List<Order> sortCols;
    int numBuckets;
    String fieldDelim;
    String fieldEscape;
    String collItemDelim;
    String mapKeyDelim;
    String lineDelim;
    String nullFormat;
    String comment;
    String inputFormat;
    String outputFormat;
    String location;
    String serName;
    String storageHandler;
    Map<String, String> serdeProps;
    Map<String, String> tblProps;
    boolean ifNotExists;
    List<String> skewedColNames;
    List<List<String>> skewedColValues;
    boolean isStoredAsSubDirectories = false;
    boolean isTemporary = false;
    private boolean isMaterialization = false;
    private boolean replaceMode = false;
    private ReplicationSpec replicationSpec = null;
    private boolean isCTAS = false;
    List<SQLPrimaryKey> primaryKeys;
    List<SQLForeignKey> foreignKeys;

    public CreateTableDesc() {
    }

    public CreateTableDesc(String databaseName, String tableName, boolean isExternal, boolean isTemporary, List<FieldSchema> cols, List<FieldSchema> partCols, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists, List<String> skewedColNames, List<List<String>> skewedColValues, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) {
        this(tableName, isExternal, isTemporary, cols, partCols, bucketCols, sortCols, numBuckets, fieldDelim, fieldEscape, collItemDelim, mapKeyDelim, lineDelim, comment, inputFormat, outputFormat, location, serName, storageHandler, serdeProps, tblProps, ifNotExists, skewedColNames, skewedColValues, primaryKeys, foreignKeys);
        this.databaseName = databaseName;
    }

    public CreateTableDesc(String databaseName, String tableName, boolean isExternal, boolean isTemporary, List<FieldSchema> cols, List<FieldSchema> partCols, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists, List<String> skewedColNames, List<List<String>> skewedColValues, boolean isCTAS, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) {
        this(databaseName, tableName, isExternal, isTemporary, cols, partCols, bucketCols, sortCols, numBuckets, fieldDelim, fieldEscape, collItemDelim, mapKeyDelim, lineDelim, comment, inputFormat, outputFormat, location, serName, storageHandler, serdeProps, tblProps, ifNotExists, skewedColNames, skewedColValues, primaryKeys, foreignKeys);
        this.isCTAS = isCTAS;
    }

    public CreateTableDesc(String tableName, boolean isExternal, boolean isTemporary, List<FieldSchema> cols, List<FieldSchema> partCols, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists, List<String> skewedColNames, List<List<String>> skewedColValues, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) {
        this.tableName = tableName;
        this.isExternal = isExternal;
        this.isTemporary = isTemporary;
        this.bucketCols = new ArrayList<String>(bucketCols);
        this.sortCols = new ArrayList<Order>(sortCols);
        this.collItemDelim = collItemDelim;
        this.cols = new ArrayList<FieldSchema>(cols);
        this.comment = comment;
        this.fieldDelim = fieldDelim;
        this.fieldEscape = fieldEscape;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.lineDelim = lineDelim;
        this.location = location;
        this.mapKeyDelim = mapKeyDelim;
        this.numBuckets = numBuckets;
        this.partCols = new ArrayList<FieldSchema>(partCols);
        this.serName = serName;
        this.storageHandler = storageHandler;
        this.serdeProps = serdeProps;
        this.tblProps = tblProps;
        this.ifNotExists = ifNotExists;
        this.skewedColNames = CreateTableDesc.copyList(skewedColNames);
        this.skewedColValues = CreateTableDesc.copyList(skewedColValues);
        this.primaryKeys = primaryKeys == null ? new ArrayList<SQLPrimaryKey>() : new ArrayList<SQLPrimaryKey>(primaryKeys);
        this.foreignKeys = foreignKeys == null ? new ArrayList<SQLForeignKey>() : new ArrayList<SQLForeignKey>(foreignKeys);
    }

    private static <T> List<T> copyList(List<T> copy) {
        return copy == null ? null : new ArrayList<T>(copy);
    }

    @Explain(displayName="columns")
    public List<String> getColsString() {
        return Utilities.getFieldSchemaString(this.getCols());
    }

    @Explain(displayName="partition columns")
    public List<String> getPartColsString() {
        return Utilities.getFieldSchemaString(this.getPartCols());
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<FieldSchema> getCols() {
        return this.cols;
    }

    public void setCols(ArrayList<FieldSchema> cols) {
        this.cols = cols;
    }

    public List<FieldSchema> getPartCols() {
        return this.partCols;
    }

    public void setPartCols(ArrayList<FieldSchema> partCols) {
        this.partCols = partCols;
    }

    public List<SQLPrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(ArrayList<SQLPrimaryKey> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public List<SQLForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(ArrayList<SQLForeignKey> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    @Explain(displayName="bucket columns")
    public List<String> getBucketCols() {
        return this.bucketCols;
    }

    public void setBucketCols(ArrayList<String> bucketCols) {
        this.bucketCols = bucketCols;
    }

    @Explain(displayName="# buckets")
    public Integer getNumBucketsExplain() {
        if (this.numBuckets == -1) {
            return null;
        }
        return this.numBuckets;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    @Explain(displayName="field delimiter")
    public String getFieldDelim() {
        return this.fieldDelim;
    }

    public void setFieldDelim(String fieldDelim) {
        this.fieldDelim = fieldDelim;
    }

    @Explain(displayName="field escape")
    public String getFieldEscape() {
        return this.fieldEscape;
    }

    public void setFieldEscape(String fieldEscape) {
        this.fieldEscape = fieldEscape;
    }

    @Explain(displayName="collection delimiter")
    public String getCollItemDelim() {
        return this.collItemDelim;
    }

    public void setCollItemDelim(String collItemDelim) {
        this.collItemDelim = collItemDelim;
    }

    @Explain(displayName="map key delimiter")
    public String getMapKeyDelim() {
        return this.mapKeyDelim;
    }

    public void setMapKeyDelim(String mapKeyDelim) {
        this.mapKeyDelim = mapKeyDelim;
    }

    @Explain(displayName="line delimiter")
    public String getLineDelim() {
        return this.lineDelim;
    }

    public void setLineDelim(String lineDelim) {
        this.lineDelim = lineDelim;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Explain(displayName="input format")
    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Explain(displayName="output format")
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Explain(displayName="storage handler")
    public String getStorageHandler() {
        return this.storageHandler;
    }

    public void setStorageHandler(String storageHandler) {
        this.storageHandler = storageHandler;
    }

    @Explain(displayName="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Explain(displayName="isExternal", displayOnlyOnTrue=true)
    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    @Explain(displayName="sort columns")
    public List<Order> getSortCols() {
        return this.sortCols;
    }

    public void setSortCols(ArrayList<Order> sortCols) {
        this.sortCols = sortCols;
    }

    @Explain(displayName="serde name")
    public String getSerName() {
        return this.serName;
    }

    public void setSerName(String serName) {
        this.serName = serName;
    }

    @Explain(displayName="serde properties")
    public Map<String, String> getSerdeProps() {
        return this.serdeProps;
    }

    public void setSerdeProps(Map<String, String> serdeProps) {
        this.serdeProps = serdeProps;
    }

    @Explain(displayName="table properties")
    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    public void setTblProps(Map<String, String> tblProps) {
        this.tblProps = tblProps;
    }

    public List<String> getSkewedColNames() {
        return this.skewedColNames;
    }

    public void setSkewedColNames(ArrayList<String> skewedColNames) {
        this.skewedColNames = skewedColNames;
    }

    public List<List<String>> getSkewedColValues() {
        return this.skewedColValues;
    }

    public void setSkewedColValues(ArrayList<List<String>> skewedColValues) {
        this.skewedColValues = skewedColValues;
    }

    public void validate(HiveConf conf) throws SemanticException {
        boolean found;
        if (this.getCols() == null || this.getCols().size() == 0) {
            if (Table.hasMetastoreBasedSchema(conf, this.serName) && StringUtils.isEmpty(this.getStorageHandler())) {
                throw new SemanticException(ErrorMsg.INVALID_TBL_DDL_SERDE.getMsg());
            }
            return;
        }
        if (this.getStorageHandler() == null) {
            try {
                Class<?> origin = Class.forName(this.getOutputFormat(), true, Utilities.getSessionSpecifiedClassLoader());
                Class<? extends OutputFormat> replaced = HiveFileFormatUtils.getOutputFormatSubstitute(origin);
                if (!HiveOutputFormat.class.isAssignableFrom(replaced)) {
                    throw new SemanticException(ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg());
                }
            }
            catch (ClassNotFoundException e) {
                throw new SemanticException(ErrorMsg.CLASSPATH_ERROR.getMsg(), e);
            }
        }
        List<String> colNames = ParseUtils.validateColumnNameUniqueness(this.getCols());
        if (this.getBucketCols() != null) {
            for (String bucketCol : this.getBucketCols()) {
                found = false;
                for (String colName : colNames) {
                    if (!bucketCol.equalsIgnoreCase(colName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(" '" + bucketCol + "'"));
            }
        }
        if (this.getSortCols() != null) {
            Iterator<Order> sortCols = this.getSortCols().iterator();
            while (sortCols.hasNext()) {
                String sortCol = sortCols.next().getCol();
                found = false;
                for (String colName : colNames) {
                    if (!sortCol.equalsIgnoreCase(colName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(" '" + sortCol + "'"));
            }
        }
        if (this.getPartCols() != null) {
            for (FieldSchema fs : this.getPartCols()) {
                String partCol = fs.getName();
                PrimitiveTypeInfo pti = null;
                try {
                    pti = TypeInfoFactory.getPrimitiveTypeInfo(fs.getType());
                }
                catch (Exception err) {
                    LOG.error("Failed to get type info", err);
                }
                if (null == pti) {
                    throw new SemanticException(ErrorMsg.PARTITION_COLUMN_NON_PRIMITIVE.getMsg() + " Found " + partCol + " of type: " + fs.getType());
                }
                Iterator<String> colNamesIter = colNames.iterator();
                while (colNamesIter.hasNext()) {
                    String colName = BaseSemanticAnalyzer.unescapeIdentifier(colNamesIter.next());
                    if (!partCol.equalsIgnoreCase(colName)) continue;
                    throw new SemanticException(ErrorMsg.COLUMN_REPEATED_IN_PARTITIONING_COLS.getMsg());
                }
            }
        }
        ValidationUtility.validateSkewedInformation(colNames, this.getSkewedColNames(), this.getSkewedColValues());
    }

    public boolean isStoredAsSubDirectories() {
        return this.isStoredAsSubDirectories;
    }

    public void setStoredAsSubDirectories(boolean isStoredAsSubDirectories) {
        this.isStoredAsSubDirectories = isStoredAsSubDirectories;
    }

    public String getNullFormat() {
        return this.nullFormat;
    }

    public void setNullFormat(String nullFormat) {
        this.nullFormat = nullFormat;
    }

    @Explain(displayName="isTemporary", displayOnlyOnTrue=true)
    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setTemporary(boolean isTemporary) {
        this.isTemporary = isTemporary;
    }

    @Explain(displayName="isMaterialization", displayOnlyOnTrue=true)
    public boolean isMaterialization() {
        return this.isMaterialization;
    }

    public void setMaterialization(boolean isMaterialization) {
        this.isMaterialization = isMaterialization;
    }

    public void setReplaceMode(boolean replaceMode) {
        this.replaceMode = replaceMode;
    }

    public boolean getReplaceMode() {
        return this.replaceMode;
    }

    public void setReplicationSpec(ReplicationSpec replicationSpec) {
        this.replicationSpec = replicationSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        if (this.replicationSpec == null) {
            this.replicationSpec = new ReplicationSpec();
        }
        return this.replicationSpec;
    }

    public boolean isCTAS() {
        return this.isCTAS;
    }

    public Table toTable(HiveConf conf) throws HiveException {
        String databaseName = this.getDatabaseName();
        String tableName = this.getTableName();
        if (databaseName == null || tableName.contains(".")) {
            String[] names = Utilities.getDbTableName(tableName);
            databaseName = names[0];
            tableName = names[1];
        }
        Table tbl = new Table(databaseName, tableName);
        if (this.getTblProps() != null) {
            tbl.getTTable().getParameters().putAll(this.getTblProps());
        }
        if (this.getPartCols() != null) {
            tbl.setPartCols(this.getPartCols());
        }
        if (this.getNumBuckets() != -1) {
            tbl.setNumBuckets(this.getNumBuckets());
        }
        if (this.getStorageHandler() != null) {
            tbl.setProperty("storage_handler", this.getStorageHandler());
        }
        HiveStorageHandler storageHandler = tbl.getStorageHandler();
        if (this.getSerName() == null) {
            if (storageHandler == null) {
                LOG.info("Default to LazySimpleSerDe for table " + tableName);
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                String serDeClassName = storageHandler.getSerDeClass().getName();
                LOG.info("Use StorageHandler-supplied " + serDeClassName + " for table " + tableName);
                tbl.setSerializationLib(serDeClassName);
            }
        } else {
            DDLTask.validateSerDe(this.getSerName(), conf);
            tbl.setSerializationLib(this.getSerName());
        }
        if (this.getFieldDelim() != null) {
            tbl.setSerdeParam("field.delim", this.getFieldDelim());
            tbl.setSerdeParam("serialization.format", this.getFieldDelim());
        }
        if (this.getFieldEscape() != null) {
            tbl.setSerdeParam("escape.delim", this.getFieldEscape());
        }
        if (this.getCollItemDelim() != null) {
            tbl.setSerdeParam("colelction.delim", this.getCollItemDelim());
        }
        if (this.getMapKeyDelim() != null) {
            tbl.setSerdeParam("mapkey.delim", this.getMapKeyDelim());
        }
        if (this.getLineDelim() != null) {
            tbl.setSerdeParam("line.delim", this.getLineDelim());
        }
        if (this.getNullFormat() != null) {
            tbl.setSerdeParam("serialization.null.format", this.getNullFormat());
        }
        if (this.getSerdeProps() != null) {
            for (Map.Entry<String, String> m : this.getSerdeProps().entrySet()) {
                tbl.setSerdeParam(m.getKey(), m.getValue());
            }
        }
        if (this.getCols() != null) {
            tbl.setFields(this.getCols());
        }
        if (this.getBucketCols() != null) {
            tbl.setBucketCols(this.getBucketCols());
        }
        if (this.getSortCols() != null) {
            tbl.setSortCols(this.getSortCols());
        }
        if (this.getComment() != null) {
            tbl.setProperty("comment", this.getComment());
        }
        if (this.getLocation() != null) {
            tbl.setDataLocation(new Path(this.getLocation()));
        }
        if (this.getSkewedColNames() != null) {
            tbl.setSkewedColNames(this.getSkewedColNames());
        }
        if (this.getSkewedColValues() != null) {
            tbl.setSkewedColValues(this.getSkewedColValues());
        }
        tbl.getTTable().setTemporary(this.isTemporary());
        tbl.setStoredAsSubDirectories(this.isStoredAsSubDirectories());
        tbl.setInputFormatClass(this.getInputFormat());
        tbl.setOutputFormatClass(this.getOutputFormat());
        if (this.getInputFormat() != null && !this.getInputFormat().isEmpty()) {
            tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
        }
        if (this.getOutputFormat() != null && !this.getOutputFormat().isEmpty()) {
            tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        }
        if (!Utilities.isDefaultNameNode(conf) && DDLTask.doesTableNeedLocation(tbl)) {
            DDLTask.makeLocationQualified(tbl.getDbName(), tbl.getTTable().getSd(), tableName, conf);
        }
        if (this.isExternal()) {
            tbl.setProperty("EXTERNAL", "TRUE");
            tbl.setTableType(TableType.EXTERNAL_TABLE);
        }
        if (tbl.getBucketCols() != null && tbl.getSortCols() != null) {
            List<String> bucketCols = tbl.getBucketCols();
            List<Order> sortCols = tbl.getSortCols();
            if (sortCols.size() > 0 && sortCols.size() >= bucketCols.size()) {
                boolean found = true;
                for (String bucketCol : bucketCols) {
                    boolean colFound = false;
                    for (int i = 0; i < bucketCols.size(); ++i) {
                        if (!bucketCol.equals(sortCols.get(i).getCol())) continue;
                        colFound = true;
                        break;
                    }
                    if (colFound) continue;
                    found = false;
                    break;
                }
                if (found) {
                    tbl.setProperty("SORTBUCKETCOLSPREFIX", "TRUE");
                }
            }
        }
        if (this.getLocation() == null && !this.isCTAS) {
            if (!tbl.isPartitioned() && conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                StatsSetupConst.setBasicStatsStateForCreateTable(tbl.getTTable().getParameters(), "true");
            }
        } else {
            StatsSetupConst.setBasicStatsStateForCreateTable(tbl.getTTable().getParameters(), "false");
        }
        return tbl;
    }
}

