/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.spark;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkProcContext;
import org.apache.hadoop.hive.ql.parse.spark.SparkPartitionPruningSinkOperator;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hive.com.google.common.base.Preconditions;

public class SplitOpTreeForDPP
implements NodeProcessor {
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        SparkPartitionPruningSinkOperator pruningSinkOp = (SparkPartitionPruningSinkOperator)nd;
        GenSparkProcContext context = (GenSparkProcContext)procCtx;
        Operator filterOp = pruningSinkOp;
        SparkPartitionPruningSinkOperator selOp = null;
        while (filterOp != null && filterOp.getNumChild() <= 1) {
            selOp = filterOp;
            filterOp = filterOp.getParentOperators().get(0);
        }
        for (Operator<OperatorDesc> childOp : filterOp.getChildOperators()) {
            if (!(childOp instanceof ReduceSinkOperator) || !(childOp.getChildOperators().get(0) instanceof MapJoinOperator)) continue;
            context.pruningSinkSet.add(pruningSinkOp);
            return null;
        }
        LinkedList roots = new LinkedList();
        this.collectRoots(roots, pruningSinkOp);
        List<Operator<? extends OperatorDesc>> savedChildOps = filterOp.getChildOperators();
        filterOp.setChildOperators(Utilities.makeList(selOp));
        List<Operator<?>> newRoots = SerializationUtilities.cloneOperatorTree(roots);
        for (int i = 0; i < roots.size(); ++i) {
            TableScanOperator newTs = (TableScanOperator)newRoots.get(i);
            TableScanOperator tableScanOperator = (TableScanOperator)roots.get(i);
            ((TableScanDesc)newTs.getConf()).setTableMetadata(((TableScanDesc)tableScanOperator.getConf()).getTableMetadata());
        }
        context.clonedPruningTableScanSet.addAll(newRoots);
        filterOp.setChildOperators(savedChildOps);
        filterOp.removeChild(selOp);
        HashSet sinkSet = new HashSet();
        for (Operator operator : newRoots) {
            SparkUtilities.collectOp(sinkSet, operator, SparkPartitionPruningSinkOperator.class);
        }
        Preconditions.checkArgument(sinkSet.size() == 1, "AssertionError: expected to only contain one SparkPartitionPruningSinkOperator, but found " + sinkSet.size());
        SparkPartitionPruningSinkOperator clonedPruningSinkOp = (SparkPartitionPruningSinkOperator)sinkSet.iterator().next();
        ((SparkPartitionPruningSinkDesc)clonedPruningSinkOp.getConf()).setTableScan(((SparkPartitionPruningSinkDesc)pruningSinkOp.getConf()).getTableScan());
        context.pruningSinkSet.add(clonedPruningSinkOp);
        return null;
    }

    private void collectRoots(List<Operator<?>> result, Operator<?> op) {
        if (op.getNumParent() == 0) {
            result.add(op);
        } else {
            for (Operator<OperatorDesc> parentOp : op.getParentOperators()) {
                this.collectRoots(result, parentOp);
            }
        }
    }
}

