/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.util.List;
import org.apache.hadoop.hive.metastore.FileFormatProxy;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.orc.OrcFileFormatProxy;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionExpressionForMetastore
implements PartitionExpressionProxy {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionExpressionForMetastore.class);

    @Override
    public String convertExprToFilter(byte[] exprBytes) throws MetaException {
        return this.deserializeExpr(exprBytes).getExprString();
    }

    @Override
    public boolean filterPartitionsByExpr(List<String> partColumnNames, List<PrimitiveTypeInfo> partColumnTypeInfos, byte[] exprBytes, String defaultPartitionName, List<String> partitionNames) throws MetaException {
        ExprNodeGenericFuncDesc expr = this.deserializeExpr(exprBytes);
        try {
            long startTime = System.nanoTime();
            long len = partitionNames.size();
            boolean result = PartitionPruner.prunePartitionNames(partColumnNames, partColumnTypeInfos, expr, defaultPartitionName, partitionNames);
            double timeMs = (double)(System.nanoTime() - startTime) / 1000000.0;
            LOG.debug("Pruning " + len + " partition names took " + timeMs + "ms");
            return result;
        }
        catch (HiveException ex) {
            LOG.error("Failed to apply the expression", ex);
            throw new MetaException(ex.getMessage());
        }
    }

    private ExprNodeGenericFuncDesc deserializeExpr(byte[] exprBytes) throws MetaException {
        ExprNodeGenericFuncDesc expr = null;
        try {
            expr = SerializationUtilities.deserializeExpressionFromKryo(exprBytes);
        }
        catch (Exception ex) {
            LOG.error("Failed to deserialize the expression", ex);
            throw new MetaException(ex.getMessage());
        }
        if (expr == null) {
            throw new MetaException("Failed to deserialize expression - ExprNodeDesc not present");
        }
        return expr;
    }

    @Override
    public FileFormatProxy getFileFormatProxy(FileMetadataExprType type) {
        switch (type) {
            case ORC_SARG: {
                return new OrcFileFormatProxy();
            }
        }
        throw new RuntimeException("Unsupported format " + type);
    }

    @Override
    public FileMetadataExprType getMetadataType(String inputFormat) {
        try {
            Class<?> ifClass = Class.forName(inputFormat);
            if (OrcInputFormat.class.isAssignableFrom(ifClass)) {
                return FileMetadataExprType.ORC_SARG;
            }
            return null;
        }
        catch (Throwable t) {
            LOG.warn("Can't create the class for input format " + inputFormat, t);
            return null;
        }
    }

    @Override
    public SearchArgument createSarg(byte[] expr) {
        return ConvertAstToSearchArg.create(expr);
    }
}

